/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.prompt;

import cn.gitlab.kilo.jetbrains.common.ChatMessage;
import cn.gitlab.kilo.jetbrains.common.CustomException;
import cn.gitlab.kilo.jetbrains.common.I18nKt;
import cn.gitlab.kilo.jetbrains.common.LLMChatMessage;
import cn.gitlab.kilo.jetbrains.common.Speaker;
import cn.gitlab.kilo.jetbrains.composer.prompts.MemoryServiceKt;
import cn.gitlab.kilo.jetbrains.composer.prompts.ProjectMemoryPrompterKt;
import cn.gitlab.kilo.jetbrains.composer.prompts.RulesServiceKt;
import cn.gitlab.kilo.jetbrains.config.ModelsConfiguration;
import cn.gitlab.kilo.jetbrains.prompt.ChatPromptResult;
import cn.gitlab.kilo.jetbrains.services.Configuration;
import cn.gitlab.kilo.jetbrains.services.ConfigurationKt;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J$\u0010#\u001a\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&2\u0006\u0010(\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020*J$\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00130&2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00130&2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J$\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00130&2\u0006\u0010.\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020*J\u0016\u0010/\u001a\u00020\u000f2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00130&H\u0002J\u0016\u00100\u001a\u00020\u000f2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&H\u0002J\u0010\u00100\u001a\u00020\u000f2\u0006\u00101\u001a\u00020\u0003H\u0002R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\"\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"\u00a8\u00062"}, d2={"Lcn/gitlab/kilo/jetbrains/prompt/ChatPrompter;", "", "modelId", "", "rules", "", "<init>", "(Ljava/lang/String;Ljava/util/Set;)V", "model", "Lcn/gitlab/kilo/jetbrains/config/ModelsConfiguration$ModelConfig;", "getModel", "()Lcn/gitlab/kilo/jetbrains/config/ModelsConfiguration$ModelConfig;", "setModel", "(Lcn/gitlab/kilo/jetbrains/config/ModelsConfiguration$ModelConfig;)V", "tokenLimit", "", "usedTokens", "head", "", "Lcn/gitlab/kilo/jetbrains/common/LLMChatMessage;", "getHead", "()Ljava/util/List;", "tail", "getTail", "manualRules", "getManualRules", "()Ljava/util/Set;", "setManualRules", "(Ljava/util/Set;)V", "thinking", "", "getThinking", "()Z", "setThinking", "(Z)V", "prompt", "Lcn/gitlab/kilo/jetbrains/prompt/ChatPromptResult;", "msgs", "", "Lcn/gitlab/kilo/jetbrains/common/ChatMessage;", "useProjectMemory", "project", "Lcom/intellij/openapi/project/Project;", "truncateMessagesToFitTokenLimit", "messages", "getPreamble", "provider", "countLLMChatMessageTokens", "countTokens", "input", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nChatPrompter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatPrompter.kt\ncn/gitlab/kilo/jetbrains/prompt/ChatPrompter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,202:1\n1563#2:203\n1634#2,3:204\n1#3:207\n*S KotlinDebug\n*F\n+ 1 ChatPrompter.kt\ncn/gitlab/kilo/jetbrains/prompt/ChatPrompter\n*L\n57#1:203\n57#1:204,3\n*E\n"})
public final class ChatPrompter {
    @NotNull
    private ModelsConfiguration.ModelConfig model;
    private int tokenLimit;
    private int usedTokens;
    @NotNull
    private final List<LLMChatMessage> head;
    @NotNull
    private final List<LLMChatMessage> tail;
    @Nullable
    private Set<String> manualRules;
    private boolean thinking;

    public ChatPrompter(@NotNull String modelId, @NotNull Set<String> rules) {
        Intrinsics.checkNotNullParameter((Object)modelId, (String)"modelId");
        Intrinsics.checkNotNullParameter(rules, (String)"rules");
        this.model = new ModelsConfiguration.ModelConfig(null, null, null, null, null, null, null, false, null, false, false, 2047, null);
        this.tokenLimit = 38400;
        this.head = new ArrayList();
        this.tail = new ArrayList();
        this.manualRules = rules;
        ModelsConfiguration.ModelConfig modelConfig = ModelsConfiguration.Companion.getInstance().getChatModels().get(modelId);
        if (modelConfig == null) {
            throw new IllegalArgumentException("ChatPrompter: invalid model key:" + modelId);
        }
        this.model = modelConfig;
        this.thinking = this.model.getReasoning();
        this.tokenLimit = (int)Math.floor(3.15 * (double)ModelsConfiguration.ModelConfig.getContextLength$default(this.model, false, 1, null));
    }

    @NotNull
    public final ModelsConfiguration.ModelConfig getModel() {
        return this.model;
    }

    public final void setModel(@NotNull ModelsConfiguration.ModelConfig modelConfig) {
        Intrinsics.checkNotNullParameter((Object)modelConfig, (String)"<set-?>");
        this.model = modelConfig;
    }

    @NotNull
    public final List<LLMChatMessage> getHead() {
        return this.head;
    }

    @NotNull
    public final List<LLMChatMessage> getTail() {
        return this.tail;
    }

    @Nullable
    public final Set<String> getManualRules() {
        return this.manualRules;
    }

    public final void setManualRules(@Nullable Set<String> set2) {
        this.manualRules = set2;
    }

    public final boolean getThinking() {
        return this.thinking;
    }

    public final void setThinking(boolean bl) {
        this.thinking = bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ChatPromptResult prompt(@NotNull List<? extends ChatMessage> msgs, boolean useProjectMemory, @NotNull Project project) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object preamble;
        Intrinsics.checkNotNullParameter(msgs, (String)"msgs");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (msgs.isEmpty()) {
            throw new CustomException("Prompter: no messages");
        }
        ChatMessage lastMsg = msgs.get(msgs.size() - 1);
        if (lastMsg.getSpeaker() != Speaker.human) {
            throw new CustomException("Prompter: last message is not from human, got " + lastMsg.getSpeaker());
        }
        if (!this.thinking || !Intrinsics.areEqual((Object)this.model.getProvider(), (Object)"deepseek")) {
            preamble = this.getPreamble(this.model.getProvider(), useProjectMemory, project);
            this.usedTokens += this.countLLMChatMessageTokens((List<LLMChatMessage>)preamble);
            this.head.addAll((Collection)preamble);
        }
        if (this.usedTokens > this.tokenLimit) {
            preamble = I18nKt.getMessage("prompt.token.history.limitation.warning");
            Object[] objectArray = new Object[]{this.usedTokens + "/" + this.tokenLimit};
            String string = String.format((String)preamble, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            throw new CustomException(string);
        }
        preamble = msgs;
        List<LLMChatMessage> list = this.tail;
        boolean $i$f$map = false;
        void var7_9 = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ChatMessage chatMessage = (ChatMessage)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new LLMChatMessage((ChatMessage)it));
        }
        list.addAll((List)destination$iv$iv);
        List result2 = new ArrayList();
        result2.addAll((Collection)this.head);
        int headTokens = this.countLLMChatMessageTokens(this.head);
        int availableTokens = this.tokenLimit - headTokens;
        String string = lastMsg.getText();
        if (string == null) {
            string = "";
        }
        if (availableTokens - this.countTokens(string) <= 0) {
            destination$iv$iv = I18nKt.getMessage("prompt.token.history.limitation.warning");
            Object[] objectArray = new Object[1];
            String string2 = lastMsg.getText();
            if (string2 == null) {
                string2 = "";
            }
            objectArray[0] = headTokens + this.countTokens(string2) + "/" + this.tokenLimit;
            String string3 = String.format((String)destination$iv$iv, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            throw new CustomException(string3);
        }
        List<LLMChatMessage> truncatedTail = this.truncateMessagesToFitTokenLimit(this.tail, availableTokens);
        result2.addAll((Collection)truncatedTail);
        return new ChatPromptResult(result2, CollectionsKt.emptyList(), null, 4, null);
    }

    private final List<LLMChatMessage> truncateMessagesToFitTokenLimit(List<LLMChatMessage> messages, int tokenLimit) {
        List result2 = new ArrayList();
        int currentTokens = 0;
        int n = ((Collection)messages).size() + -1;
        if (0 <= n) {
            int i;
            LLMChatMessage message;
            int messageTokens;
            while (currentTokens + (messageTokens = this.countLLMChatMessageTokens(CollectionsKt.listOf((Object)(message = messages.get(i = n--))))) <= tokenLimit) {
                result2.add(0, message);
                currentTokens += messageTokens;
                if (0 <= n) continue;
            }
        }
        return result2;
    }

    @NotNull
    public final List<LLMChatMessage> getPreamble(@NotNull String provider, boolean useProjectMemory, @NotNull Project project) {
        Triple triple;
        String userInstruction;
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = I18nKt.getPrompt("prompt.default.preamble");
        Object[] objectArray = new Object[]{provider};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        String DEFAULT_PREAMBLE = string2;
        String DEFAULT_ANSWER = I18nKt.getPrompt("prompt.default.answer");
        Configuration config2 = ConfigurationKt.getConfig();
        String string3 = I18nKt.getPrompt("prompt.default.time.info");
        Object[] objectArray2 = new Object[]{String.valueOf(new Date())};
        String string4 = String.format(string3, Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
        String timeInfo = string4;
        String model = this.model.getKey();
        if (StringsKt.contains$default((CharSequence)model, (CharSequence)"mistral", (boolean)false, (int)2, null)) {
            String preamble = DEFAULT_PREAMBLE + "\n" + timeInfo + "\n" + config2.getChat().getInstruction();
            Object[] objectArray3 = new LLMChatMessage[]{new LLMChatMessage(Speaker.human, preamble), new LLMChatMessage(Speaker.assistant, DEFAULT_ANSWER)};
            return CollectionsKt.listOf((Object[])objectArray3);
        }
        String string5 = RulesServiceKt.getUserCustomerInstruction();
        if (string5 == null) {
            string5 = userInstruction = "";
        }
        if (useProjectMemory) {
            String string6 = project.getBasePath();
            if (string6 == null) {
                string6 = "";
            }
            triple = new Triple(null, null, (Object)ProjectMemoryPrompterKt.createChatProjectMemoryPrompt(string6));
        } else {
            String string7 = project.getBasePath();
            if (string7 == null) {
                string7 = "";
            }
            List list = CollectionsKt.listOf((Object)userInstruction);
            Set set2 = this.manualRules;
            if (set2 == null) {
                set2 = SetsKt.emptySet();
            }
            triple = new Triple((Object)RulesServiceKt.forgeRule(string7, list, set2), (Object)MemoryServiceKt.forgeMemory(), null);
        }
        Triple triple2 = triple;
        String coderiderRules = (String)triple2.component1();
        String coderiderMemories = (String)triple2.component2();
        String coderiderProjectMemory = (String)triple2.component3();
        String preamble = StringsKt.trimIndent((String)("\n" + DEFAULT_PREAMBLE + " " + I18nKt.getPrompt("prompt.default.response.format") + "\n" + timeInfo + "\n" + coderiderRules + "\n" + coderiderMemories + "\n" + coderiderProjectMemory + "\n" + config2.getChat().getInstruction() + "\n            "));
        return CollectionsKt.listOf((Object)new LLMChatMessage(Speaker.system, preamble));
    }

    /*
     * WARNING - void declaration
     */
    private final int countLLMChatMessageTokens(List<LLMChatMessage> msgs) {
        int tokens = 0;
        for (LLMChatMessage msg : msgs) {
            int n;
            int n2 = tokens;
            if (msg.getText() != null) {
                void it;
                int n3 = n2;
                boolean bl = false;
                int n4 = this.countTokens((String)it);
                n2 = n3;
                n = n4;
            } else {
                n = 0;
            }
            tokens = n2 + n;
        }
        return tokens;
    }

    private final int countTokens(List<? extends ChatMessage> msgs) {
        int tokens = 0;
        for (ChatMessage chatMessage : msgs) {
            int n;
            if (chatMessage.getText() != null) {
                String it;
                boolean bl = false;
                n = this.countTokens(it);
            } else {
                n = 0;
            }
            int countTokens = n;
            tokens += countTokens;
        }
        return tokens;
    }

    private final int countTokens(String input) {
        return input.length();
    }
}

