/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.llmClient;

import cn.gitlab.kilo.jetbrains.common.ChatRequest;
import cn.gitlab.kilo.jetbrains.common.CustomException;
import cn.gitlab.kilo.jetbrains.common.GenerateMetrics;
import cn.gitlab.kilo.jetbrains.common.GenerateParameters;
import cn.gitlab.kilo.jetbrains.common.GenerateResult;
import cn.gitlab.kilo.jetbrains.common.Logger;
import cn.gitlab.kilo.jetbrains.config.ModelsConfiguration;
import cn.gitlab.kilo.jetbrains.llmClient.ChatClient;
import cn.gitlab.kilo.jetbrains.llmClient.Message;
import cn.gitlab.kilo.jetbrains.llmClient.OllamaResponse;
import cn.gitlab.kilo.jetbrains.services.GenerationCallbacks;
import cn.gitlab.kilo.jetbrains.services.ResponseCallbacks;
import cn.gitlab.kilo.jetbrains.services.context.ContextSnippet;
import cn.gitlab.kilo.jetbrains.utils.ChatParameters;
import cn.gitlab.kilo.jetbrains.utils.ClientUtilsKt;
import cn.gitlab.kilo.jetbrains.utils.StreamUtilsKt;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http2.StreamResetException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 &2\u00020\u0001:\u0001&B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016JH\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\f2\u000e\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001e2\u0006\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\"H\u0016J\u001e\u0010#\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0014\u001a\u00020$2\u0006\u0010\u000f\u001a\u00020%H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcn/gitlab/kilo/jetbrains/llmClient/OllamaClient;", "Lcn/gitlab/kilo/jetbrains/llmClient/ChatClient;", "<init>", "()V", "logger", "Lcn/gitlab/kilo/jetbrains/common/Logger;", "client", "Lokhttp3/OkHttpClient;", "doStreamRequest", "Lkotlin/Function0;", "", "url", "", "req", "Lcn/gitlab/kilo/jetbrains/common/ChatRequest;", "cb", "Lcn/gitlab/kilo/jetbrains/services/ResponseCallbacks;", "Lcn/gitlab/kilo/jetbrains/llmClient/OllamaResponse;", "generate", "Lcn/gitlab/kilo/jetbrains/common/GenerateResult;", "param", "Lcn/gitlab/kilo/jetbrains/common/GenerateParameters;", "timeoutMs", "", "codeCompletion", "modelKey", "languageId", "prefix", "suffix", "context", "", "Lcn/gitlab/kilo/jetbrains/services/context/ContextSnippet;", "filePath", "shouldDoMultiline", "", "chat", "Lcn/gitlab/kilo/jetbrains/utils/ChatParameters;", "Lcn/gitlab/kilo/jetbrains/services/GenerationCallbacks;", "Companion", "coderider-kilo-jetbrains"})
public final class OllamaClient
implements ChatClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger = Logger.Companion.getInstance("OllamaClient");
    @NotNull
    private final OkHttpClient client = ClientUtilsKt.generateOkHttpClientBuilder().callTimeout(600000L, TimeUnit.MILLISECONDS).connectTimeout(30000L, TimeUnit.MILLISECONDS).readTimeout(30000L, TimeUnit.MILLISECONDS).build();
    private static final long DEFAULT_TIMEOUT_MS = 30000L;
    private static final long DEFAULT_CALL_TIMEOUT_MS = 600000L;
    @NotNull
    private static final MediaType JSON_MEDIA_TYPE = MediaType.Companion.get("application/json; charset=utf-8");

    private final Function0<Unit> doStreamRequest(String url, ChatRequest req, ResponseCallbacks<OllamaResponse> cb) {
        String string = new Gson().toJson((Object)req);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
        RequestBody requestBody = RequestBody.Companion.create(string, JSON_MEDIA_TYPE);
        Request request = new Request.Builder().url(url).post(requestBody).build();
        Call call = this.client.newCall(request);
        call.enqueue(new Callback(cb){
            final /* synthetic */ ResponseCallbacks<OllamaResponse> $cb;
            {
                this.$cb = $cb;
            }

            public void onFailure(Call call, IOException e) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$cb.onError(e);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(Call call, Response response) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                if (!response.isSuccessful()) {
                    this.$cb.onError(new Exception("OllamaClient: Request failed with status " + response.code()));
                    return;
                }
                ResponseBody responseBody = response.body();
                if (responseBody != null) {
                    Closeable closeable = (Closeable)responseBody;
                    ResponseCallbacks<OllamaResponse> responseCallbacks = this.$cb;
                    Throwable throwable = null;
                    try {
                        ResponseBody responseBody2 = (ResponseBody)closeable;
                        boolean bl = false;
                        InputStream dataFlow$iv = responseBody2.byteStream();
                        boolean $i$f$processDataFlow = false;
                        Gson gson$iv = new Gson();
                        try {
                            TextStreamsKt.forEachLine((Reader)new BufferedReader(new InputStreamReader(dataFlow$iv, StandardCharsets.UTF_8)), (Function1)((Function1)new Function1<String, Unit>(gson$iv, responseCallbacks){
                                final /* synthetic */ Gson $gson;
                                final /* synthetic */ ResponseCallbacks $callbacks;
                                {
                                    this.$gson = $gson;
                                    this.$callbacks = $callbacks;
                                }

                                public final void invoke(String line) {
                                    block5: {
                                        Object object;
                                        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                                        String data = StringsKt.removePrefix((String)line, (CharSequence)"data:");
                                        Logger.debug$default(StreamUtilsKt.getLogger(), "Chat Response line: " + data, null, 2, null);
                                        Object object2 = this.$gson;
                                        ResponseCallbacks responseCallbacks = this.$callbacks;
                                        try {
                                            Unit unit;
                                            boolean bl = false;
                                            Object object3 = object2.fromJson(data, OllamaResponse.class);
                                            if (object3 != null) {
                                                Object p0 = object3;
                                                boolean bl2 = false;
                                                responseCallbacks.onChange(p0);
                                                unit = Unit.INSTANCE;
                                            } else {
                                                unit = null;
                                            }
                                            object = Result.constructor-impl(unit);
                                        }
                                        catch (Throwable p0) {
                                            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)p0));
                                        }
                                        object2 = object;
                                        responseCallbacks = this.$callbacks;
                                        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
                                        if (throwable == null) break block5;
                                        Throwable e = throwable;
                                        boolean bl = false;
                                        Logger.info$default(StreamUtilsKt.getLogger(), "Chat Response line: " + data, null, 2, null);
                                        if (e instanceof CustomException) {
                                            responseCallbacks.onError(e);
                                        }
                                    }
                                }
                            }));
                        }
                        catch (SocketException e$iv) {
                            StreamUtilsKt.getLogger().warn(e$iv);
                            responseCallbacks.onComplete();
                        }
                        catch (StreamResetException e$iv) {
                            responseCallbacks.onError(e$iv);
                        }
                        catch (Throwable e$iv) {
                            responseCallbacks.onError(e$iv);
                        }
                        responseCallbacks.onComplete();
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
            }
        });
        return () -> OllamaClient.doStreamRequest$lambda$0(call);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public GenerateResult generate(@NotNull GenerateParameters param, long timeoutMs) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)param, (String)"param");
        String string = StringsKt.substringAfter$default((String)param.getModel(), (String)"/", null, (int)2, null);
        String string2 = param.getPrompt();
        Object object2 = new Pair[3];
        object2[0] = TuplesKt.to((Object)"temperature", (Object)0.7);
        object2[1] = TuplesKt.to((Object)"top_p", (Object)0.9);
        Integer n = param.getMaxTokensToSample();
        object2[2] = TuplesKt.to((Object)"max_tokens", (Object)(n != null ? n : 256));
        Map map = MapsKt.mapOf((Pair[])object2);
        object2 = param.getStop();
        ChatRequest req = new ChatRequest(string, null, string2, null, false, null, null, null, null, null, (List)object2, map, null, 5098, null);
        long startTime = System.currentTimeMillis();
        ModelsConfiguration.ModelConfig modelConfig = ModelsConfiguration.Companion.getInstance().getCodeModels().get(param.getModel());
        Intrinsics.checkNotNull((Object)modelConfig);
        ModelsConfiguration.ModelConfig model = modelConfig;
        String string3 = new Gson().toJson((Object)req);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toJson(...)");
        RequestBody requestBody = RequestBody.Companion.create(string3, JSON_MEDIA_TYPE);
        Request request = new Request.Builder().url(model.getCompletionUrl()).post(requestBody).build();
        try {
            GenerateResult generateResult;
            object = (Closeable)this.client.newCall(request).execute();
            Throwable throwable = null;
            try {
                Response response = (Response)object;
                boolean bl = false;
                if (!response.isSuccessful()) {
                    throw new CustomException("Request failed with status: " + response.code());
                }
                ResponseBody responseBody = response.body();
                String responseBody2 = responseBody != null ? responseBody.string() : null;
                OllamaResponse ollamaResp = (OllamaResponse)new Gson().fromJson(responseBody2, OllamaResponse.class);
                long totalDuration = System.currentTimeMillis() - startTime;
                Object object3 = ollamaResp;
                if (object3 == null || (object3 = ((OllamaResponse)object3).getResponse()) == null) {
                    object3 = "";
                }
                OllamaResponse ollamaResponse = ollamaResp;
                OllamaResponse ollamaResponse2 = ollamaResp;
                generateResult = new GenerateResult((String)object3, new GenerateMetrics(totalDuration, null, null, null, ollamaResponse != null ? ollamaResponse.getPromptEvalCount() : null, ollamaResponse2 != null ? ollamaResponse2.getEvalCount() : null, 14, null));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = generateResult;
        }
        catch (Exception e) {
            this.logger.debug("Error in generate function", e);
            object = new GenerateResult("", null);
        }
        return object;
    }

    @Override
    @NotNull
    public GenerateResult codeCompletion(@NotNull String modelKey, @NotNull String languageId, @NotNull String prefix, @NotNull String suffix, @Nullable List<ContextSnippet> context, @NotNull String filePath, boolean shouldDoMultiline) {
        Intrinsics.checkNotNullParameter((Object)modelKey, (String)"modelKey");
        Intrinsics.checkNotNullParameter((Object)languageId, (String)"languageId");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    @NotNull
    public Function0<Unit> chat(@NotNull ChatParameters param, @NotNull GenerationCallbacks cb) {
        Intrinsics.checkNotNullParameter((Object)param, (String)"param");
        Intrinsics.checkNotNullParameter((Object)cb, (String)"cb");
        long time = System.currentTimeMillis();
        Logger.debug$default(this.logger, "Ollama chat started at " + time, null, 2, null);
        Ref.ObjectRef accumulated = new Ref.ObjectRef();
        accumulated.element = "";
        ResponseCallbacks callbacks2 = new ResponseCallbacks<OllamaResponse>((Ref.ObjectRef<String>)accumulated, cb, this){
            final /* synthetic */ Ref.ObjectRef<String> $accumulated;
            final /* synthetic */ GenerationCallbacks $cb;
            final /* synthetic */ OllamaClient this$0;
            {
                this.$accumulated = $accumulated;
                this.$cb = $cb;
                this.this$0 = $receiver;
            }

            public void onChange(OllamaResponse resp) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)resp, (String)"resp");
                    Object object = resp.getMessage();
                    if (object == null || (object = ((Message)object).getContent()) == null) break block0;
                    Object object2 = object;
                    Ref.ObjectRef<String> objectRef = this.$accumulated;
                    GenerationCallbacks generationCallbacks = this.$cb;
                    Object it = object2;
                    boolean bl = false;
                    objectRef.element = objectRef.element + (String)it;
                    GenerationCallbacks.DefaultImpls.onChange$default(generationCallbacks, (String)objectRef.element, null, 2, null);
                }
            }

            public void onComplete() {
                GenerationCallbacks.DefaultImpls.onComplete$default(this.$cb, (String)this.$accumulated.element, null, 2, null);
            }

            public void onError(Throwable error2) {
                Intrinsics.checkNotNullParameter((Object)error2, (String)"error");
                OllamaClient.access$getLogger$p(this.this$0).debug("Ollama chat error", error2);
                this.$cb.onError((String)this.$accumulated.element, error2);
            }
        };
        ModelsConfiguration.ModelConfig modelConfig = ModelsConfiguration.Companion.getInstance().getChatModels().get(param.getModelId());
        Intrinsics.checkNotNull((Object)modelConfig);
        ModelsConfiguration.ModelConfig model = modelConfig;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"temperature", (Object)0.7), TuplesKt.to((Object)"top_p", (Object)0.9)};
        ChatRequest req = new ChatRequest(StringsKt.substringAfter$default((String)model.getKey(), (String)"/", null, (int)2, null), param.getMessages(), null, null, param.getStream(), null, null, null, null, null, null, MapsKt.mapOf((Pair[])pairArray), null, 6124, null);
        return this.doStreamRequest(model.getChatUrl(), req, callbacks2);
    }

    private static final Unit doStreamRequest$lambda$0(Call $call) {
        $call.cancel();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Logger access$getLogger$p(OllamaClient $this) {
        return $this.logger;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcn/gitlab/kilo/jetbrains/llmClient/OllamaClient$Companion;", "", "<init>", "()V", "DEFAULT_TIMEOUT_MS", "", "DEFAULT_CALL_TIMEOUT_MS", "JSON_MEDIA_TYPE", "Lokhttp3/MediaType;", "coderider-kilo-jetbrains"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

