/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.listener;

import cn.gitlab.kilo.jetbrains.common.I18nKt;
import cn.gitlab.kilo.jetbrains.common.Logger;
import cn.gitlab.kilo.jetbrains.config.CockpitConfiguration;
import cn.gitlab.kilo.jetbrains.utils.KeymapUtilsKt;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.ui.GotItTooltip;
import java.awt.Component;
import java.awt.Point;
import java.util.Map;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00100\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcn/gitlab/kilo/jetbrains/listener/CodeCompletionHint;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "logger", "Lcn/gitlab/kilo/jetbrains/common/Logger;", "state", "Lcn/gitlab/kilo/jetbrains/config/CockpitConfiguration$PluginState;", "multilineText", "", "enhanceText", "multilineTooltip", "Lcom/intellij/ui/GotItTooltip;", "enhanceTextTooltip", "multilineAndEnhanceTextTooltip", "tooltipMap", "", "showHint", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "caret", "Lcom/intellij/openapi/editor/Caret;", "coderider-kilo-jetbrains"})
public final class CodeCompletionHint {
    @NotNull
    private final Project project;
    @NotNull
    private final Logger logger;
    @NotNull
    private final CockpitConfiguration.PluginState state;
    @NotNull
    private final String multilineText;
    @NotNull
    private final String enhanceText;
    @NotNull
    private final GotItTooltip multilineTooltip;
    @NotNull
    private final GotItTooltip enhanceTextTooltip;
    @NotNull
    private final GotItTooltip multilineAndEnhanceTextTooltip;
    @NotNull
    private final Map<String, GotItTooltip> tooltipMap;

    public CodeCompletionHint(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.logger = Logger.Companion.getInstance("HintCaretListener");
        this.state = CockpitConfiguration.Companion.getInstance().getState();
        this.multilineText = I18nKt.getMessage("multiline.code.completion") + KeymapUtilsKt.getShortcutForAction("coderider-kilo.CustomMultilineCompletionActionCall");
        this.enhanceText = I18nKt.getMessage("enhance.code.completion") + KeymapUtilsKt.getShortcutForAction("coderider-kilo.CustomCallEnhanceCompletionActionCall");
        this.multilineTooltip = new GotItTooltip("coderider.autocomplete.multilineTooltip", this.multilineText, null);
        this.enhanceTextTooltip = new GotItTooltip("coderider.autocomplete.enhanceTextTooltip", this.enhanceText, null);
        this.multilineAndEnhanceTextTooltip = new GotItTooltip("coderider.autocomplete.multilineAndEnhanceTextTooltip", this.multilineText + this.enhanceText, null);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)String.valueOf(this.multilineText.hashCode()), (Object)this.multilineTooltip), TuplesKt.to((Object)String.valueOf(this.enhanceText.hashCode()), (Object)this.enhanceTextTooltip), TuplesKt.to((Object)String.valueOf((this.multilineText + this.enhanceText).hashCode()), (Object)this.multilineAndEnhanceTextTooltip)};
        this.tooltipMap = MapsKt.mutableMapOf((Pair[])pairArray);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final void showHint(@NotNull Editor editor, @NotNull Caret caret) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        if (CockpitConfiguration.Companion.getInstance().needLogin() || !this.state.getShowHint()) {
            return;
        }
        ActionsKt.invokeLater$default(null, () -> CodeCompletionHint.showHint$lambda$1(editor, this, caret), (int)1, null);
    }

    private static final Point showHint$lambda$1$lambda$0(Editor $editor, Caret $caret, Component component, Balloon balloon) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)balloon, (String)"<unused var>");
        Point point = $editor.visualPositionToXY($caret.getVisualPosition());
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"visualPositionToXY(...)");
        return point;
    }

    private static final Unit showHint$lambda$1(Editor $editor, CodeCompletionHint this$0, Caret $caret) {
        JComponent jComponent = $editor.getContentComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getContentComponent(...)");
        JComponent component = jComponent;
        if (!component.isShowing()) {
            return Unit.INSTANCE;
        }
        if (this$0.state.getShouldDoMultiline()) {
            return Unit.INSTANCE;
        }
        String tooltipText = this$0.multilineText;
        try {
            GotItTooltip gotItTooltip;
            GotItTooltip gotItTooltip2;
            GotItTooltip gotItTooltip3 = this$0.tooltipMap.get(tooltipText);
            if (gotItTooltip3 != null && (gotItTooltip2 = gotItTooltip3.withHeader(I18nKt.getMessage("gotit.autocomplete.header"))) != null && (gotItTooltip = gotItTooltip2.withPosition(Balloon.Position.above)) != null) {
                gotItTooltip.show(component, (arg_0, arg_1) -> CodeCompletionHint.showHint$lambda$1$lambda$0($editor, $caret, arg_0, arg_1));
            }
        }
        catch (Exception e) {
            this$0.logger.warn("Failed to display GotIt tooltip", e);
        }
        return Unit.INSTANCE;
    }
}

