/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.editor.settings;

import cn.gitlab.kilo.jetbrains.client.CoderiderClient;
import cn.gitlab.kilo.jetbrains.client.CoderiderClientKt;
import cn.gitlab.kilo.jetbrains.client.DeleteIdeCommandRequest;
import cn.gitlab.kilo.jetbrains.client.GetCommandsRequest;
import cn.gitlab.kilo.jetbrains.client.GetIdeCommandResponse;
import cn.gitlab.kilo.jetbrains.client.KnowledgeBaseCreateReq;
import cn.gitlab.kilo.jetbrains.client.PostIdeCommandCreateRequest;
import cn.gitlab.kilo.jetbrains.client.PostIdeCommandCreateResponse;
import cn.gitlab.kilo.jetbrains.client.PostIdeRequest;
import cn.gitlab.kilo.jetbrains.client.PutIdeCommandUpdateRequest;
import cn.gitlab.kilo.jetbrains.client.PutIdeCommandUpdateResponse;
import cn.gitlab.kilo.jetbrains.client.RuleEpListResponse;
import cn.gitlab.kilo.jetbrains.client.RuleEpResponse;
import cn.gitlab.kilo.jetbrains.common.AuthStatus;
import cn.gitlab.kilo.jetbrains.common.CoderiderAuth;
import cn.gitlab.kilo.jetbrains.common.ExtensionMessage;
import cn.gitlab.kilo.jetbrains.common.GetResponse;
import cn.gitlab.kilo.jetbrains.common.I18nKt;
import cn.gitlab.kilo.jetbrains.common.Rag;
import cn.gitlab.kilo.jetbrains.common.RagConfig;
import cn.gitlab.kilo.jetbrains.common.RagSelectItem;
import cn.gitlab.kilo.jetbrains.common.Route;
import cn.gitlab.kilo.jetbrains.composer.prompts.RulesServiceKt;
import cn.gitlab.kilo.jetbrains.config.CockpitConfiguration;
import cn.gitlab.kilo.jetbrains.constants.ConstantsKt;
import cn.gitlab.kilo.jetbrains.editor.settings.MemoryManager;
import cn.gitlab.kilo.jetbrains.editor.settings.RagManager;
import cn.gitlab.kilo.jetbrains.editor.settings.RulesManager;
import cn.gitlab.kilo.jetbrains.factories.CustomLifeSpanHandler;
import cn.gitlab.kilo.jetbrains.factories.CustomerRequestHandler;
import cn.gitlab.kilo.jetbrains.factories.SchemeHandlerRegistrar;
import cn.gitlab.kilo.jetbrains.services.BrowserServiceKt;
import cn.gitlab.kilo.jetbrains.services.CockpitChatPluginServiceKt;
import cn.gitlab.kilo.jetbrains.services.StorageService;
import cn.gitlab.kilo.jetbrains.utils.ThemeUtilKt;
import com.google.gson.Gson;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.jcef.JBCefApp;
import com.intellij.ui.jcef.JBCefBrowser;
import com.intellij.ui.jcef.JBCefBrowserBase;
import com.intellij.ui.jcef.JBCefClient;
import com.intellij.ui.jcef.JBCefJSQuery;
import java.awt.Component;
import java.awt.Container;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.SupervisorKt;
import org.cef.browser.CefBrowser;
import org.cef.handler.CefLifeSpanHandler;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefLoadHandlerAdapter;
import org.cef.handler.CefRequestHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\u0011H\u0002J\b\u0010$\u001a\u00020\"H\u0002J\u000f\u0010%\u001a\u0004\u0018\u00010\"H\u0002\u00a2\u0006\u0002\u0010&J\u000e\u0010'\u001a\u00020\"2\u0006\u0010(\u001a\u00020\u0006J\u0006\u0010)\u001a\u00020\"J\"\u0010*\u001a\u00020\"2\b\u0010+\u001a\u0004\u0018\u00010\u00062\u0006\u0010,\u001a\u00020\u00112\u0006\u0010-\u001a\u00020.H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001f\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001e\u001a\n  *\u0004\u0018\u00010\u001f0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcn/gitlab/kilo/jetbrains/editor/settings/SettingsPanel;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "queryMap", "", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/Map;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getQueryMap", "()Ljava/util/Map;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "browser", "Lcom/intellij/ui/jcef/JBCefBrowser;", "rulesManager", "Lcn/gitlab/kilo/jetbrains/editor/settings/RulesManager;", "ragManager", "Lcn/gitlab/kilo/jetbrains/editor/settings/RagManager;", "memoryManager", "Lcn/gitlab/kilo/jetbrains/editor/settings/MemoryManager;", "panel", "Ljavax/swing/JPanel;", "getPanel", "()Ljavax/swing/JPanel;", "setPanel", "(Ljavax/swing/JPanel;)V", "props", "Lcom/intellij/ide/util/PropertiesComponent;", "kotlin.jvm.PlatformType", "dispose", "", "createBrowser", "registerAppSchemeHandler", "onThemeChanged", "()Lkotlin/Unit;", "sendRouteMessage", "page", "refreshMemory", "handleMessage", "raw", "jb", "q", "Lcom/intellij/ui/jcef/JBCefJSQuery;", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nSettingsPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingsPanel.kt\ncn/gitlab/kilo/jetbrains/editor/settings/SettingsPanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,357:1\n1#2:358\n216#3,2:359\n*S KotlinDebug\n*F\n+ 1 SettingsPanel.kt\ncn/gitlab/kilo/jetbrains/editor/settings/SettingsPanel\n*L\n154#1:359,2\n*E\n"})
public final class SettingsPanel
implements Disposable {
    @NotNull
    private final Project project;
    @Nullable
    private final Map<String, String> queryMap;
    @NotNull
    private final Logger logger;
    @Nullable
    private JBCefBrowser browser;
    @Nullable
    private RulesManager rulesManager;
    @NotNull
    private RagManager ragManager;
    @Nullable
    private MemoryManager memoryManager;
    @Nullable
    private JPanel panel;
    private final PropertiesComponent props;

    /*
     * WARNING - void declaration
     */
    public SettingsPanel(@NotNull Project project, @Nullable Map<String, String> queryMap) {
        void $this$_init__u24lambda_u240;
        JPanel jPanel;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.queryMap = queryMap;
        Logger logger = Logger.getInstance(SettingsPanel.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.ragManager = new RagManager();
        this.props = PropertiesComponent.getInstance();
        JPanel jPanel2 = jPanel = new JPanel();
        SettingsPanel settingsPanel = this;
        boolean bl = false;
        $this$_init__u24lambda_u240.setLayout(new BoxLayout((Container)$this$_init__u24lambda_u240, 1));
        $this$_init__u24lambda_u240.setAlignmentX(0.0f);
        if (JBCefApp.isSupported()) {
            JBCefBrowser jBCefBrowser = this.browser = this.createBrowser();
            Intrinsics.checkNotNull((Object)jBCefBrowser);
            this.rulesManager = new RulesManager(this.project, jBCefBrowser);
            JBCefBrowser jBCefBrowser2 = this.browser;
            Intrinsics.checkNotNull((Object)jBCefBrowser2);
            this.memoryManager = new MemoryManager(this.project, jBCefBrowser2);
            JBCefBrowser jBCefBrowser3 = this.browser;
            Intrinsics.checkNotNull((Object)jBCefBrowser3);
            $this$_init__u24lambda_u240.add((Component)jBCefBrowser3.getComponent(), "Center");
        } else {
            $this$_init__u24lambda_u240.add(new JLabel("JCEF is not supported on this platform."));
        }
        settingsPanel.panel = jPanel;
    }

    public /* synthetic */ SettingsPanel(Project project, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            map = null;
        }
        this(project, map);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final Map<String, String> getQueryMap() {
        return this.queryMap;
    }

    @Nullable
    public final JPanel getPanel() {
        return this.panel;
    }

    public final void setPanel(@Nullable JPanel jPanel) {
        this.panel = jPanel;
    }

    public void dispose() {
        JBCefBrowser jBCefBrowser = this.browser;
        if (jBCefBrowser != null) {
            jBCefBrowser.dispose();
        }
        this.browser = null;
    }

    private final JBCefBrowser createBrowser() {
        JBCefClient jBCefClient;
        JBCefBrowser jBCefBrowser = JBCefBrowser.createBuilder().setOffScreenRendering(false).setEnableOpenDevToolsMenuItem(true).build();
        Intrinsics.checkNotNullExpressionValue((Object)jBCefBrowser, (String)"build(...)");
        JBCefBrowser browser = jBCefBrowser;
        JBCefClient $this$createBrowser_u24lambda_u243 = jBCefClient = browser.getJBCefClient();
        boolean bl = false;
        $this$createBrowser_u24lambda_u243.addLifeSpanHandler((CefLifeSpanHandler)new CustomLifeSpanHandler(), browser.getCefBrowser());
        $this$createBrowser_u24lambda_u243.addRequestHandler((CefRequestHandler)new CustomerRequestHandler(), browser.getCefBrowser());
        this.registerAppSchemeHandler();
        JBCefJSQuery jBCefJSQuery = JBCefJSQuery.create((JBCefBrowserBase)((JBCefBrowserBase)browser));
        Intrinsics.checkNotNullExpressionValue((Object)jBCefJSQuery, (String)"create(...)");
        JBCefJSQuery jsQuery = jBCefJSQuery;
        jsQuery.addHandler(arg_0 -> SettingsPanel.createBrowser$lambda$3$lambda$2(arg_0 -> SettingsPanel.createBrowser$lambda$3$lambda$1(this, browser, jsQuery, arg_0), arg_0));
        $this$createBrowser_u24lambda_u243.addLoadHandler((CefLoadHandler)new CefLoadHandlerAdapter(jsQuery, this){
            final /* synthetic */ JBCefJSQuery $jsQuery;
            final /* synthetic */ SettingsPanel this$0;
            {
                this.$jsQuery = $jsQuery;
                this.this$0 = $receiver;
            }

            public void onLoadingStateChange(CefBrowser browser, boolean isLoading, boolean canGoBack, boolean canGoForward) {
                if (!isLoading) {
                    BrowserServiceKt.executeInitJavaScript(browser, this.$jsQuery);
                    SettingsPanel.access$onThemeChanged(this.this$0);
                }
            }
        }, browser.getCefBrowser());
        browser.loadURL(ConstantsKt.getRulesWebViewUrl());
        return browser;
    }

    private final void registerAppSchemeHandler() {
        SchemeHandlerRegistrar.INSTANCE.ensureRegistered();
    }

    private final Unit onThemeChanged() {
        Unit unit;
        JBCefBrowser jBCefBrowser = this.browser;
        if (jBCefBrowser != null) {
            JBCefBrowser it = jBCefBrowser;
            boolean bl = false;
            ThemeUtilKt.updateThemeToBrowser(it);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    public final void sendRouteMessage(@NotNull String page) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)page, (String)"page");
            JBCefBrowser jBCefBrowser = this.browser;
            if (jBCefBrowser == null) break block0;
            JBCefBrowser it = jBCefBrowser;
            boolean bl = false;
            ThemeUtilKt.sendToWebview((ExtensionMessage)new Route("route", page), this.project);
        }
    }

    public final void refreshMemory() {
        block0: {
            MemoryManager memoryManager = this.memoryManager;
            if (memoryManager == null) break block0;
            memoryManager.sendMemories();
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void handleMessage(String raw, JBCefBrowser jb, JBCefJSQuery q) {
        block148: {
            var4_4 = raw;
            if (var4_4 == null || StringsKt.isBlank((CharSequence)var4_4) != false) {
                return;
            }
            json = JsonParser.parseString((String)raw).getAsJsonObject();
            command = json.get("command").getAsString();
            v0 /* !! */  = json.get("requestId");
            if (v0 /* !! */  == null || (v0 /* !! */  = v0 /* !! */ .getAsString()) == null) {
                v0 /* !! */  = "";
            }
            requestId /* !! */  = v0 /* !! */ ;
            this.logger.debug("command=" + command + " id=" + (String)requestId /* !! */  + " raw=" + raw);
            var7_7 = command;
            if (var7_7 == null) break block148;
            tmp = -1;
            switch (var7_7.hashCode()) {
                case 90006109: {
                    if (var7_7.equals("postIdeCommandCreate")) {
                        tmp = 1;
                    }
                    break;
                }
                case -1519545939: {
                    if (var7_7.equals("postDeleteRag")) {
                        tmp = 2;
                    }
                    break;
                }
                case 1098253751: {
                    if (var7_7.equals("removeItem")) {
                        tmp = 3;
                    }
                    break;
                }
                case -562468676: {
                    if (var7_7.equals("postCreateRag")) {
                        tmp = 4;
                    }
                    break;
                }
                case -1240766004: {
                    if (var7_7.equals("ruleChange")) {
                        tmp = 5;
                    }
                    break;
                }
                case -219447956: {
                    if (var7_7.equals("postUserMemory")) {
                        tmp = 6;
                    }
                    break;
                }
                case -1043610878: {
                    if (var7_7.equals("openRuleFile")) {
                        tmp = 7;
                    }
                    break;
                }
                case -684260738: {
                    if (var7_7.equals("postCancelRag")) {
                        tmp = 8;
                    }
                    break;
                }
                case 1576518654: {
                    if (var7_7.equals("postRename")) {
                        tmp = 9;
                    }
                    break;
                }
                case -75439223: {
                    if (var7_7.equals("getItem")) {
                        tmp = 3;
                    }
                    break;
                }
                case -752789899: {
                    if (var7_7.equals("getIdeCommandList")) {
                        tmp = 10;
                    }
                    break;
                }
                case 600081758: {
                    if (var7_7.equals("syncMemoryToCloud")) {
                        tmp = 11;
                    }
                    break;
                }
                case 1984670357: {
                    if (var7_7.equals("setItem")) {
                        tmp = 3;
                    }
                    break;
                }
                case -925132997: {
                    if (var7_7.equals("routed")) {
                        tmp = 12;
                    }
                    break;
                }
                case 603477657: {
                    if (var7_7.equals("putIdeCommandUpdate")) {
                        tmp = 13;
                    }
                    break;
                }
                case 1508472140: {
                    if (var7_7.equals("deleteIdeCommand")) {
                        tmp = 14;
                    }
                    break;
                }
                case -1474498053: {
                    if (var7_7.equals("getRuleEpList")) {
                        tmp = 15;
                    }
                    break;
                }
                case 603643216: {
                    if (var7_7.equals("updateUserRule")) {
                        tmp = 16;
                    }
                    break;
                }
                case 1242932856: {
                    if (var7_7.equals("mounted")) {
                        tmp = 17;
                    }
                    break;
                }
                case 1184932303: {
                    if (var7_7.equals("postUpdateRag")) {
                        tmp = 18;
                    }
                    break;
                }
                case -753073751: {
                    if (var7_7.equals("getIdeCommandById")) {
                        tmp = 19;
                    }
                    break;
                }
                case 221526208: {
                    if (var7_7.equals("getUserMemories")) {
                        tmp = 20;
                    }
                    break;
                }
                case -49135706: {
                    if (var7_7.equals("updateUserRAGConfig")) {
                        tmp = 21;
                    }
                    break;
                }
                case 1214114027: {
                    if (var7_7.equals("ruleFileConflictResponse")) {
                        tmp = 22;
                    }
                    break;
                }
                case 1464310846: {
                    if (var7_7.equals("downloadRuleTemplate")) {
                        tmp = 23;
                    }
                    break;
                }
                case 1057846132: {
                    if (var7_7.equals("getRagStatus")) {
                        tmp = 24;
                    }
                    break;
                }
                case 2004170895: {
                    if (var7_7.equals("syncMemoryFromCloud")) {
                        tmp = 25;
                    }
                    break;
                }
                case 776139709: {
                    if (var7_7.equals("getRuleEp")) {
                        tmp = 26;
                    }
                    break;
                }
            }
            switch (tmp) {
                case 17: {
                    $this$handleMessage_u24lambda_u247 = var9_8 = new StringBuilder();
                    $i$a$-buildString-SettingsPanel$handleMessage$queryParam$1 = false;
                    v1 = this.queryMap;
                    if (v1 != null) {
                        $this$forEach$iv = v1;
                        $i$f$forEach = false;
                        var14_80 = $this$forEach$iv.entrySet().iterator();
                        while (var14_80.hasNext()) {
                            var16_85 = element$iv = var14_80.next();
                            $i$a$-forEach-SettingsPanel$handleMessage$queryParam$1$1 = false;
                            k = var16_85.getKey();
                            v = var16_85.getValue();
                            $this$handleMessage_u24lambda_u247.append(k + "=" + v);
                        }
                        v2 = Unit.INSTANCE;
                    } else {
                        v2 = null;
                    }
                    queryParam = var9_8.toString();
                    ThemeUtilKt.sendToWebview((ExtensionMessage)new Route("route", "/modelConfig?" + queryParam), this.project);
                    break;
                }
                case 12: {
                    v3 /* !! */  = json.get("page");
                    if (v3 /* !! */  == null || (v3 /* !! */  = v3 /* !! */ .getAsString()) == null) {
                        return;
                    }
                    page /* !! */  = v3 /* !! */ ;
                    if (!Intrinsics.areEqual((Object)page /* !! */ , (Object)"/modelConfig")) {
                        return;
                    }
                    ApplicationManager.getApplication().executeOnPooledThread((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, handleMessage$lambda$8(cn.gitlab.kilo.jetbrains.editor.settings.SettingsPanel ), ()V)((SettingsPanel)this));
                    config = CockpitConfiguration.Companion.getInstance().getState();
                    if (this.browser == null) {
                        return;
                    }
                    v4 = config.getCoderiderServerHost();
                    v5 = config.getGitlabHost();
                    v6 = config.getUserId();
                    Intrinsics.checkNotNull((Object)v6);
                    v7 = config.getUserName();
                    if (v7 == null) {
                        v7 = "";
                    }
                    ThemeUtilKt.sendToWebview((ExtensionMessage)new CoderiderAuth(null, new AuthStatus(true, v4, v5, v6, v7), 1, null), this.project);
                    ThemeUtilKt.sendToWebview((ExtensionMessage)new RagConfig(CockpitConfiguration.Companion.getInstance().getSelectedRags(), null, 2, null), this.project);
                    break;
                }
                case 16: {
                    rule = json.get("config").getAsJsonObject().get("userRule").getAsString();
                    if (rule.length() > RulesServiceKt.getRULE_LIMIT()) {
                        v8 = this.browser;
                        if (v8 != null) {
                            ThemeUtilKt.showErrorBalloon(v8, I18nKt.getMessage("rules.user.update.too_long"));
                            v9 = Unit.INSTANCE;
                        } else {
                            v9 = null;
                        }
                        return;
                    }
                    this.props.setValue("UserRule", rule, "");
                    try {
                        v10 = CoderiderClientKt.getCoderiderClient();
                        Intrinsics.checkNotNull((Object)rule);
                        v10.postUpsertRulePersonal(rule);
                        v11 = this.browser;
                        if (v11 != null) {
                            ThemeUtilKt.showInfoBalloon(v11, I18nKt.getMessage("rules.user.update.success"));
                            v12 = Unit.INSTANCE;
                        } else {
                            v12 = null;
                        }
                    }
                    catch (Throwable <unused var>) {
                        v13 = this.browser;
                        if (v13 != null) {
                            ThemeUtilKt.showErrorBalloon(v13, I18nKt.getMessage("rules.user.update.failed"));
                            v14 = Unit.INSTANCE;
                        }
                        v14 = null;
                    }
                    ApplicationManager.getApplication().invokeLater((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, handleMessage$lambda$9(), ()V)());
                    break;
                }
                case 23: {
                    cfg = json.get("config").getAsJsonObject();
                    v15 = this.rulesManager;
                    Intrinsics.checkNotNull((Object)v15);
                    Intrinsics.checkNotNull((Object)cfg);
                    v15.downloadRuleTemplate(cfg);
                    break;
                }
                case 5: {
                    cfg = json.get("config").getAsJsonObject();
                    config = cfg.get("type").getAsString();
                    if (config == null) ** GOTO lbl-1000
                    tmp = -1;
                    switch (config.hashCode()) {
                        case 96417: {
                            if (config.equals("add")) {
                                tmp = 1;
                            }
                            break;
                        }
                        case 3108362: {
                            if (config.equals("edit")) {
                                tmp = 2;
                            }
                            break;
                        }
                        case -1335458389: {
                            if (config.equals("delete")) {
                                tmp = 3;
                            }
                            break;
                        }
                    }
                    switch (tmp) {
                        case 1: {
                            v16 = this.rulesManager;
                            Intrinsics.checkNotNull((Object)v16);
                            Intrinsics.checkNotNull((Object)cfg);
                            v16.addRule(cfg);
                            v17 = Unit.INSTANCE;
                            break;
                        }
                        case 2: {
                            v18 = this.rulesManager;
                            Intrinsics.checkNotNull((Object)v18);
                            Intrinsics.checkNotNull((Object)cfg);
                            v18.editRule(cfg);
                            v17 = Unit.INSTANCE;
                            break;
                        }
                        case 3: {
                            v19 = this.rulesManager;
                            Intrinsics.checkNotNull((Object)v19);
                            Intrinsics.checkNotNull((Object)cfg);
                            v19.deleteRule(cfg);
                            v17 = Unit.INSTANCE;
                            break;
                        }
                        default: lbl-1000:
                        // 2 sources

                        {
                            v17 = Unit.INSTANCE;
                        }
                    }
                    it = config = v17;
                    $i$a$-also-SettingsPanel$handleMessage$4 = false;
                    v20 = this.rulesManager;
                    Intrinsics.checkNotNull((Object)v20);
                    v20.sendRulesFiles();
                    ApplicationManager.getApplication().invokeLater((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, handleMessage$lambda$11(cn.gitlab.kilo.jetbrains.editor.settings.SettingsPanel ), ()V)((SettingsPanel)this));
                    break;
                }
                case 15: {
                    ruleEpList = CoderiderClient.getRuleEpList$default(CoderiderClientKt.getCoderiderClient(), 0, 0, null, 1, 7, null);
                    response = new GetResponse<RuleEpListResponse>(command + "Response", ruleEpList, (String)requestId /* !! */ );
                    ThemeUtilKt.sendToWebview((ExtensionMessage)response, this.project);
                    break;
                }
                case 26: {
                    id = json.get("payload").getAsString();
                    try {
                        v21 = CoderiderClientKt.getCoderiderClient();
                        Intrinsics.checkNotNull((Object)id);
                        ruleEp = v21.getRuleEp(id);
                        response = new GetResponse<RuleEpResponse>(command + "Response", ruleEp, (String)requestId /* !! */ );
                        ThemeUtilKt.sendToWebview((ExtensionMessage)response, this.project);
                        ruleEp = Unit.INSTANCE;
                    }
                    catch (Throwable e) {
                        v22 = this.browser;
                        if (v22 != null) {
                            $this$forEach$iv = I18nKt.getMessage("rules.download.failed");
                            $i$f$forEach = new Object[]{id};
                            v23 = String.format($this$forEach$iv, Arrays.copyOf($i$f$forEach, $i$f$forEach.length));
                            Intrinsics.checkNotNullExpressionValue((Object)v23, (String)"format(...)");
                            ThemeUtilKt.showErrorBalloon(v22, v23 + "\n\n error:" + e.getMessage());
                            v24 = Unit.INSTANCE;
                        } else {
                            v24 = null;
                        }
                        ruleEp = v24;
                    }
                    break;
                }
                case 22: {
                    try {
                        config = json.get("config").getAsJsonObject();
                        action = config.get("action").getAsString();
                        ruleName = config.get("ruleName").getAsString();
                        ruleContent = config.get("ruleContent").getAsString();
                        v25 /* !! */  = config.get("rulePath");
                        if (v25 /* !! */  == null || (v25 /* !! */  = v25 /* !! */ .getAsString()) == null) {
                            v25 /* !! */  = "";
                        }
                        rulePath /* !! */  = v25 /* !! */ ;
                        v26 = config.get("newRuleName");
                        newRuleName = v26 != null ? v26.getAsString() : null;
                        v27 /* !! */  = config.get("ruleActiveType");
                        if (v27 /* !! */  == null || (v27 /* !! */  = v27 /* !! */ .getAsString()) == null) {
                            v27 /* !! */  = ruleActiveType /* !! */  = "";
                        }
                        if (StringsKt.isBlank((CharSequence)((CharSequence)rulePath /* !! */ ))) {
                            v28 = this.rulesManager;
                            Intrinsics.checkNotNull((Object)v28);
                            v29 = v28.getRulesRoot();
                        } else {
                            v30 = this.rulesManager;
                            Intrinsics.checkNotNull((Object)v30);
                            v31 = v30.getRulesRoot().resolve((String)rulePath /* !! */ );
                            v29 = v31;
                            Intrinsics.checkNotNullExpressionValue((Object)v31, (String)"resolve(...)");
                        }
                        dir = v29;
                        v32 = new FileAttribute[]{};
                        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(dir, Arrays.copyOf(v32, v32.length)), (String)"createDirectories(...)");
                        finalRuleName = Intrinsics.areEqual((Object)action, (Object)"rename") != false && (($i$a$-forEach-SettingsPanel$handleMessage$queryParam$1$1 = (CharSequence)newRuleName) == null || StringsKt.isBlank((CharSequence)$i$a$-forEach-SettingsPanel$handleMessage$queryParam$1$1) != false) == false ? newRuleName : ruleName;
                        fileName = finalRuleName + ".md";
                        v33 = dir.resolve(fileName);
                        Intrinsics.checkNotNullExpressionValue((Object)v33, (String)"resolve(...)");
                        file = v33;
                        if (Intrinsics.areEqual((Object)action, (Object)"rename") && !((var19_92 = (Pair[])newRuleName) == null || StringsKt.isBlank((CharSequence)var19_92) != false)) {
                            v34 = new LinkOption[]{};
                            if (Files.exists(file, Arrays.copyOf(v34, v34.length))) {
                                v35 = this.browser;
                                if (v35 != null) {
                                    var20_112 = I18nKt.getMessage("rules.download.file.exists");
                                    var21_114 = new Object[]{fileName};
                                    v36 = String.format((String)var20_112, Arrays.copyOf(var21_114, var21_114.length));
                                    Intrinsics.checkNotNullExpressionValue((Object)v36, (String)"format(...)");
                                    ThemeUtilKt.showErrorBalloon(v35, v36);
                                    v37 = Unit.INSTANCE;
                                } else {
                                    v37 = null;
                                }
                                var19_92 = new Pair[2];
                                var19_92[0] = TuplesKt.to((Object)"type", (Object)"ruleFileConflict");
                                var20_112 = new Pair[]{TuplesKt.to((Object)"ruleName", (Object)ruleName), TuplesKt.to((Object)"ruleContent", (Object)ruleContent), TuplesKt.to((Object)"rulePath", (Object)rulePath /* !! */ ), TuplesKt.to((Object)"existingFileName", (Object)fileName), TuplesKt.to((Object)"ruleActiveType", (Object)ruleActiveType /* !! */ )};
                                var19_92[1] = TuplesKt.to((Object)"config", (Object)MapsKt.mapOf((Pair[])var20_112));
                                ThemeUtilKt.sendToWebview((Map<String, ? extends Object>)MapsKt.mapOf((Pair[])var19_92), jb);
                                return;
                            }
                        }
                        Intrinsics.checkNotNull((Object)ruleContent);
                        v38 = ruleContent;
                        v39 = StandardCharsets.UTF_8;
                        Intrinsics.checkNotNullExpressionValue((Object)v39, (String)"UTF_8");
                        PathsKt.writeText((Path)file, (CharSequence)v38, (Charset)v39, (OpenOption[])new OpenOption[0]);
                        v40 = this.browser;
                        if (v40 != null) {
                            var21_115 = var20_113 = action;
                            var23_116 = v40;
                            $i$a$-takeIf-SettingsPanel$handleMessage$6 = false;
                            var24_118 = Intrinsics.areEqual((Object)it, (Object)"overwrite");
                            v41 /* !! */  = var24_118 != false ? var20_113 : null;
                            if (v41 /* !! */  == null) {
                                v41 /* !! */  = "";
                            }
                            var20_113 = I18nKt.getMessage("rules.download." + (String)v41 /* !! */  + ".success");
                            var21_115 = new Object[]{PathsKt.getName((Path)file)};
                            v42 = String.format((String)var20_113, Arrays.copyOf(var21_115, var21_115.length));
                            Intrinsics.checkNotNullExpressionValue((Object)v42, (String)"format(...)");
                            ThemeUtilKt.showInfoBalloon(var23_116, v42);
                            v43 = Unit.INSTANCE;
                        } else {
                            v43 = null;
                        }
                        v44 = this.rulesManager;
                        Intrinsics.checkNotNull((Object)v44);
                        v44.tryOpenFile(file);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        v45 = this.browser;
                        if (v45 != null) {
                            ruleContent = I18nKt.getMessage("rules.download.process.failed");
                            rulePath = new Object[1];
                            v46 = e.getMessage();
                            if (v46 == null) {
                                v46 = "Unknown error";
                            }
                            rulePath[0] = v46;
                            v47 = String.format(ruleContent, Arrays.copyOf(rulePath, rulePath.length));
                            Intrinsics.checkNotNullExpressionValue((Object)v47, (String)"format(...)");
                            ThemeUtilKt.showErrorBalloon(v45, v47);
                            v48 = Unit.INSTANCE;
                        }
                        v48 = null;
                    }
                    v49 = this.rulesManager;
                    Intrinsics.checkNotNull((Object)v49);
                    v49.sendRulesFiles();
                    ApplicationManager.getApplication().invokeLater((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, handleMessage$lambda$13(), ()V)());
                    break;
                }
                case 7: {
                    cfg = json.get("config").getAsJsonObject();
                    v50 /* !! */  = cfg.get("ruleName");
                    if (v50 /* !! */  == null || (v50 /* !! */  = v50 /* !! */ .getAsString()) == null) {
                        return;
                    }
                    ruleName /* !! */  = v50 /* !! */ ;
                    v51 = cfg.get("ruleActiveType");
                    ruleActiveType = v51 != null ? v51.getAsInt() : 3;
                    v52 = this.rulesManager;
                    Intrinsics.checkNotNull((Object)v52);
                    v53 = v52.getRulesRoot().resolve((String)ruleName /* !! */  + "_" + RulesServiceKt.getRULE_TYPE_TO_FILE().get(ruleActiveType) + ".md");
                    Intrinsics.checkNotNullExpressionValue((Object)v53, (String)"resolve(...)");
                    file = v53;
                    v54 = new LinkOption[]{};
                    if (!Files.exists(file, Arrays.copyOf(v54, v54.length))) {
                        v55 = this.browser;
                        if (v55 != null) {
                            newRuleName = I18nKt.getMessage("rules.open.file.not.found");
                            var14_82 = new Object[]{ruleName /* !! */ };
                            v56 = String.format(newRuleName, Arrays.copyOf(var14_82, var14_82.length));
                            Intrinsics.checkNotNullExpressionValue((Object)v56, (String)"format(...)");
                            ThemeUtilKt.showErrorBalloon(v55, v56);
                            v57 = Unit.INSTANCE;
                        } else {
                            v57 = null;
                        }
                        return;
                    }
                    v58 = this.browser;
                    if (v58 != null) {
                        ThemeUtilKt.showInfoBalloon(v58, I18nKt.getMessage("rules.open.file.hint.settings.exit"));
                        v59 = Unit.INSTANCE;
                    } else {
                        v59 = null;
                    }
                    v60 = this.rulesManager;
                    Intrinsics.checkNotNull((Object)v60);
                    v60.tryOpenFile(file);
                    break;
                }
                case 10: {
                    type = new TypeToken<PostIdeRequest<GetCommandsRequest>>(){}.getType();
                    request = (PostIdeRequest)new Gson().fromJson(raw, type);
                    payload = CoderiderClientKt.getCoderiderClient().getIdeCommandList((GetCommandsRequest)request.getPayload());
                    rulePath = command + "Response";
                    newRuleName = MapsKt.mapOf((Pair)TuplesKt.to((Object)"data", payload));
                    response = new GetResponse<Map>(rulePath, newRuleName, (String)requestId /* !! */ );
                    ThemeUtilKt.sendToWebview((ExtensionMessage)response, this.project);
                    break;
                }
                case 1: {
                    try {
                        type = new TypeToken<PostIdeRequest<PostIdeCommandCreateRequest>>(){}.getType();
                        request = (PostIdeRequest)new Gson().fromJson(raw, type);
                        payload = CoderiderClientKt.getCoderiderClient().postIdeCommandCreate((PostIdeCommandCreateRequest)request.getPayload());
                        rulePath = command + "Response";
                        response = new GetResponse<PostIdeCommandCreateResponse>(rulePath, payload, (String)requestId /* !! */ );
                        ThemeUtilKt.sendToWebview((ExtensionMessage)response, this.project);
                    }
                    catch (Throwable e) {
                        v61 = this.browser;
                        if (v61 != null) {
                            it = v61;
                            $i$a$-let-SettingsPanel$handleMessage$8 = false;
                            CockpitChatPluginServiceKt.handleError$default(it, command, (String)requestId /* !! */ , null, e.getMessage(), null, 40, null);
                            v62 = Unit.INSTANCE;
                            break;
                        }
                        v62 = null;
                    }
                    break;
                }
                case 19: {
                    type = new TypeToken<PostIdeRequest<CoderiderClient.GetIdeCommandRequest>>(){}.getType();
                    request = (PostIdeRequest)new Gson().fromJson(raw, type);
                    payload = CoderiderClientKt.getCoderiderClient().getIdeCommandById((CoderiderClient.GetIdeCommandRequest)request.getPayload());
                    it = command + "Response";
                    response = new GetResponse<GetIdeCommandResponse>(it, payload, (String)requestId /* !! */ );
                    ThemeUtilKt.sendToWebview((ExtensionMessage)response, this.project);
                    break;
                }
                case 13: {
                    type = new TypeToken<PostIdeRequest<PutIdeCommandUpdateRequest>>(){}.getType();
                    request = (PostIdeRequest)new Gson().fromJson(raw, type);
                    payload = CoderiderClientKt.getCoderiderClient().putIdeCommandUpdate((PutIdeCommandUpdateRequest)request.getPayload());
                    it = command + "Response";
                    response = new GetResponse<PutIdeCommandUpdateResponse>(it, payload, (String)requestId /* !! */ );
                    ThemeUtilKt.sendToWebview((ExtensionMessage)response, this.project);
                    break;
                }
                case 14: {
                    type = new TypeToken<PostIdeRequest<DeleteIdeCommandRequest>>(){}.getType();
                    request = (PostIdeRequest)new Gson().fromJson(raw, type);
                    CoderiderClientKt.getCoderiderClient().deleteIdeCommand((DeleteIdeCommandRequest)request.getPayload());
                    payload = Unit.INSTANCE;
                    it = command + "Response";
                    response = new GetResponse<Unit>(it, payload, (String)requestId /* !! */ );
                    ThemeUtilKt.sendToWebview((ExtensionMessage)response, this.project);
                    break;
                }
                case 24: {
                    try {
                        CoderiderClientKt.getCoderiderClient().syncRagConfig();
                        request = command + "Response";
                        payload = CockpitConfiguration.Companion.getInstance().getRags();
                        response = new GetResponse<List<Rag>>(request, payload, (String)requestId /* !! */ );
                        ThemeUtilKt.sendToWebview((ExtensionMessage)response, this.project);
                    }
                    catch (Throwable e) {
                        v63 = this.browser;
                        if (v63 != null) {
                            it = v63;
                            $i$a$-let-SettingsPanel$handleMessage$9 = false;
                            CockpitChatPluginServiceKt.handleError$default(it, command, (String)requestId /* !! */ , null, e.getMessage(), null, 40, null);
                            v64 = Unit.INSTANCE;
                            break;
                        }
                        v64 = null;
                    }
                    break;
                }
                case 4: {
                    v65 = new Gson().fromJson(json.get("payload"), KnowledgeBaseCreateReq.class);
                    Intrinsics.checkNotNullExpressionValue((Object)v65, (String)"fromJson(...)");
                    success = this.ragManager.createKnowledgeBase((KnowledgeBaseCreateReq)v65);
                    payload = command + "Response";
                    response = MapsKt.mapOf((Pair)TuplesKt.to((Object)"success", (Object)success));
                    response = new GetResponse<Map>(payload, response, (String)requestId /* !! */ );
                    ThemeUtilKt.sendToWebview((ExtensionMessage)response, this.project);
                    break;
                }
                case 2: {
                    v66 = json.get("payload").getAsJsonObject().get("kb_project_id").getAsString();
                    Intrinsics.checkNotNullExpressionValue((Object)v66, (String)"getAsString(...)");
                    success = this.ragManager.deleteKnowledgeBase(v66);
                    payload = command + "Response";
                    response = MapsKt.mapOf((Pair)TuplesKt.to((Object)"success", (Object)success));
                    response = new GetResponse<Map>(payload, response, (String)requestId /* !! */ );
                    ThemeUtilKt.sendToWebview((ExtensionMessage)response, this.project);
                    break;
                }
                case 18: {
                    v67 = json.get("payload").getAsJsonObject().get("kb_project_id").getAsString();
                    Intrinsics.checkNotNullExpressionValue((Object)v67, (String)"getAsString(...)");
                    success = this.ragManager.updateKnowledgeBase(v67);
                    payload = command + "Response";
                    response = MapsKt.mapOf((Pair)TuplesKt.to((Object)"success", (Object)success));
                    response = new GetResponse<Map>(payload, response, (String)requestId /* !! */ );
                    ThemeUtilKt.sendToWebview((ExtensionMessage)response, this.project);
                    break;
                }
                case 8: {
                    v68 = json.get("payload").getAsJsonObject().get("kb_project_id").getAsString();
                    Intrinsics.checkNotNullExpressionValue((Object)v68, (String)"getAsString(...)");
                    this.ragManager.terminateKnowledgeBase(v68);
                    break;
                }
                case 9: {
                    v69 = json.get("payload").getAsJsonObject();
                    Intrinsics.checkNotNullExpressionValue((Object)v69, (String)"getAsJsonObject(...)");
                    success = this.ragManager.renameKnowledgeBase(v69);
                    payload = command + "Response";
                    response = MapsKt.mapOf((Pair)TuplesKt.to((Object)"success", (Object)success));
                    response = new GetResponse<Map>(payload, response, (String)requestId /* !! */ );
                    ThemeUtilKt.sendToWebview((ExtensionMessage)response, this.project);
                    break;
                }
                case 20: {
                    v70 = this.memoryManager;
                    Intrinsics.checkNotNull((Object)v70);
                    v70.sendMemories();
                    break;
                }
                case 6: {
                    v71 = this.memoryManager;
                    Intrinsics.checkNotNull((Object)v71);
                    Intrinsics.checkNotNull((Object)json);
                    v71.postUserMemory(json);
                    break;
                }
                case 11: {
                    v72 = this.memoryManager;
                    Intrinsics.checkNotNull((Object)v72);
                    v72.syncMemoryToCloud();
                    break;
                }
                case 25: {
                    v73 = this.memoryManager;
                    Intrinsics.checkNotNull((Object)v73);
                    v73.syncMemoryFromCloud();
                    break;
                }
                case 21: {
                    CockpitConfiguration.Companion.getInstance().setSelectedRags((List)new Gson().fromJson(json.get("config").getAsJsonObject().get("availableKnowledgeBases"), new TypeToken<List<? extends RagSelectItem>>(){}.getType()));
                    break;
                }
                case 3: {
                    v74 = this.browser;
                    if (v74 != null) {
                        it = v74;
                        $i$a$-let-SettingsPanel$handleMessage$11 = false;
                        StorageService.INSTANCE.handleWebviewMessage(raw, it, this.project);
                        v75 = Unit.INSTANCE;
                        break;
                    }
                    v75 = null;
                }
            }
        }
    }

    private static final JBCefJSQuery.Response createBrowser$lambda$3$lambda$1(SettingsPanel this$0, JBCefBrowser $browser, JBCefJSQuery $jsQuery, String msg) {
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)Dispatchers.getIO().plus((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null))), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, msg, $browser, $jsQuery, null){
            int label;
            final /* synthetic */ SettingsPanel this$0;
            final /* synthetic */ String $msg;
            final /* synthetic */ JBCefBrowser $browser;
            final /* synthetic */ JBCefJSQuery $jsQuery;
            {
                this.this$0 = $receiver;
                this.$msg = $msg;
                this.$browser = $browser;
                this.$jsQuery = $jsQuery;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        SettingsPanel.access$handleMessage(this.this$0, this.$msg, this.$browser, this.$jsQuery);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        return null;
    }

    private static final JBCefJSQuery.Response createBrowser$lambda$3$lambda$2(Function1 $tmp0, Object p0) {
        return (JBCefJSQuery.Response)$tmp0.invoke(p0);
    }

    private static final void handleMessage$lambda$8(SettingsPanel this$0) {
        RulesManager rulesManager = this$0.rulesManager;
        Intrinsics.checkNotNull((Object)rulesManager);
        rulesManager.sendRulesFiles();
    }

    private static final void handleMessage$lambda$9() {
        VirtualFileManager.getInstance().syncRefresh();
    }

    private static final void handleMessage$lambda$11(SettingsPanel this$0) {
        block0: {
            VirtualFileManager.getInstance().syncRefresh();
            Object object = ToolWindowManager.Companion.getInstance(this$0.project).getToolWindow("CodeRider-Kilo");
            if (object == null || (object = object.getContentManager()) == null || (object = object.getSelectedContent()) == null || (object = object.getComponent()) == null) break block0;
            ((JComponent)object).requestFocusInWindow();
        }
    }

    private static final void handleMessage$lambda$13() {
        VirtualFileManager.getInstance().syncRefresh();
    }

    public static final /* synthetic */ void access$handleMessage(SettingsPanel $this, String raw, JBCefBrowser jb, JBCefJSQuery q) {
        $this.handleMessage(raw, jb, q);
    }

    public static final /* synthetic */ Unit access$onThemeChanged(SettingsPanel $this) {
        return $this.onThemeChanged();
    }
}

