/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.editor.settings;

import cn.gitlab.kilo.jetbrains.editor.settings.SettingsPanel;
import cn.gitlab.kilo.jetbrains.editor.settings.SettingsVirtualFile;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\rJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u000fH\u0016J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0016J\b\u0010\u001b\u001a\u00020\u0005H\u0016J\b\u0010\u001c\u001a\u00020\rH\u0016J\u0010\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J)\u0010!\u001a\u0004\u0018\u0001H\"\"\n\b\u0000\u0010\"*\u0004\u0018\u00010#2\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H\"0%H\u0016\u00a2\u0006\u0002\u0010&J1\u0010'\u001a\u00020\r\"\n\b\u0000\u0010\"*\u0004\u0018\u00010#2\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H\"0%2\b\u0010(\u001a\u0004\u0018\u0001H\"H\u0016\u00a2\u0006\u0002\u0010)R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcn/gitlab/kilo/jetbrains/editor/settings/SettingsEditor;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;)V", "settingsPanel", "Lcn/gitlab/kilo/jetbrains/editor/settings/SettingsPanel;", "component", "Ljavax/swing/JPanel;", "sendRouteMessage", "", "page", "", "refreshMemory", "getComponent", "Ljavax/swing/JComponent;", "getPreferredFocusedComponent", "getName", "setState", "state", "Lcom/intellij/openapi/fileEditor/FileEditorState;", "isModified", "", "isValid", "getFile", "dispose", "addPropertyChangeListener", "listener", "Ljava/beans/PropertyChangeListener;", "removePropertyChangeListener", "getUserData", "T", "", "key", "Lcom/intellij/openapi/util/Key;", "(Lcom/intellij/openapi/util/Key;)Ljava/lang/Object;", "putUserData", "value", "(Lcom/intellij/openapi/util/Key;Ljava/lang/Object;)V", "coderider-kilo-jetbrains"})
public final class SettingsEditor
implements FileEditor {
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile file;
    @NotNull
    private final SettingsPanel settingsPanel;
    @Nullable
    private final JPanel component;

    public SettingsEditor(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.project = project;
        VirtualFile virtualFile = this.file = file;
        SettingsVirtualFile settingsVirtualFile = virtualFile instanceof SettingsVirtualFile ? (SettingsVirtualFile)virtualFile : null;
        this.settingsPanel = new SettingsPanel(this.project, settingsVirtualFile != null ? settingsVirtualFile.getQueryParam() : null);
        this.component = this.settingsPanel.getPanel();
    }

    public final void sendRouteMessage(@NotNull String page) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        this.settingsPanel.sendRouteMessage(page);
    }

    public final void refreshMemory() {
        this.settingsPanel.refreshMemory();
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.component;
        Intrinsics.checkNotNull((Object)jPanel);
        return jPanel;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JPanel jPanel = this.component;
        Intrinsics.checkNotNull((Object)jPanel);
        return jPanel;
    }

    @NotNull
    public String getName() {
        return "CodeRider-Kilo Settings";
    }

    public void setState(@NotNull FileEditorState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    @NotNull
    public VirtualFile getFile() {
        return this.file;
    }

    public void dispose() {
        this.settingsPanel.dispose();
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return null;
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
    }
}

