/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.editor.settings;

import cn.gitlab.kilo.jetbrains.client.CoderiderClient;
import cn.gitlab.kilo.jetbrains.client.CoderiderClientKt;
import cn.gitlab.kilo.jetbrains.client.GetUserMemoryReq;
import cn.gitlab.kilo.jetbrains.client.GetUserMemoryResponse;
import cn.gitlab.kilo.jetbrains.client.UpsertUserMemoryReq;
import cn.gitlab.kilo.jetbrains.common.ExtensionMessage;
import cn.gitlab.kilo.jetbrains.common.I18nKt;
import cn.gitlab.kilo.jetbrains.common.MessageTip;
import cn.gitlab.kilo.jetbrains.composer.prompts.MemoryInfo;
import cn.gitlab.kilo.jetbrains.composer.prompts.ProjectMemoryPrompterKt;
import cn.gitlab.kilo.jetbrains.config.CockpitConfiguration;
import cn.gitlab.kilo.jetbrains.config.UserMemoryStorage;
import cn.gitlab.kilo.jetbrains.utils.ThemeUtilKt;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.openapi.project.Project;
import com.intellij.ui.jcef.JBCefBrowser;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0011J\u0006\u0010\u0016\u001a\u00020\u0011J\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u000f*\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u000fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcn/gitlab/kilo/jetbrains/editor/settings/MemoryManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "browser", "Lcom/intellij/ui/jcef/JBCefBrowser;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ui/jcef/JBCefBrowser;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getBrowser", "()Lcom/intellij/ui/jcef/JBCefBrowser;", "userMemoryStorage", "Lcn/gitlab/kilo/jetbrains/config/UserMemoryStorage;", "projectCategory", "", "sendMemories", "", "postUserMemory", "req", "Lcom/google/gson/JsonObject;", "syncMemoryToCloud", "syncMemoryFromCloud", "safeAsString", "key", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nMemoryManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MemoryManager.kt\ncn/gitlab/kilo/jetbrains/editor/settings/MemoryManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,209:1\n1878#2,3:210\n1869#2,2:213\n1869#2,2:215\n1#3:217\n*S KotlinDebug\n*F\n+ 1 MemoryManager.kt\ncn/gitlab/kilo/jetbrains/editor/settings/MemoryManager\n*L\n30#1:210,3\n125#1:213,2\n170#1:215,2\n*E\n"})
public final class MemoryManager {
    @NotNull
    private final Project project;
    @NotNull
    private final JBCefBrowser browser;
    @NotNull
    private final UserMemoryStorage userMemoryStorage;
    @NotNull
    private final String projectCategory;

    public MemoryManager(@NotNull Project project, @NotNull JBCefBrowser browser) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)browser, (String)"browser");
        this.project = project;
        this.browser = browser;
        this.userMemoryStorage = UserMemoryStorage.Companion.getInstance();
        this.projectCategory = "project_overview";
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final JBCefBrowser getBrowser() {
        return this.browser;
    }

    /*
     * WARNING - void declaration
     */
    public final void sendMemories() {
        JsonObject userMemories = new JsonObject();
        try {
            String string;
            void $this$sendMemories_u24lambda_u243;
            JsonObject jsonObject2;
            Iterable $this$forEachIndexed$iv = UserMemoryStorage.Companion.getCategoryList();
            boolean $i$f$forEachIndexed = false;
            int index$iv22 = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void $this$sendMemories_u24lambda_u242_u24lambda_u241;
                Unit unit;
                JsonObject $this$sendMemories_u24lambda_u242_u24lambda_u240;
                JsonObject jsonObject3;
                void var14_21;
                JsonObject jsonObject4;
                void category;
                int n;
                if ((n = index$iv22++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String string2 = (String)item$iv;
                int index = n;
                boolean bl = false;
                MemoryInfo memory = this.userMemoryStorage.getMemory((String)category);
                if (memory == null) {
                    JsonObject jsonObject5 = jsonObject4 = new JsonObject();
                    var14_21 = category;
                    jsonObject3 = userMemories;
                    boolean bl2 = false;
                    $this$sendMemories_u24lambda_u242_u24lambda_u240.addProperty("id", String.valueOf(index));
                    $this$sendMemories_u24lambda_u242_u24lambda_u240.addProperty("category", (String)category);
                    $this$sendMemories_u24lambda_u242_u24lambda_u240.addProperty("content", "");
                    $this$sendMemories_u24lambda_u242_u24lambda_u240.addProperty("createdAt", "");
                    $this$sendMemories_u24lambda_u242_u24lambda_u240.addProperty("updatedAt", "");
                    $this$sendMemories_u24lambda_u242_u24lambda_u240.addProperty("source", "auto");
                    $this$sendMemories_u24lambda_u242_u24lambda_u240.addProperty("memory_loom_mode", (Number)1);
                    $this$sendMemories_u24lambda_u242_u24lambda_u240.addProperty("memory_chat_mode", (Number)1);
                    unit = Unit.INSTANCE;
                    jsonObject3.add((String)var14_21, (JsonElement)jsonObject4);
                    continue;
                }
                $this$sendMemories_u24lambda_u242_u24lambda_u240 = jsonObject4 = new JsonObject();
                var14_21 = category;
                jsonObject3 = userMemories;
                boolean bl3 = false;
                $this$sendMemories_u24lambda_u242_u24lambda_u241.addProperty("id", String.valueOf(index));
                $this$sendMemories_u24lambda_u242_u24lambda_u241.addProperty("category", (String)category);
                $this$sendMemories_u24lambda_u242_u24lambda_u241.addProperty("content", memory.getContent());
                if (!StringsKt.isBlank((CharSequence)memory.getTags())) {
                    String[] stringArray = new String[]{","};
                    List tagList = StringsKt.split$default((CharSequence)memory.getTags(), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                    $this$sendMemories_u24lambda_u242_u24lambda_u241.add("tags", (JsonElement)new Gson().toJsonTree(tagList.subList(0, Math.min(3, tagList.size()))).getAsJsonArray());
                }
                $this$sendMemories_u24lambda_u242_u24lambda_u241.addProperty("createdAt", "");
                $this$sendMemories_u24lambda_u242_u24lambda_u241.addProperty("updatedAt", "");
                $this$sendMemories_u24lambda_u242_u24lambda_u241.addProperty("source", "auto");
                $this$sendMemories_u24lambda_u242_u24lambda_u241.addProperty("memory_loom_mode", (Number)(memory.getLoom() ? 1 : 0));
                $this$sendMemories_u24lambda_u242_u24lambda_u241.addProperty("memory_chat_mode", (Number)(memory.getChat() ? 1 : 0));
                unit = Unit.INSTANCE;
                jsonObject3.add((String)var14_21, (JsonElement)jsonObject4);
            }
            UserMemoryStorage.UserMemoryScope userMemoryScope = this.userMemoryStorage.getUserMemoryState();
            JsonObject index$iv22 = jsonObject2 = new JsonObject();
            String string3 = this.projectCategory;
            JsonObject jsonObject6 = userMemories;
            boolean bl = false;
            $this$sendMemories_u24lambda_u243.addProperty("id", "4");
            $this$sendMemories_u24lambda_u243.addProperty("category", this.projectCategory);
            String string4 = this.project.getBasePath();
            if (string4 == null) {
                string4 = "";
            }
            if ((string = ProjectMemoryPrompterKt.getProjectMemoryContent(string4)) == null) {
                string = "";
            }
            $this$sendMemories_u24lambda_u243.addProperty("content", string);
            $this$sendMemories_u24lambda_u243.addProperty("createdAt", "");
            $this$sendMemories_u24lambda_u243.addProperty("updatedAt", "");
            $this$sendMemories_u24lambda_u243.addProperty("source", "auto");
            $this$sendMemories_u24lambda_u243.addProperty("memory_loom_mode", (Number)(userMemoryScope.getLoom() ? 1 : 0));
            $this$sendMemories_u24lambda_u243.addProperty("memory_chat_mode", (Number)(userMemoryScope.getChat() ? 1 : 0));
            Unit unit = Unit.INSTANCE;
            jsonObject6.add(string3, (JsonElement)jsonObject2);
            JsonObject $this$sendMemories_u24lambda_u244 = jsonObject2 = new JsonObject();
            boolean bl4 = false;
            $this$sendMemories_u24lambda_u244.addProperty("type", "userMemories");
            $this$sendMemories_u24lambda_u244.add("memories", (JsonElement)userMemories);
            $this$sendMemories_u24lambda_u244.addProperty("memoryEnabled", Boolean.valueOf(CockpitConfiguration.Companion.getInstance().getState().getMemoryOpen()));
            $this$sendMemories_u24lambda_u244.addProperty("memoryEverEnabled", Boolean.valueOf(userMemoryScope.getEverOpen()));
            ThemeUtilKt.sendToWebview(jsonObject2, this.browser);
        }
        catch (Throwable e) {
            JsonObject jsonObject7;
            JsonObject $this$sendMemories_u24lambda_u245 = jsonObject7 = new JsonObject();
            boolean bl = false;
            $this$sendMemories_u24lambda_u245.addProperty("type", "userMemories");
            $this$sendMemories_u24lambda_u245.add("memories", (JsonElement)new JsonObject());
            ThemeUtilKt.sendToWebview(jsonObject7, this.browser);
        }
    }

    public final void postUserMemory(@NotNull JsonObject req) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        try {
            JsonObject jsonObject2 = req.get("memory").getAsJsonObject();
            Intrinsics.checkNotNull((Object)jsonObject2);
            JsonObject memory = jsonObject2;
            String category = this.safeAsString(req, "category");
            if (Intrinsics.areEqual((Object)category, (Object)this.projectCategory)) {
                UserMemoryStorage.UserMemoryScope userMemoryScope = this.userMemoryStorage.getUserMemoryState();
                String string = this.safeAsString(memory, "content");
                if (string == null) {
                    string = "";
                }
                ProjectMemoryPrompterKt.updateProjectMemoryContent(string, this.project);
                String string2 = this.safeAsString(memory, "memory_loom_mode");
                if (string2 == null) {
                    string2 = "1";
                }
                userMemoryScope.setLoom(Intrinsics.areEqual((Object)string2, (Object)"1"));
                String string3 = this.safeAsString(memory, "memory_chat_mode");
                if (string3 == null) {
                    string3 = "1";
                }
                userMemoryScope.setChat(Intrinsics.areEqual((Object)string3, (Object)"1"));
            } else if (CollectionsKt.contains((Iterable)UserMemoryStorage.Companion.getCategoryList(), (Object)category)) {
                String string;
                MemoryInfo memoryInfo;
                String string4 = category;
                Intrinsics.checkNotNull((Object)string4);
                MemoryInfo memoryInfo2 = this.userMemoryStorage.getMemory(string4);
                if (memoryInfo2 == null) {
                    memoryInfo2 = memoryInfo = new MemoryInfo(category, null, null, false, false, 30, null);
                }
                if ((string = this.safeAsString(memory, "content")) == null) {
                    string = "";
                }
                memoryInfo.setContent(string);
                String string5 = this.safeAsString(memory, "memory_loom_mode");
                if (string5 == null) {
                    string5 = "1";
                }
                memoryInfo.setLoom(Intrinsics.areEqual((Object)string5, (Object)"1"));
                String string6 = this.safeAsString(memory, "memory_chat_mode");
                if (string6 == null) {
                    string6 = "1";
                }
                memoryInfo.setChat(Intrinsics.areEqual((Object)string6, (Object)"1"));
                this.userMemoryStorage.putMemory(memoryInfo);
            }
            this.sendMemories();
            MessageTip msg = new MessageTip(null, "info", I18nKt.getMessage("memory.setting.card.update.success"), 1, null);
            ThemeUtilKt.sendToWebview((ExtensionMessage)msg, this.project);
        }
        catch (Throwable throwable) {
            MessageTip msg = new MessageTip(null, "error", I18nKt.getMessage("memory.setting.card.update.failed"), 1, null);
            ThemeUtilKt.sendToWebview((ExtensionMessage)msg, this.project);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void syncMemoryToCloud() {
        try {
            UpsertUserMemoryReq upsertUserMemoryReq;
            int n;
            Object object;
            Iterable $this$forEach$iv = this.userMemoryStorage.getMemories().values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                UpsertUserMemoryReq upsertUserMemoryReq2;
                MemoryInfo memoryInfo = (MemoryInfo)element$iv;
                boolean bl = false;
                Object object2 = CoderiderClientKt.getCoderiderClient();
                if (CockpitConfiguration.Companion.getInstance().getState().getUserId() != null) {
                    void id;
                    object = object2;
                    boolean bl2 = false;
                    n = Integer.parseInt((String)id);
                    String string = memoryInfo.getCategory();
                    String string2 = memoryInfo.getContent();
                    String string3 = memoryInfo.getTags();
                    String string4 = this.userMemoryStorage.getPlatformType();
                    boolean bl3 = memoryInfo.getLoom();
                    boolean bl4 = memoryInfo.getChat();
                    upsertUserMemoryReq2 = new UpsertUserMemoryReq(n, string, string4, string3, bl3, bl4, string2);
                    object2 = object;
                } else {
                    upsertUserMemoryReq2 = null;
                }
                ((CoderiderClient)object2).postUpsertUserMemory(upsertUserMemoryReq2);
            }
            UserMemoryStorage.UserMemoryScope userMemoryScope = this.userMemoryStorage.getUserMemoryState();
            CoderiderClient coderiderClient = CoderiderClientKt.getCoderiderClient();
            String string = CockpitConfiguration.Companion.getInstance().getState().getUserId();
            if (string != null) {
                void id;
                Object element$iv;
                element$iv = string;
                CoderiderClient coderiderClient2 = coderiderClient;
                boolean bl = false;
                int n2 = Integer.parseInt((String)id);
                String string5 = this.projectCategory;
                object = this.userMemoryStorage.getPlatformType();
                boolean bl5 = userMemoryScope.getLoom();
                n = userMemoryScope.getChat() ? 1 : 0;
                upsertUserMemoryReq = new UpsertUserMemoryReq(n2, string5, (String)object, "", bl5, n != 0, "");
                coderiderClient = coderiderClient2;
            } else {
                upsertUserMemoryReq = null;
            }
            coderiderClient.postUpsertUserMemory(upsertUserMemoryReq);
            MessageTip msg = new MessageTip(null, "info", I18nKt.getMessage("memory.setting.card.push.success"), 1, null);
            ThemeUtilKt.sendToWebview((ExtensionMessage)msg, this.project);
        }
        catch (Throwable throwable) {
            MessageTip msg = new MessageTip(null, "error", I18nKt.getMessage("memory.setting.card.push.failed"), 1, null);
            ThemeUtilKt.sendToWebview((ExtensionMessage)msg, this.project);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void syncMemoryFromCloud() {
        try {
            GetUserMemoryReq getUserMemoryReq;
            CoderiderClient coderiderClient = CoderiderClientKt.getCoderiderClient();
            String string = CockpitConfiguration.Companion.getInstance().getState().getUserId();
            if (string != null) {
                void id;
                String string2 = string;
                CoderiderClient coderiderClient2 = coderiderClient;
                boolean bl = false;
                getUserMemoryReq = new GetUserMemoryReq(Integer.parseInt((String)id), this.userMemoryStorage.getPlatformType(), null, 4, null);
                coderiderClient = coderiderClient2;
            } else {
                getUserMemoryReq = null;
            }
            List<GetUserMemoryResponse> memories = coderiderClient.getUserMemory(getUserMemoryReq);
            ConcurrentHashMap newUserMemories = new ConcurrentHashMap();
            boolean chat2 = false;
            chat2 = true;
            boolean loom = false;
            loom = true;
            Iterable $this$forEach$iv = memories;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                GetUserMemoryResponse response = (GetUserMemoryResponse)element$iv;
                boolean bl = false;
                if (Intrinsics.areEqual((Object)response.getMemoryType(), (Object)this.projectCategory)) {
                    loom = response.getMemoryLoomMode();
                    chat2 = response.getMemoryChatMode();
                    continue;
                }
                ((Map)newUserMemories).put(response.getMemoryType(), new MemoryInfo(response.getMemoryType(), response.getMemoryContent(), response.getMemoryTag(), response.getMemoryChatMode(), response.getMemoryLoomMode()));
            }
            this.userMemoryStorage.putMemories(newUserMemories, chat2, loom);
            this.sendMemories();
            MessageTip msg = new MessageTip(null, "info", I18nKt.getMessage("memory.setting.card.pull.success"), 1, null);
            ThemeUtilKt.sendToWebview((ExtensionMessage)msg, this.project);
        }
        catch (Throwable throwable) {
            MessageTip msg = new MessageTip(null, "error", I18nKt.getMessage("memory.setting.card.pull.failed"), 1, null);
            ThemeUtilKt.sendToWebview((ExtensionMessage)msg, this.project);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String safeAsString(JsonObject $this$safeAsString, String key) {
        JsonElement jsonElement;
        JsonElement jsonElement3 = $this$safeAsString.get(key);
        jsonElement3 = jsonElement3;
        if (jsonElement2 == null) return null;
        JsonElement it = jsonElement = jsonElement3;
        boolean bl = false;
        if (it.isJsonNull()) return null;
        boolean bl2 = true;
        if (!bl2) return null;
        JsonElement jsonElement3 = jsonElement;
        jsonElement3 = jsonElement3;
        if (jsonElement4 == null) return null;
        String string = jsonElement3.getAsString();
        return string;
    }
}

