/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.editor;

import cn.gitlab.kilo.jetbrains.services.GitlabService;
import cn.gitlab.kilo.jetbrains.utils.ThemeUtilKt;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.ui.jcef.JBCefBrowser;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003\u001a\u001e\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003\u00a8\u0006\u000b"}, d2={"isMr", "", "jsonObject", "Lcom/google/gson/JsonObject;", "handleSendNotesForSingleFileCodeReview", "", "message", "panel", "Lcom/intellij/ui/jcef/JBCefBrowser;", "issuable", "handleSendNotesForMultipleFileCodeReviews", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nGitlabBrowserEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitlabBrowserEditor.kt\ncn/gitlab/kilo/jetbrains/editor/GitlabBrowserEditorKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,717:1\n1869#2,2:718\n*S KotlinDebug\n*F\n+ 1 GitlabBrowserEditor.kt\ncn/gitlab/kilo/jetbrains/editor/GitlabBrowserEditorKt\n*L\n639#1:718,2\n*E\n"})
public final class GitlabBrowserEditorKt {
    public static final boolean isMr(@NotNull JsonObject jsonObject2) {
        Intrinsics.checkNotNullParameter((Object)jsonObject2, (String)"jsonObject");
        JsonElement sha = jsonObject2.get("sha");
        return sha != null;
    }

    public static final void handleSendNotesForSingleFileCodeReview(@NotNull JsonObject message, @NotNull JBCefBrowser panel, @NotNull JsonObject issuable) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)panel, (String)"panel");
        Intrinsics.checkNotNullParameter((Object)issuable, (String)"issuable");
        try {
            JsonElement jsonElement = message.get("mrId");
            if (jsonElement == null) {
                throw new IllegalArgumentException("mrId is missing");
            }
            Object object = message.get("text");
            if (object == null || (object = object.getAsString()) == null) {
                throw new IllegalArgumentException("text is missing");
            }
            JsonElement jsonElement2 = message.get("commentInfo");
            if (jsonElement2 == null || (jsonElement2 = jsonElement2.getAsJsonObject()) == null) {
                throw new IllegalArgumentException("commentInfo is missing");
            }
            GitlabService.INSTANCE.createDiffNote(jsonElement.getAsInt(), (String)object, (JsonObject)jsonElement2);
            List<JsonObject> discussionsAndLabels = GitlabService.INSTANCE.getDiscussionsAndLabelEvents(issuable);
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"type", (Object)"issuableFetch"), TuplesKt.to((Object)"issuable", (Object)issuable), TuplesKt.to((Object)"discussions", discussionsAndLabels)};
            ThemeUtilKt.sendToWebview((Map<String, ? extends Object>)MapsKt.mapOf((Pair[])pairArray), panel);
            ThemeUtilKt.sendToWebview((Map<String, ? extends Object>)MapsKt.mapOf((Pair)TuplesKt.to((Object)"type", (Object)"closeSingleFileCodeReviewModel")), panel);
            pairArray = new Pair[3];
            pairArray[0] = TuplesKt.to((Object)"type", (Object)"tipMessage");
            JsonElement jsonElement3 = message.get("path");
            pairArray[1] = TuplesKt.to((Object)"messageText", (Object)((jsonElement3 != null ? jsonElement3.getAsString() : null) + "\u6dfb\u52a0\u8bc4\u8bba\u6210\u529f"));
            pairArray[2] = TuplesKt.to((Object)"messageType", (Object)"success");
            ThemeUtilKt.sendToWebview((Map<String, ? extends Object>)MapsKt.mapOf((Pair[])pairArray), panel);
        }
        catch (Exception e) {
            Pair[] pairArray = new Pair[3];
            pairArray[0] = TuplesKt.to((Object)"type", (Object)"tipMessage");
            Object object = e.getMessage();
            if (object == null) {
                JsonElement jsonElement = message.get("path");
                object = (jsonElement != null ? jsonElement.getAsString() : null) + "\u6dfb\u52a0\u8bc4\u8bba\u5931\u8d25";
            }
            pairArray[1] = TuplesKt.to((Object)"messageText", (Object)object);
            pairArray[2] = TuplesKt.to((Object)"messageType", (Object)"error");
            ThemeUtilKt.sendToWebview((Map<String, ? extends Object>)MapsKt.mapOf((Pair[])pairArray), panel);
        }
    }

    public static final void handleSendNotesForMultipleFileCodeReviews(@NotNull JsonObject message, @NotNull JBCefBrowser panel, @NotNull JsonObject issuable) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)panel, (String)"panel");
        Intrinsics.checkNotNullParameter((Object)issuable, (String)"issuable");
        try {
            JsonElement jsonElement = message.get("noteRequests");
            if (jsonElement == null || (jsonElement = jsonElement.getAsJsonArray()) == null) {
                throw new IllegalArgumentException("noteRequests is missing");
            }
            JsonElement noteRequests = jsonElement;
            List successPaths = new ArrayList();
            List failedPaths = new ArrayList();
            Iterable $this$forEach$iv = (Iterable)noteRequests;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                JsonElement noteRequestElement = (JsonElement)element$iv;
                boolean bl = false;
                JsonObject noteRequest = noteRequestElement.getAsJsonObject();
                try {
                    JsonElement jsonElement2 = noteRequest.get("mrId");
                    if (jsonElement2 == null) {
                        throw new IllegalArgumentException("mrId is missing");
                    }
                    Object object = noteRequest.get("text");
                    if (object == null || (object = object.getAsString()) == null) {
                        throw new IllegalArgumentException("text is missing");
                    }
                    JsonElement jsonElement3 = noteRequest.get("commentInfo");
                    if (jsonElement3 == null || (jsonElement3 = jsonElement3.getAsJsonObject()) == null) {
                        throw new IllegalArgumentException("commentInfo is missing");
                    }
                    GitlabService.INSTANCE.createDiffNote(jsonElement2.getAsInt(), (String)object, (JsonObject)jsonElement3);
                    Object object2 = noteRequest.get("path");
                    if (object2 == null || (object2 = object2.getAsString()) == null) {
                        object2 = "unknown";
                    }
                    successPaths.add(object2);
                }
                catch (Exception e) {
                    Object object = noteRequest.get("path");
                    if (object == null || (object = object.getAsString()) == null) {
                        object = "unknown";
                    }
                    failedPaths.add(object);
                }
            }
            List<JsonObject> discussionsAndLabels = GitlabService.INSTANCE.getDiscussionsAndLabelEvents(issuable);
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"type", (Object)"issuableFetch"), TuplesKt.to((Object)"issuable", (Object)issuable), TuplesKt.to((Object)"discussions", discussionsAndLabels)};
            ThemeUtilKt.sendToWebview((Map<String, ? extends Object>)MapsKt.mapOf((Pair[])pairArray), panel);
            ThemeUtilKt.sendToWebview((Map<String, ? extends Object>)MapsKt.mapOf((Pair)TuplesKt.to((Object)"type", (Object)"closeSingleFileCodeReviewModel")), panel);
            if (failedPaths.isEmpty()) {
                pairArray = new Pair[]{TuplesKt.to((Object)"type", (Object)"tipMessage"), TuplesKt.to((Object)"messageText", (Object)("\u6dfb\u52a0\u8bc4\u8bba\u6210\u529f\u5171 " + noteRequests.size() + " \u6761")), TuplesKt.to((Object)"messageType", (Object)"success")};
                ThemeUtilKt.sendToWebview((Map<String, ? extends Object>)MapsKt.mapOf((Pair[])pairArray), panel);
            } else {
                pairArray = new Pair[]{TuplesKt.to((Object)"type", (Object)"tipMessage"), TuplesKt.to((Object)"messageText", (Object)("\u6210\u529f\u6dfb\u52a0 " + successPaths.size() + " \u6761\u8bc4\u8bba\uff0c\u5931\u8d25 " + failedPaths.size() + " \u6761")), TuplesKt.to((Object)"messageType", (Object)"error"), TuplesKt.to((Object)"list", (Object)failedPaths)};
                ThemeUtilKt.sendToWebview((Map<String, ? extends Object>)MapsKt.mapOf((Pair[])pairArray), panel);
            }
        }
        catch (Exception e) {
            Pair[] pairArray = new Pair[3];
            pairArray[0] = TuplesKt.to((Object)"type", (Object)"tipMessage");
            String string = e.getMessage();
            if (string == null) {
                string = "\u6dfb\u52a0\u8bc4\u8bba\u5931\u8d25";
            }
            pairArray[1] = TuplesKt.to((Object)"messageText", (Object)string);
            pairArray[2] = TuplesKt.to((Object)"messageType", (Object)"error");
            ThemeUtilKt.sendToWebview((Map<String, ? extends Object>)MapsKt.mapOf((Pair[])pairArray), panel);
        }
    }
}

