/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.edit.widget;

import cn.gitlab.kilo.jetbrains.common.Logger;
import cn.gitlab.kilo.jetbrains.common.Range;
import cn.gitlab.kilo.jetbrains.edit.widget.LensAction;
import cn.gitlab.kilo.jetbrains.edit.widget.LensWidget;
import cn.gitlab.kilo.jetbrains.edit.widget.LensWidgetGroup;
import cn.gitlab.kilo.jetbrains.edit.widget.LensWidgetGroupKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.ui.JBColor;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002*\u0002\u0018\u001b\u0018\u0000 Y2\u00020\u00012\u00020\u0002:\u0001YB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u00101\u001a\u000202H\u0002J\u0018\u00103\u001a\u0002022\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u001eH\u0007J\u0006\u00107\u001a\u000202J\b\u00108\u001a\u00020&H\u0002J\u0014\u00109\u001a\u00020&2\n\u0010*\u001a\u0006\u0012\u0002\b\u00030+H\u0016J\u0014\u0010:\u001a\u00020&2\n\u0010*\u001a\u0006\u0012\u0002\b\u00030+H\u0016J\b\u0010;\u001a\u00020<H\u0002J\u000e\u0010=\u001a\u00020<2\u0006\u0010>\u001a\u00020\u0014J,\u0010?\u001a\u0002022\n\u0010*\u001a\u0006\u0012\u0002\b\u00030+2\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020EH\u0016J\u001a\u0010F\u001a\u0004\u0018\u00010\u00142\u0006\u0010G\u001a\u00020&2\u0006\u0010H\u001a\u00020&H\u0002J\u000e\u0010I\u001a\u0002022\u0006\u0010>\u001a\u00020\u0014J\b\u0010J\u001a\u00020&H\u0002J\u0006\u0010K\u001a\u000202J\u0010\u0010L\u001a\u0002022\u0006\u0010M\u001a\u00020NH\u0002J\u0010\u0010O\u001a\u0002022\u0006\u0010M\u001a\u00020NH\u0002J\b\u0010P\u001a\u000202H\u0016J\b\u0010Q\u001a\u000202H\u0003J\"\u0010R\u001a\b\u0012\u0004\u0012\u0002HT0S\"\u0004\b\u0000\u0010T2\f\u0010U\u001a\b\u0012\u0004\u0012\u0002HT0VH\u0002J\b\u0010W\u001a\u00020XH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0010\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0019R\u0010\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u001f\u001a\u0010\u0012\f\u0012\n \"*\u0004\u0018\u00010!0!0 \u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u001c\u0010%\u001a\u0010\u0012\f\u0012\n \"*\u0004\u0018\u00010&0&0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010'\u001a\u0004\u0018\u00010(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010)\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010*\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010+X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u000e\u00100\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006Z"}, d2={"Lcn/gitlab/kilo/jetbrains/edit/widget/LensWidgetGroup;", "Lcom/intellij/openapi/editor/EditorCustomElementRenderer;", "Lcom/intellij/openapi/Disposable;", "parentComponent", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/editor/Editor;)V", "logger", "Lcn/gitlab/kilo/jetbrains/common/Logger;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "getEditor", "()Lcom/intellij/openapi/editor/impl/EditorImpl;", "isDisposed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "addedListeners", "removedListeners", "widgets", "", "Lcn/gitlab/kilo/jetbrains/edit/widget/LensWidget;", "getWidgets", "()Ljava/util/List;", "mouseClickListener", "cn/gitlab/kilo/jetbrains/edit/widget/LensWidgetGroup$mouseClickListener$1", "Lcn/gitlab/kilo/jetbrains/edit/widget/LensWidgetGroup$mouseClickListener$1;", "mouseMotionListener", "cn/gitlab/kilo/jetbrains/edit/widget/LensWidgetGroup$mouseMotionListener$1", "Lcn/gitlab/kilo/jetbrains/edit/widget/LensWidgetGroup$mouseMotionListener$1;", "listenersMuted", "", "widgetFont", "Ljava/util/concurrent/atomic/AtomicReference;", "Ljava/awt/Font;", "kotlin.jvm.PlatformType", "getWidgetFont", "()Ljava/util/concurrent/atomic/AtomicReference;", "inlayHeight", "", "widgetFontMetrics", "Ljava/awt/FontMetrics;", "lastHoveredWidget", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "getInlay", "()Lcom/intellij/openapi/editor/Inlay;", "setInlay", "(Lcom/intellij/openapi/editor/Inlay;)V", "lastComputedIndent", "updateFonts", "", "show", "range", "Lcn/gitlab/kilo/jetbrains/common/Range;", "shouldScrollToLens", "update", "computeInlayHeight", "calcWidthInPixels", "calcHeightInPixels", "widgetGroupXY", "Ljava/awt/Point;", "widgetXY", "widget", "paint", "g", "Ljava/awt/Graphics2D;", "targetRegion", "Ljava/awt/geom/Rectangle2D;", "textAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "findWidgetAt", "x", "y", "addWidget", "leftMargin", "reset", "handleMouseClick", "e", "Lcom/intellij/openapi/editor/event/EditorMouseEvent;", "handleMouseMove", "dispose", "disposeInlay", "onEventThread", "Ljava/util/concurrent/CompletableFuture;", "T", "handler", "Ljava/util/function/Supplier;", "toString", "", "Companion", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nLensWidgetGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LensWidgetGroup.kt\ncn/gitlab/kilo/jetbrains/edit/widget/LensWidgetGroup\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,393:1\n1803#2,3:394\n648#3,5:397\n1#4:402\n*S KotlinDebug\n*F\n+ 1 LensWidgetGroup.kt\ncn/gitlab/kilo/jetbrains/edit/widget/LensWidgetGroup\n*L\n199#1:394,3\n260#1:397,5\n*E\n"})
public final class LensWidgetGroup
implements EditorCustomElementRenderer,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private final AtomicBoolean isDisposed;
    @NotNull
    private final AtomicBoolean addedListeners;
    @NotNull
    private final AtomicBoolean removedListeners;
    @NotNull
    private final List<LensWidget> widgets;
    @NotNull
    private final mouseClickListener.1 mouseClickListener;
    @NotNull
    private final mouseMotionListener.1 mouseMotionListener;
    private boolean listenersMuted;
    @NotNull
    private final AtomicReference<Font> widgetFont;
    @NotNull
    private final AtomicReference<Integer> inlayHeight;
    @Nullable
    private FontMetrics widgetFontMetrics;
    @Nullable
    private LensWidget lastHoveredWidget;
    @Nullable
    private Inlay<EditorCustomElementRenderer> inlay;
    private int lastComputedIndent;
    private static final int DEFAULT_MARGIN = 20;
    private static final double INLAY_HEIGHT_SCALE_FACTOR = 1.2;
    private static final int RECOMPUTE = -1;

    public LensWidgetGroup(@NotNull Editor parentComponent) {
        Intrinsics.checkNotNullParameter((Object)parentComponent, (String)"parentComponent");
        this.logger = Logger.Companion.getInstance(LensWidgetGroup.class);
        this.editor = (EditorImpl)parentComponent;
        this.isDisposed = new AtomicBoolean(false);
        this.addedListeners = new AtomicBoolean(false);
        this.removedListeners = new AtomicBoolean(false);
        this.widgets = new ArrayList();
        this.mouseClickListener = new EditorMouseListener(this){
            final /* synthetic */ LensWidgetGroup this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseClicked(EditorMouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (!LensWidgetGroup.access$getListenersMuted$p(this.this$0)) {
                    LensWidgetGroup.access$handleMouseClick(this.this$0, e);
                }
            }
        };
        this.mouseMotionListener = new EditorMouseMotionListener(this){
            final /* synthetic */ LensWidgetGroup this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseMoved(EditorMouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (!LensWidgetGroup.access$getListenersMuted$p(this.this$0)) {
                    LensWidgetGroup.access$handleMouseMove(this.this$0, e);
                }
            }
        };
        this.widgetFont = new AtomicReference<Font>(UIUtil.getLabelFont());
        this.inlayHeight = new AtomicReference<Integer>(this.computeInlayHeight());
        this.lastComputedIndent = -1;
        this.editor.addEditorMouseListener((EditorMouseListener)this.mouseClickListener);
        this.editor.addEditorMouseMotionListener((EditorMouseMotionListener)this.mouseMotionListener);
        this.addedListeners.set(true);
        MessageBusConnection messageBusConnection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        Topic topic = EditorColorsManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, arg_0 -> LensWidgetGroup._init_$lambda$0(this, arg_0));
    }

    @NotNull
    public final EditorImpl getEditor() {
        return this.editor;
    }

    @NotNull
    public final AtomicBoolean isDisposed() {
        return this.isDisposed;
    }

    @NotNull
    public final List<LensWidget> getWidgets() {
        return this.widgets;
    }

    @NotNull
    public final AtomicReference<Font> getWidgetFont() {
        return this.widgetFont;
    }

    @Nullable
    public final Inlay<EditorCustomElementRenderer> getInlay() {
        return this.inlay;
    }

    public final void setInlay(@Nullable Inlay<EditorCustomElementRenderer> inlay) {
        this.inlay = inlay;
    }

    private final void updateFonts() {
        Font font = EditorColorsManager.getInstance().getGlobalScheme().getFont(EditorFontType.PLAIN);
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getFont(...)");
        Font font2 = font;
        this.widgetFont.set(new Font(font2.getName(), font2.getStyle(), font2.getSize()));
        this.widgetFontMetrics = null;
    }

    @RequiresEdt
    public final void show(@NotNull Range range, boolean shouldScrollToLens) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        int startOffset = range.getStart();
        if (this.isDisposed.get()) {
            throw new IllegalStateException("Request to show disposed inlay: " + this);
        }
        this.inlay = this.editor.getInlayModel().addBlockElement(startOffset, false, true, 0, (EditorCustomElementRenderer)this);
        Disposable disposable = this;
        Inlay<EditorCustomElementRenderer> inlay = this.inlay;
        Intrinsics.checkNotNull(inlay);
        Disposer.register((Disposable)disposable, (Disposable)((Disposable)inlay));
        if (shouldScrollToLens) {
            // empty if block
        }
    }

    public final void update() {
        block0: {
            Inlay<EditorCustomElementRenderer> inlay;
            this.inlayHeight.set(this.computeInlayHeight());
            Inlay<EditorCustomElementRenderer> inlay2 = this.inlay;
            if (inlay2 == null) break block0;
            Inlay<EditorCustomElementRenderer> $this$update_u24lambda_u241 = inlay = inlay2;
            boolean bl = false;
            $this$update_u24lambda_u241.update();
            $this$update_u24lambda_u241.repaint();
        }
    }

    private final int computeInlayHeight() {
        Font font = new Font(this.editor.getColorsScheme().getFontPreferences().getFontFamily(), this.widgetFont.get().getStyle(), this.widgetFont.get().getSize());
        FontMetrics fontMetrics = FontInfo.getFontMetrics((Font)font, (FontRenderContext)FontInfo.getFontRenderContext((Component)((Component)this.editor.getContentComponent())));
        Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"getFontMetrics(...)");
        FontMetrics fontMetrics2 = fontMetrics;
        int totalHeight = fontMetrics2.getAscent() + fontMetrics2.getDescent();
        return MathKt.roundToInt((double)((double)totalHeight * 1.2));
    }

    public int calcWidthInPixels(@NotNull Inlay<?> inlay) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        return this.editor.getComponent().getWidth();
    }

    public int calcHeightInPixels(@NotNull Inlay<?> inlay) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        Integer n = this.inlayHeight.get();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"get(...)");
        return ((Number)n).intValue();
    }

    private final Point widgetGroupXY() {
        Inlay<EditorCustomElementRenderer> inlay = this.inlay;
        if (inlay == null) {
            return new Point(0, 0);
        }
        Point point = this.editor.offsetToXY(inlay.getOffset());
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"offsetToXY(...)");
        return point;
    }

    @NotNull
    public final Point widgetXY(@NotNull LensWidget widget2) {
        Intrinsics.checkNotNullParameter((Object)widget2, (String)"widget");
        Point ourXY = this.widgetGroupXY();
        FontMetrics fontMetrics = this.widgetFontMetrics;
        if (fontMetrics == null) {
            FontMetrics fontMetrics2 = this.editor.getFontMetrics(0);
            fontMetrics = fontMetrics2;
            Intrinsics.checkNotNullExpressionValue((Object)fontMetrics2, (String)"getFontMetrics(...)");
        }
        FontMetrics fontMetrics3 = fontMetrics;
        int sum = this.leftMargin();
        for (LensWidget w : this.widgets) {
            if (Intrinsics.areEqual((Object)w, (Object)widget2)) break;
            sum += w.calcWidthInPixels(fontMetrics3);
        }
        return new Point(ourXY.x + sum, ourXY.y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void paint(@NotNull Inlay<?> inlay, @NotNull Graphics2D g, @NotNull Rectangle2D targetRegion, @NotNull TextAttributes textAttributes) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)targetRegion, (String)"targetRegion");
        Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
        g.setFont(this.widgetFont.get());
        if (this.widgetFontMetrics == null) {
            this.widgetFontMetrics = g.getFontMetrics();
        }
        int inlayHeight = this.calcHeightInPixels(inlay);
        g.setColor((Color)new JBColor(15527410, 2500653));
        g.fillRect(MathKt.roundToInt((double)targetRegion.getX()), MathKt.roundToInt((double)targetRegion.getY()), this.calcWidthInPixels(inlay), inlayHeight);
        FontMetrics fontMetrics = g.getFontMetrics();
        int fontHeight = fontMetrics.getAscent() + fontMetrics.getDescent();
        int verticalPadding = (inlayHeight - fontHeight) / 2;
        double top = targetRegion.getY() + (double)verticalPadding;
        double left = targetRegion.getX() + (double)this.leftMargin();
        Iterable iterable = this.widgets;
        double initial$iv = left;
        boolean $i$f$fold = false;
        double accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            double d;
            LensWidget lensWidget = (LensWidget)element$iv;
            double acc = accumulator$iv;
            boolean bl = false;
            try {
                void widget2;
                widget2.paint(g, (float)acc, (float)top);
                FontMetrics fontMetrics2 = g.getFontMetrics();
                Intrinsics.checkNotNullExpressionValue((Object)fontMetrics2, (String)"getFontMetrics(...)");
                d = acc + (double)widget2.calcWidthInPixels(fontMetrics2);
            }
            finally {
                g.setFont(this.widgetFont.get());
            }
            accumulator$iv = d;
        }
    }

    private final LensWidget findWidgetAt(int x, int y) {
        int currentX = this.leftMargin();
        FontMetrics fontMetrics = this.widgetFontMetrics;
        if (fontMetrics == null) {
            return null;
        }
        FontMetrics fontMetrics2 = fontMetrics;
        Object object = this.inlay;
        boolean bl = object != null && (object = object.getBounds()) != null ? !((Rectangle)object).contains(x, y) : false;
        if (bl) {
            return null;
        }
        for (LensWidget widget2 : this.widgets) {
            int widgetWidth = widget2.calcWidthInPixels(fontMetrics2);
            int rightEdgeX = currentX + widgetWidth;
            if (x >= currentX && x <= rightEdgeX) {
                return widget2;
            }
            currentX = rightEdgeX;
        }
        return null;
    }

    public final void addWidget(@NotNull LensWidget widget2) {
        Intrinsics.checkNotNullParameter((Object)widget2, (String)"widget");
        this.widgets.add(widget2);
        Disposer.register((Disposable)this, (Disposable)widget2);
    }

    /*
     * WARNING - void declaration
     */
    private final int leftMargin() {
        if (this.lastComputedIndent != -1) {
            return this.lastComputedIndent;
        }
        try {
            int inlayLineNumber;
            Integer inlayOffset;
            DocumentEx documentEx = this.editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
            DocumentEx document = documentEx;
            Inlay<EditorCustomElementRenderer> inlay = this.inlay;
            Integer n = inlayOffset = inlay != null ? Integer.valueOf(inlay.getOffset()) : null;
            if (inlayOffset == null) {
                this.lastComputedIndent = 20;
                return 20;
            }
            int lineCount = document.getLineCount();
            for (int lineNumber = inlayLineNumber = document.getLineNumber(inlayOffset.intValue()); lineNumber < lineCount; ++lineNumber) {
                int indentationLevel;
                String string;
                int n2;
                CharSequence charSequence;
                int spaceWidth;
                int tabSize;
                block7: {
                    void $this$takeWhile$iv;
                    String lineText;
                    int lineStartOffset = document.getLineStartOffset(lineNumber);
                    int lineEndOffset = document.getLineEndOffset(lineNumber);
                    Intrinsics.checkNotNullExpressionValue((Object)document.getText(new TextRange(lineStartOffset, lineEndOffset)), (String)"getText(...)");
                    if (!(!StringsKt.isBlank((CharSequence)lineText))) continue;
                    tabSize = EditorUtil.getTabSize((Editor)((Editor)this.editor));
                    spaceWidth = EditorUtil.getSpaceWidth((int)0, (Editor)((Editor)this.editor));
                    charSequence = lineText;
                    boolean $i$f$takeWhile = false;
                    n2 = $this$takeWhile$iv.length();
                    for (int index$iv = 0; index$iv < n2; ++index$iv) {
                        char it22 = $this$takeWhile$iv.charAt(index$iv);
                        int n3 = 0;
                        if (CharsKt.isWhitespace((char)it22)) continue;
                        void it22 = $this$takeWhile$iv;
                        n3 = 0;
                        String string2 = it22.substring(n3, index$iv);
                        string = string2;
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                        break block7;
                    }
                    string = $this$takeWhile$iv;
                }
                charSequence = string;
                int n4 = 0;
                for (int i = 0; i < charSequence.length(); ++i) {
                    int it22 = n2 = (int)charSequence.charAt(i);
                    int n5 = n4;
                    boolean bl = false;
                    int n6 = it22 == 9 ? tabSize * spaceWidth : spaceWidth;
                    n4 = n5 + n6;
                }
                this.lastComputedIndent = indentationLevel = n4;
                return indentationLevel;
            }
        }
        catch (Exception x) {
            this.logger.warn("Error computing code lens left margin", x);
        }
        this.lastComputedIndent = 20;
        return 20;
    }

    public final void reset() {
        this.lastComputedIndent = -1;
    }

    private final void handleMouseClick(EditorMouseEvent e) {
        Point point = e.getMouseEvent().getPoint();
        Intrinsics.checkNotNull((Object)point);
        int x = LensWidgetGroupKt.component1(point);
        int y = LensWidgetGroupKt.component2(point);
        LensWidget lensWidget = this.findWidgetAt(x, y);
        boolean bl = lensWidget != null ? lensWidget.onClick(e) : false;
        if (bl) {
            e.consume();
        }
    }

    private final void handleMouseMove(EditorMouseEvent e) {
        block5: {
            Point point = e.getMouseEvent().getPoint();
            Intrinsics.checkNotNull((Object)point);
            int x = LensWidgetGroupKt.component1(point);
            int y = LensWidgetGroupKt.component2(point);
            LensWidget widget2 = this.findWidgetAt(x, y);
            LensWidget lastWidget = this.lastHoveredWidget;
            if (widget2 instanceof LensAction) {
                e.getEditor().getContentComponent().setCursor(Cursor.getPredefinedCursor(12));
            } else {
                e.getEditor().getContentComponent().setCursor(Cursor.getPredefinedCursor(0));
            }
            if (Intrinsics.areEqual((Object)widget2, (Object)lastWidget)) break block5;
            LensWidget lensWidget = lastWidget;
            if (lensWidget != null) {
                lensWidget.onMouseExit(e);
            }
            this.lastHoveredWidget = widget2;
            LensWidget lensWidget2 = widget2;
            if (lensWidget2 != null) {
                lensWidget2.onMouseEnter(e);
            }
            Inlay<EditorCustomElementRenderer> inlay = this.inlay;
            if (inlay != null) {
                inlay.update();
            }
        }
    }

    public void dispose() {
        if (this.isDisposed.get()) {
            return;
        }
        this.isDisposed.set(true);
        if (this.editor.isDisposed()) {
            return;
        }
        this.onEventThread(() -> LensWidgetGroup.dispose$lambda$5(this));
    }

    @RequiresEdt
    private final void disposeInlay() {
        block1: {
            Inlay<EditorCustomElementRenderer> inlay;
            Inlay<EditorCustomElementRenderer> inlay2 = this.inlay;
            if (inlay2 == null) break block1;
            Inlay<EditorCustomElementRenderer> $this$disposeInlay_u24lambda_u246 = inlay = inlay2;
            boolean bl = false;
            if ($this$disposeInlay_u24lambda_u246.isValid()) {
                Disposer.dispose((Disposable)((Disposable)$this$disposeInlay_u24lambda_u246));
            }
            this.inlay = null;
        }
    }

    private final <T> CompletableFuture<T> onEventThread(Supplier<T> handler) {
        CompletableFuture result2 = new CompletableFuture();
        Function0 executeAndComplete = () -> LensWidgetGroup.onEventThread$lambda$7(result2, handler);
        if (ApplicationManager.getApplication().isDispatchThread()) {
            executeAndComplete.invoke();
        } else {
            ActionsKt.runInEdt$default(null, () -> LensWidgetGroup.onEventThread$lambda$8(executeAndComplete), (int)1, null);
        }
        return result2;
    }

    @NotNull
    public String toString() {
        String render = CollectionsKt.joinToString$default((Iterable)this.widgets, (CharSequence)",", null, null, (int)0, null, LensWidgetGroup::toString$lambda$9, (int)30, null);
        return "LensWidgetGroup: {" + render + "}";
    }

    private static final void _init_$lambda$0(LensWidgetGroup this$0, EditorColorsScheme it) {
        this$0.updateFonts();
        this$0.update();
    }

    private static final Unit dispose$lambda$5(LensWidgetGroup this$0) {
        if (this$0.editor.isDisposed()) {
            return Unit.INSTANCE;
        }
        if (this$0.addedListeners.get() && !this$0.removedListeners.get()) {
            try {
                this$0.removedListeners.set(true);
                this$0.editor.removeEditorMouseListener((EditorMouseListener)this$0.mouseClickListener);
                this$0.editor.removeEditorMouseMotionListener((EditorMouseMotionListener)this$0.mouseMotionListener);
            }
            catch (Throwable t) {
                this$0.logger.warn("Error removing mouse listeners", t);
            }
        }
        try {
            this$0.disposeInlay();
        }
        catch (Throwable t) {
            this$0.logger.warn("Error disposing inlay", t);
        }
        return Unit.INSTANCE;
    }

    private static final Unit onEventThread$lambda$7(CompletableFuture $result, Supplier $handler) {
        try {
            $result.complete($handler.get());
        }
        catch (Exception e) {
            $result.completeExceptionally(e);
        }
        return Unit.INSTANCE;
    }

    private static final Unit onEventThread$lambda$8(Function0 $executeAndComplete) {
        $executeAndComplete.invoke();
        return Unit.INSTANCE;
    }

    private static final CharSequence toString$lambda$9(LensWidget it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.toString();
    }

    public static final /* synthetic */ boolean access$getListenersMuted$p(LensWidgetGroup $this) {
        return $this.listenersMuted;
    }

    public static final /* synthetic */ void access$handleMouseClick(LensWidgetGroup $this, EditorMouseEvent e) {
        $this.handleMouseClick(e);
    }

    public static final /* synthetic */ void access$handleMouseMove(LensWidgetGroup $this, EditorMouseEvent e) {
        $this.handleMouseMove(e);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcn/gitlab/kilo/jetbrains/edit/widget/LensWidgetGroup$Companion;", "", "<init>", "()V", "DEFAULT_MARGIN", "", "INLAY_HEIGHT_SCALE_FACTOR", "", "RECOMPUTE", "coderider-kilo-jetbrains"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

