/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.edit.widget;

import cn.gitlab.kilo.jetbrains.edit.widget.LensWidget;
import cn.gitlab.kilo.jetbrains.edit.widget.LensWidgetGroup;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J \u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0016J\b\u0010\u001f\u001a\u00020\u0005H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\t\"\u0004\b\u0013\u0010\u0014\u00a8\u0006 "}, d2={"Lcn/gitlab/kilo/jetbrains/edit/widget/LensLabel;", "Lcn/gitlab/kilo/jetbrains/edit/widget/LensWidget;", "group", "Lcn/gitlab/kilo/jetbrains/edit/widget/LensWidgetGroup;", "text", "", "<init>", "(Lcn/gitlab/kilo/jetbrains/edit/widget/LensWidgetGroup;Ljava/lang/String;)V", "getText", "()Ljava/lang/String;", "SEPARATOR", "getSEPARATOR", "calcWidthInPixels", "", "fontMetrics", "Ljava/awt/FontMetrics;", "calcHeightInPixels", "hoverText", "getHoverText", "setHoverText", "(Ljava/lang/String;)V", "onMouseEnter", "", "e", "Lcom/intellij/openapi/editor/event/EditorMouseEvent;", "paint", "g", "Ljava/awt/Graphics2D;", "x", "", "y", "toString", "coderider-kilo-jetbrains"})
public class LensLabel
extends LensWidget {
    @NotNull
    private final String text;
    @NotNull
    private final String SEPARATOR;
    @Nullable
    private String hoverText;

    public LensLabel(@NotNull LensWidgetGroup group, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        super(group);
        this.text = text;
        this.SEPARATOR = " \u2223 ";
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @NotNull
    public final String getSEPARATOR() {
        return this.SEPARATOR;
    }

    @Override
    public int calcWidthInPixels(@NotNull FontMetrics fontMetrics) {
        Intrinsics.checkNotNullParameter((Object)fontMetrics, (String)"fontMetrics");
        return fontMetrics.stringWidth(this.text);
    }

    @Override
    public int calcHeightInPixels(@NotNull FontMetrics fontMetrics) {
        Intrinsics.checkNotNullParameter((Object)fontMetrics, (String)"fontMetrics");
        return fontMetrics.getHeight();
    }

    @Nullable
    public final String getHoverText() {
        return this.hoverText;
    }

    public final void setHoverText(@Nullable String string) {
        this.hoverText = string;
    }

    @Override
    public void onMouseEnter(@NotNull EditorMouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.setMouseInBounds(true);
        String string = this.hoverText;
        if (string == null) {
            return;
        }
        MouseEvent mouseEvent = e.getMouseEvent();
        Intrinsics.checkNotNullExpressionValue((Object)mouseEvent, (String)"getMouseEvent(...)");
        this.showTooltip(string, mouseEvent);
    }

    @Override
    public void paint(@NotNull Graphics2D g, float x, float y) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        g.setColor(Intrinsics.areEqual((Object)this.text, (Object)this.SEPARATOR) ? UIUtil.shade((Color)JBColor.foreground(), (double)1.0, (double)0.4) : this.getBaseTextColor());
        g.drawString(this.text, x, y + (float)g.getFontMetrics().getAscent());
    }

    @NotNull
    public String toString() {
        return "LensLabel(text=" + this.text + ")";
    }
}

