/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.edit.widget;

import cn.gitlab.kilo.jetbrains.edit.widget.LensWidget;
import cn.gitlab.kilo.jetbrains.edit.widget.LensWidgetGroup;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001c"}, d2={"Lcn/gitlab/kilo/jetbrains/edit/widget/LensIcon;", "Lcn/gitlab/kilo/jetbrains/edit/widget/LensWidget;", "group", "Lcn/gitlab/kilo/jetbrains/edit/widget/LensWidgetGroup;", "icon", "Ljavax/swing/Icon;", "<init>", "(Lcn/gitlab/kilo/jetbrains/edit/widget/LensWidgetGroup;Ljavax/swing/Icon;)V", "getIcon", "()Ljavax/swing/Icon;", "calcWidthInPixels", "", "fontMetrics", "Ljava/awt/FontMetrics;", "calcHeightInPixels", "paint", "", "g", "Ljava/awt/Graphics2D;", "x", "", "y", "toString", "", "onClick", "", "e", "Lcom/intellij/openapi/editor/event/EditorMouseEvent;", "coderider-kilo-jetbrains"})
public final class LensIcon
extends LensWidget {
    @NotNull
    private final Icon icon;

    public LensIcon(@NotNull LensWidgetGroup group, @NotNull Icon icon) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        super(group);
        this.icon = icon;
    }

    @NotNull
    public final Icon getIcon() {
        return this.icon;
    }

    @Override
    public int calcWidthInPixels(@NotNull FontMetrics fontMetrics) {
        Intrinsics.checkNotNullParameter((Object)fontMetrics, (String)"fontMetrics");
        float desiredHeight = (float)(fontMetrics.getHeight() + fontMetrics.getAscent()) / 2.0f;
        float scaleFactor = desiredHeight / (float)this.icon.getIconHeight();
        return (int)((float)this.icon.getIconWidth() * scaleFactor);
    }

    @Override
    public int calcHeightInPixels(@NotNull FontMetrics fontMetrics) {
        Intrinsics.checkNotNullParameter((Object)fontMetrics, (String)"fontMetrics");
        return (int)((float)(fontMetrics.getHeight() + fontMetrics.getAscent()) / 2.0f);
    }

    @Override
    public void paint(@NotNull Graphics2D g, float x, float y) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        FontMetrics fontMetrics = g.getFontMetrics();
        float textCenterLine = y + (float)(fontMetrics.getAscent() + fontMetrics.getDescent()) / 2.0f;
        float desiredHeight = (float)(fontMetrics.getHeight() + fontMetrics.getAscent()) / 2.0f;
        float scaleFactor = desiredHeight / (float)this.icon.getIconHeight();
        float iconY = textCenterLine - desiredHeight / 2.0f;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        AffineTransform originalTransform = g.getTransform();
        g.translate((int)x, (int)iconY);
        g.scale(scaleFactor, scaleFactor);
        this.icon.paintIcon(null, g, 0, 1);
        g.setTransform(originalTransform);
    }

    @NotNull
    public String toString() {
        return "LensIcon(icon=" + this.icon + ")";
    }

    @Override
    public boolean onClick(@NotNull EditorMouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return true;
    }
}

