/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.edit;

import cn.gitlab.kilo.jetbrains.common.I18nKt;
import cn.gitlab.kilo.jetbrains.common.Logger;
import cn.gitlab.kilo.jetbrains.common.Range;
import cn.gitlab.kilo.jetbrains.config.ModelsConfiguration;
import cn.gitlab.kilo.jetbrains.edit.EditInlineStreamService;
import cn.gitlab.kilo.jetbrains.edit.EditStreamHandler;
import cn.gitlab.kilo.jetbrains.edit.InlineEditPanel;
import cn.gitlab.kilo.jetbrains.edit.InstructionsInputTextArea;
import cn.gitlab.kilo.jetbrains.edit.LensesService;
import cn.gitlab.kilo.jetbrains.edit.PromptHistory;
import cn.gitlab.kilo.jetbrains.edit.TextAreaHistoryManager;
import cn.gitlab.kilo.jetbrains.edit.action.EditCodeAction;
import cn.gitlab.kilo.jetbrains.edit.common.EditTask;
import cn.gitlab.kilo.jetbrains.psi.PsiUtils;
import cn.gitlab.kilo.jetbrains.services.CoderiderTrackClient;
import cn.gitlab.kilo.jetbrains.services.TrackService;
import cn.gitlab.kilo.jetbrains.services.context.LanguageUtilsKt;
import cn.gitlab.kilo.jetbrains.utils.EditUtil;
import cn.gitlab.kilo.jetbrains.utils.EditUtilKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.psi.PsiFile;
import com.intellij.ui.util.UiSizeUtilKt;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.invoke.LambdaMetafactory;
import java.util.Map;
import java.util.UUID;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00cf\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0000\n\u0002\b\u0003*\u0001d\u0018\u0000 |2\u00020\u00012\u00020\u0002:\u0001|B9\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\f\b\u0002\u0010\u000b\u001a\u00060\bj\u0002`\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0006\u0010g\u001a\u00020hJ\b\u0010i\u001a\u00020jH\u0002J\b\u0010k\u001a\u00020lH\u0002J\b\u0010m\u001a\u00020jH\u0003J\b\u0010n\u001a\u00020jH\u0003J\b\u0010o\u001a\u00020jH\u0003J\b\u0010p\u001a\u00020jH\u0002J\b\u0010q\u001a\u00020XH\u0002J\u0012\u0010r\u001a\u00020\b2\b\u0010s\u001a\u0004\u0018\u00010GH\u0002J\u001c\u0010t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010s\u001a\u0004\u0018\u00010GH\u0002J\b\u0010u\u001a\u00020XH\u0002J\b\u0010v\u001a\u00020XH\u0002J\b\u0010w\u001a\u00020jH\u0007J\b\u0010x\u001a\u00020jH\u0016J\u0012\u0010y\u001a\u0004\u0018\u00010z2\u0006\u0010{\u001a\u00020\bH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00060\bj\u0002`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001b\u001a\u00070\u001c\u00a2\u0006\u0002\b\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\"R\u0011\u0010%\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\"R\u001a\u0010'\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\"\"\u0004\b)\u0010*R\u0011\u0010+\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\"R\u0011\u0010-\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\"R\u001a\u0010/\u001a\u000200X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\u001a\u00105\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00107\"\u0004\b8\u00109R\u001b\u0010:\u001a\f0\b\u00a2\u0006\u0002\b\u001d\u00a2\u0006\u0002\b;\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u00107R\u001b\u0010=\u001a\f0\b\u00a2\u0006\u0002\b\u001d\u00a2\u0006\u0002\b;\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u00107R\u001b\u0010?\u001a\f0\b\u00a2\u0006\u0002\b\u001d\u00a2\u0006\u0002\b;\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u00107R\u0011\u0010A\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010\"R\u001d\u0010C\u001a\u000e\u0018\u00010\b\u00a2\u0006\u0002\bD\u00a2\u0006\u0002\b\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u00107R\u0018\u0010F\u001a\t\u0018\u00010G\u00a2\u0006\u0002\bH\u00a2\u0006\b\n\u0000\u001a\u0004\bI\u0010JR\u001a\u0010K\u001a\u00020LX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bM\u0010N\"\u0004\bO\u0010PR\u0011\u0010Q\u001a\u00020R\u00a2\u0006\b\n\u0000\u001a\u0004\bS\u0010TR\u000e\u0010U\u001a\u00020VX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010W\u001a\u00020XX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010Y\u001a\u00020ZX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010[\u001a\u00020\\X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010]\u001a\u00020^X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010_\u001a\u00020ZX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010`\u001a\u00020ZX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010a\u001a\u00020bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010c\u001a\u00020dX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010eR\u000e\u0010f\u001a\u00020ZX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006}"}, d2={"Lcn/gitlab/kilo/jetbrains/edit/InlineEditPanel;", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "dialogTitle", "", "previousEdit", "Lcn/gitlab/kilo/jetbrains/edit/common/EditTask;", "taskId", "Lcn/gitlab/kilo/jetbrains/edit/TaskId;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Ljava/lang/String;Lcn/gitlab/kilo/jetbrains/edit/common/EditTask;Ljava/lang/String;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "popup", "Lcom/intellij/openapi/ui/popup/JBPopup;", "logger", "Lcn/gitlab/kilo/jetbrains/common/Logger;", "offset", "", "connection", "Lcom/intellij/util/messages/MessageBusConnection;", "selectionModel", "Lcom/intellij/openapi/editor/SelectionModel;", "Lorg/jetbrains/annotations/NotNull;", "getSelectionModel", "()Lcom/intellij/openapi/editor/SelectionModel;", "startOffset", "getStartOffset", "()I", "endOffset", "getEndOffset", "startLineNumber", "getStartLineNumber", "endLineNumber", "getEndLineNumber", "setEndLineNumber", "(I)V", "expandedStartOffset", "getExpandedStartOffset", "expandedEndOffset", "getExpandedEndOffset", "range", "Lcn/gitlab/kilo/jetbrains/common/Range;", "getRange", "()Lcn/gitlab/kilo/jetbrains/common/Range;", "setRange", "(Lcn/gitlab/kilo/jetbrains/common/Range;)V", "originFile", "getOriginFile", "()Ljava/lang/String;", "setOriginFile", "(Ljava/lang/String;)V", "prefix", "Lcom/intellij/openapi/util/NlsSafe;", "getPrefix", "highlighted", "getHighlighted", "suffix", "getSuffix", "lineNumber", "getLineNumber", "path", "Lorg/jetbrains/annotations/NonNls;", "getPath", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/annotations/Nullable;", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "lensesService", "Lcn/gitlab/kilo/jetbrains/edit/LensesService;", "getLensesService", "()Lcn/gitlab/kilo/jetbrains/edit/LensesService;", "setLensesService", "(Lcn/gitlab/kilo/jetbrains/edit/LensesService;)V", "diffStreamHandler", "Lcn/gitlab/kilo/jetbrains/edit/EditStreamHandler;", "getDiffStreamHandler", "()Lcn/gitlab/kilo/jetbrains/edit/EditStreamHandler;", "okButton", "Ljavax/swing/JButton;", "okButtonGroup", "Ljavax/swing/JPanel;", "cancelLabel", "Ljavax/swing/JLabel;", "instructionsField", "Lcn/gitlab/kilo/jetbrains/edit/InstructionsInputTextArea;", "historyManager", "Lcn/gitlab/kilo/jetbrains/edit/TextAreaHistoryManager;", "titleLabel", "filePathLabel", "promptCaretListener", "Ljavax/swing/event/CaretListener;", "keyPressListener", "cn/gitlab/kilo/jetbrains/edit/InlineEditPanel$keyPressListener$1", "Lcn/gitlab/kilo/jetbrains/edit/InlineEditPanel$keyPressListener$1;", "historyLabel", "isOkActionEnabled", "", "createAndShowPopup", "", "createPopupContent", "Ljavax/swing/JComponent;", "setupTextField", "updateOkButtonState", "checkForInterruptions", "performCancelAction", "createTopRow", "getFormattedFilePath", "file", "getProjectRootPath", "createCenterPanel", "createBottomRow", "performOKAction", "dispose", "getData", "", "dataId", "Companion", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nInlineEditPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineEditPanel.kt\ncn/gitlab/kilo/jetbrains/edit/InlineEditPanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,497:1\n1#2:498\n31#3,2:499\n1310#4,2:501\n*S KotlinDebug\n*F\n+ 1 InlineEditPanel.kt\ncn/gitlab/kilo/jetbrains/edit/InlineEditPanel\n*L\n241#1:499,2\n343#1:501,2\n*E\n"})
public final class InlineEditPanel
implements Disposable,
DataProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Editor editor;
    @NotNull
    private final String dialogTitle;
    @Nullable
    private final EditTask previousEdit;
    @NotNull
    private final String taskId;
    @Nullable
    private JBPopup popup;
    @NotNull
    private final Logger logger;
    private final int offset;
    @Nullable
    private MessageBusConnection connection;
    @NotNull
    private final SelectionModel selectionModel;
    private final int startOffset;
    private final int endOffset;
    private final int startLineNumber;
    private int endLineNumber;
    private final int expandedStartOffset;
    private final int expandedEndOffset;
    @NotNull
    private Range range;
    @NotNull
    private String originFile;
    @NotNull
    private final String prefix;
    @NotNull
    private final String highlighted;
    @NotNull
    private final String suffix;
    private final int lineNumber;
    @Nullable
    private final String path;
    @Nullable
    private final VirtualFile virtualFile;
    @NotNull
    private LensesService lensesService;
    @NotNull
    private final EditStreamHandler diffStreamHandler;
    @NotNull
    private final JButton okButton;
    @NotNull
    private final JPanel okButtonGroup;
    @NotNull
    private final JLabel cancelLabel;
    @NotNull
    private final InstructionsInputTextArea instructionsField;
    @NotNull
    private final TextAreaHistoryManager historyManager;
    @NotNull
    private JLabel titleLabel;
    @NotNull
    private JLabel filePathLabel;
    @NotNull
    private final CaretListener promptCaretListener;
    @NotNull
    private final keyPressListener.1 keyPressListener;
    @NotNull
    private final JLabel historyLabel;
    @NotNull
    private static final Key<InlineEditPanel> EDIT_COMMAND_PROMPT_KEY;
    public static final int DEFAULT_TEXT_FIELD_WIDTH = 700;
    public static final int DIALOG_MINIMUM_HEIGHT = 200;
    @NotNull
    private static final String FILE_PATH_404 = "unknown file";
    private static final int HISTORY_CAPACITY = 100;
    @NotNull
    private static final PromptHistory promptHistory;
    @NotNull
    private static String lastPrompt;

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public InlineEditPanel(@NotNull Project project, @NotNull Editor editor, @NotNull String dialogTitle, @Nullable EditTask previousEdit, @NotNull String taskId) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)dialogTitle, (String)"dialogTitle");
        Intrinsics.checkNotNullParameter((Object)taskId, (String)"taskId");
        super();
        this.project = project;
        this.editor = editor;
        this.dialogTitle = dialogTitle;
        this.previousEdit = previousEdit;
        this.taskId = taskId;
        this.logger = Logger.Companion.getInstance(InlineEditPanel.class);
        this.offset = this.editor.getCaretModel().getPrimaryCaret().getOffset();
        v0 = this.editor.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getSelectionModel(...)");
        this.selectionModel = v0;
        this.startOffset = this.selectionModel.getSelectionStart();
        this.endOffset = this.selectionModel.getSelectionEnd();
        this.startLineNumber = this.editor.getDocument().getLineNumber(this.startOffset);
        this.endLineNumber = this.editor.getDocument().getLineNumber(this.endOffset);
        this.expandedStartOffset = this.editor.getDocument().getLineStartOffset(this.startLineNumber);
        this.expandedEndOffset = this.editor.getDocument().getLineEndOffset(this.endLineNumber);
        this.range = new Range(this.expandedStartOffset, this.expandedEndOffset);
        v1 = this.editor.getDocument().getText();
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getText(...)");
        this.originFile = v1;
        v2 = this.editor.getDocument().getText(new TextRange(0, this.expandedStartOffset));
        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getText(...)");
        this.prefix = v2;
        v3 = this.editor.getDocument().getText(new TextRange(this.expandedStartOffset, this.expandedEndOffset));
        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getText(...)");
        this.highlighted = v3;
        v4 = this.editor.getDocument().getText(new TextRange(this.expandedEndOffset, this.editor.getDocument().getTextLength()));
        Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getText(...)");
        this.suffix = v4;
        this.lineNumber = Math.max(0, this.startLineNumber - 1);
        v5 = FileDocumentManager.getInstance().getFile(this.editor.getDocument());
        this.path = v5 != null ? v5.getPath() : null;
        this.virtualFile = FileDocumentManager.getInstance().getFile(this.editor.getDocument());
        this.lensesService = LensesService.Companion.getInstance(this.project);
        this.diffStreamHandler = new EditStreamHandler((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, diffStreamHandler$lambda$0(cn.gitlab.kilo.jetbrains.edit.InlineEditPanel ), ()Lkotlin/Unit;)((InlineEditPanel)this), (Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, diffStreamHandler$lambda$1(cn.gitlab.kilo.jetbrains.edit.InlineEditPanel ), ()Lkotlin/Unit;)((InlineEditPanel)this), this.project, this.editor, this.startLineNumber, this.endLineNumber, (Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, diffStreamHandler$lambda$2(), ()Lkotlin/Unit;)(), (Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, diffStreamHandler$lambda$3(cn.gitlab.kilo.jetbrains.edit.InlineEditPanel ), ()Lkotlin/Unit;)((InlineEditPanel)this), this.path, this.originFile, this.expandedStartOffset, this.expandedEndOffset, this.editor, null, null, null, 57344, null);
        var6_6 = EditUtil.INSTANCE.namedButton("ok-button");
        var7_7 = var6_6;
        var14_9 = this;
        $i$a$-apply-InlineEditPanel$okButton$1 = false;
        $this$okButton_u24lambda_u245 /* !! */ .setText(I18nKt.getMessage("inline.edit.edit.button"));
        $this$okButton_u24lambda_u245 /* !! */ .setForeground(InlineEditPanel.Companion.boldLabelColor());
        $this$okButton_u24lambda_u245 /* !! */ .addActionListener((ActionListener)LambdaMetafactory.metafactory(null, null, null, (Ljava/awt/event/ActionEvent;)V, okButton$lambda$5$lambda$4(cn.gitlab.kilo.jetbrains.edit.InlineEditPanel java.awt.event.ActionEvent ), (Ljava/awt/event/ActionEvent;)V)((InlineEditPanel)this));
        var14_9.okButton = var6_6;
        var6_6 = EditUtil.INSTANCE.namedPanel("ok-button-group");
        $this$okButton_u24lambda_u245 /* !! */  = var6_6;
        var14_9 = this;
        $i$a$-apply-InlineEditPanel$okButtonGroup$1 = false;
        $this$okButtonGroup_u24lambda_u248.setBorder(BorderFactory.createEmptyBorder(4, 0, 4, 4));
        $this$okButtonGroup_u24lambda_u248.setOpaque(false);
        $this$okButtonGroup_u24lambda_u248.setBackground(InlineEditPanel.Companion.textFieldBackground());
        $this$okButtonGroup_u24lambda_u248.setLayout(new BoxLayout($this$okButtonGroup_u24lambda_u248, 0));
        v6 = KeymapUtil.getActiveKeymapShortcuts((String)"coderider.inlineEditEditCode");
        Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"getActiveKeymapShortcuts(...)");
        activeKeymapShortcuts = v6;
        v7 = activeKeymapShortcuts.getShortcuts();
        Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"getShortcuts(...)");
        if (((Object[])v7).length == 0 == false) {
            $this$okButtonGroup_u24lambda_u248_u24lambda_u246 = var10_13 = EditUtil.INSTANCE.namedLabel("ok-keyboard-shortcut-label");
            $i$a$-apply-InlineEditPanel$okButtonGroup$1$shortcutLabel$1 = false;
            $this$okButtonGroup_u24lambda_u248_u24lambda_u246.setText(KeymapUtil.getShortcutsText((Shortcut[])activeKeymapShortcuts.getShortcuts()));
            $this$okButtonGroup_u24lambda_u248_u24lambda_u246.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 12));
            p0 = var10_13;
            $i$a$-also-InlineEditPanel$okButtonGroup$1$shortcutLabel$2 = false;
            $this$okButtonGroup_u24lambda_u248.add(p0);
            v8 = var10_13;
        } else {
            v8 = null;
        }
        shortcutLabel = v8;
        $this$okButtonGroup_u24lambda_u248.add(this.okButton);
        $this$okButtonGroup_u24lambda_u248.addPropertyChangeListener((PropertyChangeListener)LambdaMetafactory.metafactory(null, null, null, (Ljava/beans/PropertyChangeEvent;)V, okButtonGroup$lambda$8$lambda$7(cn.gitlab.kilo.jetbrains.edit.InlineEditPanel javax.swing.JLabel java.beans.PropertyChangeEvent ), (Ljava/beans/PropertyChangeEvent;)V)((InlineEditPanel)this, shortcutLabel));
        var14_9.okButtonGroup = var6_6;
        $this$okButtonGroup_u24lambda_u248 = var6_6 = EditUtil.INSTANCE.namedLabel("esc-cancel-label");
        var14_9 = this;
        $i$a$-apply-InlineEditPanel$cancelLabel$1 = false;
        $this$cancelLabel_u24lambda_u249.setText(I18nKt.getMessage("inline.edit.cancel.button"));
        $this$cancelLabel_u24lambda_u249.setForeground(InlineEditPanel.Companion.boldLabelColor());
        $this$cancelLabel_u24lambda_u249.setCursor(new Cursor(12));
        $this$cancelLabel_u24lambda_u249.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ InlineEditPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseClicked(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                InlineEditPanel.access$performCancelAction(this.this$0);
            }
        });
        var14_9.cancelLabel = var6_6;
        this.instructionsField = new InstructionsInputTextArea();
        this.historyManager = new TextAreaHistoryManager((JTextArea)this.instructionsField, InlineEditPanel.promptHistory);
        $this$cancelLabel_u24lambda_u249 = var6_6 = EditUtil.INSTANCE.namedLabel("title-label");
        var14_9 = this;
        $i$a$-apply-InlineEditPanel$titleLabel$1 = false;
        $this$titleLabel_u24lambda_u2410.setText(this.dialogTitle);
        $this$titleLabel_u24lambda_u2410.setBorder(BorderFactory.createEmptyBorder(10, 14, 10, 10));
        $this$titleLabel_u24lambda_u2410.setForeground(InlineEditPanel.Companion.boldLabelColor());
        var14_9.titleLabel = var6_6;
        $this$titleLabel_u24lambda_u2410 = var6_6 = EditUtil.INSTANCE.namedLabel("file-path-label");
        var14_9 = this;
        $i$a$-apply-InlineEditPanel$filePathLabel$1 = false;
        $this$filePathLabel_u24lambda_u2411.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        $this$filePathLabel_u24lambda_u2411.setForeground(InlineEditPanel.Companion.mutedLabelColor());
        var14_9.filePathLabel = var6_6;
        this.promptCaretListener = (CaretListener)LambdaMetafactory.metafactory(null, null, null, (Ljavax/swing/event/CaretEvent;)V, promptCaretListener$lambda$12(cn.gitlab.kilo.jetbrains.edit.InlineEditPanel javax.swing.event.CaretEvent ), (Ljavax/swing/event/CaretEvent;)V)((InlineEditPanel)this);
        this.keyPressListener = new KeyAdapter(this){
            final /* synthetic */ InlineEditPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void keyPressed(KeyEvent e) {
                block2: {
                    block1: {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        if (!e.isShiftDown() || e.getKeyCode() != 10) break block1;
                        InlineEditPanel.access$getInstructionsField$p(this.this$0).insert("\n", InlineEditPanel.access$getInstructionsField$p(this.this$0).getCaretPosition());
                        e.consume();
                        break block2;
                    }
                    if (e.getKeyCode() != 10) break block2;
                    InlineEditPanel inlineEditPanel = (InlineEditPanel)InlineEditPanel.Companion.getEDIT_COMMAND_PROMPT_KEY().get((UserDataHolder)this.this$0.getProject());
                    if (inlineEditPanel != null) {
                        inlineEditPanel.performOKAction();
                    }
                }
            }
        };
        $this$filePathLabel_u24lambda_u2411 = var6_6 = EditUtil.INSTANCE.namedLabel("history-label");
        var14_9 = this;
        $i$a$-apply-InlineEditPanel$historyLabel$1 = false;
        $this$historyLabel_u24lambda_u2413.setText(I18nKt.getMessage("inline.edit.history.button"));
        $this$historyLabel_u24lambda_u2413.setHorizontalAlignment(0);
        if (!this.historyManager.isHistoryAvailable()) ** GOTO lbl-1000
        v9 = this.instructionsField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"getText(...)");
        if (((CharSequence)v9).length() == 0) {
            v10 = true;
        } else lbl-1000:
        // 2 sources

        {
            v10 = false;
        }
        $this$historyLabel_u24lambda_u2413.setEnabled(v10);
        var14_9.historyLabel = var6_6;
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.connection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        this.project.putUserData(InlineEditPanel.EDIT_COMMAND_PROMPT_KEY, (Object)this);
        this.setupTextField();
        this.updateOkButtonState();
        this.createAndShowPopup();
        $this$service$iv = (ComponentManager)this.project;
        $i$f$service = false;
        serviceClass$iv = EditInlineStreamService.class;
        v11 = $this$service$iv.getService(serviceClass$iv);
        if (v11 == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ((EditInlineStreamService)v11).register(this.diffStreamHandler, this.editor);
    }

    public /* synthetic */ InlineEditPanel(Project project, Editor editor, String string, EditTask editTask, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            editTask = null;
        }
        if ((n & 0x10) != 0) {
            string2 = UUID.randomUUID().toString();
        }
        this(project, editor, string, editTask, string2);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    @NotNull
    public final SelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public final int getStartOffset() {
        return this.startOffset;
    }

    public final int getEndOffset() {
        return this.endOffset;
    }

    public final int getStartLineNumber() {
        return this.startLineNumber;
    }

    public final int getEndLineNumber() {
        return this.endLineNumber;
    }

    public final void setEndLineNumber(int n) {
        this.endLineNumber = n;
    }

    public final int getExpandedStartOffset() {
        return this.expandedStartOffset;
    }

    public final int getExpandedEndOffset() {
        return this.expandedEndOffset;
    }

    @NotNull
    public final Range getRange() {
        return this.range;
    }

    public final void setRange(@NotNull Range range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"<set-?>");
        this.range = range;
    }

    @NotNull
    public final String getOriginFile() {
        return this.originFile;
    }

    public final void setOriginFile(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.originFile = string;
    }

    @NotNull
    public final String getPrefix() {
        return this.prefix;
    }

    @NotNull
    public final String getHighlighted() {
        return this.highlighted;
    }

    @NotNull
    public final String getSuffix() {
        return this.suffix;
    }

    public final int getLineNumber() {
        return this.lineNumber;
    }

    @Nullable
    public final String getPath() {
        return this.path;
    }

    @Nullable
    public final VirtualFile getVirtualFile() {
        return this.virtualFile;
    }

    @NotNull
    public final LensesService getLensesService() {
        return this.lensesService;
    }

    public final void setLensesService(@NotNull LensesService lensesService) {
        Intrinsics.checkNotNullParameter((Object)lensesService, (String)"<set-?>");
        this.lensesService = lensesService;
    }

    @NotNull
    public final EditStreamHandler getDiffStreamHandler() {
        return this.diffStreamHandler;
    }

    public final boolean isOkActionEnabled() {
        JBPopup jBPopup = this.popup;
        return (jBPopup != null ? jBPopup.isVisible() : false) && this.okButtonGroup.isEnabled();
    }

    private final void createAndShowPopup() {
        block1: {
            JBPopup jBPopup = this.popup = JBPopupFactory.getInstance().createComponentPopupBuilder(this.createPopupContent(), (JComponent)((Object)this.instructionsField)).setMovable(true).setResizable(true).setRequestFocus(true).setMinSize(new Dimension(700, 200)).createPopup();
            if (jBPopup != null) {
                jBPopup.showInBestPositionFor(this.editor);
            }
            JBPopup jBPopup2 = this.popup;
            if (jBPopup2 == null) break block1;
            jBPopup2.addListener(new JBPopupListener(this){
                final /* synthetic */ InlineEditPanel this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onClosed(LightweightWindowEvent event2) {
                    Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
                    InlineEditPanel.access$performCancelAction(this.this$0);
                }
            });
        }
    }

    private final JComponent createPopupContent() {
        JPanel jPanel;
        JPanel $this$createPopupContent_u24lambda_u2414 = jPanel = new JPanel(new BorderLayout());
        boolean bl = false;
        $this$createPopupContent_u24lambda_u2414.add((Component)this.createTopRow(), "North");
        $this$createPopupContent_u24lambda_u2414.add((Component)this.createCenterPanel(), "Center");
        $this$createPopupContent_u24lambda_u2414.add((Component)this.createBottomRow(), "South");
        $this$createPopupContent_u24lambda_u2414.setEnabled(true);
        return jPanel;
    }

    @RequiresEdt
    private final void setupTextField() {
        this.instructionsField.addCaretListener(this.promptCaretListener);
        this.instructionsField.addKeyListener(this.keyPressListener);
    }

    @RequiresEdt
    private final void updateOkButtonState() {
        String string = this.instructionsField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        this.okButtonGroup.setEnabled(!StringsKt.isBlank((CharSequence)string));
    }

    @RequiresEdt
    private final void checkForInterruptions() {
        if (this.editor.isDisposed() || this.editor.isViewer() || !this.editor.getDocument().isWritable()) {
            this.performCancelAction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void performCancelAction() {
        try {
            String string = this.instructionsField.getText();
            if (string != null) {
                String it = string;
                boolean bl = false;
                lastPrompt = it;
            }
            MessageBusConnection messageBusConnection = this.connection;
            if (messageBusConnection != null) {
                messageBusConnection.disconnect();
            }
            this.connection = null;
            JBPopup jBPopup = this.popup;
            if (jBPopup != null) {
                jBPopup.cancel();
            }
            this.editor.getMarkupModel().removeAllHighlighters();
        }
        catch (Exception x) {
            this.logger.warn("Error cancelling edit command prompt", x);
        }
        finally {
            this.dispose();
        }
    }

    private final JPanel createTopRow() {
        JPanel jPanel;
        JPanel $this$createTopRow_u24lambda_u2417 = jPanel = EditUtil.INSTANCE.namedPanel("top-row");
        boolean bl = false;
        $this$createTopRow_u24lambda_u2417.setLayout(new BorderLayout());
        $this$createTopRow_u24lambda_u2417.setFocusable(false);
        $this$createTopRow_u24lambda_u2417.add((Component)this.titleLabel, "West");
        LogicalPosition it = this.editor.offsetToLogicalPosition(this.offset);
        boolean bl2 = false;
        Pair pair = new Pair((Object)it.line, (Object)it.column);
        int line = ((Number)pair.component1()).intValue();
        int col = ((Number)pair.component2()).intValue();
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(this.editor.getDocument());
        String file = this.getFormattedFilePath(virtualFile);
        this.filePathLabel.setText(file + " at " + (line + 1) + ":" + (col + 1));
        VirtualFile virtualFile2 = virtualFile;
        this.filePathLabel.setToolTipText(virtualFile2 != null ? virtualFile2.getPath() : null);
        $this$createTopRow_u24lambda_u2417.add((Component)this.filePathLabel, "Center");
        return jPanel;
    }

    private final String getFormattedFilePath(VirtualFile file) {
        CharSequence charSequence;
        Object object;
        Object fileName;
        int maxLength = 70;
        Object object2 = file;
        if (object2 == null || (object2 = object2.getName()) == null) {
            object2 = fileName = FILE_PATH_404;
        }
        if ((object = file) == null || (object = object.getPath()) == null) {
            return fileName;
        }
        Object fullPath = object;
        Project project = this.editor.getProject();
        if (project == null) {
            return FILE_PATH_404;
        }
        Project project2 = project;
        String string = this.getProjectRootPath(project2, file);
        if (string == null) {
            return fileName;
        }
        String projectRootPath = string;
        String relativePath = StringsKt.removePrefix((String)fullPath, (CharSequence)projectRootPath);
        Object truncatedPath = relativePath.length() > maxLength ? "\u2026" + StringsKt.takeLast((String)relativePath, (int)(maxLength - 1)) : relativePath;
        CharSequence charSequence2 = (CharSequence)truncatedPath;
        if (charSequence2.length() == 0) {
            boolean bl = false;
            charSequence = fileName;
        } else {
            charSequence = charSequence2;
        }
        return (String)charSequence;
    }

    private final String getProjectRootPath(Project project, VirtualFile file) {
        VirtualFile contentRoot;
        VirtualFile virtualFile;
        block3: {
            ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)project);
            VirtualFile[] virtualFileArray = projectRootManager.getContentRoots();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getContentRoots(...)");
            VirtualFile[] contentRoots = virtualFileArray;
            VirtualFile virtualFile2 = file;
            if (virtualFile2 != null) {
                VirtualFile nonNullFile = virtualFile2;
                boolean bl = false;
                VirtualFile[] $this$firstOrNull$iv = contentRoots;
                boolean $i$f$firstOrNull = false;
                int n = $this$firstOrNull$iv.length;
                for (int i = 0; i < n; ++i) {
                    VirtualFile element$iv;
                    VirtualFile it = element$iv = $this$firstOrNull$iv[i];
                    boolean bl2 = false;
                    if (!VfsUtilCore.isAncestor((VirtualFile)it, (VirtualFile)nonNullFile, (boolean)false)) continue;
                    virtualFile = element$iv;
                    break block3;
                }
                virtualFile = null;
            } else {
                virtualFile = null;
            }
        }
        VirtualFile virtualFile3 = contentRoot = virtualFile;
        return virtualFile3 != null ? virtualFile3.getPath() : null;
    }

    /*
     * WARNING - void declaration
     */
    private final JPanel createCenterPanel() {
        void $this$createCenterPanel_u24lambda_u2424_u24lambda_u2423_u24lambda_u2422;
        JPanel jPanel;
        void $this$createCenterPanel_u24lambda_u2424_u24lambda_u2423;
        JComponent $this$createCenterPanel_u24lambda_u2424_u24lambda_u2421;
        JComponent jComponent;
        JPanel jPanel2;
        JPanel $this$createCenterPanel_u24lambda_u2424 = jPanel2 = EditUtil.INSTANCE.namedPanel("center-panel");
        boolean bl = false;
        $this$createCenterPanel_u24lambda_u2424.setOpaque(true);
        $this$createCenterPanel_u24lambda_u2424.setBackground(Companion.textFieldBackground());
        $this$createCenterPanel_u24lambda_u2424.setLayout(new BorderLayout());
        JScrollPane jScrollPane = jComponent = new JScrollPane();
        JPanel jPanel3 = $this$createCenterPanel_u24lambda_u2424;
        boolean bl2 = false;
        $this$createCenterPanel_u24lambda_u2424_u24lambda_u2421.setVerticalScrollBarPolicy(20);
        $this$createCenterPanel_u24lambda_u2424_u24lambda_u2421.setHorizontalScrollBarPolicy(30);
        $this$createCenterPanel_u24lambda_u2424_u24lambda_u2421.setBorder((Border)JBUI.Borders.empty());
        $this$createCenterPanel_u24lambda_u2424_u24lambda_u2421.getViewport().setOpaque(false);
        $this$createCenterPanel_u24lambda_u2424_u24lambda_u2421.setViewportView((Component)((Object)this.instructionsField));
        UiSizeUtilKt.setPreferredHeight((JComponent)$this$createCenterPanel_u24lambda_u2424_u24lambda_u2421, (int)100);
        jPanel3.add((Component)jComponent, "Center");
        $this$createCenterPanel_u24lambda_u2424_u24lambda_u2421 = jComponent = EditUtil.INSTANCE.namedPanel("llmDropdown-horizontal-positioner");
        jPanel3 = $this$createCenterPanel_u24lambda_u2424;
        boolean bl3 = false;
        $this$createCenterPanel_u24lambda_u2424_u24lambda_u2423.setLayout(new BoxLayout((Container)$this$createCenterPanel_u24lambda_u2424_u24lambda_u2423, 0));
        $this$createCenterPanel_u24lambda_u2424_u24lambda_u2423.setOpaque(false);
        $this$createCenterPanel_u24lambda_u2424_u24lambda_u2423.setBorder((Border)JBUI.Borders.empty());
        $this$createCenterPanel_u24lambda_u2424_u24lambda_u2423.add(Box.createHorizontalStrut(15));
        JPanel jPanel4 = jPanel = EditUtil.INSTANCE.namedPanel("llmDropdown-vertical-positioner");
        void var10_10 = $this$createCenterPanel_u24lambda_u2424_u24lambda_u2423;
        boolean bl4 = false;
        $this$createCenterPanel_u24lambda_u2424_u24lambda_u2423_u24lambda_u2422.setLayout(new BoxLayout((Container)$this$createCenterPanel_u24lambda_u2424_u24lambda_u2423_u24lambda_u2422, 1));
        $this$createCenterPanel_u24lambda_u2424_u24lambda_u2423_u24lambda_u2422.setOpaque(false);
        $this$createCenterPanel_u24lambda_u2424_u24lambda_u2423_u24lambda_u2422.setBorder((Border)JBUI.Borders.empty());
        $this$createCenterPanel_u24lambda_u2424_u24lambda_u2423_u24lambda_u2422.add(Box.createVerticalStrut(10));
        var10_10.add(jPanel);
        $this$createCenterPanel_u24lambda_u2424_u24lambda_u2423.setOpaque(false);
        $this$createCenterPanel_u24lambda_u2424_u24lambda_u2423.add(Box.createHorizontalStrut(15));
        jPanel3.add((Component)jComponent, "South");
        return jPanel2;
    }

    private final JPanel createBottomRow() {
        JPanel jPanel;
        JPanel $this$createBottomRow_u24lambda_u2425 = jPanel = EditUtil.INSTANCE.namedPanel("bottom-row-outer");
        boolean bl = false;
        $this$createBottomRow_u24lambda_u2425.setLayout(new BoxLayout($this$createBottomRow_u24lambda_u2425, 0));
        $this$createBottomRow_u24lambda_u2425.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 12));
        $this$createBottomRow_u24lambda_u2425.add(this.cancelLabel);
        $this$createBottomRow_u24lambda_u2425.add(Box.createHorizontalGlue());
        $this$createBottomRow_u24lambda_u2425.add(this.historyLabel);
        $this$createBottomRow_u24lambda_u2425.add(Box.createHorizontalGlue());
        $this$createBottomRow_u24lambda_u2425.add(this.okButtonGroup);
        return jPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresEdt
    public final void performOKAction() {
        try {
            TrackService.commandUsage$default(TrackService.INSTANCE, null, CoderiderTrackClient.CommandType.edit_code, 1, null);
            String text = this.instructionsField.getText();
            Intrinsics.checkNotNull((Object)text);
            if (StringsKt.isBlank((CharSequence)text)) {
                this.performCancelAction();
                return;
            }
            this.historyManager.addPrompt(text);
            if (this.editor.getProject() == null) {
                String msg = "Null project for new edit session";
                Logger.warn$default(this.logger, msg, null, 2, null);
                return;
            }
            String indentation = EditUtilKt.getCurrentLineIndentation(this.editor, this.startOffset);
            String string = this.editor.getVirtualFile().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            String language = LanguageUtilsKt.getLanguageFromPath(string);
            VirtualFile virtualFile = this.editor.getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
            PsiFile psiFile = VirtualFileUtil.findPsiFile((VirtualFile)virtualFile, (Project)this.project);
            if (psiFile != null) {
                PsiFile it = psiFile;
                boolean bl = false;
                String it1 = language;
                boolean bl2 = false;
                PsiUtils.INSTANCE.getExtractedTextStrAsync(it, new Range(this.expandedStartOffset, this.expandedEndOffset), it1, (Function1<? super String, Unit>)((Function1)arg_0 -> InlineEditPanel.performOKAction$lambda$30$lambda$29$lambda$28(this, text, arg_0)));
            }
        }
        finally {
            this.performCancelAction();
        }
    }

    public void dispose() {
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.project;
        }
        return null;
    }

    private static final Unit diffStreamHandler$lambda$0(InlineEditPanel this$0) {
        this$0.lensesService.clearLenses(this$0.editor);
        return Unit.INSTANCE;
    }

    private static final Unit diffStreamHandler$lambda$1(InlineEditPanel this$0) {
        if (this$0.virtualFile != null) {
            LensesService lensesService = this$0.lensesService;
            Editor editor = this$0.editor;
            String string = this$0.virtualFile.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
            lensesService.updateLenses(editor, string, this$0.virtualFile, this$0.lensesService.generateInlineEditStartLense(this$0.range, this$0.taskId));
        }
        return Unit.INSTANCE;
    }

    private static final Unit diffStreamHandler$lambda$2() {
        return Unit.INSTANCE;
    }

    private static final Unit diffStreamHandler$lambda$3(InlineEditPanel this$0) {
        if (this$0.virtualFile != null) {
            LensesService lensesService = this$0.lensesService;
            Editor editor = this$0.editor;
            String string = this$0.virtualFile.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
            lensesService.updateLenses(editor, string, this$0.virtualFile, this$0.lensesService.generateInlineEditEndLense(this$0.range, this$0.taskId));
        }
        return Unit.INSTANCE;
    }

    private static final void okButton$lambda$5$lambda$4(InlineEditPanel this$0, ActionEvent it) {
        this$0.performOKAction();
    }

    private static final void okButtonGroup$lambda$8$lambda$7(InlineEditPanel this$0, JLabel $shortcutLabel, PropertyChangeEvent evt) {
        block1: {
            PropertyChangeEvent propertyChangeEvent = evt;
            if (!Intrinsics.areEqual((Object)(propertyChangeEvent != null ? propertyChangeEvent.getPropertyName() : null), (Object)"enabled")) break block1;
            JButton jButton = this$0.okButton;
            Object object = evt.getNewValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
            jButton.setEnabled((Boolean)object);
            JLabel jLabel = $shortcutLabel;
            if (jLabel != null) {
                Object object2 = evt.getNewValue();
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Boolean");
                jLabel.setEnabled((Boolean)object2);
            }
        }
    }

    private static final void promptCaretListener$lambda$12(InlineEditPanel this$0, CaretEvent it) {
        this$0.updateOkButtonState();
        this$0.checkForInterruptions();
        this$0.historyLabel.setEnabled(this$0.historyManager.isHistoryAvailable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit performOKAction$lambda$30$lambda$29$lambda$28$lambda$27(InlineEditPanel this$0, String $text) {
        try {
            EditStreamHandler editStreamHandler = this$0.diffStreamHandler;
            Intrinsics.checkNotNull((Object)$text);
            EditStreamHandler.streamDiffLinesToEditor$default(editStreamHandler, $text, true, true, null, 8, null);
        }
        catch (Throwable e) {
            String string = e.getMessage();
            if (string != null) {
                String it = string;
                boolean bl = false;
                Messages.showErrorDialog((String)it, (String)I18nKt.getMessage("error"));
            }
            this$0.diffStreamHandler.handleFinishedResponse();
        }
        finally {
            this$0.performCancelAction();
        }
        return Unit.INSTANCE;
    }

    private static final Unit performOKAction$lambda$30$lambda$29$lambda$28(InlineEditPanel this$0, String $text, String extraInfo) {
        Intrinsics.checkNotNullParameter((Object)extraInfo, (String)"extraInfo");
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        EditTask result2 = new EditTask(string, "Finished", null, new Range(this$0.expandedStartOffset, this$0.expandedStartOffset), $text, ModelsConfiguration.Companion.getInstance().getDefaultChatModel().getKey(), this$0.originFile);
        ActionsKt.invokeLater$default(null, () -> InlineEditPanel.performOKAction$lambda$30$lambda$29$lambda$28$lambda$27(this$0, $text), (int)1, null);
        ((Map)EditCodeAction.Companion.getCompletedEditTasks()).put(result2.getId(), result2);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$performCancelAction(InlineEditPanel $this) {
        $this.performCancelAction();
    }

    public static final /* synthetic */ InstructionsInputTextArea access$getInstructionsField$p(InlineEditPanel $this) {
        return $this.instructionsField;
    }

    static {
        Key key = Key.create((String)"EDIT_COMMAND_PROMPT_KEY");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        EDIT_COMMAND_PROMPT_KEY = key;
        promptHistory = new PromptHistory(100);
        lastPrompt = "";
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u0019J\u0006\u0010\u001b\u001a\u00020\u0019J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fR\u0019\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006 "}, d2={"Lcn/gitlab/kilo/jetbrains/edit/InlineEditPanel$Companion;", "", "<init>", "()V", "EDIT_COMMAND_PROMPT_KEY", "Lcom/intellij/openapi/util/Key;", "Lcn/gitlab/kilo/jetbrains/edit/InlineEditPanel;", "getEDIT_COMMAND_PROMPT_KEY", "()Lcom/intellij/openapi/util/Key;", "DEFAULT_TEXT_FIELD_WIDTH", "", "DIALOG_MINIMUM_HEIGHT", "FILE_PATH_404", "", "HISTORY_CAPACITY", "promptHistory", "Lcn/gitlab/kilo/jetbrains/edit/PromptHistory;", "getPromptHistory", "()Lcn/gitlab/kilo/jetbrains/edit/PromptHistory;", "lastPrompt", "getLastPrompt", "()Ljava/lang/String;", "setLastPrompt", "(Ljava/lang/String;)V", "mutedLabelColor", "Ljava/awt/Color;", "boldLabelColor", "textFieldBackground", "isVisible", "", "project", "Lcom/intellij/openapi/project/Project;", "coderider-kilo-jetbrains"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<InlineEditPanel> getEDIT_COMMAND_PROMPT_KEY() {
            return EDIT_COMMAND_PROMPT_KEY;
        }

        @NotNull
        public final PromptHistory getPromptHistory() {
            return promptHistory;
        }

        @NotNull
        public final String getLastPrompt() {
            return lastPrompt;
        }

        public final void setLastPrompt(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            lastPrompt = string;
        }

        @NotNull
        public final Color mutedLabelColor() {
            Color color = EditUtil.INSTANCE.getThemeColor("Label.disabledForeground");
            Intrinsics.checkNotNull((Object)color);
            return color;
        }

        @NotNull
        public final Color boldLabelColor() {
            Color color = EditUtil.INSTANCE.getThemeColor("Label.foreground");
            Intrinsics.checkNotNull((Object)color);
            return color;
        }

        @NotNull
        public final Color textFieldBackground() {
            Color color = EditUtil.INSTANCE.getThemeColor("TextField.background");
            Intrinsics.checkNotNull((Object)color);
            return color;
        }

        public final boolean isVisible(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            InlineEditPanel commandPrompt = (InlineEditPanel)this.getEDIT_COMMAND_PROMPT_KEY().get((UserDataHolder)project);
            InlineEditPanel inlineEditPanel = commandPrompt;
            return inlineEditPanel != null && (inlineEditPanel = inlineEditPanel.popup) != null ? inlineEditPanel.isVisible() : false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

