/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.edit;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorEmbeddedComponentManager;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.view.FontLayoutService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00192\u00020\u0001:\u0003\u0017\u0018\u0019B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J$\u0010\u000f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0005H\u0007J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u0012\u0012\b\u0012\u00060\fR\u00020\u0000\u0012\u0004\u0012\u00020\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00060\u000eR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcn/gitlab/kilo/jetbrains/edit/EditorComponentInlaysManager;", "Lcom/intellij/openapi/Disposable;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "onlyOneInlay", "", "<init>", "(Lcom/intellij/openapi/editor/impl/EditorImpl;Z)V", "getEditor", "()Lcom/intellij/openapi/editor/impl/EditorImpl;", "managedInlays", "", "Lcn/gitlab/kilo/jetbrains/edit/EditorComponentInlaysManager$ComponentWrapper;", "editorWidthWatcher", "Lcn/gitlab/kilo/jetbrains/edit/EditorComponentInlaysManager$EditorTextWidthWatcher;", "insert", "lineIndex", "", "component", "Ljavax/swing/JComponent;", "showAbove", "dispose", "", "ComponentWrapper", "EditorTextWidthWatcher", "Companion", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nEditorComponentInlaysManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorComponentInlaysManager.kt\ncn/gitlab/kilo/jetbrains/edit/EditorComponentInlaysManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,162:1\n1869#2,2:163\n1869#2,2:165\n*S KotlinDebug\n*F\n+ 1 EditorComponentInlaysManager.kt\ncn/gitlab/kilo/jetbrains/edit/EditorComponentInlaysManager\n*L\n46#1:163,2\n93#1:165,2\n*E\n"})
public final class EditorComponentInlaysManager
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EditorImpl editor;
    private final boolean onlyOneInlay;
    @NotNull
    private final Map<ComponentWrapper, Disposable> managedInlays;
    @NotNull
    private final EditorTextWidthWatcher editorWidthWatcher;
    @NotNull
    private static final Key<EditorComponentInlaysManager> INLAYS_KEY;

    public EditorComponentInlaysManager(@NotNull EditorImpl editor, boolean onlyOneInlay) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.editor = editor;
        this.onlyOneInlay = onlyOneInlay;
        this.managedInlays = new LinkedHashMap();
        this.editorWidthWatcher = new EditorTextWidthWatcher();
        this.editor.getScrollPane().getViewport().addComponentListener(this.editorWidthWatcher);
        Disposer.register((Disposable)this, () -> EditorComponentInlaysManager._init_$lambda$0(this));
        EditorUtil.disposeWithEditor((Editor)((Editor)this.editor), (Disposable)this);
    }

    @NotNull
    public final EditorImpl getEditor() {
        return this.editor;
    }

    @RequiresEdt
    @Nullable
    public final Disposable insert(int lineIndex, @NotNull JComponent component, boolean showAbove) {
        Inlay inlay;
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        if (Disposer.isDisposed((Disposable)this)) {
            return null;
        }
        if (this.onlyOneInlay) {
            Iterable $this$forEach$iv = this.managedInlays.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Disposable p0 = (Disposable)element$iv;
                boolean bl = false;
                Disposer.dispose((Disposable)p0);
            }
        }
        ComponentWrapper wrappedComponent = new ComponentWrapper(component);
        int offset = this.editor.getDocument().getLineStartOffset(lineIndex);
        Inlay inlay2 = EditorEmbeddedComponentManager.getInstance().addComponent((EditorEx)this.editor, (JComponent)((Object)wrappedComponent), new EditorEmbeddedComponentManager.Properties(EditorEmbeddedComponentManager.ResizePolicy.none(), null, !this.editor.getInlayModel().getBlockElementsInRange(offset, offset).isEmpty(), showAbove, 0, offset));
        if (inlay2 != null) {
            Inlay inlay3;
            Inlay it = inlay3 = inlay2;
            boolean bl = false;
            this.managedInlays.put(wrappedComponent, (Disposable)it);
            Disposer.register((Disposable)((Disposable)it), () -> EditorComponentInlaysManager.insert$lambda$2$lambda$1(this, wrappedComponent));
            inlay = inlay3;
        } else {
            inlay = null;
        }
        return (Disposable)inlay;
    }

    public static /* synthetic */ Disposable insert$default(EditorComponentInlaysManager editorComponentInlaysManager, int n, JComponent jComponent, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return editorComponentInlaysManager.insert(n, jComponent, bl);
    }

    public void dispose() {
        Iterable $this$forEach$iv = this.managedInlays.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Disposable p0 = (Disposable)element$iv;
            boolean bl = false;
            Disposer.dispose((Disposable)p0);
        }
    }

    private static final void _init_$lambda$0(EditorComponentInlaysManager this$0) {
        this$0.editor.getScrollPane().getViewport().removeComponentListener(this$0.editorWidthWatcher);
    }

    private static final void insert$lambda$2$lambda$1(EditorComponentInlaysManager this$0, ComponentWrapper $wrappedComponent) {
        this$0.managedInlays.remove((Object)$wrappedComponent);
    }

    static {
        Key key = Key.create((String)"EditorComponentInlaysManager");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        INLAYS_KEY = key;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lcn/gitlab/kilo/jetbrains/edit/EditorComponentInlaysManager$Companion;", "", "<init>", "()V", "INLAYS_KEY", "Lcom/intellij/openapi/util/Key;", "Lcn/gitlab/kilo/jetbrains/edit/EditorComponentInlaysManager;", "getINLAYS_KEY", "()Lcom/intellij/openapi/util/Key;", "from", "editor", "Lcom/intellij/openapi/editor/Editor;", "onlyOneInlay", "", "coderider-kilo-jetbrains"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<EditorComponentInlaysManager> getINLAYS_KEY() {
            return INLAYS_KEY;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final EditorComponentInlaysManager from(@NotNull Editor editor, boolean onlyOneInlay) {
            EditorComponentInlaysManager editorComponentInlaysManager;
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Editor editor2 = editor;
            synchronized (editor2) {
                EditorComponentInlaysManager editorComponentInlaysManager2;
                boolean bl = false;
                EditorComponentInlaysManager manager = (EditorComponentInlaysManager)editor.getUserData(Companion.getINLAYS_KEY());
                if (manager == null) {
                    EditorComponentInlaysManager newManager = new EditorComponentInlaysManager((EditorImpl)editor, false);
                    ((EditorImpl)editor).putUserData(Companion.getINLAYS_KEY(), (Object)newManager);
                    editorComponentInlaysManager2 = newManager;
                } else {
                    editorComponentInlaysManager2 = manager;
                }
                editorComponentInlaysManager = editorComponentInlaysManager2;
            }
            return editorComponentInlaysManager;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcn/gitlab/kilo/jetbrains/edit/EditorComponentInlaysManager$ComponentWrapper;", "Lcom/intellij/ui/components/JBScrollPane;", "component", "Ljavax/swing/JComponent;", "<init>", "(Lcn/gitlab/kilo/jetbrains/edit/EditorComponentInlaysManager;Ljavax/swing/JComponent;)V", "getPreferredSize", "Ljava/awt/Dimension;", "coderider-kilo-jetbrains"})
    private final class ComponentWrapper
    extends JBScrollPane {
        @NotNull
        private final JComponent component;

        public ComponentWrapper(JComponent component) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            super((Component)component);
            this.component = component;
            this.setOpaque(false);
            this.viewport.setOpaque(false);
            this.setBorder((Border)JBUI.Borders.empty());
            this.setViewportBorder((Border)JBUI.Borders.empty());
            this.horizontalScrollBarPolicy = 31;
            this.verticalScrollBar.setPreferredSize(new Dimension(0, 0));
            this.setViewportView(this.component);
            this.component.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.dispatchEvent(new ComponentEvent(component, 101));
                }
            });
        }

        @NotNull
        public Dimension getPreferredSize() {
            return new Dimension(EditorComponentInlaysManager.this.getEditor().getContentComponent().getWidth(), this.component.getPreferredSize().height);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0013\u001a\u00020\u000eH\u0002J\b\u0010\u0014\u001a\u00020\u0005H\u0002J\b\u0010\u0015\u001a\u00020\u0005H\u0002J\b\u0010\u0016\u001a\u00020\u0005H\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcn/gitlab/kilo/jetbrains/edit/EditorComponentInlaysManager$EditorTextWidthWatcher;", "Ljava/awt/event/ComponentAdapter;", "<init>", "(Lcn/gitlab/kilo/jetbrains/edit/EditorComponentInlaysManager;)V", "editorTextWidth", "", "getEditorTextWidth", "()I", "setEditorTextWidth", "(I)V", "maximumEditorTextWidth", "verticalScrollbarFlipped", "", "componentResized", "", "e", "Ljava/awt/event/ComponentEvent;", "componentHidden", "componentShown", "updateWidthForAllInlays", "calcWidth", "getVerticalScrollbarWidth", "getGutterTextGap", "coderider-kilo-jetbrains"})
    @SourceDebugExtension(value={"SMAP\nEditorComponentInlaysManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorComponentInlaysManager.kt\ncn/gitlab/kilo/jetbrains/edit/EditorComponentInlaysManager$EditorTextWidthWatcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,162:1\n1869#2,2:163\n*S KotlinDebug\n*F\n+ 1 EditorComponentInlaysManager.kt\ncn/gitlab/kilo/jetbrains/edit/EditorComponentInlaysManager$EditorTextWidthWatcher\n*L\n123#1:163,2\n*E\n"})
    private final class EditorTextWidthWatcher
    extends ComponentAdapter {
        private int editorTextWidth;
        private final int maximumEditorTextWidth;
        private final boolean verticalScrollbarFlipped;

        public EditorTextWidthWatcher() {
            FontMetrics fontMetrics = EditorComponentInlaysManager.this.getEditor().getFontMetrics(0);
            Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"getFontMetrics(...)");
            FontMetrics metrics = fontMetrics;
            float spaceWidth = FontLayoutService.Companion.getInstance().charWidth2D(metrics, 32);
            this.maximumEditorTextWidth = (int)Math.ceil(spaceWidth * (float)EditorComponentInlaysManager.this.getEditor().getSettings().getRightMargin(EditorComponentInlaysManager.this.getEditor().getProject()) - (float)4);
            Object scrollbarFlip = EditorComponentInlaysManager.this.getEditor().getScrollPane().getClientProperty(JBScrollPane.Flip.class);
            this.verticalScrollbarFlipped = scrollbarFlip == JBScrollPane.Flip.HORIZONTAL || scrollbarFlip == JBScrollPane.Flip.BOTH;
        }

        public final int getEditorTextWidth() {
            return this.editorTextWidth;
        }

        public final void setEditorTextWidth(int n) {
            this.editorTextWidth = n;
        }

        @Override
        public void componentResized(@NotNull ComponentEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.updateWidthForAllInlays();
        }

        @Override
        public void componentHidden(@NotNull ComponentEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.updateWidthForAllInlays();
        }

        @Override
        public void componentShown(@NotNull ComponentEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.updateWidthForAllInlays();
        }

        private final void updateWidthForAllInlays() {
            int newWidth = this.calcWidth();
            if (this.editorTextWidth == newWidth) {
                return;
            }
            this.editorTextWidth = newWidth;
            Iterable $this$forEach$iv = EditorComponentInlaysManager.this.managedInlays.keySet();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ComponentWrapper it = (ComponentWrapper)((Object)element$iv);
                boolean bl = false;
                it.dispatchEvent(new ComponentEvent((Component)((Object)it), 101));
                it.invalidate();
            }
        }

        private final int calcWidth() {
            int visibleEditorTextWidth = EditorComponentInlaysManager.this.getEditor().getScrollPane().getViewport().getWidth() - this.getVerticalScrollbarWidth() - this.getGutterTextGap();
            return Math.min(Math.max(visibleEditorTextWidth, 0), this.maximumEditorTextWidth);
        }

        private final int getVerticalScrollbarWidth() {
            int width = EditorComponentInlaysManager.this.getEditor().getScrollPane().getVerticalScrollBar().getWidth();
            return !this.verticalScrollbarFlipped ? width * 2 : width;
        }

        private final int getGutterTextGap() {
            int n;
            if (this.verticalScrollbarFlipped) {
                EditorImpl editorImpl = EditorComponentInlaysManager.this.getEditor();
                Intrinsics.checkNotNull((Object)editorImpl, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
                EditorGutterComponentEx editorGutterComponentEx = ((EditorEx)editorImpl).getGutterComponentEx();
                Intrinsics.checkNotNullExpressionValue((Object)editorGutterComponentEx, (String)"getGutterComponentEx(...)");
                EditorGutterComponentEx gutter = editorGutterComponentEx;
                n = gutter.getWidth() - gutter.getWhitespaceSeparatorOffset();
            } else {
                n = 0;
            }
            return n;
        }
    }
}

