/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.edit;

import ai.grazie.utils.mpp.UUID;
import cn.gitlab.kilo.jetbrains.common.I18nKt;
import cn.gitlab.kilo.jetbrains.common.Range;
import cn.gitlab.kilo.jetbrains.edit.CockpitInlineQuickCommandRenderKt;
import cn.gitlab.kilo.jetbrains.edit.EditInlineStreamService;
import cn.gitlab.kilo.jetbrains.edit.EditStreamHandler;
import cn.gitlab.kilo.jetbrains.edit.InlineEditPanel;
import cn.gitlab.kilo.jetbrains.edit.LensesService;
import cn.gitlab.kilo.jetbrains.edit.action.DiffStreamUtilsKt;
import cn.gitlab.kilo.jetbrains.edit.action.InlineActionHelperKt;
import cn.gitlab.kilo.jetbrains.services.CoderiderTrackClient;
import cn.gitlab.kilo.jetbrains.services.TrackService;
import cn.gitlab.kilo.jetbrains.utils.ThemeUtilKt;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.awt.RelativePoint;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B_\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000e\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\u0003\u0012\u0006\u0010\u0010\u001a\u00020\u0003\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014J4\u00109\u001a\u00020:2'\u0010;\u001a#\b\u0001\u0012\u0004\u0012\u000208\u0012\n\u0012\b\u0012\u0004\u0012\u00020:0=\u0012\u0006\u0012\u0004\u0018\u00010>0<\u00a2\u0006\u0002\b?\u00a2\u0006\u0002\u0010@J\u0014\u0010F\u001a\u00020\f2\n\u0010G\u001a\u0006\u0012\u0002\b\u00030HH\u0016J\u0006\u0010Q\u001a\u00020RJ\u0006\u0010S\u001a\u00020RJ,\u0010T\u001a\u00020:2\n\u0010G\u001a\u0006\u0012\u0002\b\u00030H2\u0006\u0010U\u001a\u00020V2\u0006\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u00020ZH\u0016J\u000e\u0010[\u001a\u00020:2\u0006\u0010\\\u001a\u00020XJ\u000e\u0010]\u001a\u00020R2\u0006\u0010^\u001a\u00020_J\b\u0010`\u001a\u00020:H\u0002J\b\u0010a\u001a\u00020:H\u0002J\b\u0010b\u001a\u00020:H\u0002J\b\u0010c\u001a\u00020:H\u0002J\b\u0010d\u001a\u00020:H\u0002J)\u0010e\u001a\u00020f2\u0006\u0010g\u001a\u00020\n2\n\b\u0002\u0010h\u001a\u0004\u0018\u00010\f2\u0006\u0010i\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010jJ%\u0010k\u001a\u00020f2\n\b\u0002\u0010g\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010h\u001a\u0004\u0018\u00010\fH\u0002\u00a2\u0006\u0002\u0010lR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0016\"\u0004\b\u001a\u0010\u0018R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001a\u0010\r\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010(\"\u0004\b,\u0010*R\u001a\u0010\u000e\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010(\"\u0004\b.\u0010*R\u001a\u0010\u000f\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\u0016\"\u0004\b0\u0010\u0018R\u001a\u0010\u0010\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010\u0016\"\u0004\b2\u0010\u0018R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00104\"\u0004\b5\u00106R\u000e\u00107\u001a\u000208X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010A\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010B\u001a\u00020CX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010D\u001a\u00020CX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010E\u001a\u00020CX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010I\u001a\u0004\u0018\u00010J\u00a2\u0006\b\n\u0000\u001a\u0004\bK\u0010LR\u0011\u0010M\u001a\u00020N\u00a2\u0006\b\n\u0000\u001a\u0004\bO\u0010P\u00a8\u0006m"}, d2={"Lcn/gitlab/kilo/jetbrains/edit/CockpitInlineQuickCommandRender;", "Lcom/intellij/openapi/editor/EditorCustomElementRenderer;", "path", "", "originFile", "range", "Lcn/gitlab/kilo/jetbrains/common/Range;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "leftMarginX", "", "startLine", "endLine", "selectedText", "filePath", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lcn/gitlab/kilo/jetbrains/common/Range;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;IIILjava/lang/String;Ljava/lang/String;Lcom/intellij/openapi/vfs/VirtualFile;)V", "getPath", "()Ljava/lang/String;", "setPath", "(Ljava/lang/String;)V", "getOriginFile", "setOriginFile", "getRange", "()Lcn/gitlab/kilo/jetbrains/common/Range;", "setRange", "(Lcn/gitlab/kilo/jetbrains/common/Range;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "setProject", "(Lcom/intellij/openapi/project/Project;)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "setEditor", "(Lcom/intellij/openapi/editor/Editor;)V", "getLeftMarginX", "()I", "setLeftMarginX", "(I)V", "getStartLine", "setStartLine", "getEndLine", "setEndLine", "getSelectedText", "setSelectedText", "getFilePath", "setFilePath", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "setVirtualFile", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "ioCoroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "launchInIOScope", "", "block", "Lkotlin/Function2;", "Lkotlin/coroutines/Continuation;", "", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function2;)V", "taskId", "grayIcon", "Ljavax/swing/Icon;", "blueIcon", "icon", "calcWidthInPixels", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "psiFile", "Lcom/intellij/psi/PsiFile;", "getPsiFile", "()Lcom/intellij/psi/PsiFile;", "language", "Ljava/io/Serializable;", "getLanguage", "()Ljava/io/Serializable;", "hovered", "", "unhovered", "paint", "g", "Ljava/awt/Graphics;", "targetRegion", "Ljava/awt/Rectangle;", "textAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "onIconClicked", "bounds", "isIconSelected", "p", "Ljava/awt/Point;", "handleEditCode", "handleGenerateTests", "handleGenerateComments", "handleGenerateDocstrings", "handleCodeOpt", "generateNewFileDiffStreamHandler", "Lcn/gitlab/kilo/jetbrains/edit/EditStreamHandler;", "newEditor", "targetStartLine", "oldFilePath", "(Lcom/intellij/openapi/editor/Editor;Ljava/lang/Integer;Ljava/lang/String;)Lcn/gitlab/kilo/jetbrains/edit/EditStreamHandler;", "generateDiffStreamHandler", "(Lcom/intellij/openapi/editor/Editor;Ljava/lang/Integer;)Lcn/gitlab/kilo/jetbrains/edit/EditStreamHandler;", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nCockpitInlineQuickCommandRender.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CockpitInlineQuickCommandRender.kt\ncn/gitlab/kilo/jetbrains/edit/CockpitInlineQuickCommandRender\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,514:1\n31#2,2:515\n31#2,2:521\n31#2,2:523\n31#2,2:525\n31#2,2:527\n31#2,2:529\n37#3:517\n36#3,3:518\n*S KotlinDebug\n*F\n+ 1 CockpitInlineQuickCommandRender.kt\ncn/gitlab/kilo/jetbrains/edit/CockpitInlineQuickCommandRender\n*L\n117#1:515,2\n285#1:521,2\n299#1:523,2\n313#1:525,2\n252#1:527,2\n265#1:529,2\n158#1:517\n158#1:518,3\n*E\n"})
public final class CockpitInlineQuickCommandRender
implements EditorCustomElementRenderer {
    @NotNull
    private String path;
    @NotNull
    private String originFile;
    @NotNull
    private Range range;
    @NotNull
    private Project project;
    @NotNull
    private Editor editor;
    private int leftMarginX;
    private int startLine;
    private int endLine;
    @NotNull
    private String selectedText;
    @NotNull
    private String filePath;
    @NotNull
    private VirtualFile virtualFile;
    @NotNull
    private final CoroutineScope ioCoroutineScope;
    @NotNull
    private final String taskId;
    @NotNull
    private final Icon grayIcon;
    @NotNull
    private final Icon blueIcon;
    @NotNull
    private Icon icon;
    @Nullable
    private final PsiFile psiFile;
    @NotNull
    private final Serializable language;

    public CockpitInlineQuickCommandRender(@NotNull String path, @NotNull String originFile, @NotNull Range range, @NotNull Project project, @NotNull Editor editor, int leftMarginX, int startLine, int endLine, @NotNull String selectedText, @NotNull String filePath, @NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)originFile, (String)"originFile");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)selectedText, (String)"selectedText");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        this.path = path;
        this.originFile = originFile;
        this.range = range;
        this.project = project;
        this.editor = editor;
        this.leftMarginX = leftMarginX;
        this.startLine = startLine;
        this.endLine = endLine;
        this.selectedText = selectedText;
        this.filePath = filePath;
        this.virtualFile = virtualFile;
        this.ioCoroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO()));
        this.taskId = UUID.Companion.random().toString();
        this.grayIcon = IconLoader.getIcon((String)"/kilo/CodeRider-Kilo-128-grey.svg", this.getClass());
        this.blueIcon = IconLoader.getIcon((String)"/kilo/CodeRider-Kilo-128-blue.svg", this.getClass());
        this.icon = this.grayIcon;
        this.psiFile = PsiManager.getInstance((Project)this.project).findFile(this.virtualFile);
        PsiFile psiFile = this.psiFile;
        this.language = psiFile != null && (psiFile = psiFile.getLanguage()) != null ? (Serializable)psiFile : (Serializable)((Object)"txt");
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    public final void setPath(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.path = string;
    }

    @NotNull
    public final String getOriginFile() {
        return this.originFile;
    }

    public final void setOriginFile(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.originFile = string;
    }

    @NotNull
    public final Range getRange() {
        return this.range;
    }

    public final void setRange(@NotNull Range range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"<set-?>");
        this.range = range;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final void setProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"<set-?>");
        this.project = project;
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    public final void setEditor(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"<set-?>");
        this.editor = editor;
    }

    public final int getLeftMarginX() {
        return this.leftMarginX;
    }

    public final void setLeftMarginX(int n) {
        this.leftMarginX = n;
    }

    public final int getStartLine() {
        return this.startLine;
    }

    public final void setStartLine(int n) {
        this.startLine = n;
    }

    public final int getEndLine() {
        return this.endLine;
    }

    public final void setEndLine(int n) {
        this.endLine = n;
    }

    @NotNull
    public final String getSelectedText() {
        return this.selectedText;
    }

    public final void setSelectedText(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.selectedText = string;
    }

    @NotNull
    public final String getFilePath() {
        return this.filePath;
    }

    public final void setFilePath(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.filePath = string;
    }

    @NotNull
    public final VirtualFile getVirtualFile() {
        return this.virtualFile;
    }

    public final void setVirtualFile(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"<set-?>");
        this.virtualFile = virtualFile;
    }

    public final void launchInIOScope(@NotNull Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        BuildersKt.launch$default((CoroutineScope)this.ioCoroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(block, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Function2<CoroutineScope, Continuation<? super Unit>, Object> $block;
            {
                this.$block = $block;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineScope $this$launch = (CoroutineScope)this.L$0;
                        this.label = 1;
                        Object object3 = this.$block.invoke((Object)$this$launch, (Object)((Object)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public int calcWidthInPixels(@NotNull Inlay<?> inlay) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        return this.icon.getIconWidth() + this.leftMarginX;
    }

    @Nullable
    public final PsiFile getPsiFile() {
        return this.psiFile;
    }

    @NotNull
    public final Serializable getLanguage() {
        return this.language;
    }

    public final boolean hovered() {
        if (!Intrinsics.areEqual((Object)this.icon, (Object)this.blueIcon)) {
            this.icon = this.blueIcon;
            return true;
        }
        return false;
    }

    public final boolean unhovered() {
        if (!Intrinsics.areEqual((Object)this.icon, (Object)this.grayIcon)) {
            this.icon = this.grayIcon;
            return true;
        }
        return false;
    }

    public void paint(@NotNull Inlay<?> inlay, @NotNull Graphics g, @NotNull Rectangle targetRegion, @NotNull TextAttributes textAttributes) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)targetRegion, (String)"targetRegion");
        Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
        int iconX = targetRegion.x + this.leftMarginX;
        int iconY = targetRegion.y + (targetRegion.height - this.icon.getIconHeight()) / 2;
        this.icon.paintIcon(null, g, iconX, iconY);
    }

    public final void onIconClicked(@NotNull Rectangle bounds) {
        block7: {
            List list;
            String string;
            Project project;
            block9: {
                block8: {
                    Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
                    this.unhovered();
                    project = this.editor.getProject();
                    if (project == null) break block7;
                    string = project.getBasePath();
                    if (string == null) break block8;
                    String basePath = string;
                    boolean bl = false;
                    String string2 = this.virtualFile.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
                    String string3 = StringsKt.removePrefix((String)string2, (CharSequence)(basePath + "/"));
                    string = string3;
                    if (string3 != null) break block9;
                }
                string = "Unknown Relative Path";
            }
            String relativePath = string;
            Editor editorInstance = this.editor;
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<EditInlineStreamService> serviceClass$iv = EditInlineStreamService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            if (((EditInlineStreamService)object).isOnBusy(this.editor)) {
                HintManager.getInstance().showInformationHint(this.editor, I18nKt.getMessage("inline.edit.busy"));
                return;
            }
            int startOffset = editorInstance.getDocument().getLineStartOffset(RangesKt.coerceAtLeast((int)Math.min(this.startLine, editorInstance.getDocument().getLineCount() - 1), (int)0));
            int endOffset = editorInstance.getDocument().getLineEndOffset(RangesKt.coerceAtLeast((int)Math.min(this.endLine, editorInstance.getDocument().getLineCount() - 1), (int)0));
            editorInstance.getSelectionModel().setSelection(startOffset, endOffset);
            if (InlineActionHelperKt.fileIsReadOnly(this.virtualFile, this.editor)) {
                list = CollectionsKt.emptyList();
            } else {
                Object[] bl = new String[]{I18nKt.getMessage("quick.command.edit"), I18nKt.getMessage("quick.command.test"), I18nKt.getMessage("quick.command.comments"), I18nKt.getMessage("quick.command.docstrings"), I18nKt.getMessage("quick.command.opt")};
                list = CollectionsKt.listOf((Object[])bl);
            }
            List options = list;
            Collection $this$toTypedArray$iv = options;
            boolean $i$f$toTypedArray22 = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            JList<String> list2 = new JList<String>(thisCollection$iv.toArray(new String[0]));
            list2.setCellRenderer(new DefaultListCellRenderer(){

                public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    Intrinsics.checkNotNullParameter(list, (String)"list");
                    Component component = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    Object object = value;
                    Icon icon = Intrinsics.areEqual((Object)object, (Object)I18nKt.getMessage("quick.command.edit")) ? IconLoader.getIcon((String)("/icons/" + ThemeUtilKt.getThemeIsDark() + "/edit.svg"), this.getClass()) : (Intrinsics.areEqual((Object)object, (Object)I18nKt.getMessage("quick.command.test")) ? IconLoader.getIcon((String)("/icons/" + ThemeUtilKt.getThemeIsDark() + "/debug.svg"), this.getClass()) : (Intrinsics.areEqual((Object)object, (Object)I18nKt.getMessage("quick.command.comments")) ? IconLoader.getIcon((String)("/icons/" + ThemeUtilKt.getThemeIsDark() + "/inlayRenameInComments.svg"), this.getClass()) : (Intrinsics.areEqual((Object)object, (Object)I18nKt.getMessage("quick.command.docstrings")) ? IconLoader.getIcon((String)("/icons/" + ThemeUtilKt.getThemeIsDark() + "/docstring.svg"), this.getClass()) : (Intrinsics.areEqual((Object)object, (Object)I18nKt.getMessage("quick.command.opt")) ? IconLoader.getIcon((String)("/icons/" + ThemeUtilKt.getThemeIsDark() + "/eye.svg"), this.getClass()) : IconLoader.getIcon((String)"/icons/actions/default.svg", this.getClass())))));
                    Intrinsics.checkNotNull((Object)component, (String)"null cannot be cast to non-null type javax.swing.JLabel");
                    ((JLabel)component).setIcon(icon);
                    ((JLabel)component).setIconTextGap(5);
                    ((JLabel)component).setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
                    return component;
                }
            });
            JBPopup $i$f$toTypedArray22 = new PopupChooserBuilder(list2).setItemChosenCallback(arg_0 -> CockpitInlineQuickCommandRender.onIconClicked$lambda$2(arg_0 -> CockpitInlineQuickCommandRender.onIconClicked$lambda$1(this, arg_0), arg_0)).setTitle("CodeRider-Kilo").createPopup();
            Intrinsics.checkNotNullExpressionValue((Object)$i$f$toTypedArray22, (String)"createPopup(...)");
            JBPopup popupMenu = $i$f$toTypedArray22;
            Point point = bounds.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getLocation(...)");
            Point point2 = point;
            RelativePoint relativePoint = new RelativePoint((Component)this.editor.getContentComponent(), point2);
            popupMenu.show(relativePoint);
        }
    }

    public final boolean isIconSelected(@NotNull Point p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        return p.x >= this.leftMarginX;
    }

    private final void handleEditCode() {
        new InlineEditPanel(this.project, this.editor, I18nKt.getMessage("inline.edit.header"), null, null, 24, null);
    }

    private final void handleGenerateTests() {
        TrackService.commandUsage$default(TrackService.INSTANCE, null, CoderiderTrackClient.CommandType.generate_test, 1, null);
        CockpitInlineQuickCommandRenderKt.createTestFileNameSafe(this.project, this.virtualFile, this.filePath, (Function1<? super String, Unit>)((Function1)arg_0 -> CockpitInlineQuickCommandRender.handleGenerateTests$lambda$3(this, arg_0)));
    }

    private final void handleGenerateComments() {
        TrackService.commandUsage$default(TrackService.INSTANCE, null, CoderiderTrackClient.CommandType.document_code, 1, null);
        EditStreamHandler diffStreamHandler = CockpitInlineQuickCommandRender.generateDiffStreamHandler$default(this, null, null, 3, null);
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<EditInlineStreamService> serviceClass$iv = EditInlineStreamService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ((EditInlineStreamService)object).register(diffStreamHandler, this.editor);
        String string = I18nKt.getInlinePrompt("prompt.document.code");
        Object[] objectArray = new Object[]{this.language, this.selectedText};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        EditStreamHandler.streamDiffLinesToEditor$default(diffStreamHandler, string2, true, false, null, 8, null);
    }

    private final void handleGenerateDocstrings() {
        TrackService.commandUsage$default(TrackService.INSTANCE, null, CoderiderTrackClient.CommandType.generate_docstrings, 1, null);
        EditStreamHandler diffStreamHandler = CockpitInlineQuickCommandRender.generateDiffStreamHandler$default(this, null, null, 3, null);
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<EditInlineStreamService> serviceClass$iv = EditInlineStreamService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ((EditInlineStreamService)object).register(diffStreamHandler, this.editor);
        String string = I18nKt.getPrompt("prompt.generate.docstrings");
        Object[] objectArray = new Object[]{this.language, this.selectedText};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        EditStreamHandler.streamDiffLinesToEditor$default(diffStreamHandler, string2, true, false, null, 8, null);
    }

    private final void handleCodeOpt() {
        TrackService.commandUsage$default(TrackService.INSTANCE, null, CoderiderTrackClient.CommandType.smell_code, 1, null);
        EditStreamHandler diffStreamHandler = CockpitInlineQuickCommandRender.generateDiffStreamHandler$default(this, null, null, 3, null);
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<EditInlineStreamService> serviceClass$iv = EditInlineStreamService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ((EditInlineStreamService)object).register(diffStreamHandler, this.editor);
        String string = I18nKt.getInlinePrompt("prompt.smell.code");
        Object[] objectArray = new Object[]{this.filePath, this.selectedText};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        EditStreamHandler.streamDiffLinesToEditor$default(diffStreamHandler, string2, null, null, null, 14, null);
    }

    private final EditStreamHandler generateNewFileDiffStreamHandler(Editor newEditor, Integer targetStartLine, String oldFilePath) {
        LensesService lensesService = LensesService.Companion.getInstance(this.project);
        Editor editor = newEditor;
        if (editor == null) {
            editor = this.editor;
        }
        Editor targetEditor = editor;
        return new EditStreamHandler(() -> CockpitInlineQuickCommandRender.generateNewFileDiffStreamHandler$lambda$4(lensesService, targetEditor), () -> CockpitInlineQuickCommandRender.generateNewFileDiffStreamHandler$lambda$5(this, targetStartLine, targetEditor, lensesService), this.project, targetEditor, this.startLine, this.endLine, CockpitInlineQuickCommandRender::generateNewFileDiffStreamHandler$lambda$6, () -> CockpitInlineQuickCommandRender.generateNewFileDiffStreamHandler$lambda$7(newEditor, this, oldFilePath), this.path, this.originFile, this.range.getStart(), this.range.getEnd(), this.editor, targetStartLine, null, oldFilePath, 16384, null);
    }

    static /* synthetic */ EditStreamHandler generateNewFileDiffStreamHandler$default(CockpitInlineQuickCommandRender cockpitInlineQuickCommandRender, Editor editor, Integer n, String string, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        return cockpitInlineQuickCommandRender.generateNewFileDiffStreamHandler(editor, n, string);
    }

    private final EditStreamHandler generateDiffStreamHandler(Editor newEditor, Integer targetStartLine) {
        LensesService lensesService = LensesService.Companion.getInstance(this.project);
        Editor editor = newEditor;
        if (editor == null) {
            editor = this.editor;
        }
        Editor targetEditor = editor;
        return new EditStreamHandler(() -> CockpitInlineQuickCommandRender.generateDiffStreamHandler$lambda$8(lensesService, targetEditor), () -> CockpitInlineQuickCommandRender.generateDiffStreamHandler$lambda$9(this, targetStartLine, targetEditor, lensesService), this.project, targetEditor, this.startLine, this.endLine, CockpitInlineQuickCommandRender::generateDiffStreamHandler$lambda$10, () -> CockpitInlineQuickCommandRender.generateDiffStreamHandler$lambda$11(this, targetStartLine, targetEditor, lensesService), this.path, this.originFile, this.range.getStart(), this.range.getEnd(), this.editor, targetStartLine, null, null, 49152, null);
    }

    static /* synthetic */ EditStreamHandler generateDiffStreamHandler$default(CockpitInlineQuickCommandRender cockpitInlineQuickCommandRender, Editor editor, Integer n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            editor = null;
        }
        if ((n2 & 2) != 0) {
            n = null;
        }
        return cockpitInlineQuickCommandRender.generateDiffStreamHandler(editor, n);
    }

    private static final Unit onIconClicked$lambda$1(CockpitInlineQuickCommandRender this$0, String selectedItem) {
        String string = selectedItem;
        if (Intrinsics.areEqual((Object)string, (Object)I18nKt.getMessage("quick.command.edit"))) {
            this$0.handleEditCode();
        } else if (Intrinsics.areEqual((Object)string, (Object)I18nKt.getMessage("quick.command.test"))) {
            this$0.handleGenerateTests();
        } else if (Intrinsics.areEqual((Object)string, (Object)I18nKt.getMessage("quick.command.comments"))) {
            this$0.handleGenerateComments();
        } else if (Intrinsics.areEqual((Object)string, (Object)I18nKt.getMessage("quick.command.docstrings"))) {
            this$0.handleGenerateDocstrings();
        } else if (Intrinsics.areEqual((Object)string, (Object)I18nKt.getMessage("quick.command.opt"))) {
            this$0.handleCodeOpt();
        } else {
            System.out.println((Object)("\u672a\u77e5\u9009\u9879: " + selectedItem));
        }
        return Unit.INSTANCE;
    }

    private static final void onIconClicked$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit handleGenerateTests$lambda$3(CockpitInlineQuickCommandRender this$0, String newFile) {
        Intrinsics.checkNotNullParameter((Object)newFile, (String)"newFile");
        boolean fileExists = CockpitInlineQuickCommandRenderKt.fileExists(newFile);
        Editor newEditor = null;
        if (!fileExists) {
            newEditor = CockpitInlineQuickCommandRenderKt.createNewFileEditor(this$0.project, newFile);
            if (newEditor != null) {
                EditStreamHandler diffStreamHandler = this$0.generateDiffStreamHandler(newEditor, 0);
                Object $this$service$iv = (ComponentManager)this$0.project;
                boolean $i$f$service22 = false;
                Class<EditInlineStreamService> serviceClass$iv = EditInlineStreamService.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                ((EditInlineStreamService)object).register(diffStreamHandler, newEditor);
                $this$service$iv = I18nKt.getInlinePrompt("prompt.generate.test");
                Object[] $i$f$service22 = new Object[]{this$0.filePath, this$0.language, this$0.selectedText};
                String string = String.format((String)$this$service$iv, Arrays.copyOf($i$f$service22, $i$f$service22.length));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
                diffStreamHandler.streamDiffLinesToEditor(string, false, true, true);
            }
        } else {
            newEditor = CockpitInlineQuickCommandRenderKt.createTemporaryVirtualFileAndOpen$default(this$0.project, newFile, null, 4, null);
            if (newEditor != null) {
                EditStreamHandler diffStreamHandler = this$0.generateNewFileDiffStreamHandler(newEditor, 0, newFile);
                ComponentManager $this$service$iv = (ComponentManager)this$0.project;
                boolean $i$f$service = false;
                Class<EditInlineStreamService> serviceClass$iv = EditInlineStreamService.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                ((EditInlineStreamService)object).register(diffStreamHandler, newEditor);
                String string = I18nKt.getInlinePrompt("prompt.generate.test");
                Object[] objectArray = new Object[]{this$0.filePath, this$0.language, this$0.selectedText};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                diffStreamHandler.streamDiffLinesToEditor(string2, false, true, true);
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit generateNewFileDiffStreamHandler$lambda$4(LensesService $lensesService, Editor $targetEditor) {
        $lensesService.clearLenses($targetEditor);
        return Unit.INSTANCE;
    }

    private static final Unit generateNewFileDiffStreamHandler$lambda$5(CockpitInlineQuickCommandRender this$0, Integer $targetStartLine, Editor $targetEditor, LensesService $lensesService) {
        VirtualFile virtualFile;
        Range r = new Range(this$0.range.getStart(), this$0.range.getEnd());
        Integer n = $targetStartLine;
        if (n != null && n == 0) {
            r.setStart(0);
            r.setEnd(0);
        }
        if ((virtualFile = FileDocumentManager.getInstance().getFile($targetEditor.getDocument())) != null) {
            String string = virtualFile.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
            $lensesService.updateLenses($targetEditor, string, virtualFile, $lensesService.generateInlineEditStartLense(r, this$0.taskId));
        }
        return Unit.INSTANCE;
    }

    private static final Unit generateNewFileDiffStreamHandler$lambda$6() {
        return Unit.INSTANCE;
    }

    private static final Unit generateNewFileDiffStreamHandler$lambda$7(Editor $newEditor, CockpitInlineQuickCommandRender this$0, String $oldFilePath) {
        try {
            DiffStreamUtilsKt.generateTestDiffFile($newEditor, this$0.project, $oldFilePath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Unit.INSTANCE;
    }

    private static final Unit generateDiffStreamHandler$lambda$8(LensesService $lensesService, Editor $targetEditor) {
        $lensesService.clearLenses($targetEditor);
        return Unit.INSTANCE;
    }

    private static final Unit generateDiffStreamHandler$lambda$9(CockpitInlineQuickCommandRender this$0, Integer $targetStartLine, Editor $targetEditor, LensesService $lensesService) {
        VirtualFile virtualFile;
        Range r = new Range(this$0.range.getStart(), this$0.range.getEnd());
        Integer n = $targetStartLine;
        if (n != null && n == 0) {
            r.setStart(0);
            r.setEnd(0);
        }
        if ((virtualFile = FileDocumentManager.getInstance().getFile($targetEditor.getDocument())) != null) {
            String string = virtualFile.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
            $lensesService.updateLenses($targetEditor, string, virtualFile, $lensesService.generateInlineEditStartLense(r, this$0.taskId));
        }
        return Unit.INSTANCE;
    }

    private static final Unit generateDiffStreamHandler$lambda$10() {
        return Unit.INSTANCE;
    }

    private static final Unit generateDiffStreamHandler$lambda$11(CockpitInlineQuickCommandRender this$0, Integer $targetStartLine, Editor $targetEditor, LensesService $lensesService) {
        VirtualFile virtualFile;
        Range r = new Range(this$0.range.getStart(), this$0.range.getEnd());
        Integer n = $targetStartLine;
        if (n != null && n == 0) {
            r.setStart(0);
            r.setEnd(0);
        }
        if ((virtualFile = FileDocumentManager.getInstance().getFile($targetEditor.getDocument())) != null) {
            String string = virtualFile.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
            $lensesService.updateLenses($targetEditor, string, virtualFile, $lensesService.generateInlineEditEndLense(r, this$0.taskId));
        }
        return Unit.INSTANCE;
    }
}

