/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.composer.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0018\u0019B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JB\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00070\u00060\u0005\"\u0004\b\u0000\u0010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\u00052\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u00020\n0\fJ\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\nH\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001c\u0010\u0015\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\n2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0005\u00a8\u0006\u001a"}, d2={"Lcn/gitlab/kilo/jetbrains/composer/util/FuzzySearchUtil;", "", "<init>", "()V", "search", "", "Lcn/gitlab/kilo/jetbrains/composer/util/FuzzySearchUtil$FuzzyMatch;", "T", "items", "query", "", "selector", "Lkotlin/Function1;", "fuzzyMatch", "Lcn/gitlab/kilo/jetbrains/composer/util/FuzzySearchUtil$MatchResult;", "text", "pattern", "isSeparator", "", "char", "", "highlightMatches", "positions", "", "FuzzyMatch", "MatchResult", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nFuzzySearchUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FuzzySearchUtil.kt\ncn/gitlab/kilo/jetbrains/composer/util/FuzzySearchUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,152:1\n1068#2:153\n*S KotlinDebug\n*F\n+ 1 FuzzySearchUtil.kt\ncn/gitlab/kilo/jetbrains/composer/util/FuzzySearchUtil\n*L\n40#1:153\n*E\n"})
public final class FuzzySearchUtil {
    @NotNull
    public static final FuzzySearchUtil INSTANCE = new FuzzySearchUtil();

    private FuzzySearchUtil() {
    }

    @NotNull
    public final <T> List<FuzzyMatch<T>> search(@NotNull List<? extends T> items, @NotNull String query, @NotNull Function1<? super T, String> selector) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(selector, (String)"selector");
        if (StringsKt.isBlank((CharSequence)query)) {
            return CollectionsKt.emptyList();
        }
        String string = query.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String normalizedQuery = string;
        List results = new ArrayList();
        for (T item : items) {
            String text;
            Intrinsics.checkNotNullExpressionValue((Object)((String)selector.invoke(item)).toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
            MatchResult match = this.fuzzyMatch(text, normalizedQuery);
            if (match == null) continue;
            results.add(new FuzzyMatch<T>(item, match.getScore(), match.getPositions()));
        }
        Iterable $this$sortedByDescending$iv = results;
        boolean $i$f$sortedByDescending = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                FuzzyMatch it = (FuzzyMatch)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getScore());
                it = (FuzzyMatch)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getScore()));
            }
        });
    }

    private final MatchResult fuzzyMatch(String text, String pattern) {
        if (((CharSequence)pattern).length() == 0) {
            return null;
        }
        if (((CharSequence)text).length() == 0) {
            return null;
        }
        int patternIndex = 0;
        List positions = new ArrayList();
        int score = 0;
        int consecutiveMatches = 0;
        int lastMatchIndex = -1;
        for (int textIndex = 0; textIndex < text.length() && patternIndex < pattern.length(); ++textIndex) {
            char patternChar;
            char textChar = text.charAt(textIndex);
            if (textChar != (patternChar = pattern.charAt(patternIndex))) continue;
            positions.add(textIndex);
            ++patternIndex;
            ++score;
            if (textIndex == lastMatchIndex + 1) {
                score += 5 * ++consecutiveMatches;
            } else {
                consecutiveMatches = 0;
            }
            if (textIndex == 0) {
                score += 10;
            } else if (textIndex > 0 && this.isSeparator(text.charAt(textIndex - 1))) {
                score += 8;
            }
            lastMatchIndex = textIndex;
        }
        if (patternIndex != pattern.length()) {
            return null;
        }
        return new MatchResult(score += RangesKt.coerceAtLeast((int)(100 - text.length()), (int)0), positions);
    }

    private final boolean isSeparator(char c) {
        return StringsKt.contains$default((CharSequence)" _-/\\.", (char)c, (boolean)false, (int)2, null);
    }

    @NotNull
    public final String highlightMatches(@NotNull String text, @NotNull List<Integer> positions) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(positions, (String)"positions");
        if (positions.isEmpty()) {
            return text;
        }
        StringBuilder result2 = new StringBuilder();
        int lastIndex = 0;
        Iterator iterator = CollectionsKt.sorted((Iterable)positions).iterator();
        while (iterator.hasNext()) {
            int pos = ((Number)iterator.next()).intValue();
            if (pos >= text.length()) continue;
            if (pos > lastIndex) {
                String string = text.substring(lastIndex, pos);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                result2.append(string);
            }
            result2.append("<mark>");
            result2.append(text.charAt(pos));
            result2.append("</mark>");
            lastIndex = pos + 1;
        }
        if (lastIndex < text.length()) {
            String string = text.substring(lastIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            result2.append(string);
        }
        String string = result2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0011\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007H\u00c6\u0003J8\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0015J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lcn/gitlab/kilo/jetbrains/composer/util/FuzzySearchUtil$FuzzyMatch;", "T", "", "item", "score", "", "positions", "", "<init>", "(Ljava/lang/Object;ILjava/util/List;)V", "getItem", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getScore", "()I", "getPositions", "()Ljava/util/List;", "component1", "component2", "component3", "copy", "(Ljava/lang/Object;ILjava/util/List;)Lcn/gitlab/kilo/jetbrains/composer/util/FuzzySearchUtil$FuzzyMatch;", "equals", "", "other", "hashCode", "toString", "", "coderider-kilo-jetbrains"})
    public static final class FuzzyMatch<T> {
        private final T item;
        private final int score;
        @NotNull
        private final List<Integer> positions;

        public FuzzyMatch(T item, int score, @NotNull List<Integer> positions) {
            Intrinsics.checkNotNullParameter(positions, (String)"positions");
            this.item = item;
            this.score = score;
            this.positions = positions;
        }

        public final T getItem() {
            return this.item;
        }

        public final int getScore() {
            return this.score;
        }

        @NotNull
        public final List<Integer> getPositions() {
            return this.positions;
        }

        public final T component1() {
            return this.item;
        }

        public final int component2() {
            return this.score;
        }

        @NotNull
        public final List<Integer> component3() {
            return this.positions;
        }

        @NotNull
        public final FuzzyMatch<T> copy(T item, int score, @NotNull List<Integer> positions) {
            Intrinsics.checkNotNullParameter(positions, (String)"positions");
            return new FuzzyMatch<T>(item, score, positions);
        }

        public static /* synthetic */ FuzzyMatch copy$default(FuzzyMatch fuzzyMatch, Object object, int n, List list, int n2, Object object2) {
            if ((n2 & 1) != 0) {
                object = fuzzyMatch.item;
            }
            if ((n2 & 2) != 0) {
                n = fuzzyMatch.score;
            }
            if ((n2 & 4) != 0) {
                list = fuzzyMatch.positions;
            }
            return fuzzyMatch.copy(object, n, list);
        }

        @NotNull
        public String toString() {
            return "FuzzyMatch(item=" + this.item + ", score=" + this.score + ", positions=" + this.positions + ")";
        }

        public int hashCode() {
            int result2 = this.item == null ? 0 : this.item.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.score);
            result2 = result2 * 31 + ((Object)this.positions).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FuzzyMatch)) {
                return false;
            }
            FuzzyMatch fuzzyMatch = (FuzzyMatch)other;
            if (!Intrinsics.areEqual(this.item, fuzzyMatch.item)) {
                return false;
            }
            if (this.score != fuzzyMatch.score) {
                return false;
            }
            return Intrinsics.areEqual(this.positions, fuzzyMatch.positions);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcn/gitlab/kilo/jetbrains/composer/util/FuzzySearchUtil$MatchResult;", "", "score", "", "positions", "", "<init>", "(ILjava/util/List;)V", "getScore", "()I", "getPositions", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "coderider-kilo-jetbrains"})
    private static final class MatchResult {
        private final int score;
        @NotNull
        private final List<Integer> positions;

        public MatchResult(int score, @NotNull List<Integer> positions) {
            Intrinsics.checkNotNullParameter(positions, (String)"positions");
            this.score = score;
            this.positions = positions;
        }

        public final int getScore() {
            return this.score;
        }

        @NotNull
        public final List<Integer> getPositions() {
            return this.positions;
        }

        public final int component1() {
            return this.score;
        }

        @NotNull
        public final List<Integer> component2() {
            return this.positions;
        }

        @NotNull
        public final MatchResult copy(int score, @NotNull List<Integer> positions) {
            Intrinsics.checkNotNullParameter(positions, (String)"positions");
            return new MatchResult(score, positions);
        }

        public static /* synthetic */ MatchResult copy$default(MatchResult matchResult, int n, List list, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = matchResult.score;
            }
            if ((n2 & 2) != 0) {
                list = matchResult.positions;
            }
            return matchResult.copy(n, list);
        }

        @NotNull
        public String toString() {
            return "MatchResult(score=" + this.score + ", positions=" + this.positions + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.score);
            result2 = result2 * 31 + ((Object)this.positions).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MatchResult)) {
                return false;
            }
            MatchResult matchResult = (MatchResult)other;
            if (this.score != matchResult.score) {
                return false;
            }
            return Intrinsics.areEqual(this.positions, matchResult.positions);
        }
    }
}

