/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.composer.util;

import cn.gitlab.kilo.jetbrains.common.Logger;
import cn.gitlab.kilo.jetbrains.composer.ClineIgnoreController;
import cn.gitlab.kilo.jetbrains.composer.service.diff.DiffVirtualFile;
import cn.gitlab.kilo.jetbrains.composer.util.FileNode;
import cn.gitlab.kilo.jetbrains.composer.util.SearchResult;
import cn.gitlab.kilo.jetbrains.composer.util.StopSearch;
import cn.gitlab.kilo.jetbrains.editor.MyVirtualFile;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.MalformedInputException;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000|\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a.\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\u0014\b\u0002\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\r\u001a8\u0010\u0006\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\u000e\u001a\u00020\u000b2\b\b\u0002\u0010\u000f\u001a\u00020\u000b2\u0014\b\u0002\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\r\u001aL\u0010\u0010\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\u0011\u001a\u00020\u00032\b\b\u0002\u0010\u000e\u001a\u00020\u000b2\b\b\u0002\u0010\u0012\u001a\u00020\u00012\b\b\u0002\u0010\u0013\u001a\u00020\u00012\u0014\b\u0002\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\r\u001a\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u00152\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u00152\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u00152\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0003\u001a\u0016\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0003\u001a0\u0010\u001b\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0015\u0012\u0004\u0012\u00020\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u001f\u001a\u00020\u000b\u001a0\u0010 \u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00030\u00152\u0006\u0010\"\u001a\u00020\u00012\n\b\u0002\u0010#\u001a\u0004\u0018\u00010$\u001a\f\u0010'\u001a\u00020\u0003*\u00020(H\u0002\u001a\u0018\u0010)\u001a\u00020(2\u0006\u0010*\u001a\u00020(2\u0006\u0010+\u001a\u00020(H\u0002\u001a\u0018\u0010,\u001a\u00020\u00012\u0006\u0010-\u001a\u00020(2\u0006\u0010.\u001a\u00020(H\u0002\u001a\f\u0010/\u001a\u00020\u0001*\u00020(H\u0002\u001a\u001e\u00102\u001a\u00020\u00032\f\u00103\u001a\b\u0012\u0004\u0012\u0002040\u00152\u0006\u00105\u001a\u00020(H\u0002\u001aT\u00106\u001a\u00020\u00032\u0006\u00105\u001a\u00020(2\u0006\u00107\u001a\u00020(2\u0006\u00108\u001a\u00020\u00032\n\b\u0002\u00109\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010#\u001a\u0004\u0018\u00010$2\b\b\u0002\u0010:\u001a\u00020\u000b2\b\b\u0002\u0010;\u001a\u00020<2\b\b\u0002\u0010=\u001a\u00020\u0001\u001a\u0018\u0010>\u001a\u00020\u00012\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020(H\u0002\u001a\u0012\u0010B\u001a\u0004\u0018\u00010C2\u0006\u0010?\u001a\u00020@H\u0002\u001a\u000e\u0010D\u001a\u0004\u0018\u00010\u0003*\u00020EH\u0002\u001a&\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00030\u00152\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010G\u001a\u00020\u00032\b\b\u0002\u0010:\u001a\u00020\u000b\"\u000e\u0010%\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010&\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u00100\u001a\b\u0012\u0004\u0012\u00020\u000301X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"isPathOutsideWorkspace", "", "absolutePath", "", "project", "Lcom/intellij/openapi/project/Project;", "getDirTreeBFS", "Lcn/gitlab/kilo/jetbrains/composer/util/FileNode;", "root", "Ljava/io/File;", "maxChars", "", "filter", "Lkotlin/Function1;", "maxDepth", "maxNodes", "getDirTreeDFS", "prefix", "isLast", "isRoot", "getVisibleFilePaths", "", "getOpenTabs", "getFilePaths", "rootPath", "getFileOrFolderContent", "mentionPath", "listFiles", "Lkotlin/Pair;", "dirPath", "recursive", "limit", "formatFilesList", "files", "didHitLimit", "clineIgnoreController", "Lcn/gitlab/kilo/jetbrains/composer/ClineIgnoreController;", "MAX_RESULTS", "IS_WINDOWS", "posixString", "Ljava/nio/file/Path;", "safeRelativize", "base", "other", "equalPaths", "a", "b", "isFsRoot", "SYSTEM_DIRS", "", "formatResults", "results", "Lcn/gitlab/kilo/jetbrains/composer/util/SearchResult;", "cwd", "regexSearchFiles", "directoryPath", "regex", "filePattern", "maxResults", "maxFileSizeBytes", "", "caseInsensitiveOnWindows", "looksBinary", "head", "", "path", "sniffCharset", "Ljava/nio/charset/Charset;", "markThenReadNextLine", "Ljava/io/BufferedReader;", "searchFiles", "query", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nFileUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileUtils.kt\ncn/gitlab/kilo/jetbrains/composer/util/FileUtilsKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 7 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 8 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,750:1\n3829#2:751\n4344#2,2:752\n3829#2:757\n4344#2,2:758\n3829#2:762\n4344#2,2:763\n11228#2:770\n11563#2,3:771\n3829#2:774\n4344#2,2:775\n13537#2,3:793\n6482#2:796\n6482#2:797\n12647#2,2:827\n1878#3,3:754\n1869#3,2:760\n1878#3,3:765\n1563#3:777\n1634#3,3:778\n774#3:781\n865#3,2:782\n1563#3:784\n1634#3,3:785\n1563#3:798\n1634#3,3:799\n1563#3:802\n1634#3,3:803\n1491#3:806\n1516#3,3:807\n1519#3,3:817\n1878#3,2:821\n1869#3,2:823\n1880#3:825\n1869#3,2:832\n1869#3,2:836\n31#4,2:768\n31#4,2:788\n31#4,2:791\n31#4,2:834\n1#5:790\n382#6,7:810\n216#7:820\n217#7:826\n1104#8,3:829\n*S KotlinDebug\n*F\n+ 1 FileUtils.kt\ncn/gitlab/kilo/jetbrains/composer/util/FileUtilsKt\n*L\n109#1:751\n109#1:752,2\n142#1:757\n142#1:758,2\n173#1:762\n173#1:763,2\n195#1:770\n195#1:771,3\n201#1:774\n201#1:775,2\n262#1:793,3\n342#1:796\n356#1:797\n649#1:827,2\n111#1:754,3\n143#1:760,2\n174#1:765,3\n202#1:777\n202#1:778,3\n203#1:781\n203#1:782,2\n204#1:784\n204#1:785,3\n383#1:798\n383#1:799,3\n404#1:802\n404#1:803,3\n476#1:806\n476#1:807,3\n476#1:817,3\n480#1:821,2\n486#1:823,2\n480#1:825\n741#1:832,2\n734#1:836,2\n192#1:768,2\n211#1:788,2\n246#1:791,2\n693#1:834,2\n476#1:810,7\n478#1:820\n478#1:826\n609#1:829,3\n*E\n"})
public final class FileUtilsKt {
    private static final int MAX_RESULTS = 300;
    private static final boolean IS_WINDOWS;
    @NotNull
    private static final Set<String> SYSTEM_DIRS;

    public static final boolean isPathOutsideWorkspace(@NotNull String absolutePath, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)absolutePath, (String)"absolutePath");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = project.getBasePath();
        if (string == null) {
            return true;
        }
        String basePath = string;
        Path baseNormalized = Paths.get(basePath, new String[0]).toAbsolutePath().normalize();
        Path fileNormalized = Paths.get(absolutePath, new String[0]).toAbsolutePath().normalize();
        String baseStr = ((Object)baseNormalized).toString();
        String fileStr = ((Object)fileNormalized).toString();
        return !Intrinsics.areEqual((Object)fileStr, (Object)baseStr) && !StringsKt.startsWith$default((String)fileStr, (String)(baseStr + File.separator), (boolean)false, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FileNode getDirTreeBFS(@NotNull File root, int maxChars, @NotNull Function1<? super File, Boolean> filter2) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(filter2, (String)"filter");
        int extraDirLen = 3;
        int extraFileLen = 1;
        int placeholderLen = 3;
        Queue queue = new LinkedList();
        FileNode rootNode = new FileNode(root, 0, null, null, false, 30, null);
        queue.offer(rootNode);
        int remainingChars = 0;
        remainingChars = maxChars - root.getName().length() - (root.isDirectory() ? extraDirLen + placeholderLen : extraFileLen);
        while (!((Collection)queue).isEmpty() && remainingChars > 0) {
            List list;
            FileNode current = (FileNode)queue.poll();
            if (!current.getFile().isDirectory()) continue;
            if (current.getFile().listFiles() != null) {
                void $this$filterTo$iv$iv;
                File[] $this$filter$iv;
                boolean $i$f$filter = false;
                File[] fileArray = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (void element$iv$iv : $this$filterTo$iv$iv) {
                    if (!((Boolean)filter2.invoke((Object)element$iv$iv)).booleanValue()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list = (List)destination$iv$iv;
            } else {
                list = CollectionsKt.emptyList();
            }
            List children = list;
            int cnt = 0;
            cnt = children.size();
            Iterable $this$forEachIndexed$iv = children;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                int extra;
                void file;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                File file2 = (File)item$iv;
                int i = n;
                boolean bl = false;
                int n2 = file.isDirectory() ? extraDirLen + (i < CollectionsKt.getLastIndex((List)children) ? placeholderLen : 0) : (extra = extraFileLen);
                if ((remainingChars -= file.getName().length() + extra) <= 0) continue;
                Intrinsics.checkNotNull((Object)file);
                Intrinsics.checkNotNull((Object)current);
                queue.add(new FileNode((File)file, current));
                cnt += -1;
            }
            if (cnt != 0) continue;
            current.setAllChildrenIncluded(true);
        }
        return rootNode;
    }

    public static /* synthetic */ FileNode getDirTreeBFS$default(File file, int n, Function1 function1, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = Integer.MAX_VALUE;
        }
        if ((n2 & 4) != 0) {
            function1 = FileUtilsKt::getDirTreeBFS$lambda$0;
        }
        return FileUtilsKt.getDirTreeBFS(file, n, (Function1<? super File, Boolean>)function1);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String getDirTreeBFS(@NotNull File root, int maxDepth, int maxNodes, @NotNull Function1<? super File, Boolean> filter2) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(filter2, (String)"filter");
        Queue queue = new LinkedList();
        FileNode rootNode = new FileNode(root, 0, null, null, false, 30, null);
        queue.add(rootNode);
        int remainingNodes = maxNodes;
        while (!((Collection)queue).isEmpty() && remainingNodes > 0) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            File[] fileArray;
            FileNode current = (FileNode)queue.poll();
            --remainingNodes;
            Object object = current.getParent();
            if (object != null && (object = ((FileNode)object).getChildren()) != null) {
                Intrinsics.checkNotNull((Object)current);
                object.add(current);
            }
            if (!current.getFile().isDirectory() || current.getDepth() >= maxDepth || (fileArray = current.getFile().listFiles()) == null) continue;
            File[] fileArray2 = fileArray;
            boolean $i$f$filter = false;
            Iterator iterator = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                if (!((Boolean)filter2.invoke((Object)element$iv$iv)).booleanValue()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File child = (File)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)child);
                queue.add(new FileNode(child, current.getDepth() + 1, null, current, false, 20, null));
            }
        }
        return FileNode.fmt$default(rootNode, null, false, false, 7, null);
    }

    public static /* synthetic */ String getDirTreeBFS$default(File file, int n, int n2, Function1 function1, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = Integer.MAX_VALUE;
        }
        if ((n3 & 4) != 0) {
            n2 = Integer.MAX_VALUE;
        }
        if ((n3 & 8) != 0) {
            function1 = FileUtilsKt::getDirTreeBFS$lambda$2;
        }
        return FileUtilsKt.getDirTreeBFS(file, n, n2, (Function1<? super File, Boolean>)function1);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String getDirTreeDFS(@NotNull File root, @NotNull String prefix, int maxDepth, boolean isLast, boolean isRoot, @NotNull Function1<? super File, Boolean> filter2) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter(filter2, (String)"filter");
        StringBuilder builder2 = new StringBuilder();
        if (!isRoot) {
            builder2.append(prefix + (isLast ? "\u2514\u2500\u2500 " : "\u251c\u2500\u2500 "));
        }
        builder2.append(root.getName() + (root.isDirectory() ? "/" : "")).append('\n');
        if (root.isDirectory() && maxDepth > 0) {
            List list;
            String newPrefix = isRoot ? prefix : prefix + (isLast ? "    " : "\u2502   ");
            File[] fileArray = root.listFiles();
            if (fileArray != null) {
                void $this$filterTo$iv$iv;
                File[] $this$filter$iv = fileArray;
                boolean $i$f$filter = false;
                File[] fileArray2 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (void element$iv$iv : $this$filterTo$iv$iv) {
                    if (!((Boolean)filter2.invoke((Object)element$iv$iv)).booleanValue()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list = (List)destination$iv$iv;
            } else {
                list = CollectionsKt.emptyList();
            }
            List children = list;
            Iterable $this$forEachIndexed$iv = children;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void file;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                File $i$f$filterTo = (File)item$iv;
                int i = n;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)file);
                builder2.append(FileUtilsKt.getDirTreeDFS((File)file, newPrefix, maxDepth - 1, i == children.size() - 1, false, filter2));
            }
        }
        String string = builder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static /* synthetic */ String getDirTreeDFS$default(File file, String string, int n, boolean bl, boolean bl2, Function1 function1, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string = "";
        }
        if ((n2 & 4) != 0) {
            n = Integer.MAX_VALUE;
        }
        if ((n2 & 8) != 0) {
            bl = true;
        }
        if ((n2 & 0x10) != 0) {
            bl2 = true;
        }
        if ((n2 & 0x20) != 0) {
            function1 = FileUtilsKt::getDirTreeDFS$lambda$4;
        }
        return FileUtilsKt.getDirTreeDFS(file, string, n, bl, bl2, (Function1<? super File, Boolean>)function1);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> getVisibleFilePaths(@NotNull Project project) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        VirtualFile[] openFiles;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        VirtualFile[] serviceClass$iv = ClineIgnoreController.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ClineIgnoreController ignoreController = (ClineIgnoreController)object;
        FileEditorManager editorManager = FileEditorManager.getInstance((Project)project);
        VirtualFile[] virtualFileArray = editorManager.getSelectedFiles();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getSelectedFiles(...)");
        serviceClass$iv = openFiles = virtualFileArray;
        ClineIgnoreController clineIgnoreController = ignoreController;
        boolean $i$f$map = false;
        void var6_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var12_14 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            collection.add(string);
        }
        return clineIgnoreController.filterPaths((List)destination$iv$iv);
    }

    @NotNull
    public static final List<String> getOpenTabs(@NotNull Project project) {
        List list;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        try {
            String it;
            Collection collection;
            Object $this$mapTo$iv$iv;
            Iterable $this$filterTo$iv$iv;
            FileEditorManager editorManager = FileEditorManager.getInstance((Project)project);
            VirtualFile[] virtualFileArray = editorManager.getOpenFiles();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getOpenFiles(...)");
            Object $this$filter$iv = virtualFileArray;
            boolean $i$f$filter = false;
            Object[] objectArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (VirtualFile element$iv$iv : $this$filterTo$iv$iv) {
                VirtualFile it2 = element$iv$iv;
                boolean bl = false;
                if (!(!(it2 instanceof DiffVirtualFile) && !(it2 instanceof MyVirtualFile))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                VirtualFile element$iv$iv;
                Object item$iv$iv = iterator.next();
                element$iv$iv = (VirtualFile)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getPath());
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                boolean bl2 = !StringsKt.isBlank((CharSequence)it);
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object item$iv$iv = iterator.next();
                it = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((Object)Paths.get(it, new String[0]).toAbsolutePath()).toString());
            }
            list = (List)destination$iv$iv;
        }
        catch (Exception e) {
            Logger.Companion.getInstance("composer").error("Error getting open tabs", e);
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final List<String> getFilePaths(@NotNull Project project, @NotNull String rootPath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)rootPath, (String)"rootPath");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<ClineIgnoreController> serviceClass$iv = ClineIgnoreController.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ClineIgnoreController ignoreController = (ClineIgnoreController)object;
        Path root = Paths.get(rootPath, new String[0]).toAbsolutePath().normalize();
        List paths = new ArrayList();
        int maxResults = 300;
        try {
            LinkedList<Path> linkedList;
            LinkedList<Path> $this$getFilePaths_u24lambda_u2411 = linkedList = new LinkedList<Path>();
            boolean bl = false;
            $this$getFilePaths_u24lambda_u2411.add(root);
            Queue queue = linkedList;
            while (!((Collection)queue).isEmpty() && paths.size() < maxResults) {
                Path currentPath = (Path)queue.poll();
                if (!Files.isDirectory(currentPath, new LinkOption[0])) continue;
                AutoCloseable autoCloseable = Files.list(currentPath);
                Throwable throwable = null;
                try {
                    Stream dirContents = (Stream)autoCloseable;
                    boolean bl2 = false;
                    Iterator iterator = dirContents.iterator();
                    while (iterator.hasNext()) {
                        Path path = (Path)iterator.next();
                        Intrinsics.checkNotNull((Object)path);
                        if (!ignoreController.validateAccess(path)) continue;
                        if (paths.size() >= maxResults) break;
                        Intrinsics.checkNotNull((Object)root);
                        String relativePath = FileUtilsKt.posixString(FileUtilsKt.safeRelativize(root, path));
                        if (!(!StringsKt.isBlank((CharSequence)relativePath))) continue;
                        Object finalPath = Files.isDirectory(path, new LinkOption[0]) ? relativePath + "/" : relativePath;
                        paths.add(finalPath);
                        if (!Files.isDirectory(path, new LinkOption[0])) continue;
                        queue.add(path);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return paths;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String getFileOrFolderContent(@NotNull Project project, @NotNull String mentionPath) {
        String string;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)mentionPath, (String)"mentionPath");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Object serviceClass$iv = ClineIgnoreController.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ClineIgnoreController ignoreController = (ClineIgnoreController)object;
        String string2 = project.getBasePath();
        if (string2 == null) {
            string2 = "";
        }
        Path absPath = Paths.get(string2, new String[0]).resolve(mentionPath).normalize();
        File file = absPath.toFile();
        try {
            Object object2;
            if (file.isFile()) {
                Path path = file.toPath();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
                if (!ignoreController.validateAccess(path)) {
                    object2 = "(Binary file, unable to display content)";
                } else {
                    serviceClass$iv = FileUtil.loadFile((File)file);
                    Intrinsics.checkNotNull((Object)serviceClass$iv);
                    object2 = serviceClass$iv;
                }
            } else if (file.isDirectory()) {
                Object[] entries = file.listFiles();
                StringBuilder folderContent = new StringBuilder();
                StringBuilder fileContent = new StringBuilder();
                if (entries != null) {
                    Object[] $this$forEachIndexed$iv = entries;
                    boolean $i$f$forEachIndexed = false;
                    int index$iv = 0;
                    for (File file2 : $this$forEachIndexed$iv) {
                        StringBuilder stringBuilder;
                        void entry;
                        int n = index$iv++;
                        File file22 = file2;
                        int index = n;
                        boolean bl = false;
                        boolean isLast = index == ArraysKt.getLastIndex((Object[])entries);
                        String linePrefix = isLast ? "\u2514\u2500\u2500 " : "\u251c\u2500\u2500 ";
                        if (entry.isFile()) {
                            StringBuilder stringBuilder2;
                            folderContent.append(linePrefix + entry.getName() + "\n");
                            StringBuilder stringBuilder3 = stringBuilder2 = new StringBuilder();
                            StringBuilder stringBuilder4 = fileContent;
                            boolean bl2 = false;
                            Path path = file.toPath();
                            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
                            Path path2 = entry.toPath();
                            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toPath(...)");
                            String relativePath = FileUtilsKt.posixString(FileUtilsKt.safeRelativize(path, path2));
                            try {
                                Path path3 = entry.toPath();
                                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"toPath(...)");
                                if (ignoreController.validateAccess(path3)) {
                                    String content2;
                                    void $this$getFileOrFolderContent_u24lambda_u2414_u24lambda_u2413;
                                    Intrinsics.checkNotNullExpressionValue((Object)FileUtil.loadFile((File)entry), (String)"loadFile(...)");
                                    $this$getFileOrFolderContent_u24lambda_u2414_u24lambda_u2413.append("<file_content path=\"" + relativePath + "\">").append('\n');
                                    $this$getFileOrFolderContent_u24lambda_u2414_u24lambda_u2413.append(content2).append('\n');
                                    $this$getFileOrFolderContent_u24lambda_u2414_u24lambda_u2413.append("</file_content>");
                                }
                            }
                            catch (Exception e) {
                                Logger.warn$default(Logger.Companion.getInstance("composer"), "Failed to read file " + relativePath + ": " + e.getMessage(), null, 2, null);
                            }
                            stringBuilder = stringBuilder4.append(stringBuilder2.toString()).append("\n\n");
                            continue;
                        }
                        stringBuilder = entry.isDirectory() ? folderContent.append(linePrefix + entry.getName() + "/\n") : folderContent.append(linePrefix + entry.getName() + "\n");
                    }
                }
                object2 = ((Object)StringsKt.trim((CharSequence)(folderContent + "\n" + fileContent))).toString();
            } else {
                object2 = "(Failed to read contents of " + mentionPath + ")";
            }
            string = object2;
        }
        catch (Exception error2) {
            throw new Exception("Failed to access path \"" + mentionPath + "\": " + error2.getMessage());
        }
        return string;
    }

    @NotNull
    public static final Pair<List<String>, Boolean> listFiles(@NotNull String dirPath, boolean recursive, int limit) {
        LinkedList<File> linkedList2;
        LinkedHashSet<String> results;
        Object dirsToIgnore;
        Path absPath;
        block14: {
            Object object;
            block16: {
                block15: {
                    Intrinsics.checkNotNullParameter((Object)dirPath, (String)"dirPath");
                    File file = new File(dirPath).getAbsoluteFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAbsoluteFile(...)");
                    absPath = FilesKt.normalize((File)file).toPath();
                    Path userHomePath = Paths.get(System.getProperty("user.home"), new String[0]).toAbsolutePath().normalize();
                    Intrinsics.checkNotNull((Object)absPath);
                    if (FileUtilsKt.isFsRoot(absPath)) {
                        return TuplesKt.to((Object)CollectionsKt.listOf((Object)FileUtilsKt.posixString(absPath)), (Object)false);
                    }
                    Intrinsics.checkNotNull((Object)userHomePath);
                    if (FileUtilsKt.equalPaths(absPath, userHomePath)) {
                        return TuplesKt.to((Object)CollectionsKt.listOf((Object)FileUtilsKt.posixString(userHomePath)), (Object)false);
                    }
                    Object object2 = new String[]{"node_modules", "__pycache__", "env", "venv", "target/dependency", "build/dependencies", "dist", "out", "bundle", "vendor", "tmp", "temp", "deps", "pkg", "Pods"};
                    Object $this$listFiles_u24lambda_u2415 = object2 = SetsKt.hashSetOf((Object[])object2);
                    boolean linkedList2 = false;
                    if (IS_WINDOWS) {
                        ((AbstractCollection)$this$listFiles_u24lambda_u2415).addAll((Collection)SYSTEM_DIRS);
                    }
                    dirsToIgnore = object2;
                    results = new LinkedHashSet<String>();
                    if (recursive) break block14;
                    object = absPath.toFile().listFiles();
                    if (object == null) break block15;
                    Object[] $this$sortedBy$iv = object;
                    boolean $i$f$sortedBy = false;
                    object = ArraysKt.sortedWith((Object[])$this$sortedBy$iv, (Comparator)new Comparator(){

                        public final int compare(T a, T b) {
                            File it = (File)a;
                            boolean bl = false;
                            String string = it.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                            String string2 = string.toLowerCase(Locale.ROOT);
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                            it = (File)b;
                            Comparable comparable = (Comparable)((Object)string2);
                            bl = false;
                            String string3 = it.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
                            String string4 = string3.toLowerCase(Locale.ROOT);
                            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
                            return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string4)));
                        }
                    });
                    if (object != null) break block16;
                }
                object = CollectionsKt.emptyList();
            }
            Object files = object;
            Iterator linkedList2 = files.iterator();
            while (linkedList2.hasNext()) {
                Object object3;
                File file = (File)linkedList2.next();
                Path path = file.toPath();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
                String relPath = FileUtilsKt.posixString(FileUtilsKt.safeRelativize(absPath, path));
                if (file.isDirectory()) {
                    char[] cArray = new char[]{'/'};
                    object3 = StringsKt.trimEnd((String)relPath, (char[])cArray) + "/";
                } else {
                    object3 = relPath;
                }
                String mark = object3;
                String abs = StringsKt.replace$default((String)((Object)absPath.resolve(mark).normalize()).toString(), (char)'\\', (char)'/', (boolean)false, (int)4, null);
                results.add(abs);
                if (results.size() < limit) continue;
            }
            return TuplesKt.to((Object)CollectionsKt.toList((Iterable)results), (Object)(results.size() >= limit ? 1 : 0));
        }
        LinkedList<File> $this$listFiles_u24lambda_u2417 = linkedList2 = new LinkedList<File>();
        boolean bl = false;
        $this$listFiles_u24lambda_u2417.add(absPath.toFile());
        Queue queue = linkedList2;
        block1: while (!((Collection)queue).isEmpty() && results.size() < limit) {
            File currentDir = (File)queue.poll();
            Object object = currentDir.listFiles();
            if (object == null) continue;
            Object[] $this$sortedBy$iv = object;
            boolean $i$f$sortedBy = false;
            object = ArraysKt.sortedWith((Object[])$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    File it = (File)a;
                    boolean bl = false;
                    String string = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    String string2 = string.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                    it = (File)b;
                    Comparable comparable = (Comparable)((Object)string2);
                    bl = false;
                    String string3 = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
                    String string4 = string3.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string4)));
                }
            });
            if (object == null) {
                continue;
            }
            Object files = object;
            Iterator iterator = files.iterator();
            while (iterator.hasNext()) {
                boolean bl2;
                String relPath;
                File file = (File)iterator.next();
                if (results.size() >= limit) continue block1;
                String name = file.getName();
                if (file.isDirectory()) {
                    Intrinsics.checkNotNull((Object)name);
                    if (StringsKt.startsWith$default((String)name, (String)".", (boolean)false, (int)2, null) || ((HashSet)dirsToIgnore).contains(name) || IS_WINDOWS && SYSTEM_DIRS.contains(name)) continue;
                    Path path = file.toPath();
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
                    relPath = FileUtilsKt.posixString(FileUtilsKt.safeRelativize(absPath, path));
                    results.add(StringsKt.replace$default((String)((Object)absPath.resolve(relPath + "/").normalize()).toString(), (char)'\\', (char)'/', (boolean)false, (int)4, null));
                    bl2 = queue.add(file);
                    continue;
                }
                Path path = file.toPath();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
                relPath = FileUtilsKt.posixString(FileUtilsKt.safeRelativize(absPath, path));
                bl2 = results.add(StringsKt.replace$default((String)((Object)absPath.resolve(relPath).normalize()).toString(), (char)'\\', (char)'/', (boolean)false, (int)4, null));
            }
        }
        return TuplesKt.to((Object)CollectionsKt.take((Iterable)CollectionsKt.toList((Iterable)results), (int)limit), (Object)(results.size() >= limit ? 1 : 0));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String formatFilesList(@NotNull String absolutePath, @NotNull List<String> files, boolean didHitLimit, @Nullable ClineIgnoreController clineIgnoreController) {
        List list;
        Object filePath;
        Collection collection;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)absolutePath, (String)"absolutePath");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        File file = new File(absolutePath).getAbsoluteFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAbsoluteFile(...)");
        Path abs = FilesKt.normalize((File)file).toPath();
        Iterable $this$map$iv = files;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void file2;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            File file3 = new File((String)file2).getAbsoluteFile();
            Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"getAbsoluteFile(...)");
            filePath = FilesKt.normalize((File)file3).toPath();
            Intrinsics.checkNotNull((Object)abs);
            Intrinsics.checkNotNull((Object)filePath);
            String rel = FileUtilsKt.posixString(FileUtilsKt.safeRelativize(abs, (Path)filePath));
            collection.add(StringsKt.endsWith$default((String)file2, (String)"/", (boolean)false, (int)2, null) ? rel + "/" : rel);
        }
        List sorted = (List)destination$iv$iv;
        List hierarchicallySorted = CollectionsKt.sortedWith((Iterable)sorted, (arg_0, arg_1) -> FileUtilsKt.formatFilesList$lambda$21(FileUtilsKt::formatFilesList$lambda$20, arg_0, arg_1));
        if (clineIgnoreController != null) {
            void $this$mapTo$iv$iv2;
            Iterable $this$map$iv2 = hierarchicallySorted;
            boolean $i$f$map2 = false;
            Iterable $i$f$mapTo2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                filePath = (String)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                String absoluteFilePath = ((Object)abs.resolve((String)filePath).toAbsolutePath().normalize()).toString();
                boolean isIgnored = !clineIgnoreController.validateAccess(absoluteFilePath);
                collection.add(isIgnored ? "\ud83d\udd12 " + (String)filePath : filePath);
            }
            list = (List)destination$iv$iv2;
        } else {
            list = hierarchicallySorted;
        }
        List clineIgnoreParsed = list;
        return didHitLimit ? CollectionsKt.joinToString$default((Iterable)clineIgnoreParsed, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null) + "\n\n(File list truncated. Use list_files on specific subdirectories if you need to explore further.)" : (clineIgnoreParsed.isEmpty() || clineIgnoreParsed.size() == 1 && Intrinsics.areEqual(clineIgnoreParsed.get(0), (Object)"") ? "No files found." : CollectionsKt.joinToString$default((Iterable)clineIgnoreParsed, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
    }

    public static /* synthetic */ String formatFilesList$default(String string, List list, boolean bl, ClineIgnoreController clineIgnoreController, int n, Object object) {
        if ((n & 8) != 0) {
            clineIgnoreController = null;
        }
        return FileUtilsKt.formatFilesList(string, list, bl, clineIgnoreController);
    }

    private static final String posixString(Path $this$posixString) {
        return StringsKt.replace$default((String)((Object)$this$posixString).toString(), (char)'\\', (char)'/', (boolean)false, (int)4, null);
    }

    private static final Path safeRelativize(Path base, Path other) {
        Path path;
        try {
            Path path2;
            boolean sameRoot;
            Path b = base.toAbsolutePath().normalize();
            Path o = other.toAbsolutePath().normalize();
            Object object = b.getRoot();
            if (object != null && (object = object.toString()) != null) {
                Path path3 = o.getRoot();
                v2 = StringsKt.equals((String)object, (String)(path3 != null ? ((Object)path3).toString() : null), (boolean)true);
            } else {
                v2 = sameRoot = false;
            }
            if (sameRoot) {
                path2 = b.relativize(o);
            } else {
                path2 = o.getFileName();
                if (path2 == null) {
                    path2 = o;
                }
            }
            path = path2;
            Intrinsics.checkNotNull((Object)path);
        }
        catch (Exception exception) {
            Path path4 = other.getFileName();
            if (path4 == null) {
                path4 = other;
            }
            path = path4;
        }
        return path;
    }

    private static final boolean equalPaths(Path a, Path b) {
        Path aa = a.toAbsolutePath().normalize();
        Path bb = b.toAbsolutePath().normalize();
        return IS_WINDOWS ? StringsKt.equals((String)((Object)aa).toString(), (String)((Object)bb).toString(), (boolean)true) : Intrinsics.areEqual((Object)aa, (Object)bb);
    }

    private static final boolean isFsRoot(Path $this$isFsRoot) {
        return $this$isFsRoot.toAbsolutePath().normalize().getParent() == null;
    }

    /*
     * WARNING - void declaration
     */
    private static final String formatResults(List<SearchResult> results, Path cwd) {
        Map grouped;
        Object list$iv$iv;
        void $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        StringBuilder builder2 = new StringBuilder();
        StringBuilder stringBuilder = results.size() >= 300 ? builder2.append("Showing first 300 of 300+ results. Use a more specific search if necessary.\n\n") : builder2.append("Found " + (String)(results.size() == 1 ? "1 result" : results.size() + " results") + ".\n\n");
        Iterable iterable = CollectionsKt.take((Iterable)results, (int)300);
        boolean $i$f$groupBy = false;
        Iterator iterator = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            SearchResult it = (SearchResult)element$iv$iv;
            boolean bl = false;
            Path path = Path.of(it.getFilePath(), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
            String key$iv$iv = FileUtilsKt.posixString(FileUtilsKt.safeRelativize(cwd, path));
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map $this$forEach$iv = grouped = destination$iv$iv;
        boolean $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            String file = (String)entry.getKey();
            List list = (List)entry.getValue();
            builder2.append(file + "\n\u2502----\n");
            Iterable $this$forEachIndexed$iv = list;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void r;
                List list2;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                list$iv$iv = (SearchResult)item$iv;
                int idx = n;
                boolean bl3 = false;
                List $this$formatResults_u24lambda_u2427_u24lambda_u2426_u24lambda_u2424 = list2 = CollectionsKt.createListBuilder();
                boolean bl4 = false;
                $this$formatResults_u24lambda_u2427_u24lambda_u2426_u24lambda_u2424.addAll((Collection)r.getBeforeContext());
                $this$formatResults_u24lambda_u2427_u24lambda_u2426_u24lambda_u2424.add(r.getMatch());
                $this$formatResults_u24lambda_u2427_u24lambda_u2426_u24lambda_u2424.addAll((Collection)r.getAfterContext());
                List all = CollectionsKt.build((List)list2);
                Iterable $this$forEach$iv2 = all;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    String it = (String)element$iv2;
                    boolean bl5 = false;
                    builder2.append("\u2502" + ((Object)StringsKt.trimEnd((CharSequence)it)).toString() + "\n");
                }
                if (idx >= list.size() - 1) continue;
                builder2.append("\u2502----\n");
            }
            builder2.append("\u2502----\n\n");
        }
        String string = builder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return ((Object)StringsKt.trim((CharSequence)string)).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final String regexSearchFiles(@NotNull Path cwd, @NotNull Path directoryPath, @NotNull String regex, @Nullable String filePattern, @Nullable ClineIgnoreController clineIgnoreController, int maxResults, long maxFileSizeBytes, boolean caseInsensitiveOnWindows) {
        List list;
        Intrinsics.checkNotNullParameter((Object)cwd, (String)"cwd");
        Intrinsics.checkNotNullParameter((Object)directoryPath, (String)"directoryPath");
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        Path dirPath = directoryPath;
        if (!Files.exists(dirPath, new LinkOption[0])) {
            return "Search path does not exist: " + dirPath;
        }
        String string = filePattern;
        if (string == null) {
            string = "*";
        }
        String glob = string;
        PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:" + glob);
        List $this$regexSearchFiles_u24lambda_u2428 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        if (caseInsensitiveOnWindows) {
            String string2 = System.getProperty("os.name");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProperty(...)");
            if (StringsKt.startsWith((String)string2, (String)"Windows", (boolean)true)) {
                $this$regexSearchFiles_u24lambda_u2428.add(RegexOption.IGNORE_CASE);
            }
        }
        List regexOptions = CollectionsKt.build((List)list);
        try {
            $this$regexSearchFiles_u24lambda_u2428 = new Regex(regex, CollectionsKt.toSet((Iterable)regexOptions));
        }
        catch (Exception e) {
            return "Invalid regex pattern: " + e.getMessage();
        }
        List searchRegex = $this$regexSearchFiles_u24lambda_u2428;
        ArrayList results = new ArrayList(Math.min(maxResults, 256));
        int maxDepth = Integer.MAX_VALUE;
        try {
            AutoCloseable autoCloseable = Files.find(dirPath, maxDepth, (arg_0, arg_1) -> FileUtilsKt.regexSearchFiles$lambda$29(matcher, arg_0, arg_1), new FileVisitOption[0]);
            Throwable throwable = null;
            try {
                Stream stream = (Stream)autoCloseable;
                boolean bl2 = false;
                stream.forEach(arg_0 -> FileUtilsKt.regexSearchFiles$lambda$38$lambda$37(arg_0 -> FileUtilsKt.regexSearchFiles$lambda$38$lambda$36(results, maxResults, clineIgnoreController, maxFileSizeBytes, (Regex)searchRegex, arg_0), arg_0));
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        catch (StopSearch stopSearch) {
            // empty catch block
        }
        return results.isEmpty() ? "No results found" : FileUtilsKt.formatResults(results, cwd);
    }

    public static /* synthetic */ String regexSearchFiles$default(Path path, Path path2, String string, String string2, ClineIgnoreController clineIgnoreController, int n, long l, boolean bl, int n2, Object object) {
        if ((n2 & 8) != 0) {
            string2 = "*";
        }
        if ((n2 & 0x10) != 0) {
            clineIgnoreController = null;
        }
        if ((n2 & 0x20) != 0) {
            n = 300;
        }
        if ((n2 & 0x40) != 0) {
            l = 0x500000L;
        }
        if ((n2 & 0x80) != 0) {
            bl = true;
        }
        return FileUtilsKt.regexSearchFiles(path, path2, string, string2, clineIgnoreController, n, l, bl);
    }

    private static final boolean looksBinary(byte[] head, Path path) {
        boolean bl;
        int n;
        int $i$f$any;
        block11: {
            String ext;
            Object[] objectArray;
            Set binaryExt;
            Object name;
            block13: {
                Object object;
                block12: {
                    object = path.getFileName();
                    if (object == null || (object = object.toString()) == null) break block12;
                    String string = ((String)object).toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                    object = string;
                    if (string != null) break block13;
                }
                object = name = "";
            }
            if ((binaryExt = SetsKt.setOf((Object[])(objectArray = new String[]{"exe", "dll", "pdb", "bin", "dat", "obj", "lib", "class", "so", "dylib"}))).contains(ext = StringsKt.substringAfterLast((String)name, (char)'.', (String)""))) {
                return true;
            }
            if (head.length == 0) {
                return false;
            }
            byte[] $this$any$iv = head;
            $i$f$any = 0;
            int n2 = $this$any$iv.length;
            for (n = 0; n < n2; ++n) {
                byte element$iv;
                byte it = element$iv = $this$any$iv[n];
                boolean bl2 = false;
                if (!(it == 0)) continue;
                bl = true;
                break block11;
            }
            bl = false;
        }
        if (bl) {
            return true;
        }
        int nonPrintable = 0;
        n = head.length;
        block4: for ($i$f$any = 0; $i$f$any < n; ++$i$f$any) {
            byte b = head[$i$f$any];
            int c = b & 0xFF;
            switch (c) {
                case 9: 
                case 10: 
                case 13: {
                    continue block4;
                }
                default: {
                    if (c >= 32 && c != 127) continue block4;
                    ++nonPrintable;
                }
            }
        }
        double ratio = (double)nonPrintable / (double)head.length;
        return ratio > 0.3;
    }

    private static final Charset sniffCharset(byte[] head) {
        Charset charset;
        if (head.length >= 3 && head[0] == -17 && head[1] == -69 && head[2] == -65) {
            return StandardCharsets.UTF_8;
        }
        if (head.length >= 2) {
            if (head[0] == -2 && head[1] == -1) {
                return StandardCharsets.UTF_16BE;
            }
            if (head[0] == -1 && head[1] == -2) {
                return StandardCharsets.UTF_16LE;
            }
        }
        try {
            StandardCharsets.UTF_8.newDecoder().decode(ByteBuffer.wrap(head));
            charset = StandardCharsets.UTF_8;
        }
        catch (Exception exception) {
            charset = Charset.defaultCharset();
        }
        return charset;
    }

    private static final String markThenReadNextLine(BufferedReader $this$markThenReadNextLine) {
        $this$markThenReadNextLine.mark(16384);
        String line = $this$markThenReadNextLine.readLine();
        $this$markThenReadNextLine.reset();
        return line;
    }

    @NotNull
    public static final List<String> searchFiles(@NotNull Project project, @NotNull String query, int maxResults) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        return (List)ActionsKt.runReadAction(() -> FileUtilsKt.searchFiles$lambda$47(project, query, maxResults));
    }

    public static /* synthetic */ List searchFiles$default(Project project, String string, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 100;
        }
        return FileUtilsKt.searchFiles(project, string, n);
    }

    private static final boolean getDirTreeBFS$lambda$0(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final boolean getDirTreeBFS$lambda$2(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final boolean getDirTreeDFS$lambda$4(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final int formatFilesList$lambda$20(String a, String b) {
        Intrinsics.checkNotNull((Object)a);
        String[] stringArray = new String[]{"/"};
        List aParts = StringsKt.split$default((CharSequence)a, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        Intrinsics.checkNotNull((Object)b);
        String[] stringArray2 = new String[]{"/"};
        List bParts = StringsKt.split$default((CharSequence)b, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
        int n = Math.min(aParts.size(), bParts.size());
        for (int i = 0; i < n; ++i) {
            if (Intrinsics.areEqual(aParts.get(i), bParts.get(i))) continue;
            if (i + 1 == aParts.size() && i + 1 < bParts.size()) {
                return -1;
            }
            if (i + 1 == bParts.size() && i + 1 < aParts.size()) {
                return 1;
            }
            return StringsKt.compareTo((String)((String)aParts.get(i)), (String)((String)bParts.get(i)), (boolean)true);
        }
        return aParts.size() - bParts.size();
    }

    private static final int formatFilesList$lambda$21(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    private static final boolean regexSearchFiles$lambda$29(PathMatcher $matcher, Path p, BasicFileAttributes attrs) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        try {
            bl = attrs.isRegularFile() && $matcher.matches(p.getFileName());
        }
        catch (SecurityException securityException) {
            bl = false;
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit regexSearchFiles$lambda$38$lambda$36(ArrayList $results, int $maxResults, ClineIgnoreController $clineIgnoreController, long $maxFileSizeBytes, Regex $searchRegex, Path path) {
        Object toRead22;
        Throwable throwable;
        long l;
        if ($results.size() >= $maxResults) {
            throw new StopSearch();
        }
        if ($clineIgnoreController != null) {
            Intrinsics.checkNotNull((Object)path);
            if (!$clineIgnoreController.validateAccess(path)) {
                return Unit.INSTANCE;
            }
        }
        try {
            l = Files.size(path);
        }
        catch (Exception exception) {
            return Unit.INSTANCE;
        }
        long size = l;
        if (size > $maxFileSizeBytes) {
            return Unit.INSTANCE;
        }
        try {
            Object ins;
            int toRead22 = (int)Math.min(size, 16384L);
            Closeable exception = Files.newInputStream(path, new OpenOption[0]);
            throwable = null;
            try {
                ins = (InputStream)exception;
                boolean bl = false;
                ins = ((InputStream)ins).readNBytes(toRead22);
            }
            catch (Throwable bl) {
                throwable = bl;
                throw bl;
            }
            finally {
                CloseableKt.closeFinally((Closeable)exception, (Throwable)throwable);
            }
            toRead22 = ins;
        }
        catch (Exception exception) {
            return Unit.INSTANCE;
        }
        Object head = toRead22;
        Intrinsics.checkNotNull((Object)head);
        Intrinsics.checkNotNull((Object)path);
        if (FileUtilsKt.looksBinary((byte[])head, path)) {
            return Unit.INSTANCE;
        }
        Charset charset = FileUtilsKt.sniffCharset((byte[])head);
        if (charset == null) {
            charset = StandardCharsets.UTF_8;
        }
        Charset charset2 = charset;
        try {
            Closeable closeable = Files.newBufferedReader(path, charset2);
            throwable = null;
            try {
                int n;
                String match;
                BufferedReader br = (BufferedReader)closeable;
                boolean bl = false;
                boolean hadMatch = false;
                String prev = null;
                int currLineNo = 0;
                while (br.readLine() != null) {
                    String line;
                    block43: {
                        Object object;
                        Object object2;
                        String string;
                        int n2;
                        int n3;
                        String string2;
                        ArrayList arrayList;
                        block47: {
                            block46: {
                                String it;
                                Object object3;
                                block45: {
                                    block44: {
                                        ++currLineNo;
                                        match = Regex.find$default((Regex)$searchRegex, (CharSequence)line, (int)0, (int)2, null);
                                        if (match == null) break block43;
                                        hadMatch = true;
                                        object3 = prev;
                                        if (object3 == null) break block44;
                                        it = object3;
                                        boolean bl2 = false;
                                        List list = CollectionsKt.listOf((Object)it);
                                        object3 = list;
                                        if (list != null) break block45;
                                    }
                                    object3 = CollectionsKt.emptyList();
                                }
                                Object beforeCtx = object3;
                                Intrinsics.checkNotNull((Object)br);
                                String after2 = FileUtilsKt.markThenReadNextLine(br);
                                arrayList = $results;
                                string2 = ((Object)path).toString();
                                n3 = currLineNo;
                                n2 = match.getRange().getFirst() + 1;
                                string = line;
                                object2 = beforeCtx;
                                object = after2;
                                if (object == null) break block46;
                                it = object;
                                Object object4 = object2;
                                String string3 = string;
                                int n4 = n2;
                                int n5 = n3;
                                String string4 = string2;
                                ArrayList arrayList2 = arrayList;
                                n = 0;
                                List list = CollectionsKt.listOf((Object)it);
                                arrayList = arrayList2;
                                string2 = string4;
                                n3 = n5;
                                n2 = n4;
                                string = string3;
                                object2 = object4;
                                List list2 = list;
                                object = list2;
                                if (list2 != null) break block47;
                            }
                            object = CollectionsKt.emptyList();
                        }
                        Object object5 = object;
                        Object object6 = object2;
                        String string5 = string;
                        int n6 = n2;
                        int n7 = n3;
                        String string6 = string2;
                        arrayList.add(new SearchResult(string6, n7, n6, string5, (List<String>)object6, (List<String>)object5));
                        if ($results.size() >= $maxResults) {
                            throw new StopSearch();
                        }
                    }
                    prev = line;
                }
                if (!hadMatch) {
                    try {
                        match = Files.readString(path, charset2);
                    }
                    catch (Exception exception) {
                        match = "";
                    }
                    String text = match;
                    Intrinsics.checkNotNull((Object)text);
                    MatchResult m = Regex.find$default((Regex)$searchRegex, (CharSequence)text, (int)0, (int)2, null);
                    if (m != null) {
                        String string = text.substring(0, m.getRange().getFirst());
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        String upto = string;
                        CharSequence $this$count$iv = upto;
                        boolean $i$f$count = false;
                        int count$iv = 0;
                        for (n = 0; n < $this$count$iv.length(); ++n) {
                            char element$iv;
                            char it = element$iv = $this$count$iv.charAt(n);
                            boolean bl3 = false;
                            if (!(it == '\n')) continue;
                            ++count$iv;
                        }
                        int lineNo = count$iv + 1;
                        int it = StringsKt.lastIndexOf$default((CharSequence)upto, (char)'\n', (int)0, (boolean)false, (int)6, null);
                        boolean bl4 = false;
                        int col = it == -1 ? 0 : it + 1;
                        $results.add(new SearchResult(((Object)path).toString(), lineNo, m.getRange().getFirst() - col + 1, m.getValue(), CollectionsKt.emptyList(), CollectionsKt.emptyList()));
                        if ($results.size() >= $maxResults) {
                            throw new StopSearch();
                        }
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (AccessDeniedException accessDeniedException) {
        }
        catch (SecurityException securityException) {
        }
        catch (MalformedInputException malformedInputException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Unit.INSTANCE;
    }

    private static final void regexSearchFiles$lambda$38$lambda$37(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void searchFiles$lambda$47$processFile(Set<String> results, int $maxResults, ClineIgnoreController ignoreController, Project $project, VirtualFile file) {
        block6: {
            block5: {
                block4: {
                    if (results.size() >= $maxResults) break block4;
                    String string = file.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                    if (ignoreController.validateAccess(string)) break block5;
                }
                return;
            }
            String string = $project.getBasePath();
            if (string == null) break block6;
            String basePath = string;
            boolean bl = false;
            try {
                String path = StringsKt.replace$default((String)((Object)Paths.get(basePath, new String[0]).relativize(Paths.get(file.getPath(), new String[0]))).toString(), (char)'\\', (char)'/', (boolean)false, (int)4, null);
                Boolean bl2 = results.add((String)(file.isDirectory() ? path + "/" : path));
            }
            catch (Exception exception) {
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    private static final boolean searchFiles$lambda$47$lambda$43$lambda$42$lambda$41(Set $results, int $maxResults, VirtualFile $dir, String $partialFilename, ClineIgnoreController $ignoreController, Project $project, VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if ($results.size() >= $maxResults) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)file, (Object)$dir)) {
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (StringsKt.contains((CharSequence)string, (CharSequence)$partialFilename, (boolean)true)) {
                FileUtilsKt.searchFiles$lambda$47$processFile($results, $maxResults, $ignoreController, $project, file);
            }
        }
        return true;
    }

    private static final boolean searchFiles$lambda$47$lambda$45(Set $results, int $maxResults, String $query, GlobalSearchScope $scope, ClineIgnoreController $ignoreController, Project $project, String fileName) {
        if ($results.size() >= $maxResults) {
            return false;
        }
        Intrinsics.checkNotNull((Object)fileName);
        if (StringsKt.contains((CharSequence)fileName, (CharSequence)$query, (boolean)true) && !Intrinsics.areEqual((Object)fileName, (Object)$query)) {
            Collection collection = FilenameIndex.getVirtualFilesByName((String)fileName, (GlobalSearchScope)$scope);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getVirtualFilesByName(...)");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VirtualFile p0 = (VirtualFile)element$iv;
                boolean bl = false;
                FileUtilsKt.searchFiles$lambda$47$processFile($results, $maxResults, $ignoreController, $project, p0);
            }
        }
        return true;
    }

    private static final boolean searchFiles$lambda$47$lambda$46(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final List searchFiles$lambda$47(Project $project, String $query, int $maxResults) {
        Set results = new LinkedHashSet();
        ComponentManager $this$service$iv = (ComponentManager)$project;
        boolean $i$f$service = false;
        Class<ClineIgnoreController> serviceClass$iv = ClineIgnoreController.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ClineIgnoreController ignoreController = (ClineIgnoreController)object;
        GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)$project);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"projectScope(...)");
        GlobalSearchScope scope = globalSearchScope;
        int lastSeparatorIndex = StringsKt.lastIndexOf$default((CharSequence)$query, (char)'/', (int)0, (boolean)false, (int)6, null);
        if (lastSeparatorIndex > 0) {
            String string = $query.substring(0, lastSeparatorIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String prefixPath = string;
            String string2 = $query.substring(lastSeparatorIndex + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String partialFilename = string2;
            String string3 = $project.getBasePath();
            if (string3 != null) {
                String basePath = string3;
                boolean bl = false;
                String[] stringArray = new String[]{prefixPath};
                File targetDir = Paths.get(basePath, stringArray).toFile();
                if (targetDir.exists() && targetDir.isDirectory()) {
                    VirtualFile targetVirtualDir;
                    VirtualFile virtualFile = targetVirtualDir = LocalFileSystem.getInstance().findFileByPath(targetDir.getAbsolutePath());
                    if (virtualFile != null) {
                        VirtualFile dir = virtualFile;
                        boolean bl2 = false;
                        VfsUtilCore.iterateChildrenRecursively((VirtualFile)dir, null, arg_0 -> FileUtilsKt.searchFiles$lambda$47$lambda$43$lambda$42$lambda$41(results, $maxResults, dir, partialFilename, ignoreController, $project, arg_0));
                    }
                }
            }
        } else {
            Collection collection = FilenameIndex.getVirtualFilesByName((String)$query, (GlobalSearchScope)scope);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getVirtualFilesByName(...)");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VirtualFile p0 = (VirtualFile)element$iv;
                boolean bl = false;
                FileUtilsKt.searchFiles$lambda$47$processFile(results, $maxResults, ignoreController, $project, p0);
            }
            if (results.size() < $maxResults) {
                FilenameIndex.processAllFileNames(arg_0 -> FileUtilsKt.searchFiles$lambda$47$lambda$46(arg_0 -> FileUtilsKt.searchFiles$lambda$47$lambda$45(results, $maxResults, $query, scope, ignoreController, $project, arg_0), arg_0), (GlobalSearchScope)scope, null);
            }
        }
        return CollectionsKt.take((Iterable)results, (int)$maxResults);
    }

    static {
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        IS_WINDOWS = StringsKt.startsWith((String)string, (String)"Windows", (boolean)true);
        Object[] objectArray = new String[]{"$RECYCLE.BIN", "System Volume Information"};
        SYSTEM_DIRS = SetsKt.setOf((Object[])objectArray);
    }
}

