/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.composer.util;

import cn.gitlab.kilo.jetbrains.composer.dto.AssistantMessageContent;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\"\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\f\u00a8\u0006\r"}, d2={"Lcn/gitlab/kilo/jetbrains/composer/util/AssistantMessageUtil;", "", "<init>", "()V", "parseAssistantMessage", "", "Lcn/gitlab/kilo/jetbrains/composer/dto/AssistantMessageContent;", "assistantMessage", "", "toolIdentifiers", "", "paramNames", "", "coderider-kilo-jetbrains"})
public final class AssistantMessageUtil {
    @NotNull
    public static final AssistantMessageUtil INSTANCE = new AssistantMessageUtil();

    private AssistantMessageUtil() {
    }

    @NotNull
    public final List<AssistantMessageContent> parseAssistantMessage(@NotNull String assistantMessage, @NotNull List<String> toolIdentifiers, @NotNull Set<String> paramNames) {
        Intrinsics.checkNotNullParameter((Object)assistantMessage, (String)"assistantMessage");
        Intrinsics.checkNotNullParameter(toolIdentifiers, (String)"toolIdentifiers");
        Intrinsics.checkNotNullParameter(paramNames, (String)"paramNames");
        List AssistantMessageContents = new ArrayList();
        AssistantMessageContent currentTextContent = null;
        int currentTextContentStartIndex = 0;
        AssistantMessageContent currentToolUse = null;
        int currentToolUseStartIndex = 0;
        String currentParamName = null;
        int currentParamValueStartIndex = 0;
        StringBuilder accumulator = new StringBuilder();
        int n = ((CharSequence)assistantMessage).length();
        for (int i = 0; i < n; ++i) {
            char c = assistantMessage.charAt(i);
            accumulator.append(c);
            if (currentToolUse != null && currentParamName != null) {
                String currentParamValue = accumulator.substring(currentParamValueStartIndex);
                String paramClosingTag = "</" + currentParamName + ">";
                Intrinsics.checkNotNull((Object)currentParamValue);
                if (!StringsKt.endsWith$default((String)currentParamValue, (String)paramClosingTag, (boolean)false, (int)2, null)) continue;
                Map<String, String> map = currentToolUse.getParams();
                if (map != null) {
                    map.put(currentParamName, ((Object)StringsKt.trim((CharSequence)StringsKt.removeSuffix((String)currentParamValue, (CharSequence)paramClosingTag))).toString());
                }
                currentParamName = null;
                continue;
            }
            if (currentToolUse != null) {
                String currentToolValue = accumulator.substring(currentToolUseStartIndex);
                String toolUseClosingTag = "</" + currentToolUse.getName() + ">";
                Intrinsics.checkNotNull((Object)currentToolValue);
                if (StringsKt.endsWith$default((String)currentToolValue, (String)toolUseClosingTag, (boolean)false, (int)2, null)) {
                    currentToolUse.setPartial(false);
                    AssistantMessageContents.add(currentToolUse);
                    currentToolUse = null;
                    continue;
                }
                for (String paramName : paramNames) {
                    String paramOpeningTag = "<" + paramName + ">";
                    if (!StringsKt.endsWith$default((CharSequence)accumulator, (CharSequence)paramOpeningTag, (boolean)false, (int)2, null)) continue;
                    currentParamName = paramName;
                    currentParamValueStartIndex = accumulator.length();
                    break;
                }
                String contentParamName = "content";
                if ((Intrinsics.areEqual((Object)currentToolUse.getName(), (Object)"write_to_file") || Intrinsics.areEqual((Object)currentToolUse.getName(), (Object)"new_rule")) && StringsKt.endsWith$default((CharSequence)accumulator, (CharSequence)("</" + contentParamName + ">"), (boolean)false, (int)2, null)) {
                    Map<String, String> map;
                    String toolContent = accumulator.substring(currentToolUseStartIndex);
                    String contentStartTag = "<" + contentParamName + ">";
                    String contentEndTag = "</" + contentParamName + ">";
                    Intrinsics.checkNotNull((Object)toolContent);
                    int contentStartIndex = StringsKt.indexOf$default((CharSequence)toolContent, (String)contentStartTag, (int)0, (boolean)false, (int)6, null) + contentStartTag.length();
                    int contentEndIndex = StringsKt.lastIndexOf$default((CharSequence)toolContent, (String)contentEndTag, (int)0, (boolean)false, (int)6, null);
                    if (contentStartIndex != -1 && contentEndIndex != -1 && contentEndIndex > contentStartIndex && (map = currentToolUse.getParams()) != null) {
                        String string = toolContent.substring(contentStartIndex, contentEndIndex);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        map.put(contentParamName, ((Object)StringsKt.trim((CharSequence)string)).toString());
                    }
                }
                currentToolUse.setPartial(true);
                continue;
            }
            boolean didStartToolUse = false;
            for (String toolName : toolIdentifiers) {
                String toolUseOpeningTag = "<" + toolName + ">";
                if (!StringsKt.endsWith$default((CharSequence)accumulator, (CharSequence)toolUseOpeningTag, (boolean)false, (int)2, null)) continue;
                currentToolUse = new AssistantMessageContent("tool_use", toolName, null, null, new LinkedHashMap(), true, null, 76, null);
                currentToolUseStartIndex = accumulator.length();
                if (currentTextContent != null) {
                    String string;
                    currentTextContent.setPartial(false);
                    String string2 = currentTextContent.getContent();
                    currentTextContent.setContent(string2 != null && (string = StringsKt.removeSuffix((String)string2, (CharSequence)StringsKt.dropLast((String)toolUseOpeningTag, (int)1))) != null ? ((Object)StringsKt.trim((CharSequence)string)).toString() : null);
                    AssistantMessageContents.add(currentTextContent);
                    currentTextContent = null;
                }
                didStartToolUse = true;
                break;
            }
            if (didStartToolUse) continue;
            if (currentTextContent == null) {
                currentTextContentStartIndex = i;
            }
            String string = accumulator.substring(currentTextContentStartIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String string3 = ((Object)StringsKt.trim((CharSequence)string)).toString();
            currentTextContent = new AssistantMessageContent("text", null, null, null, null, true, string3, 30, null);
        }
        if (currentToolUse != null) {
            if (currentParamName != null) {
                Map<String, String> map = currentToolUse.getParams();
                if (map != null) {
                    Map<String, String> map2 = map;
                    String string = accumulator.substring(currentParamValueStartIndex);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    String string4 = ((Object)StringsKt.trim((CharSequence)string)).toString();
                    map2.put(currentParamName, string4);
                }
            }
            AssistantMessageContents.add(currentToolUse);
        }
        if (currentTextContent != null) {
            AssistantMessageContents.add(currentTextContent);
        }
        return AssistantMessageContents;
    }
}

