/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.composer.tools.interaction;

import cn.gitlab.kilo.jetbrains.composer.tools.interaction.Command;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\"\u001a\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0004"}, d2={"BUILT_IN_COMMANDS", "", "", "Lcn/gitlab/kilo/jetbrains/composer/tools/interaction/Command;", "coderider-kilo-jetbrains"})
public final class RunSlashCommandToolKt {
    @NotNull
    private static final Map<String, Command> BUILT_IN_COMMANDS = MapsKt.mapOf((Pair)TuplesKt.to((Object)"init", (Object)new Command("init", "<task>\nPlease analyze this codebase and create an AGENTS.md file containing:\n1. Build/lint/test commands - especially for running a single test\n2. Code style guidelines including imports, formatting, types, naming conventions, error handling, etc.\n</task>\n\n<initialization>\n  <purpose>\n    Create (or update) a concise AGENTS.md file that enables immediate productivity for AI assistants.\n    Focus ONLY on project-specific, non-obvious information that you had to discover by reading files.\n    \n    CRITICAL: Only include information that is:\n    - Non-obvious (couldn't be guessed from standard practices)\n    - Project-specific (not generic to the framework/language)\n    - Discovered by reading files (config files, code patterns, custom utilities)\n    - Essential for avoiding mistakes or following project conventions\n    \n    Usage notes:\n    - The file you create will be given to agentic coding agents (such as yourself) that operate in this repository\n    - Keep the main AGENTS.md concise - aim for about 20 lines, but use more if the project complexity requires it\n    - If there's already an AGENTS.md, improve it\n    - If there are Claude Code rules (in CLAUDE.md), Cursor rules (in .cursor/rules/ or .cursorrules), or Copilot rules (in .github/copilot-instructions.md), make sure to include them\n    - Be sure to prefix the file with: \"# AGENTS.md\\n\\nThis file provides guidance to agents when working with code in this repository.\"\n  </purpose>\n  \n  <todo_list_creation>\n    If the update_todo_list tool is available, create a todo list with these focused analysis steps:\n    \n    1. Check for existing AGENTS.md files\n       CRITICAL - Check these EXACT paths IN THE PROJECT ROOT:\n       - AGENTS.md (in project root directory)\n       - .roo/rules-code/AGENTS.md (relative to project root)\n       - .roo/rules-debug/AGENTS.md (relative to project root)\n       - .roo/rules-ask/AGENTS.md (relative to project root)\n       - .roo/rules-architect/AGENTS.md (relative to project root)\n       \n       IMPORTANT: All paths are relative to the project/workspace root, NOT system root!\n       \n       If ANY of these exist:\n       - Read them thoroughly\n       - CRITICALLY EVALUATE: Remove ALL obvious information\n       - DELETE entries that are standard practice or framework defaults\n       - REMOVE anything that could be guessed without reading files\n       - Only KEEP truly non-obvious, project-specific discoveries\n       - Then add any new non-obvious patterns you discover\n       \n       Also check for other AI assistant rules:\n       - .cursorrules, CLAUDE.md, .roorules\n       - .cursor/rules/, .github/copilot-instructions.md\n    \n    2. Identify stack\n       - Language, framework, build tools\n       - Package manager and dependencies\n    \n    3. Extract commands\n       - Build, test, lint, run\n       - Critical directory-specific commands\n    \n    4. Map core architecture\n       - Main components and flow\n       - Key entry points\n    \n    5. Document critical patterns\n       - Project-specific utilities (that you discovered by reading code)\n       - Non-standard approaches (that differ from typical patterns)\n       - Custom conventions (that aren't obvious from file structure)\n    \n    6. Extract code style\n       - From config files only\n       - Key conventions\n    \n    7. Testing specifics\n       - Framework and run commands\n       - Directory requirements\n    \n    8. Compile/Update AGENTS.md files\n       - If files exist: AGGRESSIVELY clean them up\n         * DELETE all obvious information (even if it was there before)\n         * REMOVE standard practices, framework defaults, common patterns\n         * STRIP OUT anything derivable from file structure or names\n         * ONLY KEEP truly non-obvious discoveries\n         * Then add newly discovered non-obvious patterns\n         * Result should be SHORTER and MORE FOCUSED than before\n       - If creating new: Follow the non-obvious-only principle\n       - Create mode-specific files in .roo/rules-*/ directories (IN PROJECT ROOT)\n       \n    Note: If update_todo_list is not available, proceed with the analysis workflow directly without creating a todo list.\n  </todo_list_creation>\n</initialization>\n\n<analysis_workflow>\n  Follow the comprehensive analysis workflow to:\n  \n  1. **Discovery Phase**:\n     CRITICAL - First check for existing AGENTS.md files at these EXACT locations IN PROJECT ROOT:\n     - AGENTS.md (in project/workspace root)\n     - .roo/rules-code/AGENTS.md (relative to project root)\n     - .roo/rules-debug/AGENTS.md (relative to project root)\n     - .roo/rules-ask/AGENTS.md (relative to project root)\n     - .roo/rules-architect/AGENTS.md (relative to project root)\n     \n     IMPORTANT: The .roo folder should be created in the PROJECT ROOT, not system root!\n     \n     If found, perform CRITICAL analysis:\n     - What information is OBVIOUS and must be DELETED?\n     - What violates the non-obvious-only principle?\n     - What would an experienced developer already know?\n     - DELETE first, then consider what to add\n     - The file should get SHORTER, not longer\n     \n     Also find other AI assistant rules and documentation\n     \n  2. **Project Identification**: Identify language, stack, and build system\n  3. **Command Extraction**: Extract and verify essential commands\n  4. **Architecture Mapping**: Create visual flow diagrams of core processes\n  5. **Component Analysis**: Document key components and their interactions\n  6. **Pattern Analysis**: Identify project-specific patterns and conventions\n  7. **Code Style Extraction**: Extract formatting and naming conventions\n  8. **Security & Performance**: Document critical patterns if relevant\n  9. **Testing Discovery**: Understand testing setup and practices\n  10. **Example Extraction**: Find real examples from the codebase\n</analysis_workflow>\n\n<output_structure>\n  <main_file>\n    Create or deeply improve AGENTS.md with ONLY non-obvious information:\n    \n    If AGENTS.md exists:\n    - FIRST: Delete ALL obvious information\n    - REMOVE: Standard commands, framework defaults, common patterns\n    - STRIP: Anything that doesn't require file reading to know\n    - EVALUATE: Each line - would an experienced dev be surprised?\n    - If not surprised, DELETE IT\n    - THEN: Add only truly non-obvious new discoveries\n    - Goal: File should be SHORTER and MORE VALUABLE\n    \n    Content should include:\n    - Header: \"# AGENTS.md\\n\\nThis file provides guidance to agents when working with code in this repository.\"\n    - Build/lint/test commands - ONLY if they differ from standard package.json scripts\n    - Code style - ONLY project-specific rules not covered by linter configs\n    - Custom utilities or patterns discovered by reading the code\n    - Non-standard directory structures or file organizations\n    - Project-specific conventions that violate typical practices\n    - Critical gotchas that would cause errors if not followed\n    \n    EXCLUDE obvious information like:\n    - Standard npm/yarn commands visible in package.json\n    - Framework defaults (e.g., \"React uses JSX\")\n    - Common patterns (e.g., \"tests go in __tests__ folders\")\n    - Information derivable from file extensions or directory names\n    \n    Keep it concise (aim for ~20 lines, but expand as needed for complex projects).\n    Include existing AI assistant rules from CLAUDE.md, Cursor rules (.cursor/rules/ or .cursorrules), or Copilot rules (.github/copilot-instructions.md).\n  </main_file>\n  \n  <mode_specific_files>\n    Create or deeply improve mode-specific AGENTS.md files IN THE PROJECT ROOT.\n    \n    CRITICAL: For each of these paths (RELATIVE TO PROJECT ROOT), check if the file exists FIRST:\n    - .roo/rules-code/AGENTS.md (create .roo in project root, not system root!)\n    - .roo/rules-debug/AGENTS.md (relative to project root)\n    - .roo/rules-ask/AGENTS.md (relative to project root)\n    - .roo/rules-architect/AGENTS.md (relative to project root)\n    \n    IMPORTANT: The .roo directory must be created in the current project/workspace root directory,\n    NOT at the system root (/) or home directory. All paths are relative to where the project is located.\n    \n    If files exist:\n    - AGGRESSIVELY DELETE obvious information\n    - Remove EVERYTHING that's standard practice\n    - Strip out framework defaults and common patterns\n    - Each remaining line must be surprising/non-obvious\n    - Only then add new non-obvious discoveries\n    - Files should become SHORTER, not longer\n    \n    Example structure (ALL IN PROJECT ROOT):\n    ```\n    project-root/\n    \u251c\u2500\u2500 AGENTS.md                    # General project guidance\n    \u251c\u2500\u2500 .roo/                        # IN PROJECT ROOT, NOT SYSTEM ROOT!\n    \u2502   \u251c\u2500\u2500 rules-code/\n    \u2502   \u2502   \u2514\u2500\u2500 AGENTS.md           # Code mode specific instructions\n    \u2502   \u251c\u2500\u2500 rules-debug/\n    \u2502   \u2502   \u2514\u2500\u2500 AGENTS.md           # Debug mode specific instructions\n    \u2502   \u251c\u2500\u2500 rules-ask/\n    \u2502   \u2502   \u2514\u2500\u2500 AGENTS.md           # Ask mode specific instructions\n    \u2502   \u2514\u2500\u2500 rules-architect/\n    \u2502       \u2514\u2500\u2500 AGENTS.md           # Architect mode specific instructions\n    \u251c\u2500\u2500 src/\n    \u251c\u2500\u2500 package.json\n    \u2514\u2500\u2500 ... other project files\n    ```\n    \n    .roo/rules-code/AGENTS.md - ONLY non-obvious coding rules discovered by reading files:\n    - Custom utilities that replace standard approaches\n    - Non-standard patterns unique to this project\n    - Hidden dependencies or coupling between components\n    - Required import orders or naming conventions not enforced by linters\n    \n    Example of non-obvious rules worth documenting:\n    ```\n    # Project Coding Rules (Non-Obvious Only)\n    - Always use safeWriteJson() from src/utils/ instead of JSON.stringify for file writes (prevents corruption)\n    - API retry mechanism in src/api/providers/utils/ is mandatory (not optional as it appears)\n    - Database queries MUST use the query builder in packages/evals/src/db/queries/ (raw SQL will fail)\n    - Provider interface in packages/types/src/ has undocumented required methods\n    - Test files must be in same directory as source for vitest to work (not in separate test folder)\n    ```\n    \n    .roo/rules-debug/AGENTS.md - ONLY non-obvious debugging discoveries:\n    - Hidden log locations not mentioned in docs\n    - Non-standard debugging tools or flags\n    - Gotchas that cause silent failures\n    - Required environment variables for debugging\n    \n    Example of non-obvious debug rules worth documenting:\n    ```\n    # Project Debug Rules (Non-Obvious Only)\n    - Webview dev tools accessed via Command Palette > \"Developer: Open Webview Developer Tools\" (not F12)\n    - IPC messages fail silently if not wrapped in try/catch in packages/ipc/src/\n    - Production builds require NODE_ENV=production or certain features break without error\n    - Database migrations must run from packages/evals/ directory, not root\n    - Extension logs only visible in \"Extension Host\" output channel, not Debug Console\n    ```\n    \n    .roo/rules-ask/AGENTS.md - ONLY non-obvious documentation context:\n    - Hidden or misnamed documentation\n    - Counterintuitive code organization\n    - Misleading folder names or structures\n    - Important context not evident from file structure\n    \n    Example of non-obvious documentation rules worth documenting:\n    ```\n    # Project Documentation Rules (Non-Obvious Only)\n    - \"src/\" contains VSCode extension code, not source for web apps (counterintuitive)\n    - Provider examples in src/api/providers/ are the canonical reference (docs are outdated)\n    - UI runs in VSCode webview with restrictions (no localStorage, limited APIs)\n    - Package.json scripts must be run from specific directories, not root\n    - Locales in root are for extension, webview-ui/src/i18n for UI (two separate systems)\n    ```\n    \n    .roo/rules-architect/AGENTS.md - ONLY non-obvious architectural constraints:\n    - Hidden coupling between components\n    - Undocumented architectural decisions\n    - Non-standard patterns that must be followed\n    - Performance bottlenecks discovered through investigation\n    \n    Example of non-obvious architecture rules worth documenting:\n    ```\n    # Project Architecture Rules (Non-Obvious Only)\n    - Providers MUST be stateless - hidden caching layer assumes this\n    - Webview and extension communicate through specific IPC channel patterns only\n    - Database migrations cannot be rolled back - forward-only by design\n    - React hooks required because external state libraries break webview isolation\n    - Monorepo packages have circular dependency on types package (intentional)\n    ```\n  </mode_specific_files>\n</output_structure>\n\n<quality_criteria>\n  - ONLY include non-obvious information discovered by reading files\n  - Exclude anything that could be guessed from standard practices\n  - Focus on gotchas, hidden requirements, and counterintuitive patterns\n  - Include specific file paths when referencing custom utilities\n  - Be extremely concise - if it's obvious, don't include it\n  - Every line should prevent a potential mistake or confusion\n  - Test: Would an experienced developer be surprised by this information?\n  - If updating existing files: DELETE obvious info first, files should get SHORTER\n  - Measure success: Is the file more concise and valuable than before?\n</quality_criteria>\n\nRemember: The goal is to create documentation that enables AI assistants to be immediately productive in this codebase, focusing on project-specific knowledge that isn't obvious from the code structure alone.            ", "built-in", "<built-in:init>", "Analyze codebase and create concise AGENTS.md files for AI assistants", null)));

    public static final /* synthetic */ Map access$getBUILT_IN_COMMANDS$p() {
        return BUILT_IN_COMMANDS;
    }
}

