/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.composer.tools.file;

import cn.gitlab.kilo.jetbrains.composer.service.FileService;
import cn.gitlab.kilo.jetbrains.composer.tools.BaseToolExecutor;
import cn.gitlab.kilo.jetbrains.composer.tools.DescriptionContext;
import cn.gitlab.kilo.jetbrains.composer.tools.ToolContext;
import cn.gitlab.kilo.jetbrains.composer.tools.ToolName;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0094@\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcn/gitlab/kilo/jetbrains/composer/tools/file/ReplaceInFileTool;", "Lcn/gitlab/kilo/jetbrains/composer/tools/BaseToolExecutor;", "<init>", "()V", "getRequiredParameters", "", "", "doExecute", "", "context", "Lcn/gitlab/kilo/jetbrains/composer/tools/ToolContext;", "(Lcn/gitlab/kilo/jetbrains/composer/tools/ToolContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getDescription", "Lcn/gitlab/kilo/jetbrains/composer/tools/DescriptionContext;", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nReplaceInFileTool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReplaceInFileTool.kt\ncn/gitlab/kilo/jetbrains/composer/tools/file/ReplaceInFileTool\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,98:1\n31#2,2:99\n*S KotlinDebug\n*F\n+ 1 ReplaceInFileTool.kt\ncn/gitlab/kilo/jetbrains/composer/tools/file/ReplaceInFileTool\n*L\n19#1:99,2\n*E\n"})
public final class ReplaceInFileTool
extends BaseToolExecutor {
    public ReplaceInFileTool() {
        super(ToolName.REPLACE_IN_FILE);
    }

    @Override
    @NotNull
    public List<String> getRequiredParameters() {
        Object[] objectArray = new String[]{"path", "diff"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @Nullable
    protected Object doExecute(@NotNull ToolContext context, @NotNull Continuation<? super Unit> $completion) {
        ComponentManager $this$service$iv = (ComponentManager)context.getProject();
        boolean $i$f$service = false;
        Class<FileService> serviceClass$iv = FileService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        FileService fileService = (FileService)object;
        Object object2 = fileService.handleWriteOrReplaceFile(context.getBlock(), context.getComposer(), $completion);
        if (object2 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object2;
        }
        return Unit.INSTANCE;
    }

    @Override
    @NotNull
    public String getDescription(@NotNull DescriptionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return StringsKt.trimIndent((String)("\n## replace_in_file\nDescription: Request to replace sections of content in an existing file using SEARCH/REPLACE blocks that define exact changes to specific parts of the file. This tool should be used when you need to make targeted changes to specific parts of a file.\nParameters:\n- path: (required) The path of the file to modify (relative to the current working directory " + context.getCwd() + ")\n- diff: (required) One or more SEARCH/REPLACE blocks following this exact format:\n  ```\n  <<<<<<< SEARCH\n  [exact content to find]\n  =======\n  [new content to replace with]\n  >>>>>>> REPLACE\n  ```\n  Critical rules:\n  1. SEARCH content must match the associated file section to find EXACTLY:\n     * Match character-for-character including whitespace, indentation, line endings\n     * Include all comments, docstrings, etc.\n  2. SEARCH/REPLACE blocks will ONLY replace the first match occurrence.\n     * Including multiple unique SEARCH/REPLACE blocks if you need to make multiple changes.\n     * Include *just* enough lines in each SEARCH section to uniquely match each set of lines that need to change.\n     * When using multiple SEARCH/REPLACE blocks, list them in the order they appear in the file.\n  3. Keep SEARCH/REPLACE blocks concise:\n     * Break large SEARCH/REPLACE blocks into a series of smaller blocks that each change a small portion of the file.\n     * Include just the changing lines, and a few surrounding lines if needed for uniqueness.\n     * Do not include long runs of unchanging lines in SEARCH/REPLACE blocks.\n     * Each line must be complete. Never truncate lines mid-way through as this can cause matching failures.\n  4. Special operations:\n     * To move code: Use two SEARCH/REPLACE blocks (one to delete from original + one to insert at new location)\n     * To delete code: Use empty REPLACE section\nUsage:\n<replace_in_file>\n<path>File path here</path>\n<diff>\nSearch and replace blocks here\n</diff>\n</replace_in_file>\n\nExample: Requesting to make targeted edits to a file\n\n<replace_in_file>\n<path>src/components/App.tsx</path>\n<diff>\n<<<<<<< SEARCH\nimport React from 'react';\n=======\nimport React, { useState } from 'react';\n>>>>>>> REPLACE\n\n<<<<<<< SEARCH\nfunction handleSubmit() {\n  saveData();\n  setLoading(false);\n}\n\n=======\n>>>>>>> REPLACE\n\n<<<<<<< SEARCH\nreturn (\n  <div>\n=======\nfunction handleSubmit() {\n  saveData();\n  setLoading(false);\n}\n\nreturn (\n  <div>\n>>>>>>> REPLACE\n</diff>\n</replace_in_file>\n"));
    }
}

