/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.composer.tools.browser;

import cn.gitlab.kilo.jetbrains.composer.dto.ContentBlock;
import cn.gitlab.kilo.jetbrains.composer.tools.BaseToolExecutor;
import cn.gitlab.kilo.jetbrains.composer.tools.DescriptionContext;
import cn.gitlab.kilo.jetbrains.composer.tools.ToolContext;
import cn.gitlab.kilo.jetbrains.composer.tools.ToolName;
import com.intellij.ide.BrowserUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0094@\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcn/gitlab/kilo/jetbrains/composer/tools/browser/BrowserActionTool;", "Lcn/gitlab/kilo/jetbrains/composer/tools/BaseToolExecutor;", "<init>", "()V", "getRequiredParameters", "", "", "getOptionalParameters", "doExecute", "", "context", "Lcn/gitlab/kilo/jetbrains/composer/tools/ToolContext;", "(Lcn/gitlab/kilo/jetbrains/composer/tools/ToolContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getDescription", "Lcn/gitlab/kilo/jetbrains/composer/tools/DescriptionContext;", "coderider-kilo-jetbrains"})
public final class BrowserActionTool
extends BaseToolExecutor {
    public BrowserActionTool() {
        super(ToolName.BROWSER_ACTION);
    }

    @Override
    @NotNull
    public List<String> getRequiredParameters() {
        return CollectionsKt.listOf((Object)"action");
    }

    @Override
    @NotNull
    public List<String> getOptionalParameters() {
        Object[] objectArray = new String[]{"url", "coordinate", "text", "size"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @Nullable
    protected Object doExecute(@NotNull ToolContext context, @NotNull Continuation<? super Unit> $completion) {
        if (!context.isPartial()) {
            String string = context.getParam("url");
            if (string == null) {
                return Unit.INSTANCE;
            }
            String url = string;
            try {
                BrowserUtil.browse((String)url);
                boolean bl = context.getComposer().getUserMessageContent().add(new ContentBlock("text", "\u2705 \u6253\u5f00\u6d4f\u89c8\u5668\u8bbf\u95ee\uff1a`" + url + "`", false, null, null, false, null, null, null, null, null, 2044, null));
            }
            catch (Exception e) {
                boolean bl = context.getComposer().getUserMessageContent().add(new ContentBlock("text", "\u274c \u65e0\u6cd5\u6253\u5f00\u6d4f\u89c8\u5668\u8bbf\u95ee\uff1a`" + url + "`\n\u9519\u8bef\u4fe1\u606f\uff1a" + e.getLocalizedMessage(), false, null, null, false, null, null, null, null, null, 2044, null));
            }
        }
        return Unit.INSTANCE;
    }

    @Override
    @NotNull
    public String getDescription(@NotNull DescriptionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int viewportW = context.getBrowserSettings().getViewport().getWidth();
        int viewportH = context.getBrowserSettings().getViewport().getHeight();
        return StringsKt.trimIndent((String)("\n## browser_action\nDescription: Request to interact with a Puppeteer\u2011controlled browser. Every action, except `close`, will be responded to with a screenshot of the browser's current state, along with any new console logs. You may only perform one browser action per message, and wait for the user's response including a screenshot and logs to determine the next action.\n- The sequence of actions **must always start with** launching the browser at a URL, and **must always end with** closing the browser. If you need to visit a new URL that is not possible to navigate to from the current webpage, you must first close the browser, then launch again at the new URL.\n- While the browser is active, only the `browser_action` tool can be used. No other tools should be called during this time. You may proceed to use other tools only after closing the browser. For example if you run into an error and need to fix a file, you must close the browser, then use other tools to make the necessary changes, then re\u2011launch the browser to verify the result.\n- The browser window has a resolution of **" + viewportW + " x " + viewportH + "** pixels. When performing any click actions, ensure the coordinates are within this resolution range.\n- Before clicking on any elements such as icons, links, or buttons, you must consult the provided screenshot of the page to determine the coordinates of the element. The click should be targeted at the **center of the element**, not on its edges.\nParameters:\n- action: (required) The action to perform. The available actions are:\n    * launch: Launch a new Puppeteer\u2011controlled browser instance at the specified URL. This **must always be the first action**.\n        - Use with the `url` parameter to provide the URL.\n        - Ensure the URL is valid and includes the appropriate protocol (e.g. http://localhost:3000/page, file:///path/to/file.html, etc.)\n    * click: Click at a specific x,y coordinate.\n        - Use with the `coordinate` parameter to specify the location.\n        - Always click in the center of an element (icon, button, link, etc.) based on coordinates derived from a screenshot.\n    * type: Type a string of text on the keyboard. You might use this after clicking on a text field to input text.\n        - Use with the `text` parameter to provide the string to type.\n    * scroll_down: Scroll down the page by one page height.\n    * scroll_up: Scroll up the page by one page height.\n    * close: Close the Puppeteer\u2011controlled browser instance. This **must always be the final browser action**.\n        - Example: `<action>close</action>`\n- url: (optional) Use this for providing the URL for the `launch` action.\n    * Example: <url>https://example.com</url>\n- coordinate: (optional) The X and Y coordinates for the `click` action. Coordinates should be within the **" + viewportW + " x " + viewportH + "** resolution.\n    * Example: <coordinate>450,300</coordinate>\n- text: (optional) Use this for providing the text for the `type` action.\n    * Example: <text>Hello, world!</text>\nUsage:\n<browser_action>\n<action>Action to perform (e.g., launch, click, type, scroll_down, scroll_up, close)</action>\n<url>URL to launch the browser at (optional)</url>\n<coordinate>x,y coordinates (optional)</coordinate>\n<text>Text to type (optional)</text>\n</browser_action>\n"));
    }
}

