/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.composer.tools;

import cn.gitlab.kilo.jetbrains.composer.mode.ComposerMode;
import cn.gitlab.kilo.jetbrains.composer.mode.ComposerModeKt;
import cn.gitlab.kilo.jetbrains.composer.mode.ModeProvider;
import cn.gitlab.kilo.jetbrains.composer.tools.ToolContext;
import cn.gitlab.kilo.jetbrains.composer.tools.ToolDefinitions;
import cn.gitlab.kilo.jetbrains.composer.tools.ToolDescription;
import cn.gitlab.kilo.jetbrains.composer.tools.ToolExecutor;
import cn.gitlab.kilo.jetbrains.composer.tools.ToolGroup;
import cn.gitlab.kilo.jetbrains.composer.tools.ToolName;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 .2\u00020\u0001:\u0001.B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tJ\u001f\u0010\r\u001a\u00020\u000b2\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\u000e\"\u00020\t\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\bJ\u0010\u0010\u0013\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0012\u001a\u00020\bJ\u0010\u0010\u0014\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\bJ\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u001aJ\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\b0\u001a2\u0006\u0010\u001c\u001a\u00020\u001dJ\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00160\u001aJ\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00160 J\u001e\u0010!\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020#H\u0086@\u00a2\u0006\u0002\u0010$J.\u0010%\u001a\b\u0012\u0004\u0012\u00020\b0 2\u0006\u0010&\u001a\u00020'2\u0018\b\u0002\u0010(\u001a\u0012\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00010)j\u0002`*J\u001c\u0010+\u001a\u00020\u0018*\u0012\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00010)j\u0002`*H\u0002J\u001c\u0010,\u001a\u00020\u0018*\u0012\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00010)j\u0002`*H\u0002J\u001c\u0010-\u001a\u00020\u0018*\u0012\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00010)j\u0002`*H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcn/gitlab/kilo/jetbrains/composer/tools/ToolRegistry;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "tools", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcn/gitlab/kilo/jetbrains/composer/tools/ToolName;", "Lcn/gitlab/kilo/jetbrains/composer/tools/ToolExecutor;", "register", "", "tool", "registerAll", "", "([Lcn/gitlab/kilo/jetbrains/composer/tools/ToolExecutor;)V", "getDescription", "Lcn/gitlab/kilo/jetbrains/composer/tools/ToolDescription;", "toolName", "getExecutor", "getExecutorByIdentifier", "identifier", "", "isRegistered", "", "getRegisteredTools", "", "getRegisteredToolsInGroup", "group", "Lcn/gitlab/kilo/jetbrains/composer/tools/ToolGroup;", "getAllToolIdentifiers", "getAllKnownParamNames", "", "execute", "context", "Lcn/gitlab/kilo/jetbrains/composer/tools/ToolContext;", "(Ljava/lang/String;Lcn/gitlab/kilo/jetbrains/composer/tools/ToolContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getAvailableTools", "mode", "Lcn/gitlab/kilo/jetbrains/composer/mode/ComposerMode;", "settings", "", "Lcn/gitlab/kilo/jetbrains/composer/tools/Settings;", "isSupportsComputerUse", "isMcpMode", "isMemoryEnabled", "Companion", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nToolRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToolRegistry.kt\ncn/gitlab/kilo/jetbrains/composer/tools/ToolRegistry\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,177:1\n13472#2,2:178\n774#3:180\n865#3,2:181\n1563#3:183\n1634#3,3:184\n1869#3,2:187\n774#3:189\n865#3:190\n866#3:192\n1869#3,2:193\n1#4:191\n*S KotlinDebug\n*F\n+ 1 ToolRegistry.kt\ncn/gitlab/kilo/jetbrains/composer/tools/ToolRegistry\n*L\n34#1:178,2\n89#1:180\n89#1:181,2\n96#1:183\n96#1:184,3\n105#1:187,2\n138#1:189\n138#1:190\n138#1:192\n141#1:193,2\n*E\n"})
public final class ToolRegistry {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ConcurrentHashMap<ToolName, ToolExecutor> tools;

    public ToolRegistry(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.tools = new ConcurrentHashMap();
    }

    public final void register(@NotNull ToolExecutor tool) {
        Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
        ((Map)this.tools).put(tool.getToolName(), tool);
    }

    public final void registerAll(ToolExecutor ... tools) {
        Intrinsics.checkNotNullParameter((Object)tools, (String)"tools");
        ToolExecutor[] $this$forEach$iv = tools;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            ToolExecutor element$iv;
            ToolExecutor it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            this.register(it);
        }
    }

    @Nullable
    public final ToolDescription getDescription(@NotNull ToolName toolName) {
        Intrinsics.checkNotNullParameter((Object)((Object)toolName), (String)"toolName");
        return this.tools.get((Object)toolName);
    }

    @Nullable
    public final ToolExecutor getExecutor(@NotNull ToolName toolName) {
        Intrinsics.checkNotNullParameter((Object)((Object)toolName), (String)"toolName");
        return this.tools.get((Object)toolName);
    }

    @Nullable
    public final ToolExecutor getExecutorByIdentifier(@NotNull String identifier) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        ToolName toolName = ToolName.Companion.fromIdentifier(identifier);
        if (toolName == null) {
            return null;
        }
        ToolName toolName2 = toolName;
        return this.getExecutor(toolName2);
    }

    public final boolean isRegistered(@NotNull ToolName toolName) {
        Intrinsics.checkNotNullParameter((Object)((Object)toolName), (String)"toolName");
        return this.tools.containsKey((Object)toolName);
    }

    @NotNull
    public final List<ToolName> getRegisteredTools() {
        Set set2 = this.tools.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"<get-keys>(...)");
        return CollectionsKt.toList((Iterable)set2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ToolName> getRegisteredToolsInGroup(@NotNull ToolGroup group) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)group), (String)"group");
        List<ToolName> groupTools = ToolDefinitions.INSTANCE.getToolsInGroup(group);
        Iterable $this$filter$iv = groupTools;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ToolName it = (ToolName)((Object)element$iv$iv);
            boolean bl = false;
            if (!this.isRegistered(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getAllToolIdentifiers() {
        void $this$mapTo$iv$iv;
        Set set2 = this.tools.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"<get-keys>(...)");
        Iterable $this$map$iv = set2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ToolName toolName = (ToolName)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toIdentifier());
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final Set<String> getAllKnownParamNames() {
        Set names = new LinkedHashSet();
        Collection<ToolExecutor> collection = this.tools.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ToolExecutor exec = (ToolExecutor)element$iv;
            boolean bl = false;
            names.addAll((Collection)exec.getRequiredParameters());
            names.addAll((Collection)exec.getOptionalParameters());
        }
        return names;
    }

    @Nullable
    public final Object execute(@NotNull String identifier, @NotNull ToolContext context, @NotNull Continuation<? super Unit> $completion) {
        ToolExecutor toolExecutor = this.getExecutorByIdentifier(identifier);
        if (toolExecutor == null) {
            throw new IllegalArgumentException("Unknown tool: " + identifier);
        }
        ToolExecutor executor = toolExecutor;
        Object object = executor.execute(context, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<ToolName> getAvailableTools(@NotNull ComposerMode mode, @NotNull Map<String, ? extends Object> settings) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        Intrinsics.checkNotNullParameter(settings, (String)"settings");
        Iterable $this$filter$iv = this.getRegisteredTools();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Object object;
            Object $this$getAvailableTools_u24lambda_u246_u24lambda_u244;
            ToolName it = (ToolName)((Object)element$iv$iv);
            boolean bl = false;
            Object object2 = this;
            try {
                $this$getAvailableTools_u24lambda_u246_u24lambda_u244 = object2;
                boolean bl2 = false;
                $this$getAvailableTools_u24lambda_u246_u24lambda_u244 = Result.constructor-impl((Object)ComposerModeKt.isToolAllowedFromMode$default(it.toIdentifier(), new ModeProvider(mode), null, null, null, 28, null));
            }
            catch (Throwable bl2) {
                $this$getAvailableTools_u24lambda_u246_u24lambda_u244 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
            }
            object2 = $this$getAvailableTools_u24lambda_u246_u24lambda_u244;
            if (Result.exceptionOrNull-impl((Object)object2) == null) {
                object = object2;
            } else {
                boolean bl3 = false;
                object = false;
            }
            if (!((Boolean)object).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        LinkedHashSet tools = ai.grazie.utils.CollectionsKt.toLinkedSet((Iterable)((List)destination$iv$iv));
        Iterable $this$forEach$iv = ToolDefinitions.INSTANCE.getALWAYS_AVAILABLE_TOOLS();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ToolName tool = (ToolName)((Object)element$iv);
            boolean bl = false;
            tools.add(tool);
        }
        if (!this.isSupportsComputerUse(settings)) {
            tools.remove((Object)ToolName.BROWSER_ACTION);
        }
        if (!this.isMcpMode(settings)) {
            tools.remove((Object)ToolName.USE_MCP_TOOL);
            tools.remove((Object)ToolName.ACCESS_MCP_RESOURCE);
        }
        if (!this.isMemoryEnabled(settings)) {
            tools.remove((Object)ToolName.CREATE_MEMORY);
        }
        return tools;
    }

    public static /* synthetic */ Set getAvailableTools$default(ToolRegistry toolRegistry, ComposerMode composerMode, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        return toolRegistry.getAvailableTools(composerMode, map);
    }

    private final boolean isSupportsComputerUse(Map<String, ? extends Object> $this$isSupportsComputerUse) {
        Object object = $this$isSupportsComputerUse.get("supportsComputerUse");
        Boolean bl = object instanceof Boolean ? (Boolean)object : null;
        return bl != null ? bl : false;
    }

    private final boolean isMcpMode(Map<String, ? extends Object> $this$isMcpMode) {
        Object object = $this$isMcpMode.get("mcpMode");
        String mcpMode = object instanceof String ? (String)object : null;
        return mcpMode != null && !Intrinsics.areEqual((Object)mcpMode, (Object)"off");
    }

    private final boolean isMemoryEnabled(Map<String, ? extends Object> $this$isMemoryEnabled) {
        Object object = $this$isMemoryEnabled.get("memoryEnabled");
        Boolean bl = object instanceof Boolean ? (Boolean)object : null;
        return bl != null ? bl : false;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcn/gitlab/kilo/jetbrains/composer/tools/ToolRegistry$Companion;", "", "<init>", "()V", "getInstance", "Lcn/gitlab/kilo/jetbrains/composer/tools/ToolRegistry;", "project", "Lcom/intellij/openapi/project/Project;", "coderider-kilo-jetbrains"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ToolRegistry getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(ToolRegistry.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (ToolRegistry)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

