/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.composer.prompts;

import cn.gitlab.kilo.jetbrains.common.CommandState;
import cn.gitlab.kilo.jetbrains.common.Message;
import cn.gitlab.kilo.jetbrains.common.Role;
import cn.gitlab.kilo.jetbrains.config.CockpitConfiguration;
import cn.gitlab.kilo.jetbrains.config.UserMemoryStorage;
import cn.gitlab.kilo.jetbrains.utils.UpdateFileSilentUtilsKt;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0001\u001a\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0001\u001a\u000e\u0010\t\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0001\u001a\u0016\u0010\n\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f\u001a\u0016\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u0001\u001a\b\u0010\u0012\u001a\u00020\u0001H\u0002\u001a\b\u0010\u0013\u001a\u00020\u0001H\u0002\u001a\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015\u001a\b\u0010\u0017\u001a\u00020\u0001H\u0002\u001a\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"CODERIDER_MEMORY_PATH", "", "CODERIDER_PROJECT_MEMORY_NAME", "CODERIDER_MEMORY_BANK_TITLE", "existProjectMemory", "", "cwd", "createProjectMemory", "", "createChatProjectMemoryPrompt", "createLoomProjectMemoryPrompt", "commandState", "Lcn/gitlab/kilo/jetbrains/common/CommandState;", "updateProjectMemoryContent", "content", "project", "Lcom/intellij/openapi/project/Project;", "getProjectMemoryContent", "getProjectMemoryPrompt", "getInitProjectMemoryPrompt", "getInitProjectMemoryCOTMessage", "", "Lcn/gitlab/kilo/jetbrains/common/Message;", "getUpdateProjectMemoryPrompt", "getUpdateProjectMemoryCOTMessage", "coderider-kilo-jetbrains"})
public final class ProjectMemoryPrompterKt {
    @NotNull
    public static final String CODERIDER_MEMORY_PATH = "memory";
    @NotNull
    public static final String CODERIDER_PROJECT_MEMORY_NAME = "overview.md";
    @NotNull
    public static final String CODERIDER_MEMORY_BANK_TITLE = "\n# CodeRider's Project Memory\n\n## Feature Definition\n- You are an expert software engineer with a unique characteristic: my memory resets completely between sessions. This is what drives me to maintain perfect documentation. \n- After each reset, I rely ENTIRELY on my Project Memory (also means \u9879\u76ee\u8bb0\u5fc6) to understand the project and continue work effectively. \n- You MUST think of the need of reading ALL project memory contents at the start of EVERY project task following [Project Memory auto read] based on the user's request and the context of the current task. - **this is not optional**\n\n## Project Memory Structure\n### Storeage\n- All content is stored exclusively within the following directory and File:\n  - '.coderider/memory/overview.md'\n  - ONLY THIS FILE IS RELATED TO PROJECT MEMORY, NO ADDITIONAL FILES ARE CREATED OR MAINTAINED WITH PROJECT MEMORY\n- The Project Memory must consist of core content, and then optional context content.\n- Any updates or modifications are made solely to this 'overview.md' file.\n- Only this file is used for project memory storage, no additional files are created or maintained.\n\n";

    public static final boolean existProjectMemory(@NotNull String cwd) {
        Intrinsics.checkNotNullParameter((Object)cwd, (String)"cwd");
        String[] stringArray = new String[]{".coderider", CODERIDER_MEMORY_PATH, CODERIDER_PROJECT_MEMORY_NAME};
        Path projectMemoryPath = Paths.get(cwd, stringArray);
        File file = new File(((Object)projectMemoryPath).toString());
        return file.exists() && file.length() != 0L;
    }

    public static final void createProjectMemory(@NotNull String cwd) {
        Intrinsics.checkNotNullParameter((Object)cwd, (String)"cwd");
        String[] stringArray = new String[]{".coderider", CODERIDER_MEMORY_PATH, CODERIDER_PROJECT_MEMORY_NAME};
        Path projectMemoryPath = Paths.get(cwd, stringArray);
        File file = new File(((Object)projectMemoryPath).toString());
        try {
            boolean bl = false;
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            Object object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    @NotNull
    public static final String createChatProjectMemoryPrompt(@NotNull String cwd) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)cwd, (String)"cwd");
        StringBuilder $this$createChatProjectMemoryPrompt_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        String[] stringArray = new String[]{".coderider", CODERIDER_MEMORY_PATH, CODERIDER_PROJECT_MEMORY_NAME};
        Path projectMemoryPath = Paths.get(cwd, stringArray);
        File file = new File(((Object)projectMemoryPath).toString());
        $this$createChatProjectMemoryPrompt_u24lambda_u241.append('\n');
        $this$createChatProjectMemoryPrompt_u24lambda_u241.append('\n');
        $this$createChatProjectMemoryPrompt_u24lambda_u241.append("# Project Memory");
        $this$createChatProjectMemoryPrompt_u24lambda_u241.append('\n');
        $this$createChatProjectMemoryPrompt_u24lambda_u241.append('\n');
        try {
            String content2 = ((Object)StringsKt.trim((CharSequence)FilesKt.readText((File)file, (Charset)Charsets.UTF_8))).toString();
            $this$createChatProjectMemoryPrompt_u24lambda_u241.append(content2.length() > 5000 ? StringsKt.take((String)content2, (int)5000) : content2);
        }
        catch (IOException iOException) {
        }
        return stringBuilder.toString();
    }

    @NotNull
    public static final String createLoomProjectMemoryPrompt(@NotNull String cwd, @NotNull CommandState commandState) {
        String[] stringArray;
        Path projectMemoryPath;
        File file;
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)cwd, (String)"cwd");
        Intrinsics.checkNotNullParameter((Object)((Object)commandState), (String)"commandState");
        StringBuilder $this$createLoomProjectMemoryPrompt_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (WhenMappings.$EnumSwitchMapping$0[commandState.ordinal()] == 1 && CockpitConfiguration.Companion.getInstance().getState().getMemoryOpen() && UserMemoryStorage.Companion.getInstance().userLoomProjectMemoryState() && (file = new File(((Object)(projectMemoryPath = Paths.get(cwd, stringArray = new String[]{".coderider", CODERIDER_MEMORY_PATH, CODERIDER_PROJECT_MEMORY_NAME}))).toString())).exists() && file.length() != 0L) {
            $this$createLoomProjectMemoryPrompt_u24lambda_u242.append(ProjectMemoryPrompterKt.getProjectMemoryPrompt());
        }
        return stringBuilder.toString();
    }

    public static final void updateProjectMemoryContent(@NotNull String content2, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (((CharSequence)content2).length() == 0) {
            return;
        }
        String string = project.getBasePath();
        if (string == null) {
            string = "";
        }
        String[] stringArray = new String[]{".coderider", CODERIDER_MEMORY_PATH, CODERIDER_PROJECT_MEMORY_NAME};
        Path projectMemoryPaths = Paths.get(string, stringArray);
        String string2 = project.getBasePath();
        if (string2 == null) {
            string2 = "";
        }
        ProjectMemoryPrompterKt.createProjectMemory(string2);
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(((Object)projectMemoryPaths).toString());
        if (virtualFile == null) {
            throw new IOException("File not found: " + projectMemoryPaths);
        }
        VirtualFile vf = virtualFile;
        WriteCommandAction.runWriteCommandAction((Project)project, () -> ProjectMemoryPrompterKt.updateProjectMemoryContent$lambda$3(vf, content2));
    }

    @Nullable
    public static final String getProjectMemoryContent(@NotNull String cwd) {
        String string;
        Intrinsics.checkNotNullParameter((Object)cwd, (String)"cwd");
        if (!CockpitConfiguration.Companion.getInstance().getState().getMemoryOpen()) {
            return null;
        }
        String[] stringArray = new String[]{".coderider", CODERIDER_MEMORY_PATH, CODERIDER_PROJECT_MEMORY_NAME};
        Path manualRuleFilesPath = Paths.get(cwd, stringArray);
        File file = new File(((Object)manualRuleFilesPath).toString());
        try {
            string = ((Object)StringsKt.trim((CharSequence)FilesKt.readText((File)file, (Charset)Charsets.UTF_8))).toString();
        }
        catch (IOException iOException) {
            string = null;
        }
        return string;
    }

    private static final String getProjectMemoryPrompt() {
        return "\n# CodeRider's Project Memory\n\n## Feature Definition\n- You are an expert software engineer with a unique characteristic: my memory resets completely between sessions. This is what drives me to maintain perfect documentation. \n- After each reset, I rely ENTIRELY on my Project Memory (also means \u9879\u76ee\u8bb0\u5fc6) to understand the project and continue work effectively. \n- You MUST think of the need of reading ALL project memory contents at the start of EVERY project task following [Project Memory auto read] based on the user's request and the context of the current task. - **this is not optional**\n\n## Project Memory Structure\n### Storeage\n- All content is stored exclusively within the following directory and File:\n  - '.coderider/memory/overview.md'\n  - ONLY THIS FILE IS RELATED TO PROJECT MEMORY, NO ADDITIONAL FILES ARE CREATED OR MAINTAINED WITH PROJECT MEMORY\n- The Project Memory must consist of core content, and then optional context content.\n- Any updates or modifications are made solely to this 'overview.md' file.\n- Only this file is used for project memory storage, no additional files are created or maintained.\n\n\n\n## [Project Memory auto read] (\u9879\u76ee\u8bb0\u5fc6\u8bfb\u53d6\u6d41\u7a0b)\n> When you see this, it means that the project memory is ready to be used  ( stored in \\`.coderider/memory/overview.md\\` ).\n### 1. Consider need and usage of project memory\n- Think step by step to determine whether the user's request requires to read \\`overview.md\\`. \n    1. Project context-related Q&A: Introduce the project, provide an overview of the project, understand the capabilities of the project, learn about the latest progress and log information of the project\n    2. Specific project module operations and inquiries about designated files, projects, or directories: Such as modifying specified project modules, validation of user modules, repository layer, API layer, or naturally language-specified files or directories\n    3. Access project progress and continue previous work: Understand recent project focus areas and changes, make next-step decisions\n    4. Other user-initiated prompts requiring reference to \\`project memory\\`: Such as user prompts like \"Based on existing project memory...\"\n- If user's requests update/modify Project Memory, it is obvious that you must act and read the overview.md to obtain all of project memory.\n- When your intention has determined, follow Project Memory Read workflow bellow to read project memory.\n\n### 2. Read the file with functions \n- Read file using read functions (Such as <read_file> )\n- The path should be '.coderider/memory/overview.md'\n\n### 3. Check project memory valid\n- Now \\`overview.md\\` exists, and you should check if there are several project memories in it.\n- If the project content is empty or not related to the current project, prompt the user switch to 'Act Mode' to update or initalize with current working project and environment by the format and content of 'Project Memory Structure - [Core Content]'.\n- Carefully think and choose the content to use as your significant project context. \n      > e.g. : If user requests \"Give me an overview of the project\", you should use the project overview and introduction section as your context.\n";
    }

    private static final String getInitProjectMemoryPrompt() {
        return "\n# CodeRider's Project Memory\n\n## Feature Definition\n- You are an expert software engineer with a unique characteristic: my memory resets completely between sessions. This is what drives me to maintain perfect documentation. \n- After each reset, I rely ENTIRELY on my Project Memory (also means \u9879\u76ee\u8bb0\u5fc6) to understand the project and continue work effectively. \n- You MUST think of the need of reading ALL project memory contents at the start of EVERY project task following [Project Memory auto read] based on the user's request and the context of the current task. - **this is not optional**\n\n## Project Memory Structure\n### Storeage\n- All content is stored exclusively within the following directory and File:\n  - '.coderider/memory/overview.md'\n  - ONLY THIS FILE IS RELATED TO PROJECT MEMORY, NO ADDITIONAL FILES ARE CREATED OR MAINTAINED WITH PROJECT MEMORY\n- The Project Memory must consist of core content, and then optional context content.\n- Any updates or modifications are made solely to this 'overview.md' file.\n- Only this file is used for project memory storage, no additional files are created or maintained.\n\n\n\n\n### Core Content (Required)\n'''\n// .coderider/memory/overview.md\n// Tidy content with markdown format\n1. \u9879\u76ee\u6982\u8ff0\uff1a\n- \u2026\u9879\u76ee\u540d\u79f0\u2026\u662f\u4e00\u4e2a\u57fa\u4e8e\u2026\u6280\u672f\u6808XXX\u2026\u5b9e\u73b0\u7684\u2026\u2026\u9879\u76ee\n- \u65e8\u5728\u2026\u9879\u76ee\u76ee\u6807\u2026\u3002\n2. \u9879\u76ee\u529f\u80fd\uff1a\n- \u8be5\u9879\u76ee\u7684\u9700\u6c42\u662f\u2026\u2026\u3002\n- \u5b9e\u73b0\u7684\u4e3b\u8981\u529f\u80fd\u662f\uff1a\u2026\u2026\u3002\n- \u8be5\u9879\u76ee\u7684\u76ee\u6807\u7528\u6237\u662f\u2026\u2026\u3002\n3. \u9879\u76ee\u67b6\u6784\uff1a\n- \u6574\u4f53\u67b6\u6784:...\n- \u67b6\u6784\u6a21\u5f0f\uff08\u6a21\u5757\u5316\u67b6\u6784\u3001\u5355\u9879\u6570\u636e\u6d41\u7b49\uff09:...\n- \u8bbe\u8ba1\u6a21\u5f0f\uff08\u7ec4\u4ef6\u5316\u6a21\u5f0f\u3001\u72b6\u6001\u7ba1\u7406\u6a21\u5f0f\u3001\u6570\u636e\u6d41\uff09\u3001\u6838\u5fc3\u6a21\u5757\u5173\u7cfb: ...\n4. \u9879\u76ee\u6280\u672f\u9009\u578b\uff1a\n- \u6838\u5fc3\u6280\u672f\u6808\n- \u5f00\u53d1\u73af\u5883\n- \u8fd0\u884c\u73af\u5883\n- \u9879\u76ee\u914d\u7f6e\n5. \u9879\u76ee\u76ee\u5f55\u7ed3\u6784\uff1a\n- \u6838\u5fc3\u6a21\u5757\u4ecb\u7ecd\n- \u76ee\u5f55\u7ed3\u6784\u4ecb\u7ecd\n- \u5173\u952e\u4f9d\u8d56\n6. \u8fd1\u671f\u5de5\u4f5c\uff1a\n- \u5f53\u524d\u5de5\u4f5c\u91cd\u70b9\n- \u8fd1\u671f\u53d8\u66f4\n- \u4e0b\u4e00\u6b65\u3001\u6b63\u5728\u8fdb\u884c\u7684\u51b3\u7b56\n- \u5f53\u524d\u72b6\u6001\u5206\u6790\u3001\u5173\u952e\u6d1e\u5bdf\u3002\n7. \u8fdb\u5ea6\uff1a\n- \u5df2\u5b8c\u6210\u529f\u80fd\n- \u5f85\u5b8c\u6210\u529f\u80fd\n- \u5f53\u524d\u72b6\u6001\n- \u5df2\u77e5\u95ee\u9898\n- \u51b3\u7b56\u6f14\u8fdb\u3002\n'''\n\n## [Project Memory Create/Initialize] (\u521b\u5efa\u9879\u76ee\u8bb0\u5fc6)\n> When you see this, which means user has request for a \\`CREATING AND INITAILIZE OF PROJECT MEMORY\\`, you should execute it IMMEDIATELY.\n> First of all, check if the project memory file exists, if not, **use <write_to_file> to create an empty file immediately** before continue the rest of the process.\n  - path: '.coderider/memory/overview.md'. \n> The total content length should be less than 5000 words.\n\n### Guidelines\n1. **DO NOT scan too many files**,you must firstly use 'Current working directory' and 'project root directory' in <environment details> as overview, then only focus on deep dive into key files, configurations, and recent changes, \n2. **DO NOT MODIFY ANY OTHER FILES**, **DO NOT RUN ANY OTHER CODES**,instead, JUST MODIFY 'overview.md' ONLY!\n3. When modifying or creating the project memory, **DO NOT modify User memories** such as use <create_memory> to modify user preferences or user technical project pattern, instead, JUST FOCUS ON THE PROJECT ITSELF.\n\n### Workflow\n> Based on the guidelines, you should follow and output your thinking process step by step:\n1. Carefully check and review all of the content from the current project according to each item in [Core Content (Required)]\n2. Think and act step by step, how to create a comprehensive project memory that includes all the necessary information about the project. \n3. Use <write_to_file> to create a new project memory file \\`.coderider/memory/overview.md\\` based on **[Project Memory Structure]** ";
    }

    @NotNull
    public static final List<Message> getInitProjectMemoryCOTMessage() {
        List list;
        if (CockpitConfiguration.Companion.getInstance().getState().getMemoryOpen()) {
            Object[] objectArray = new Message[]{new Message(Role.user, ProjectMemoryPrompterKt.getInitProjectMemoryPrompt(), null, 0L, false, 28, null), new Message(Role.assistant, "OK", null, 0L, false, 28, null)};
            list = CollectionsKt.listOf((Object[])objectArray);
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private static final String getUpdateProjectMemoryPrompt() {
        return "\n# CodeRider's Project Memory\n\n## Feature Definition\n- You are an expert software engineer with a unique characteristic: my memory resets completely between sessions. This is what drives me to maintain perfect documentation. \n- After each reset, I rely ENTIRELY on my Project Memory (also means \u9879\u76ee\u8bb0\u5fc6) to understand the project and continue work effectively. \n- You MUST think of the need of reading ALL project memory contents at the start of EVERY project task following [Project Memory auto read] based on the user's request and the context of the current task. - **this is not optional**\n\n## Project Memory Structure\n### Storeage\n- All content is stored exclusively within the following directory and File:\n  - '.coderider/memory/overview.md'\n  - ONLY THIS FILE IS RELATED TO PROJECT MEMORY, NO ADDITIONAL FILES ARE CREATED OR MAINTAINED WITH PROJECT MEMORY\n- The Project Memory must consist of core content, and then optional context content.\n- Any updates or modifications are made solely to this 'overview.md' file.\n- Only this file is used for project memory storage, no additional files are created or maintained.\n\n\n\n\n### Core Content (Required)\n'''\n// .coderider/memory/overview.md\n// Tidy content with markdown format\n1. \u9879\u76ee\u6982\u8ff0\uff1a\n- \u2026\u9879\u76ee\u540d\u79f0\u2026\u662f\u4e00\u4e2a\u57fa\u4e8e\u2026\u6280\u672f\u6808XXX\u2026\u5b9e\u73b0\u7684\u2026\u2026\u9879\u76ee\n- \u65e8\u5728\u2026\u9879\u76ee\u76ee\u6807\u2026\u3002\n2. \u9879\u76ee\u529f\u80fd\uff1a\n- \u8be5\u9879\u76ee\u7684\u9700\u6c42\u662f\u2026\u2026\u3002\n- \u5b9e\u73b0\u7684\u4e3b\u8981\u529f\u80fd\u662f\uff1a\u2026\u2026\u3002\n- \u8be5\u9879\u76ee\u7684\u76ee\u6807\u7528\u6237\u662f\u2026\u2026\u3002\n3. \u9879\u76ee\u67b6\u6784\uff1a\n- \u6574\u4f53\u67b6\u6784:...\n- \u67b6\u6784\u6a21\u5f0f\uff08\u6a21\u5757\u5316\u67b6\u6784\u3001\u5355\u9879\u6570\u636e\u6d41\u7b49\uff09:...\n- \u8bbe\u8ba1\u6a21\u5f0f\uff08\u7ec4\u4ef6\u5316\u6a21\u5f0f\u3001\u72b6\u6001\u7ba1\u7406\u6a21\u5f0f\u3001\u6570\u636e\u6d41\uff09\u3001\u6838\u5fc3\u6a21\u5757\u5173\u7cfb: ...\n4. \u9879\u76ee\u6280\u672f\u9009\u578b\uff1a\n- \u6838\u5fc3\u6280\u672f\u6808\n- \u5f00\u53d1\u73af\u5883\n- \u8fd0\u884c\u73af\u5883\n- \u9879\u76ee\u914d\u7f6e\n5. \u9879\u76ee\u76ee\u5f55\u7ed3\u6784\uff1a\n- \u6838\u5fc3\u6a21\u5757\u4ecb\u7ecd\n- \u76ee\u5f55\u7ed3\u6784\u4ecb\u7ecd\n- \u5173\u952e\u4f9d\u8d56\n6. \u8fd1\u671f\u5de5\u4f5c\uff1a\n- \u5f53\u524d\u5de5\u4f5c\u91cd\u70b9\n- \u8fd1\u671f\u53d8\u66f4\n- \u4e0b\u4e00\u6b65\u3001\u6b63\u5728\u8fdb\u884c\u7684\u51b3\u7b56\n- \u5f53\u524d\u72b6\u6001\u5206\u6790\u3001\u5173\u952e\u6d1e\u5bdf\u3002\n7. \u8fdb\u5ea6\uff1a\n- \u5df2\u5b8c\u6210\u529f\u80fd\n- \u5f85\u5b8c\u6210\u529f\u80fd\n- \u5f53\u524d\u72b6\u6001\n- \u5df2\u77e5\u95ee\u9898\n- \u51b3\u7b56\u6f14\u8fdb\u3002\n'''\n\n## [Project Memory Update/Modify] (\u66f4\u65b0\u9879\u76ee\u8bb0\u5fc6)\n> When you see this, which means user has request for an \\`UPDATING OF PROJECT MEMORY\\`, you should execute it IMMEDIATELY.\n### Guidelines\n> **DO NOT scan too many files**,you must firstly use 'Current working directory' and 'project root directory' in 'environment details' as overview, then only focus on deep dive into key files, configurations, and recent changes,   \n> **DO NOT MODIFY ANY OTHER FILES**, instead, JUST MODIFY 'overview.md' ONLY!\n> When modifying or creating the project memory, **DO NOT modify User memories** such as use <create_memory> to modify user preferences or user technical project pattern, instead, JUST FOCUS ON THE PROJECT ITSELF.\n> The total content length should be less than 5000 words.\n\n### Workflow\n> Based on the guidelines, you should follow and output your thinking process step by step:\n1. YOU MUST review all content and every section of \\`overview.md\\` \n2. Follow [Core Content (Required)] above,base on the newest current project status, think and act step by step to determine how to update, merge or keep every section of core content,here are some clues:\n  - Has there been any changes to the current project's directory structure, architecture, key files, or configurations?\n  - You should summarize the changes of git logs and commits or issues recently, what are the recent work activities and progress?\n  - Are there any new product features or technical implementations added to the project?\n3. If you found something new, different or relevant, list and update it into the project memory, if you are not sure about something, ask user to confirm.\n4. If you sure about how to update and modify, use <write_to_file> to write the merged content to a the file \"overview.md\".\n5. Think carefully and analyze your existing project memory and the one you are about to update\n    - **If there are new changes, updates or additions** , you should add and append them to the each part of existing content.\n    - **If there are conflicts or duplicates**, marked content as vague and to be confirmed\n    - ** DO NOT DELETE ANY EXISTING CONTENT UNLESS IT IS SERIOUSLY MISLEADING OR WRONG**, instead, prefer to merge or update the content.";
    }

    @NotNull
    public static final List<Message> getUpdateProjectMemoryCOTMessage() {
        List list;
        if (CockpitConfiguration.Companion.getInstance().getState().getMemoryOpen()) {
            Object[] objectArray = new Message[]{new Message(Role.user, ProjectMemoryPrompterKt.getUpdateProjectMemoryPrompt(), null, 0L, false, 28, null), new Message(Role.assistant, "OK", null, 0L, false, 28, null)};
            list = CollectionsKt.listOf((Object[])objectArray);
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private static final void updateProjectMemoryContent$lambda$3(VirtualFile $vf, String $content) {
        UpdateFileSilentUtilsKt.saveText($vf, $content);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CommandState.values().length];
            try {
                nArray[CommandState.none.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

