/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.composer.prompts;

import cn.gitlab.kilo.jetbrains.common.Logger;
import cn.gitlab.kilo.jetbrains.composer.Composer;
import cn.gitlab.kilo.jetbrains.composer.dto.AssistantMessageContent;
import cn.gitlab.kilo.jetbrains.composer.dto.ClineSay;
import cn.gitlab.kilo.jetbrains.composer.prompts.MemoryInfo;
import cn.gitlab.kilo.jetbrains.composer.prompts.ResponseUtil;
import cn.gitlab.kilo.jetbrains.config.CockpitConfiguration;
import cn.gitlab.kilo.jetbrains.config.UserMemoryStorage;
import cn.gitlab.kilo.jetbrains.editor.settings.SettingsEditorProvider;
import com.google.gson.Gson;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcn/gitlab/kilo/jetbrains/composer/prompts/MemoryService;", "", "<init>", "()V", "log", "Lcn/gitlab/kilo/jetbrains/common/Logger;", "memoryStorage", "Lcn/gitlab/kilo/jetbrains/config/UserMemoryStorage;", "handleCreateMemory", "", "block", "Lcn/gitlab/kilo/jetbrains/composer/dto/AssistantMessageContent;", "project", "Lcom/intellij/openapi/project/Project;", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nMemoryService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MemoryService.kt\ncn/gitlab/kilo/jetbrains/composer/prompts/MemoryService\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,330:1\n31#2,2:331\n*S KotlinDebug\n*F\n+ 1 MemoryService.kt\ncn/gitlab/kilo/jetbrains/composer/prompts/MemoryService\n*L\n35#1:331,2\n*E\n"})
public final class MemoryService {
    @NotNull
    private final Logger log = Logger.Companion.getInstance("MemoryService");
    @NotNull
    private final UserMemoryStorage memoryStorage = UserMemoryStorage.Companion.getInstance();

    public final void handleCreateMemory(@NotNull AssistantMessageContent block, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<Composer> serviceClass$iv = Composer.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        Composer composer = (Composer)object;
        String category = block.getParam("category");
        String content2 = block.getParam("content");
        if (category == null || content2 == null) {
            return;
        }
        MemoryInfo userMemoryInfo = this.memoryStorage.getMemory(category);
        boolean isCreate = userMemoryInfo == null;
        String action = isCreate ? "created" : "updated";
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"tool", (Object)"memory_operation"), TuplesKt.to((Object)"action", (Object)action), TuplesKt.to((Object)"content", (Object)content2), TuplesKt.to((Object)"category", (Object)category)};
        Map sharedMessageProps = MapsKt.mapOf((Pair[])pairArray);
        if (block.getPartial()) {
            if (!CockpitConfiguration.Companion.getInstance().getState().getMemoryOpen()) {
                return;
            }
            String partialMessage = new Gson().toJson((Object)sharedMessageProps);
            composer.removeLastPartialMessageIfExistsWithType("ask", "tool");
            Composer.say$default(composer, ClineSay.tool, partialMessage, null, block.getPartial(), null, null, null, null, 240, null);
        } else {
            String content3 = block.getParam("content");
            if (content3 == null) {
                int n = composer.getConsecutiveMistakeCount();
                composer.setConsecutiveMistakeCount(n + 1);
                composer.pushToolResult(Composer.sayAndCreateMissingParamError$default(composer, "create_memory", "content", null, 4, null), block);
                return;
            }
            if (!CockpitConfiguration.Companion.getInstance().getState().getMemoryOpen()) {
                composer.pushToolResult(ResponseUtil.INSTANCE.toolError("[Error] Memory functionality is currently not enabled, cannot create memory.\n** YOU MUST FOLLOW THIS INSTRUCTIONS**:\n1. First Prompt the user and output: 'You can enable memory function such as auto read memory function in system settings'.\n2. Keep trying using create_memory function until the user has enabled it.\n3. Keep trying check if memory function is enabled, you can proceed with memory operations.\n"), block);
                return;
            }
            if (this.memoryStorage.isIllegalCategory(category)) {
                Composer.say$default(composer, ClineSay.error, category, null, null, null, null, null, null, 252, null);
                composer.pushToolResult(ResponseUtil.INSTANCE.toolError("Invalid memory category."), block);
                return;
            }
            composer.setConsecutiveMistakeCount(0);
            String completeMessage = new Gson().toJson((Object)sharedMessageProps);
            Map<String, String> map = block.getParams();
            Intrinsics.checkNotNull(map);
            MemoryInfo newUserMemoryInfo = new MemoryInfo(map);
            MemoryInfo memoryInfo = userMemoryInfo;
            newUserMemoryInfo.setLoom(memoryInfo != null ? memoryInfo.getLoom() : true);
            MemoryInfo memoryInfo2 = userMemoryInfo;
            newUserMemoryInfo.setChat(memoryInfo2 != null ? memoryInfo2.getChat() : true);
            this.memoryStorage.putMemory(newUserMemoryInfo);
            SettingsEditorProvider.Companion.refreshMemory(project);
            composer.removeLastPartialMessageIfExistsWithType("ask", "tool");
            Composer.say$default(composer, ClineSay.tool, completeMessage, null, false, null, null, null, null, 244, null);
            String result2 = StringsKt.trimIndent((String)("\n            Memory Create successfully:\n            - Category: " + category + "\n            - Content: " + content3 + "\n            - Tags: " + newUserMemoryInfo.getTags() + "    \n              \n            "));
            if (content3.length() > 1000) {
                composer.pushToolResult(result2, block);
            } else {
                composer.pushToolResult(result2, block);
            }
        }
    }
}

