/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.composer.mode;

import cn.gitlab.kilo.jetbrains.common.CustomException;
import cn.gitlab.kilo.jetbrains.composer.config.ComposerConfiguration;
import cn.gitlab.kilo.jetbrains.composer.mode.ComposerMode;
import cn.gitlab.kilo.jetbrains.composer.mode.ComposerModeManager;
import cn.gitlab.kilo.jetbrains.composer.mode.CustomModePrompt;
import cn.gitlab.kilo.jetbrains.composer.mode.GroupOption;
import cn.gitlab.kilo.jetbrains.composer.mode.ModeSelection;
import cn.gitlab.kilo.jetbrains.composer.mode.ModeToolGroupConfig;
import cn.gitlab.kilo.jetbrains.composer.mode.ToolModeProvider;
import cn.gitlab.kilo.jetbrains.composer.mode.ToolRequirement;
import cn.gitlab.kilo.jetbrains.composer.mode.ToolRequirementBoolean;
import cn.gitlab.kilo.jetbrains.composer.mode.ToolRequirementMap;
import cn.gitlab.kilo.jetbrains.composer.tools.ToolDefinitions;
import cn.gitlab.kilo.jetbrains.composer.tools.ToolGroup;
import cn.gitlab.kilo.jetbrains.composer.tools.ToolName;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0005\u001a\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u000e\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b\u001a\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\u00012\u0006\u0010\n\u001a\u00020\u000b\u001aT\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0016\b\u0002\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00152\u0016\b\u0002\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u0015\u001a\u0016\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u0002\"\u0017\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u001a"}, d2={"EDIT_OPERATION_PARAMS", "", "", "getEDIT_OPERATION_PARAMS", "()Ljava/util/List;", "getModeSelection", "Lcn/gitlab/kilo/jetbrains/composer/mode/ModeSelection;", "composerMode", "Lcn/gitlab/kilo/jetbrains/composer/mode/ComposerMode;", "getModesSection", "project", "Lcom/intellij/openapi/project/Project;", "getAllModesWithPrompts", "isToolAllowedFromMode", "", "tool", "modeProvider", "Lcn/gitlab/kilo/jetbrains/composer/mode/ToolModeProvider;", "toolRequirements", "Lcn/gitlab/kilo/jetbrains/composer/mode/ToolRequirement;", "toolParams", "", "experiments", "doesFileMatchRegex", "filePath", "pattern", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nComposerMode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposerMode.kt\ncn/gitlab/kilo/jetbrains/composer/mode/ComposerModeKt\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,511:1\n31#2,2:512\n1#3:514\n1761#4,3:515\n*S KotlinDebug\n*F\n+ 1 ComposerMode.kt\ncn/gitlab/kilo/jetbrains/composer/mode/ComposerModeKt\n*L\n87#1:512,2\n315#1:515,3\n*E\n"})
public final class ComposerModeKt {
    @NotNull
    private static final List<String> EDIT_OPERATION_PARAMS;

    @NotNull
    public static final List<String> getEDIT_OPERATION_PARAMS() {
        return EDIT_OPERATION_PARAMS;
    }

    @NotNull
    public static final ModeSelection getModeSelection(@NotNull ComposerMode composerMode) {
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)composerMode, (String)"composerMode");
        ConcurrentMap<String, CustomModePrompt> customPrompts = ComposerConfiguration.Companion.getInstance().getState().getCustomModePrompts();
        ComposerMode $this$getModeSelection_u24lambda_u240 = composerMode;
        boolean bl = false;
        Object object3 = (CustomModePrompt)customPrompts.get($this$getModeSelection_u24lambda_u240.getSlug());
        if (object3 == null || (object3 = ((CustomModePrompt)object3).getRoleDefinition()) == null) {
            object3 = $this$getModeSelection_u24lambda_u240.getRoleDefinition();
        }
        if ((object2 = (CustomModePrompt)customPrompts.get($this$getModeSelection_u24lambda_u240.getSlug())) == null || (object2 = ((CustomModePrompt)object2).getCustomInstructions()) == null) {
            object2 = $this$getModeSelection_u24lambda_u240.getCustomInstructions();
        }
        if ((object = (CustomModePrompt)customPrompts.get($this$getModeSelection_u24lambda_u240.getSlug())) == null || (object = ((CustomModePrompt)object).getDescription()) == null) {
            object = $this$getModeSelection_u24lambda_u240.getDescription();
        }
        return new ModeSelection((String)object3, (String)object2, (String)object);
    }

    @NotNull
    public static final String getModesSection(@NotNull Project project) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        StringBuilder $this$getModesSection_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        List<ComposerMode> allModesWithPrompts = ComposerModeKt.getAllModesWithPrompts(project);
        $this$getModesSection_u24lambda_u242.append(StringsKt.trimIndent((String)("\n====\n    \nMODES\n\n- These are the currently available modes:\n\n" + CollectionsKt.joinToString$default((Iterable)allModesWithPrompts, (CharSequence)"\n", null, null, (int)0, null, ComposerModeKt::getModesSection$lambda$2$lambda$1, (int)30, null) + "\n    \n")));
        $this$getModesSection_u24lambda_u242.append("If the user asks you to create or edit a new mode for this project, you should read the instructions by using the fetch_instructions tool, like this:\n<fetch_instructions>\n<task>create_mode</task>\n</fetch_instructions>");
        return stringBuilder.toString();
    }

    @NotNull
    public static final List<ComposerMode> getAllModesWithPrompts(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        List allMode = new ArrayList();
        ConcurrentMap<String, CustomModePrompt> customPrompts = ComposerConfiguration.Companion.getInstance().getState().getCustomModePrompts();
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<ComposerModeManager> serviceClass$iv = ComposerModeManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        List<ComposerMode> allCustomModes = ((ComposerModeManager)object).getAllCustomModes();
        for (ComposerMode buildInMode : ComposerMode.Companion.getDEFAULT_MODES()) {
            ComposerMode mode;
            Object v1;
            block4: {
                Iterable iterable = allCustomModes;
                for (Object t : iterable) {
                    ComposerMode it = (ComposerMode)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getSlug(), (Object)buildInMode.getSlug())) continue;
                    v1 = t;
                    break block4;
                }
                v1 = null;
            }
            if ((mode = (ComposerMode)v1) != null) continue;
            Object object2 = (CustomModePrompt)customPrompts.get(buildInMode.getSlug());
            if (object2 == null || (object2 = ((CustomModePrompt)object2).cloneModeWithNewPrompt(buildInMode)) == null) {
                object2 = buildInMode;
            }
            Object effectMode = object2;
            allMode.add(effectMode);
        }
        allMode.addAll((Collection)allCustomModes);
        return allMode;
    }

    public static final boolean isToolAllowedFromMode(@Nullable String tool, @NotNull ToolModeProvider modeProvider, @Nullable ToolRequirement toolRequirements, @Nullable Map<String, String> toolParams, @Nullable Map<String, Boolean> experiments) {
        Intrinsics.checkNotNullParameter((Object)modeProvider, (String)"modeProvider");
        if (tool == null) {
            return false;
        }
        ToolName toolName = ToolName.Companion.fromIdentifier(tool);
        if (CollectionsKt.contains((Iterable)ToolDefinitions.INSTANCE.getALWAYS_AVAILABLE_TOOLS(), (Object)((Object)toolName))) {
            return true;
        }
        if (experiments != null && ToolDefinitions.INSTANCE.getEXPERIMENT_IDS().values().contains(tool) && !Intrinsics.areEqual((Object)experiments.get(tool), (Object)true)) {
            return false;
        }
        ToolRequirement toolRequirement = toolRequirements;
        if (toolRequirement instanceof ToolRequirementMap ? Intrinsics.areEqual((Object)((ToolRequirementMap)toolRequirements).getRequirement().get(tool), (Object)false) : toolRequirement instanceof ToolRequirementBoolean && !((ToolRequirementBoolean)toolRequirements).getRequirement()) {
            return false;
        }
        ComposerMode composerMode = modeProvider.getMode();
        if (composerMode == null) {
            return false;
        }
        ComposerMode mode = composerMode;
        for (ModeToolGroupConfig modeToolGroupConfig : mode.getGroups()) {
            block15: {
                Object object;
                String toolInfo;
                String path;
                String fileRegex;
                block17: {
                    block16: {
                        boolean isEditOperation;
                        GroupOption groupOption;
                        block14: {
                            List<ToolName> toolsInGroup;
                            ToolGroup group = modeToolGroupConfig.component1();
                            groupOption = modeToolGroupConfig.component2();
                            if (group == null || !CollectionsKt.contains((Iterable)(toolsInGroup = ToolDefinitions.INSTANCE.getToolsInGroup(group)), (Object)((Object)toolName))) continue;
                            if (groupOption == null) {
                                return true;
                            }
                            fileRegex = groupOption.getFileRegex();
                            if (group != ToolGroup.EDIT || fileRegex == null) break block15;
                            Map<String, String> map = toolParams;
                            path = map != null ? map.get("path") : null;
                            Iterable $this$any$iv = EDIT_OPERATION_PARAMS;
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                v2 = false;
                            } else {
                                for (Object element$iv : $this$any$iv) {
                                    String it = (String)element$iv;
                                    boolean bl = false;
                                    Map<String, String> map2 = toolParams;
                                    boolean bl2 = map2 != null ? map2.containsKey(it) : false;
                                    if (!bl2) continue;
                                    v2 = true;
                                    break block14;
                                }
                                v2 = isEditOperation = false;
                            }
                        }
                        if (path == null || !isEditOperation || ComposerModeKt.doesFileMatchRegex(path, fileRegex)) break block15;
                        toolInfo = "Tool '" + tool + "' in mode '" + mode.getSlug() + "'";
                        object = groupOption.getDescription();
                        if (object == null) break block16;
                        String it = object;
                        boolean bl = false;
                        String string = " (" + it + ")";
                        object = string;
                        if (string != null) break block17;
                    }
                    object = "";
                }
                String description = object;
                throw new CustomException(StringsKt.trimIndent((String)("\n                    " + toolInfo + " can only edit files matching pattern: " + fileRegex + description + ". Got: " + path + "\n                ")));
            }
            return true;
        }
        return false;
    }

    public static /* synthetic */ boolean isToolAllowedFromMode$default(String string, ToolModeProvider toolModeProvider, ToolRequirement toolRequirement, Map map, Map map2, int n, Object object) {
        if ((n & 4) != 0) {
            toolRequirement = null;
        }
        if ((n & 8) != 0) {
            map = null;
        }
        if ((n & 0x10) != 0) {
            map2 = null;
        }
        return ComposerModeKt.isToolAllowedFromMode(string, toolModeProvider, toolRequirement, map, map2);
    }

    public static final boolean doesFileMatchRegex(@NotNull String filePath, @NotNull String pattern) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        try {
            bl = Pattern.compile(pattern).matcher(filePath).find();
        }
        catch (Exception e) {
            System.out.println((Object)("Invalid regex pattern: " + pattern + ", error: " + e.getMessage()));
            bl = false;
        }
        return bl;
    }

    private static final CharSequence getModesSection$lambda$2$lambda$1(ComposerMode mode) {
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        String string = mode.getWhenToUse();
        if (string == null || (string = StringsKt.replace$default((String)string, (String)"\n", (String)"\n    ", (boolean)false, (int)4, null)) == null) {
            string = mode.getRoleDefinition();
        }
        String description = string;
        return "* " + mode.getName() + " mode (" + mode.getSlug() + ") - " + description;
    }

    static {
        Object[] objectArray = new String[]{"diff", "content", "operations", "search", "replace", "args", "line"};
        EDIT_OPERATION_PARAMS = CollectionsKt.listOf((Object[])objectArray);
    }
}

