/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.composer.marketplace;

import cn.gitlab.kilo.jetbrains.common.Logger;
import cn.gitlab.kilo.jetbrains.composer.marketplace.MarketplaceItem;
import cn.gitlab.kilo.jetbrains.composer.marketplace.McpParameter;
import cn.gitlab.kilo.jetbrains.composer.marketplace.RemoteConfigLoader;
import cn.gitlab.kilo.jetbrains.utils.ClientUtilsKt;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.Yaml;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0005'()*+B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\b\b\u0002\u0010\u0014\u001a\u00020\u0015H\u0086@\u00a2\u0006\u0002\u0010\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\u001a\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\n2\b\b\u0002\u0010\u001b\u001a\u00020\u001cH\u0002J \u0010\u001d\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\nH\u0086@\u00a2\u0006\u0002\u0010 J\u0018\u0010!\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00122\u0006\u0010\"\u001a\u00020\nH\u0002J\u001e\u0010#\u001a\u00020$2\u0006\u0010\"\u001a\u00020\n2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\u0006\u0010&\u001a\u00020$R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcn/gitlab/kilo/jetbrains/composer/marketplace/RemoteConfigLoader;", "", "<init>", "()V", "logger", "Lcn/gitlab/kilo/jetbrains/common/Logger;", "client", "Lokhttp3/OkHttpClient;", "cache", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcn/gitlab/kilo/jetbrains/composer/marketplace/RemoteConfigLoader$CachedData;", "cacheDuration", "", "apiBaseUrl", "gson", "Lcom/google/gson/Gson;", "loadAllItems", "", "Lcn/gitlab/kilo/jetbrains/composer/marketplace/MarketplaceItem;", "hideMarketplaceMcps", "", "(ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fetchModes", "fetchMcps", "fetchWithRetry", "url", "maxRetries", "", "getItem", "id", "type", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getFromCache", "key", "setCache", "", "data", "clearCache", "CachedData", "ModeMarketplaceResponse", "McpMarketplaceResponse", "ModeMarketplaceItemYaml", "McpMarketplaceItemYaml", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nRemoteConfigLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteConfigLoader.kt\ncn/gitlab/kilo/jetbrains/composer/marketplace/RemoteConfigLoader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,258:1\n1563#2:259\n1634#2,3:260\n1563#2:263\n1634#2,3:264\n1#3:267\n*S KotlinDebug\n*F\n+ 1 RemoteConfigLoader.kt\ncn/gitlab/kilo/jetbrains/composer/marketplace/RemoteConfigLoader\n*L\n127#1:259\n127#1:260,3\n167#1:263\n167#1:264,3\n*E\n"})
public final class RemoteConfigLoader {
    @NotNull
    private final Logger logger = Logger.Companion.getInstance("RemoteConfigLoader");
    @NotNull
    private final OkHttpClient client = ClientUtilsKt.generateOkHttpClientBuilder().connectTimeout(10L, TimeUnit.SECONDS).readTimeout(10L, TimeUnit.SECONDS).build();
    @NotNull
    private final ConcurrentHashMap<String, CachedData> cache = new ConcurrentHashMap();
    private final long cacheDuration;
    @NotNull
    private final String apiBaseUrl;
    @NotNull
    private final Gson gson;

    public RemoteConfigLoader() {
        this.cacheDuration = 300000L;
        this.apiBaseUrl = "https://api.kilocode.ai";
        Gson gson = new GsonBuilder().create();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"create(...)");
        this.gson = gson;
    }

    @Nullable
    public final Object loadAllItems(boolean hideMarketplaceMcps, @NotNull Continuation<? super List<MarketplaceItem>> $completion) {
        List items = new ArrayList();
        try {
            List<MarketplaceItem> modes = this.fetchModes();
            List<MarketplaceItem> mcps = hideMarketplaceMcps ? CollectionsKt.emptyList() : this.fetchMcps();
            items.addAll((Collection)modes);
            items.addAll((Collection)mcps);
        }
        catch (Exception e) {
            this.logger.error("Failed to load marketplace items", e);
        }
        return items;
    }

    public static /* synthetic */ Object loadAllItems$default(RemoteConfigLoader remoteConfigLoader, boolean bl, Continuation continuation, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return remoteConfigLoader.loadAllItems(bl, (Continuation<? super List<MarketplaceItem>>)continuation);
    }

    /*
     * WARNING - void declaration
     */
    private final List<MarketplaceItem> fetchModes() {
        void $this$mapTo$iv$iv;
        String cacheKey = "modes";
        List<MarketplaceItem> cached = this.getFromCache(cacheKey);
        if (cached != null) {
            return cached;
        }
        String data = RemoteConfigLoader.fetchWithRetry$default(this, this.apiBaseUrl + "/api/marketplace/modes", 0, 2, null);
        Yaml yaml = new Yaml();
        Map yamlData = (Map)yaml.load(data);
        String jsonString = this.gson.toJson((Object)yamlData);
        ModeMarketplaceResponse response = (ModeMarketplaceResponse)this.gson.fromJson(jsonString, ModeMarketplaceResponse.class);
        Iterable $this$map$iv = response.getItems();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void item;
            ModeMarketplaceItemYaml modeMarketplaceItemYaml = (ModeMarketplaceItemYaml)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            MarketplaceItem x = new MarketplaceItem("mode", item.getId(), item.getName(), item.getDescription(), item.getAuthor(), item.getAuthorUrl(), item.getTags(), item.getPrerequisites(), item.getContent(), null, null);
            collection.add(x);
        }
        List items = (List)destination$iv$iv;
        this.setCache(cacheKey, items);
        return items;
    }

    /*
     * WARNING - void declaration
     */
    private final List<MarketplaceItem> fetchMcps() {
        void $this$mapTo$iv$iv;
        String cacheKey = "mcps";
        List<MarketplaceItem> cached = this.getFromCache(cacheKey);
        if (cached != null) {
            return cached;
        }
        String data = RemoteConfigLoader.fetchWithRetry$default(this, this.apiBaseUrl + "/api/marketplace/mcps", 0, 2, null);
        Yaml yaml = new Yaml();
        Map yamlData = (Map)yaml.load(data);
        String jsonString = this.gson.toJson((Object)yamlData);
        McpMarketplaceResponse response = (McpMarketplaceResponse)this.gson.fromJson(jsonString, McpMarketplaceResponse.class);
        Iterable $this$map$iv = response.getItems();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void item;
            McpMarketplaceItemYaml mcpMarketplaceItemYaml = (McpMarketplaceItemYaml)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new MarketplaceItem("mcp", item.getId(), item.getName(), item.getDescription(), item.getAuthor(), item.getAuthorUrl(), item.getTags(), item.getPrerequisites(), item.getContent(), item.getUrl(), item.getParameters()));
        }
        List items = (List)destination$iv$iv;
        this.setCache(cacheKey, items);
        return items;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String fetchWithRetry(String url, int maxRetries) {
        Exception lastError = null;
        for (int i = 0; i < maxRetries; ++i) {
            try {
                Request request = new Request.Builder().url(url).header("Accept", "application/json").header("Content-Type", "application/json").build();
                Closeable closeable = (Closeable)this.client.newCall(request).execute();
                Throwable throwable = null;
                try {
                    Response response = (Response)closeable;
                    boolean bl = false;
                    if (!response.isSuccessful()) {
                        throw new Exception("HTTP " + response.code() + ": " + response.message());
                    }
                    Object object = response.body();
                    if (object == null || (object = object.string()) == null) {
                        throw new Exception("Empty response body");
                    }
                    Object object2 = object;
                    return object2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (Exception e) {
                lastError = e;
                if (i >= maxRetries - 1) continue;
                long delay = (long)Math.pow(2.0, i) * (long)1000;
                Thread.sleep(delay);
                continue;
            }
        }
        Exception exception = lastError;
        throw exception != null ? (Throwable)exception : (Throwable)new Exception("Unknown error during fetch");
    }

    static /* synthetic */ String fetchWithRetry$default(RemoteConfigLoader remoteConfigLoader, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 3;
        }
        return remoteConfigLoader.fetchWithRetry(string, n);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object getItem(@NotNull String var1_1, @NotNull String var2_2, @NotNull Continuation<? super MarketplaceItem> $completion) {
        if (!($completion instanceof getItem.1)) ** GOTO lbl-1000
        var11_4 = $completion;
        if ((var11_4.label & -2147483648) != 0) {
            var11_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ RemoteConfigLoader this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getItem(null, null, (Continuation<? super MarketplaceItem>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var12_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = id;
                $continuation.L$1 = type;
                $continuation.label = 1;
                v0 = RemoteConfigLoader.loadAllItems$default(this, false, (Continuation)$continuation, 1, null);
                if (v0 == var12_6) {
                    return var12_6;
                }
                ** GOTO lbl24
            }
            case 1: {
                type = (String)$continuation.L$1;
                id = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                items = (List)v0;
                var5_8 = items;
                for (T var7_10 : var5_8) {
                    it = (MarketplaceItem)var7_10;
                    $i$a$-find-RemoteConfigLoader$getItem$2 = false;
                    if (!(Intrinsics.areEqual((Object)it.getId(), (Object)id) != false && Intrinsics.areEqual((Object)it.getType(), (Object)type) != false)) continue;
                    v1 = var7_10;
                    ** GOTO lbl33
                }
                v1 = null;
lbl33:
                // 2 sources

                return v1;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final List<MarketplaceItem> getFromCache(String key) {
        CachedData cachedData = this.cache.get(key);
        if (cachedData == null) {
            return null;
        }
        CachedData cached = cachedData;
        long now = System.currentTimeMillis();
        if (now - cached.getTimestamp() > this.cacheDuration) {
            this.cache.remove(key);
            return null;
        }
        return cached.getData();
    }

    private final void setCache(String key, List<MarketplaceItem> data) {
        ((Map)this.cache).put(key, new CachedData(data, System.currentTimeMillis()));
    }

    public final void clearCache() {
        this.cache.clear();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u000f\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lcn/gitlab/kilo/jetbrains/composer/marketplace/RemoteConfigLoader$CachedData;", "", "data", "", "Lcn/gitlab/kilo/jetbrains/composer/marketplace/MarketplaceItem;", "timestamp", "", "<init>", "(Ljava/util/List;J)V", "getData", "()Ljava/util/List;", "getTimestamp", "()J", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "coderider-kilo-jetbrains"})
    private static final class CachedData {
        @NotNull
        private final List<MarketplaceItem> data;
        private final long timestamp;

        public CachedData(@NotNull List<MarketplaceItem> data, long timestamp) {
            Intrinsics.checkNotNullParameter(data, (String)"data");
            this.data = data;
            this.timestamp = timestamp;
        }

        @NotNull
        public final List<MarketplaceItem> getData() {
            return this.data;
        }

        public final long getTimestamp() {
            return this.timestamp;
        }

        @NotNull
        public final List<MarketplaceItem> component1() {
            return this.data;
        }

        public final long component2() {
            return this.timestamp;
        }

        @NotNull
        public final CachedData copy(@NotNull List<MarketplaceItem> data, long timestamp) {
            Intrinsics.checkNotNullParameter(data, (String)"data");
            return new CachedData(data, timestamp);
        }

        public static /* synthetic */ CachedData copy$default(CachedData cachedData, List list, long l, int n, Object object) {
            if ((n & 1) != 0) {
                list = cachedData.data;
            }
            if ((n & 2) != 0) {
                l = cachedData.timestamp;
            }
            return cachedData.copy(list, l);
        }

        @NotNull
        public String toString() {
            return "CachedData(data=" + this.data + ", timestamp=" + this.timestamp + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.data).hashCode();
            result2 = result2 * 31 + Long.hashCode(this.timestamp);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CachedData)) {
                return false;
            }
            CachedData cachedData = (CachedData)other;
            if (!Intrinsics.areEqual(this.data, cachedData.data)) {
                return false;
            }
            return this.timestamp == cachedData.timestamp;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B}\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\u0010\b\u0002\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\t\u0012\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\t\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0010\b\u0002\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\t\u00a2\u0006\u0004\b\u0010\u0010\u0011J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\"\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010#\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0011\u0010$\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\tH\u00c6\u0003J\u0011\u0010%\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\tH\u00c6\u0003J\t\u0010&\u001a\u00020\u0003H\u00c6\u0003J\t\u0010'\u001a\u00020\rH\u00c6\u0003J\u0011\u0010(\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\tH\u00c6\u0003J\u0089\u0001\u0010)\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00032\u0010\b\u0002\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\t2\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\t2\b\b\u0002\u0010\u000b\u001a\u00020\u00032\b\b\u0002\u0010\f\u001a\u00020\r2\u0010\b\u0002\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\tH\u00c6\u0001J\u0013\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010-\u001a\u00020.H\u00d6\u0001J\t\u0010/\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0013R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0013R\u0019\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0019\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019R\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0013R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0019\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0019\u00a8\u00060"}, d2={"Lcn/gitlab/kilo/jetbrains/composer/marketplace/RemoteConfigLoader$McpMarketplaceItemYaml;", "", "id", "", "name", "description", "author", "authorUrl", "tags", "", "prerequisites", "url", "content", "Lcom/google/gson/JsonElement;", "parameters", "Lcn/gitlab/kilo/jetbrains/composer/marketplace/McpParameter;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/lang/String;Lcom/google/gson/JsonElement;Ljava/util/List;)V", "getId", "()Ljava/lang/String;", "getName", "getDescription", "getAuthor", "getAuthorUrl", "getTags", "()Ljava/util/List;", "getPrerequisites", "getUrl", "getContent", "()Lcom/google/gson/JsonElement;", "getParameters", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "copy", "equals", "", "other", "hashCode", "", "toString", "coderider-kilo-jetbrains"})
    private static final class McpMarketplaceItemYaml {
        @NotNull
        private final String id;
        @NotNull
        private final String name;
        @NotNull
        private final String description;
        @Nullable
        private final String author;
        @Nullable
        private final String authorUrl;
        @Nullable
        private final List<String> tags;
        @Nullable
        private final List<String> prerequisites;
        @NotNull
        private final String url;
        @NotNull
        private final JsonElement content;
        @Nullable
        private final List<McpParameter> parameters;

        public McpMarketplaceItemYaml(@NotNull String id, @NotNull String name, @NotNull String description, @Nullable String author, @Nullable String authorUrl, @Nullable List<String> tags, @Nullable List<String> prerequisites, @NotNull String url, @NotNull JsonElement content2, @Nullable List<McpParameter> parameters) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
            this.id = id;
            this.name = name;
            this.description = description;
            this.author = author;
            this.authorUrl = authorUrl;
            this.tags = tags;
            this.prerequisites = prerequisites;
            this.url = url;
            this.content = content2;
            this.parameters = parameters;
        }

        public /* synthetic */ McpMarketplaceItemYaml(String string, String string2, String string3, String string4, String string5, List list, List list2, String string6, JsonElement jsonElement, List list3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                string4 = null;
            }
            if ((n & 0x10) != 0) {
                string5 = null;
            }
            if ((n & 0x20) != 0) {
                list = null;
            }
            if ((n & 0x40) != 0) {
                list2 = null;
            }
            if ((n & 0x200) != 0) {
                list3 = null;
            }
            this(string, string2, string3, string4, string5, list, list2, string6, jsonElement, list3);
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getDescription() {
            return this.description;
        }

        @Nullable
        public final String getAuthor() {
            return this.author;
        }

        @Nullable
        public final String getAuthorUrl() {
            return this.authorUrl;
        }

        @Nullable
        public final List<String> getTags() {
            return this.tags;
        }

        @Nullable
        public final List<String> getPrerequisites() {
            return this.prerequisites;
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        @NotNull
        public final JsonElement getContent() {
            return this.content;
        }

        @Nullable
        public final List<McpParameter> getParameters() {
            return this.parameters;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        @NotNull
        public final String component3() {
            return this.description;
        }

        @Nullable
        public final String component4() {
            return this.author;
        }

        @Nullable
        public final String component5() {
            return this.authorUrl;
        }

        @Nullable
        public final List<String> component6() {
            return this.tags;
        }

        @Nullable
        public final List<String> component7() {
            return this.prerequisites;
        }

        @NotNull
        public final String component8() {
            return this.url;
        }

        @NotNull
        public final JsonElement component9() {
            return this.content;
        }

        @Nullable
        public final List<McpParameter> component10() {
            return this.parameters;
        }

        @NotNull
        public final McpMarketplaceItemYaml copy(@NotNull String id, @NotNull String name, @NotNull String description, @Nullable String author, @Nullable String authorUrl, @Nullable List<String> tags, @Nullable List<String> prerequisites, @NotNull String url, @NotNull JsonElement content2, @Nullable List<McpParameter> parameters) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
            return new McpMarketplaceItemYaml(id, name, description, author, authorUrl, tags, prerequisites, url, content2, parameters);
        }

        public static /* synthetic */ McpMarketplaceItemYaml copy$default(McpMarketplaceItemYaml mcpMarketplaceItemYaml, String string, String string2, String string3, String string4, String string5, List list, List list2, String string6, JsonElement jsonElement, List list3, int n, Object object) {
            if ((n & 1) != 0) {
                string = mcpMarketplaceItemYaml.id;
            }
            if ((n & 2) != 0) {
                string2 = mcpMarketplaceItemYaml.name;
            }
            if ((n & 4) != 0) {
                string3 = mcpMarketplaceItemYaml.description;
            }
            if ((n & 8) != 0) {
                string4 = mcpMarketplaceItemYaml.author;
            }
            if ((n & 0x10) != 0) {
                string5 = mcpMarketplaceItemYaml.authorUrl;
            }
            if ((n & 0x20) != 0) {
                list = mcpMarketplaceItemYaml.tags;
            }
            if ((n & 0x40) != 0) {
                list2 = mcpMarketplaceItemYaml.prerequisites;
            }
            if ((n & 0x80) != 0) {
                string6 = mcpMarketplaceItemYaml.url;
            }
            if ((n & 0x100) != 0) {
                jsonElement = mcpMarketplaceItemYaml.content;
            }
            if ((n & 0x200) != 0) {
                list3 = mcpMarketplaceItemYaml.parameters;
            }
            return mcpMarketplaceItemYaml.copy(string, string2, string3, string4, string5, list, list2, string6, jsonElement, list3);
        }

        @NotNull
        public String toString() {
            return "McpMarketplaceItemYaml(id=" + this.id + ", name=" + this.name + ", description=" + this.description + ", author=" + this.author + ", authorUrl=" + this.authorUrl + ", tags=" + this.tags + ", prerequisites=" + this.prerequisites + ", url=" + this.url + ", content=" + this.content + ", parameters=" + this.parameters + ")";
        }

        public int hashCode() {
            int result2 = this.id.hashCode();
            result2 = result2 * 31 + this.name.hashCode();
            result2 = result2 * 31 + this.description.hashCode();
            result2 = result2 * 31 + (this.author == null ? 0 : this.author.hashCode());
            result2 = result2 * 31 + (this.authorUrl == null ? 0 : this.authorUrl.hashCode());
            result2 = result2 * 31 + (this.tags == null ? 0 : ((Object)this.tags).hashCode());
            result2 = result2 * 31 + (this.prerequisites == null ? 0 : ((Object)this.prerequisites).hashCode());
            result2 = result2 * 31 + this.url.hashCode();
            result2 = result2 * 31 + this.content.hashCode();
            result2 = result2 * 31 + (this.parameters == null ? 0 : ((Object)this.parameters).hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof McpMarketplaceItemYaml)) {
                return false;
            }
            McpMarketplaceItemYaml mcpMarketplaceItemYaml = (McpMarketplaceItemYaml)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)mcpMarketplaceItemYaml.id)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.name, (Object)mcpMarketplaceItemYaml.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.description, (Object)mcpMarketplaceItemYaml.description)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.author, (Object)mcpMarketplaceItemYaml.author)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.authorUrl, (Object)mcpMarketplaceItemYaml.authorUrl)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.tags, mcpMarketplaceItemYaml.tags)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.prerequisites, mcpMarketplaceItemYaml.prerequisites)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.url, (Object)mcpMarketplaceItemYaml.url)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.content, (Object)mcpMarketplaceItemYaml.content)) {
                return false;
            }
            return Intrinsics.areEqual(this.parameters, mcpMarketplaceItemYaml.parameters);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\n\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lcn/gitlab/kilo/jetbrains/composer/marketplace/RemoteConfigLoader$McpMarketplaceResponse;", "", "items", "", "Lcn/gitlab/kilo/jetbrains/composer/marketplace/RemoteConfigLoader$McpMarketplaceItemYaml;", "<init>", "(Ljava/util/List;)V", "getItems", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "coderider-kilo-jetbrains"})
    private static final class McpMarketplaceResponse {
        @NotNull
        private final List<McpMarketplaceItemYaml> items;

        public McpMarketplaceResponse(@NotNull List<McpMarketplaceItemYaml> items) {
            Intrinsics.checkNotNullParameter(items, (String)"items");
            this.items = items;
        }

        @NotNull
        public final List<McpMarketplaceItemYaml> getItems() {
            return this.items;
        }

        @NotNull
        public final List<McpMarketplaceItemYaml> component1() {
            return this.items;
        }

        @NotNull
        public final McpMarketplaceResponse copy(@NotNull List<McpMarketplaceItemYaml> items) {
            Intrinsics.checkNotNullParameter(items, (String)"items");
            return new McpMarketplaceResponse(items);
        }

        public static /* synthetic */ McpMarketplaceResponse copy$default(McpMarketplaceResponse mcpMarketplaceResponse, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = mcpMarketplaceResponse.items;
            }
            return mcpMarketplaceResponse.copy(list);
        }

        @NotNull
        public String toString() {
            return "McpMarketplaceResponse(items=" + this.items + ")";
        }

        public int hashCode() {
            return ((Object)this.items).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof McpMarketplaceResponse)) {
                return false;
            }
            McpMarketplaceResponse mcpMarketplaceResponse = (McpMarketplaceResponse)other;
            return Intrinsics.areEqual(this.items, mcpMarketplaceResponse.items);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001Bc\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\u0010\b\u0002\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\t\u0012\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u001d\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0011\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\tH\u00c6\u0003J\u0011\u0010 \u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\tH\u00c6\u0003J\t\u0010!\u001a\u00020\fH\u00c6\u0003Jm\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00032\u0010\b\u0002\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\t2\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\t2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u00c6\u0001J\u0013\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010&\u001a\u00020'H\u00d6\u0001J\t\u0010(\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u0019\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0019\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006)"}, d2={"Lcn/gitlab/kilo/jetbrains/composer/marketplace/RemoteConfigLoader$ModeMarketplaceItemYaml;", "", "id", "", "name", "description", "author", "authorUrl", "tags", "", "prerequisites", "content", "Lcom/google/gson/JsonElement;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/List;Lcom/google/gson/JsonElement;)V", "getId", "()Ljava/lang/String;", "getName", "getDescription", "getAuthor", "getAuthorUrl", "getTags", "()Ljava/util/List;", "getPrerequisites", "getContent", "()Lcom/google/gson/JsonElement;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "", "other", "hashCode", "", "toString", "coderider-kilo-jetbrains"})
    private static final class ModeMarketplaceItemYaml {
        @NotNull
        private final String id;
        @NotNull
        private final String name;
        @NotNull
        private final String description;
        @Nullable
        private final String author;
        @Nullable
        private final String authorUrl;
        @Nullable
        private final List<String> tags;
        @Nullable
        private final List<String> prerequisites;
        @NotNull
        private final JsonElement content;

        public ModeMarketplaceItemYaml(@NotNull String id, @NotNull String name, @NotNull String description, @Nullable String author, @Nullable String authorUrl, @Nullable List<String> tags, @Nullable List<String> prerequisites, @NotNull JsonElement content2) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
            this.id = id;
            this.name = name;
            this.description = description;
            this.author = author;
            this.authorUrl = authorUrl;
            this.tags = tags;
            this.prerequisites = prerequisites;
            this.content = content2;
        }

        public /* synthetic */ ModeMarketplaceItemYaml(String string, String string2, String string3, String string4, String string5, List list, List list2, JsonElement jsonElement, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                string4 = null;
            }
            if ((n & 0x10) != 0) {
                string5 = null;
            }
            if ((n & 0x20) != 0) {
                list = null;
            }
            if ((n & 0x40) != 0) {
                list2 = null;
            }
            this(string, string2, string3, string4, string5, list, list2, jsonElement);
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getDescription() {
            return this.description;
        }

        @Nullable
        public final String getAuthor() {
            return this.author;
        }

        @Nullable
        public final String getAuthorUrl() {
            return this.authorUrl;
        }

        @Nullable
        public final List<String> getTags() {
            return this.tags;
        }

        @Nullable
        public final List<String> getPrerequisites() {
            return this.prerequisites;
        }

        @NotNull
        public final JsonElement getContent() {
            return this.content;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        @NotNull
        public final String component3() {
            return this.description;
        }

        @Nullable
        public final String component4() {
            return this.author;
        }

        @Nullable
        public final String component5() {
            return this.authorUrl;
        }

        @Nullable
        public final List<String> component6() {
            return this.tags;
        }

        @Nullable
        public final List<String> component7() {
            return this.prerequisites;
        }

        @NotNull
        public final JsonElement component8() {
            return this.content;
        }

        @NotNull
        public final ModeMarketplaceItemYaml copy(@NotNull String id, @NotNull String name, @NotNull String description, @Nullable String author, @Nullable String authorUrl, @Nullable List<String> tags, @Nullable List<String> prerequisites, @NotNull JsonElement content2) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
            return new ModeMarketplaceItemYaml(id, name, description, author, authorUrl, tags, prerequisites, content2);
        }

        public static /* synthetic */ ModeMarketplaceItemYaml copy$default(ModeMarketplaceItemYaml modeMarketplaceItemYaml, String string, String string2, String string3, String string4, String string5, List list, List list2, JsonElement jsonElement, int n, Object object) {
            if ((n & 1) != 0) {
                string = modeMarketplaceItemYaml.id;
            }
            if ((n & 2) != 0) {
                string2 = modeMarketplaceItemYaml.name;
            }
            if ((n & 4) != 0) {
                string3 = modeMarketplaceItemYaml.description;
            }
            if ((n & 8) != 0) {
                string4 = modeMarketplaceItemYaml.author;
            }
            if ((n & 0x10) != 0) {
                string5 = modeMarketplaceItemYaml.authorUrl;
            }
            if ((n & 0x20) != 0) {
                list = modeMarketplaceItemYaml.tags;
            }
            if ((n & 0x40) != 0) {
                list2 = modeMarketplaceItemYaml.prerequisites;
            }
            if ((n & 0x80) != 0) {
                jsonElement = modeMarketplaceItemYaml.content;
            }
            return modeMarketplaceItemYaml.copy(string, string2, string3, string4, string5, list, list2, jsonElement);
        }

        @NotNull
        public String toString() {
            return "ModeMarketplaceItemYaml(id=" + this.id + ", name=" + this.name + ", description=" + this.description + ", author=" + this.author + ", authorUrl=" + this.authorUrl + ", tags=" + this.tags + ", prerequisites=" + this.prerequisites + ", content=" + this.content + ")";
        }

        public int hashCode() {
            int result2 = this.id.hashCode();
            result2 = result2 * 31 + this.name.hashCode();
            result2 = result2 * 31 + this.description.hashCode();
            result2 = result2 * 31 + (this.author == null ? 0 : this.author.hashCode());
            result2 = result2 * 31 + (this.authorUrl == null ? 0 : this.authorUrl.hashCode());
            result2 = result2 * 31 + (this.tags == null ? 0 : ((Object)this.tags).hashCode());
            result2 = result2 * 31 + (this.prerequisites == null ? 0 : ((Object)this.prerequisites).hashCode());
            result2 = result2 * 31 + this.content.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ModeMarketplaceItemYaml)) {
                return false;
            }
            ModeMarketplaceItemYaml modeMarketplaceItemYaml = (ModeMarketplaceItemYaml)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)modeMarketplaceItemYaml.id)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.name, (Object)modeMarketplaceItemYaml.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.description, (Object)modeMarketplaceItemYaml.description)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.author, (Object)modeMarketplaceItemYaml.author)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.authorUrl, (Object)modeMarketplaceItemYaml.authorUrl)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.tags, modeMarketplaceItemYaml.tags)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.prerequisites, modeMarketplaceItemYaml.prerequisites)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.content, (Object)modeMarketplaceItemYaml.content);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\n\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lcn/gitlab/kilo/jetbrains/composer/marketplace/RemoteConfigLoader$ModeMarketplaceResponse;", "", "items", "", "Lcn/gitlab/kilo/jetbrains/composer/marketplace/RemoteConfigLoader$ModeMarketplaceItemYaml;", "<init>", "(Ljava/util/List;)V", "getItems", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "coderider-kilo-jetbrains"})
    private static final class ModeMarketplaceResponse {
        @NotNull
        private final List<ModeMarketplaceItemYaml> items;

        public ModeMarketplaceResponse(@NotNull List<ModeMarketplaceItemYaml> items) {
            Intrinsics.checkNotNullParameter(items, (String)"items");
            this.items = items;
        }

        @NotNull
        public final List<ModeMarketplaceItemYaml> getItems() {
            return this.items;
        }

        @NotNull
        public final List<ModeMarketplaceItemYaml> component1() {
            return this.items;
        }

        @NotNull
        public final ModeMarketplaceResponse copy(@NotNull List<ModeMarketplaceItemYaml> items) {
            Intrinsics.checkNotNullParameter(items, (String)"items");
            return new ModeMarketplaceResponse(items);
        }

        public static /* synthetic */ ModeMarketplaceResponse copy$default(ModeMarketplaceResponse modeMarketplaceResponse, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = modeMarketplaceResponse.items;
            }
            return modeMarketplaceResponse.copy(list);
        }

        @NotNull
        public String toString() {
            return "ModeMarketplaceResponse(items=" + this.items + ")";
        }

        public int hashCode() {
            return ((Object)this.items).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ModeMarketplaceResponse)) {
                return false;
            }
            ModeMarketplaceResponse modeMarketplaceResponse = (ModeMarketplaceResponse)other;
            return Intrinsics.areEqual(this.items, modeMarketplaceResponse.items);
        }
    }
}

