/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.composer;

import cn.gitlab.kilo.jetbrains.common.Logger;
import cn.gitlab.kilo.jetbrains.composer.CodeRiderIgnoreNode;
import cn.gitlab.kilo.jetbrains.composer.CodeRiderIgnoreRule;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000f\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000eH\u0002J\b\u0010$\u001a\u00020%H\u0002J\b\u0010&\u001a\u00020%H\u0002J\u0010\u0010'\u001a\u00020\u00102\u0006\u0010(\u001a\u00020\u000eH\u0002J\u0010\u0010)\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020\u0010H\u0002J\u000e\u0010+\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020\u000eJ\u000e\u0010-\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020\u000eJ\u000e\u0010-\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020\u0010J\u0010\u0010.\u001a\u0004\u0018\u00010\u000e2\u0006\u0010/\u001a\u00020\u000eJ\u001a\u00100\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\b\u00102\u001a\u00020%H\u0016J\u000e\u00103\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcn/gitlab/kilo/jetbrains/composer/ClineIgnoreController;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "logger", "Lcn/gitlab/kilo/jetbrains/common/Logger;", "isWindows", "", "ignoreFileNameList", "", "", "cwdPath", "Ljava/nio/file/Path;", "cwd", "binaryExtensions", "", "isBinaryFile", "path", "defaultIgnoresRules", "", "Lcn/gitlab/kilo/jetbrains/composer/CodeRiderIgnoreRule;", "ignoreInstance", "Lcn/gitlab/kilo/jetbrains/composer/CodeRiderIgnoreNode;", "clineIgnoreContent", "getClineIgnoreContent", "()Ljava/lang/String;", "setClineIgnoreContent", "(Ljava/lang/String;)V", "writeProtectedPatterns", "writeProtectedInstance", "fileListener", "Lcom/intellij/openapi/vfs/VirtualFileListener;", "setupFileWatcher", "", "loadClineIgnore", "resolveAbsolutePath", "input", "toRelativeUnix", "abs", "isWriteProtected", "filePath", "validateAccess", "validateCommand", "command", "filterPaths", "paths", "dispose", "getDefaultIgnores", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nClineIgnoreController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClineIgnoreController.kt\ncn/gitlab/kilo/jetbrains/composer/ClineIgnoreController\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,255:1\n1#2:256\n1563#3:257\n1634#3,3:258\n1878#3,3:261\n1869#3,2:264\n774#3:266\n865#3,2:267\n774#3:269\n865#3,2:270\n*S KotlinDebug\n*F\n+ 1 ClineIgnoreController.kt\ncn/gitlab/kilo/jetbrains/composer/ClineIgnoreController\n*L\n52#1:257\n52#1:258,3\n84#1:261,3\n90#1:264,2\n206#1:266\n206#1:267,2\n239#1:269\n239#1:270,2\n*E\n"})
public final class ClineIgnoreController
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final Logger logger;
    private final boolean isWindows;
    @NotNull
    private final List<String> ignoreFileNameList;
    @NotNull
    private final Path cwdPath;
    @NotNull
    private final String cwd;
    @NotNull
    private final Set<String> binaryExtensions;
    @NotNull
    private final List<CodeRiderIgnoreRule> defaultIgnoresRules;
    @NotNull
    private CodeRiderIgnoreNode ignoreInstance;
    @NotNull
    private String clineIgnoreContent;
    @NotNull
    private final List<String> writeProtectedPatterns;
    @NotNull
    private final CodeRiderIgnoreNode writeProtectedInstance;
    @Nullable
    private VirtualFileListener fileListener;

    /*
     * WARNING - void declaration
     */
    public ClineIgnoreController(@NotNull Project project) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        ClineIgnoreController clineIgnoreController;
        Object object;
        Object object2;
        block4: {
            block3: {
                void p0;
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                this.project = project;
                this.logger = Logger.Companion.getInstance("ClineIgnoreController");
                String string = System.getProperty("os.name");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
                this.isWindows = StringsKt.startsWith((String)string, (String)"Windows", (boolean)true);
                object2 = new String[]{".coderiderignore", ".gitignore"};
                this.ignoreFileNameList = CollectionsKt.listOf((Object[])object2);
                ClineIgnoreController clineIgnoreController2 = this;
                object = this.project.getBasePath();
                if (object == null) break block3;
                String string2 = object;
                clineIgnoreController = clineIgnoreController2;
                boolean bl = false;
                Path path = Paths.get((String)p0, new String[0]);
                clineIgnoreController2 = clineIgnoreController;
                object = path;
                if (path != null && (object = object.normalize()) != null) break block4;
            }
            Path path = Paths.get("", new String[0]).toAbsolutePath().normalize();
            object = path;
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"normalize(...)");
        }
        clineIgnoreController2.cwdPath = object;
        this.cwd = ((Object)this.cwdPath).toString();
        object2 = new String[]{"class", "jar", "war", "ear", "zip", "7z", "tar", "gz", "bz2", "xz", "exe", "dll", "so", "o", "a", "bin", "iso", "png", "jpg", "jpeg", "gif", "bmp", "ico", "svg", "mp3", "wav", "ogg", "flac", "mp4", "mkv", "avi", "mov", "wmv", "flv", "pdf", "ps", "ttf", "otf"};
        this.binaryExtensions = SetsKt.setOf((Object[])object2);
        this.defaultIgnoresRules = this.getDefaultIgnores();
        this.ignoreInstance = new CodeRiderIgnoreNode(this.defaultIgnoresRules);
        this.clineIgnoreContent = CollectionsKt.joinToString$default((Iterable)this.defaultIgnoresRules, (CharSequence)"\n", null, null, (int)0, null, ClineIgnoreController::clineIgnoreContent$lambda$0, (int)30, null);
        object2 = new String[]{".gitignore", ".coderiderignore", ".crkiloignore", ".crkilo/**"};
        this.writeProtectedPatterns = CollectionsKt.listOf((Object[])object2);
        object2 = this.writeProtectedPatterns;
        clineIgnoreController = this;
        boolean $i$f$map = false;
        void var4_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new CodeRiderIgnoreRule((String)it));
        }
        List list = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        clineIgnoreController.writeProtectedInstance = new CodeRiderIgnoreNode(list);
        this.setupFileWatcher();
        this.loadClineIgnore();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final boolean isBinaryFile(String path) {
        String string = StringsKt.substringAfterLast((String)path, (char)'.', (String)"").toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String ext = string;
        return this.binaryExtensions.contains(ext);
    }

    @NotNull
    public final String getClineIgnoreContent() {
        return this.clineIgnoreContent;
    }

    public final void setClineIgnoreContent(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.clineIgnoreContent = string;
    }

    private final void setupFileWatcher() {
        block0: {
            VirtualFileListener virtualFileListener = this.fileListener = (VirtualFileListener)new VirtualFileListener(this){
                final /* synthetic */ ClineIgnoreController this$0;
                {
                    this.this$0 = $receiver;
                }

                public void contentsChanged(VirtualFileEvent event2) {
                    Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
                    this.handle(event2);
                }

                public void fileCreated(VirtualFileEvent event2) {
                    Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
                    this.handle(event2);
                }

                public void fileDeleted(VirtualFileEvent event2) {
                    Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
                    this.handle(event2);
                }

                private final void handle(VirtualFileEvent event2) {
                    if (ClineIgnoreController.access$getIgnoreFileNameList$p(this.this$0).contains(event2.getFile().getName())) {
                        ClineIgnoreController.access$loadClineIgnore(this.this$0);
                    }
                }
            };
            if (virtualFileListener == null) break block0;
            VirtualFileListener it = virtualFileListener;
            boolean bl = false;
            VirtualFileManager.getInstance().addVirtualFileListener(it, (Disposable)this);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void loadClineIgnore() {
        try {
            this.ignoreInstance = new CodeRiderIgnoreNode(this.getDefaultIgnores());
            StringBuilder sb = new StringBuilder();
            Iterable $this$forEachIndexed$iv = this.defaultIgnoresRules;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void r;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                CodeRiderIgnoreRule codeRiderIgnoreRule = (CodeRiderIgnoreRule)((Object)item$iv);
                int idx = n;
                boolean bl = false;
                if (idx > 0) {
                    sb.append('\n');
                }
                sb.append(r.getPattern());
            }
            Iterable $this$forEach$iv = this.ignoreFileNameList;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String file = (String)element$iv;
                boolean bl = false;
                File f = this.cwdPath.resolve(file).toFile();
                if (!f.exists() || !f.isFile()) continue;
                Intrinsics.checkNotNull((Object)f);
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                String fileContent = FilesKt.readText((File)f, (Charset)charset);
                if (((CharSequence)sb).length() > 0 && StringsKt.last((CharSequence)sb) != '\n') {
                    sb.append('\n');
                }
                char[] cArray = new char[]{'\n'};
                sb.append(StringsKt.trimEnd((String)fileContent, (char[])cArray));
                this.ignoreInstance.add(fileContent);
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            this.clineIgnoreContent = string;
        }
        catch (Exception e) {
            Logger.error$default(this.logger, "Failed to load ignore files: " + e, null, 2, null);
        }
    }

    private final Path resolveAbsolutePath(String input) {
        char[] cArray = new char[]{'\"', '\''};
        String trimmed = StringsKt.trim((String)((Object)StringsKt.trim((CharSequence)input)).toString(), (char[])cArray);
        Path p = Paths.get(trimmed, new String[0]);
        Path abs = p.isAbsolute() ? p : this.cwdPath.resolve(p);
        Path path = abs.normalize().toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toAbsolutePath(...)");
        return path;
    }

    private final String toRelativeUnix(Path abs) {
        Path path;
        try {
            path = this.cwdPath.relativize(abs.normalize());
        }
        catch (Exception exception) {
            Path path2 = abs.getFileName();
            if (path2 == null) {
                path2 = abs;
            }
            path = path2;
        }
        Path rel = path;
        return StringsKt.replace$default((String)((Object)rel).toString(), (char)'\\', (char)'/', (boolean)false, (int)4, null);
    }

    public final boolean isWriteProtected(@NotNull String filePath) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        try {
            Path absolute = this.resolveAbsolutePath(filePath);
            String relativeUnix = this.toRelativeUnix(absolute);
            boolean isDir = Files.isDirectory(absolute, new LinkOption[0]);
            bl = this.writeProtectedInstance.ignores(relativeUnix, isDir);
        }
        catch (Exception e) {
            Logger.error$default(this.logger, "Error checking write protection for " + filePath + ": " + e, null, 2, null);
            bl = false;
        }
        return bl;
    }

    public final boolean validateAccess(@NotNull String filePath) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        if (this.isWriteProtected(filePath)) {
            return true;
        }
        if (StringsKt.isBlank((CharSequence)this.clineIgnoreContent)) {
            return !this.isBinaryFile(filePath);
        }
        try {
            boolean isDir;
            Path absolute = this.resolveAbsolutePath(filePath);
            String absoluteStr = ((Object)absolute).toString();
            if (this.isBinaryFile(absoluteStr)) {
                return false;
            }
            String relativeUnix = this.toRelativeUnix(absolute);
            bl = !this.ignoreInstance.ignores(relativeUnix, isDir = Files.isDirectory(absolute, new LinkOption[0]));
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public final boolean validateAccess(@NotNull Path filePath) {
        boolean bl;
        Path path;
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        try {
            path = filePath.isAbsolute() ? filePath.normalize().toAbsolutePath() : this.cwdPath.resolve(filePath).normalize().toAbsolutePath();
        }
        catch (Exception exception) {
            return false;
        }
        Path absolute = path;
        String absoluteStr = ((Object)absolute).toString();
        if (this.isWriteProtected(absoluteStr)) {
            return true;
        }
        if (StringsKt.isBlank((CharSequence)this.clineIgnoreContent)) {
            return !this.isBinaryFile(absoluteStr);
        }
        try {
            if (this.isBinaryFile(absoluteStr)) {
                return false;
            }
            Intrinsics.checkNotNull((Object)absolute);
            String relativeUnix = this.toRelativeUnix(absolute);
            boolean dir = Files.isDirectory(absolute, new LinkOption[0]);
            bl = !this.ignoreInstance.ignores(relativeUnix, dir);
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    @Nullable
    public final String validateCommand(@NotNull String command) {
        String string;
        List parts;
        Object[] $this$filterTo$iv$iv;
        block8: {
            block7: {
                Intrinsics.checkNotNullParameter((Object)command, (String)"command");
                if (StringsKt.isBlank((CharSequence)this.clineIgnoreContent)) {
                    return null;
                }
                CharSequence charSequence = ((Object)StringsKt.trim((CharSequence)command)).toString();
                Regex regex = new Regex("\\s+");
                int n = 0;
                Iterable $this$filter$iv = regex.split(charSequence, n);
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object cArray : $this$filterTo$iv$iv) {
                    String it = (String)cArray;
                    boolean bl = false;
                    boolean bl2 = ((CharSequence)it).length() > 0;
                    if (!bl2) continue;
                    destination$iv$iv.add(cArray);
                }
                parts = (List)destination$iv$iv;
                string = (String)CollectionsKt.firstOrNull((List)parts);
                if (string == null) break block7;
                String string2 = string.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                string = string2;
                if (string2 != null) break block8;
            }
            return null;
        }
        String baseCommand = string;
        $this$filterTo$iv$iv = new String[]{"cat", "less", "more", "head", "tail", "grep", "awk", "sed", "get-content", "gc", "type", "select-string", "sls"};
        Set fileReadingCommands = SetsKt.setOf((Object[])$this$filterTo$iv$iv);
        if (!fileReadingCommands.contains(baseCommand)) {
            return null;
        }
        int n = parts.size();
        for (int i = 1; i < n; ++i) {
            String raw = (String)parts.get(i);
            if (ClineIgnoreController.validateCommand$isOption(raw) || !ClineIgnoreController.validateCommand$looksLikePath(this, raw)) continue;
            char[] cArray = new char[]{'\"', '\''};
            String arg = StringsKt.trim((String)((Object)StringsKt.trim((CharSequence)raw)).toString(), (char[])cArray);
            if (this.validateAccess(arg)) continue;
            return arg;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> filterPaths(@NotNull List<String> paths) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        Iterable $this$filter$iv = paths;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!this.validateAccess(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public void dispose() {
        VirtualFileListener virtualFileListener = this.fileListener;
        if (virtualFileListener != null) {
            VirtualFileListener it = virtualFileListener;
            boolean bl = false;
            VirtualFileManager.getInstance().removeVirtualFileListener(it);
        }
        this.fileListener = null;
    }

    private final List<CodeRiderIgnoreRule> getDefaultIgnores() {
        CodeRiderIgnoreRule[] codeRiderIgnoreRuleArray = new CodeRiderIgnoreRule[]{new CodeRiderIgnoreRule(".vscode/"), new CodeRiderIgnoreRule(".git/"), new CodeRiderIgnoreRule(".idea/"), new CodeRiderIgnoreRule(".kilocode/"), new CodeRiderIgnoreRule(".cline/"), new CodeRiderIgnoreRule(".roo/")};
        return CollectionsKt.mutableListOf((Object[])codeRiderIgnoreRuleArray);
    }

    private static final CharSequence clineIgnoreContent$lambda$0(CodeRiderIgnoreRule it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return it.getPattern();
    }

    private static final boolean validateCommand$isOption(String arg) {
        return StringsKt.startsWith$default((String)arg, (String)"-", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)arg, (String)"/", (boolean)false, (int)2, null);
    }

    private static final boolean validateCommand$looksLikePath(ClineIgnoreController this$0, String arg) {
        char[] cArray = new char[]{'\"', '\''};
        String a = StringsKt.trim((String)((Object)StringsKt.trim((CharSequence)arg)).toString(), (char[])cArray);
        if (StringsKt.isBlank((CharSequence)a)) {
            return false;
        }
        if (this$0.isWindows && a.length() >= 2 && a.charAt(1) == ':' && Character.isLetter(a.charAt(0))) {
            return true;
        }
        return StringsKt.contains$default((CharSequence)a, (char)'\\', (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)a, (char)'/', (boolean)false, (int)2, null);
    }

    public static final /* synthetic */ List access$getIgnoreFileNameList$p(ClineIgnoreController $this) {
        return $this.ignoreFileNameList;
    }

    public static final /* synthetic */ void access$loadClineIgnore(ClineIgnoreController $this) {
        $this.loadClineIgnore();
    }
}

