/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.client;

import cn.gitlab.kilo.jetbrains.actions.CodeRiderPluginActionsKt;
import cn.gitlab.kilo.jetbrains.client.CoderiderClient;
import cn.gitlab.kilo.jetbrains.common.LogKt;
import cn.gitlab.kilo.jetbrains.common.Logger;
import cn.gitlab.kilo.jetbrains.config.CockpitConfiguration;
import cn.gitlab.kilo.jetbrains.factories.CockpitWidgetFactoryKt;
import cn.gitlab.kilo.jetbrains.services.CodeRiderStatus;
import cn.gitlab.kilo.jetbrains.services.CoderiderTrackClient;
import cn.gitlab.kilo.jetbrains.utils.ThemeUtilKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.sina.weibo.agent.actions.VSCodeCommandActionsKt;
import com.sina.weibo.agent.plugin.WecoderPlugin;
import java.awt.Window;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import okhttp3.MediaType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u001a\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a\u0006\u0010\b\u001a\u00020\t\u001a\u0012\u0010\f\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u001a\u0006\u0010\r\u001a\u00020\t\u001a\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"JSON_MEDIA_TYPE", "Lokhttp3/MediaType;", "coderiderClient", "Lcn/gitlab/kilo/jetbrains/client/CoderiderClient;", "getCoderiderClient", "()Lcn/gitlab/kilo/jetbrains/client/CoderiderClient;", "setCoderiderClient", "(Lcn/gitlab/kilo/jetbrains/client/CoderiderClient;)V", "logout", "", "project", "Lcom/intellij/openapi/project/Project;", "refreshOtherProjects", "logUserOut", "getCoderiderAuthToken", "", "coderider-kilo-jetbrains"})
public final class CoderiderClientKt {
    @NotNull
    private static final MediaType JSON_MEDIA_TYPE = MediaType.Companion.get("application/json; charset=utf-8");
    @NotNull
    private static CoderiderClient coderiderClient = new CoderiderClient(null, 1, null);

    @NotNull
    public static final CoderiderClient getCoderiderClient() {
        return coderiderClient;
    }

    public static final void setCoderiderClient(@NotNull CoderiderClient coderiderClient) {
        Intrinsics.checkNotNullParameter((Object)coderiderClient, (String)"<set-?>");
        CoderiderClientKt.coderiderClient = coderiderClient;
    }

    public static final void logout(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        SwingUtilities.invokeLater(() -> CoderiderClientKt.logout$lambda$0(project));
    }

    public static final void logout() {
        SwingUtilities.invokeLater(CoderiderClientKt::logout$lambda$1);
    }

    public static final void refreshOtherProjects(@Nullable Project project) {
        ThemeUtilKt.webLaunchInScope((Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(project, null){
            int label;
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        try {
                            void $this$filterTo$iv$iv;
                            void $this$filter$iv;
                            Project[] projects;
                            Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
                            Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
                            Project[] projectArray2 = projects = projectArray;
                            Project project = this.$project;
                            boolean $i$f$filter = false;
                            void var6_9 = $this$filter$iv;
                            Collection destination$iv$iv = new ArrayList<E>();
                            boolean $i$f$filterTo = false;
                            int n = ((void)$this$filterTo$iv$iv).length;
                            for (int i = 0; i < n; ++i) {
                                void element$iv$iv;
                                void it = element$iv$iv = $this$filterTo$iv$iv[i];
                                boolean bl = false;
                                if (!(!Intrinsics.areEqual((Object)it, (Object)project) && !it.isDisposed())) continue;
                                destination$iv$iv.add(element$iv$iv);
                            }
                            Iterable $this$forEach$iv = (List)destination$iv$iv;
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                Project p = (Project)element$iv;
                                boolean bl = false;
                                try {
                                    Intrinsics.checkNotNull((Object)p);
                                    WecoderPlugin.Companion.getInstance(p).reset();
                                    Logger.info$default(LogKt.getLogger(), "Triggered reset for project: " + p.getName(), null, 2, null);
                                }
                                catch (Throwable e) {
                                    LogKt.getLogger().warn("Failed to reset project: " + p.getName(), e);
                                }
                            }
                        }
                        catch (Throwable e) {
                            LogKt.getLogger().warn("Error while notifying other projects to reset", e);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    public static /* synthetic */ void refreshOtherProjects$default(Project project, int n, Object object) {
        if ((n & 1) != 0) {
            project = null;
        }
        CoderiderClientKt.refreshOtherProjects(project);
    }

    public static final void logUserOut() {
        CockpitConfiguration.PluginState state;
        CockpitConfiguration.PluginState $this$logUserOut_u24lambda_u242 = state = CockpitConfiguration.Companion.getInstance().getState();
        boolean bl = false;
        $this$logUserOut_u24lambda_u242.setGitlabAccessToken(null);
        $this$logUserOut_u24lambda_u242.setUserName(null);
        $this$logUserOut_u24lambda_u242.setUserId(null);
        $this$logUserOut_u24lambda_u242.setCoderiderAuthToken(null);
        $this$logUserOut_u24lambda_u242.setCoderiderAuthTokenExpiredAt(null);
        if (!$this$logUserOut_u24lambda_u242.getSavePAT()) {
            $this$logUserOut_u24lambda_u242.setGitlabPAT(null);
        }
    }

    @Nullable
    public static final String getCoderiderAuthToken() {
        Instant currentInstant = LocalDateTime.now(ZoneOffset.UTC).atZone(ZoneOffset.UTC).toInstant();
        DateTimeFormatter formatter = DateTimeFormatter.ISO_DATE_TIME;
        if (CockpitConfiguration.Companion.getInstance().needLogin()) {
            return null;
        }
        if (CockpitConfiguration.Companion.getInstance().getState().getCoderiderAuthToken() == null) {
            CoderiderClient.refreshMetaData$default(coderiderClient, 0, 0L, 3, null);
        } else {
            Instant expiredInstant;
            String tokenExpiry;
            String string = tokenExpiry = CockpitConfiguration.Companion.getInstance().getState().getCoderiderAuthTokenExpiredAt();
            if (string != null) {
                String it = string;
                boolean bl = false;
                v1 = LocalDateTime.parse(it, formatter).atZone(ZoneOffset.UTC).toInstant();
            } else {
                v1 = expiredInstant = null;
            }
            if (expiredInstant != null && currentInstant.isAfter(expiredInstant)) {
                CoderiderClient.refreshMetaData$default(coderiderClient, 0, 0L, 3, null);
            }
        }
        return CockpitConfiguration.Companion.getInstance().getState().getCoderiderAuthToken();
    }

    private static final void logout$lambda$0(Project $project) {
        try {
            VSCodeCommandActionsKt.executeCommand("coderider-kilo.settings.logout", $project, new Object[0], false);
            CoderiderClientKt.refreshOtherProjects($project);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        CoderiderClientKt.logUserOut();
        Window window = SwingUtilities.getWindowAncestor(CodeRiderPluginActionsKt.getMainPanel());
        if (window != null) {
            window.dispose();
        }
        CockpitWidgetFactoryKt.updateCodeRiderStatus(CodeRiderStatus.NEEDS_LOGIN);
        CoderiderTrackClient.INSTANCE.clearEvent();
    }

    private static final void logout$lambda$1() {
        try {
            Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
            Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
            Project project = (Project)ArraysKt.firstOrNull((Object[])projectArray);
            VSCodeCommandActionsKt.executeCommand("coderider-kilo.settings.logout", project, new Object[0], false);
            CoderiderClientKt.refreshOtherProjects(project);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        CoderiderClientKt.logUserOut();
        Window window = SwingUtilities.getWindowAncestor(CodeRiderPluginActionsKt.getMainPanel());
        if (window != null) {
            window.dispose();
        }
        CockpitWidgetFactoryKt.updateCodeRiderStatus(CodeRiderStatus.NEEDS_LOGIN);
        CoderiderTrackClient.INSTANCE.clearEvent();
    }

    public static final /* synthetic */ MediaType access$getJSON_MEDIA_TYPE$p() {
        return JSON_MEDIA_TYPE;
    }
}

