/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.chat;

import cn.gitlab.kilo.jetbrains.chat.ChatHandlerKt;
import cn.gitlab.kilo.jetbrains.client.CoderiderClient;
import cn.gitlab.kilo.jetbrains.client.CoderiderClientKt;
import cn.gitlab.kilo.jetbrains.client.RetrieveRagRequest;
import cn.gitlab.kilo.jetbrains.client.RetrieveRagResponse;
import cn.gitlab.kilo.jetbrains.common.ChatConfig;
import cn.gitlab.kilo.jetbrains.common.ChatDtoKt;
import cn.gitlab.kilo.jetbrains.common.ChatMessage;
import cn.gitlab.kilo.jetbrains.common.ChatModel;
import cn.gitlab.kilo.jetbrains.common.ChatPayload;
import cn.gitlab.kilo.jetbrains.common.Conversation;
import cn.gitlab.kilo.jetbrains.common.ConversationReq;
import cn.gitlab.kilo.jetbrains.common.CustomException;
import cn.gitlab.kilo.jetbrains.common.FileMention;
import cn.gitlab.kilo.jetbrains.common.I18nKt;
import cn.gitlab.kilo.jetbrains.common.LLMChatMessage;
import cn.gitlab.kilo.jetbrains.common.LLMParam;
import cn.gitlab.kilo.jetbrains.common.Logger;
import cn.gitlab.kilo.jetbrains.common.Message;
import cn.gitlab.kilo.jetbrains.common.MessageExtra;
import cn.gitlab.kilo.jetbrains.common.MessageTip;
import cn.gitlab.kilo.jetbrains.common.Rag;
import cn.gitlab.kilo.jetbrains.common.RagSelectItem;
import cn.gitlab.kilo.jetbrains.common.Range;
import cn.gitlab.kilo.jetbrains.common.Role;
import cn.gitlab.kilo.jetbrains.common.Speaker;
import cn.gitlab.kilo.jetbrains.common.Status;
import cn.gitlab.kilo.jetbrains.composer.prompts.ProjectMemoryPrompterKt;
import cn.gitlab.kilo.jetbrains.config.CockpitConfiguration;
import cn.gitlab.kilo.jetbrains.config.ModelsConfiguration;
import cn.gitlab.kilo.jetbrains.config.UserMemoryStorage;
import cn.gitlab.kilo.jetbrains.constants.ConstantsKt;
import cn.gitlab.kilo.jetbrains.edit.CockpitInlineQuickCommandRenderKt;
import cn.gitlab.kilo.jetbrains.edit.EditInlineStreamService;
import cn.gitlab.kilo.jetbrains.edit.EditStreamHandler;
import cn.gitlab.kilo.jetbrains.edit.LensesService;
import cn.gitlab.kilo.jetbrains.edit.action.DiffStreamUtilsKt;
import cn.gitlab.kilo.jetbrains.factories.CockpitWidgetFactoryKt;
import cn.gitlab.kilo.jetbrains.llmClient.ChatClient;
import cn.gitlab.kilo.jetbrains.llmClient.OllamaClient;
import cn.gitlab.kilo.jetbrains.llmClient.OpenAiClient;
import cn.gitlab.kilo.jetbrains.prompt.ChatPromptResult;
import cn.gitlab.kilo.jetbrains.prompt.ChatPrompterKt;
import cn.gitlab.kilo.jetbrains.services.CockpitChatPluginService;
import cn.gitlab.kilo.jetbrains.services.CodeRiderStatus;
import cn.gitlab.kilo.jetbrains.services.GenerationCallbacks;
import cn.gitlab.kilo.jetbrains.services.TrackService;
import cn.gitlab.kilo.jetbrains.services.context.ContextSnippet;
import cn.gitlab.kilo.jetbrains.services.context.LanguageUtilsKt;
import cn.gitlab.kilo.jetbrains.utils.ChatParameters;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.Ksuid;
import com.jgoodies.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import okhttp3.internal.http2.StreamResetException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J \u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\tH\u0002J\u000e\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007J\"\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\tJ*\u0010\u0016\u001a\u00020\u00052\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00050\u001bH\u0002J6\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001e2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\t2\b\u0010\"\u001a\u0004\u0018\u00010\tH\u0002J.\u0010#\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001e2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\"\u001a\u0004\u0018\u00010\tH\u0002J.\u0010$\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001e2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\"\u001a\u0004\u0018\u00010\tH\u0002J8\u0010%\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001e2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\"\u001a\u0004\u0018\u00010\t2\b\b\u0002\u0010&\u001a\u00020'H\u0002J$\u0010(\u001a\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020*0)2\u0006\u0010+\u001a\u00020\u00192\u0006\u0010,\u001a\u00020-H\u0002JI\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u00102\u001a\u0002012\n\b\u0002\u00103\u001a\u0004\u0018\u00010*2\u0006\u00104\u001a\u00020*2\u0006\u00105\u001a\u00020*2\u0006\u00106\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u00107JE\u00108\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u00102\u001a\u0004\u0018\u0001012\n\b\u0002\u00103\u001a\u0004\u0018\u00010*2\u0006\u00104\u001a\u00020*2\u0006\u00105\u001a\u00020*H\u0002\u00a2\u0006\u0002\u00109JD\u0010:\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010;\u001a\u0004\u0018\u00010\t2\u0006\u0010<\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010=\u001a\u00020\t2\u0010\b\u0002\u0010>\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u0018H\u0002J\u001a\u0010?\u001a\u00020'2\b\u0010\u0015\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0012\u0010C\u001a\u00020B2\n\b\u0002\u0010D\u001a\u0004\u0018\u00010\tJA\u0010E\u001a\u00020\u00052\n\b\u0002\u0010<\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010F\u001a\u0004\u0018\u00010'2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010G\u001a\u00020\u001e2\n\b\u0002\u0010H\u001a\u0004\u0018\u00010'H\u0002\u00a2\u0006\u0002\u0010IJ*\u0010J\u001a\b\u0012\u0004\u0012\u00020\u001e0K2\u0006\u0010=\u001a\u00020\t2\u0012\u0010L\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u001e0AH\u0002J\u0016\u0010M\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010N\u001a\u00020\tJ\u0018\u0010O\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010G\u001a\u00020\u001eH\u0002J\u000e\u0010P\u001a\u00020'2\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010Q\u001a\u00020R2\u0006\u0010<\u001a\u00020\u000eJ\u0016\u0010S\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010D\u001a\u00020\tJ\u001e\u0010T\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010U\u001a\u00020\t2\u0006\u0010V\u001a\u00020'J\u0016\u0010W\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010U\u001a\u00020\tR\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010@\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020B0AX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006X"}, d2={"Lcn/gitlab/kilo/jetbrains/chat/ChatHandler;", "", "<init>", "()V", "init", "", "project", "Lcom/intellij/openapi/project/Project;", "getChatTitle", "", "lastDisplayText", "lastTitle", "conversations", "", "Lcn/gitlab/kilo/jetbrains/common/Conversation;", "requestCanceller", "Lkotlin/Function0;", "getConversation", "handleChatSubmit", "payload", "Lcn/gitlab/kilo/jetbrains/common/ChatPayload;", "commandType", "executeFileMention", "fileMentions", "", "Lcn/gitlab/kilo/jetbrains/common/FileMention;", "callback", "Lkotlin/Function1;", "handleEditCode", "botMsg", "Lcn/gitlab/kilo/jetbrains/common/ChatMessage;", "messageExtra", "Lcn/gitlab/kilo/jetbrains/common/MessageExtra;", "prompt", "text", "handleGenerateTests", "handleSmellCode", "handleDocumentCode", "isDocstring", "", "getStartLineAndEndLine", "Lkotlin/Pair;", "", "fileMention", "document", "Lcom/intellij/openapi/editor/Document;", "generateVirtualFileWithDiffStreamHandler", "Lcn/gitlab/kilo/jetbrains/edit/EditStreamHandler;", "editor", "Lcom/intellij/openapi/editor/Editor;", "newEditor", "targetStartLine", "startLine", "endLine", "oldFilePath", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Ljava/lang/Integer;IILjava/lang/String;)Lcn/gitlab/kilo/jetbrains/edit/EditStreamHandler;", "generateDiffStreamHandler", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Ljava/lang/Integer;II)Lcn/gitlab/kilo/jetbrains/edit/EditStreamHandler;", "getRagAndCall", "payloadTextInput", "conv", "currentNode", "kbIds", "useProjectMemory", "llmClients", "", "Lcn/gitlab/kilo/jetbrains/llmClient/ChatClient;", "getLLMClient", "modelKey", "updateMessage", "storeConv", "msg", "setAsCurrentNode", "(Lcn/gitlab/kilo/jetbrains/common/Conversation;Ljava/lang/Boolean;Lcom/intellij/openapi/project/Project;Lcn/gitlab/kilo/jetbrains/common/ChatMessage;Ljava/lang/Boolean;)V", "getLinearMessages", "", "messages", "insertError", "errorMsg", "insertMessage", "cancelInflightRequests", "getChatConfig", "Lcn/gitlab/kilo/jetbrains/common/ChatConfig;", "handleChatChangeModel", "handleChatRegenerate", "msgId", "inPlace", "chatClearContext", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nChatHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatHandler.kt\ncn/gitlab/kilo/jetbrains/chat/ChatHandler\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,930:1\n382#2,7:931\n1#3:938\n1068#4:939\n1669#4,8:940\n1869#4,2:948\n1869#4,2:952\n1563#4:954\n1634#4,3:955\n31#5,2:950\n*S KotlinDebug\n*F\n+ 1 ChatHandler.kt\ncn/gitlab/kilo/jetbrains/chat/ChatHandler\n*L\n75#1:931,7\n152#1:939\n153#1:940,8\n154#1:948,2\n828#1:952,2\n849#1:954\n849#1:955,3\n505#1:950,2\n*E\n"})
public final class ChatHandler {
    @NotNull
    public static final ChatHandler INSTANCE = new ChatHandler();
    @NotNull
    private static final Map<Project, Conversation> conversations = new LinkedHashMap();
    @Nullable
    private static Function0<Unit> requestCanceller;
    @NotNull
    private static final Map<String, ChatClient> llmClients;

    private ChatHandler() {
    }

    public final void init(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Map<Project, Conversation> map = conversations;
        String string = Ksuid.generate();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"generate(...)");
        Conversation conversation = new Conversation(string, null, System.currentTimeMillis(), 0L, ModelsConfiguration.Companion.getInstance().getCurrentChatModelId(), ChatHandler.getChatTitle$default(this, null, null, 3, null), new LinkedHashMap(), null, null, 384, null);
        map.put(project, conversation);
    }

    private final String getChatTitle(String lastDisplayText, String lastTitle) {
        if (lastTitle != null && !Intrinsics.areEqual((Object)lastTitle, (Object)I18nKt.getMessage("new.conversation"))) {
            return lastTitle;
        }
        if (!Strings.isBlank((String)lastDisplayText)) {
            String string = lastDisplayText;
            Intrinsics.checkNotNull((Object)string);
            return string;
        }
        return I18nKt.getMessage("new.conversation");
    }

    static /* synthetic */ String getChatTitle$default(ChatHandler chatHandler, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        return chatHandler.getChatTitle(string, string2);
    }

    @NotNull
    public final Conversation getConversation(@NotNull Project project) {
        Conversation conversation;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Map<Project, Conversation> $this$getOrPut$iv = conversations;
        boolean $i$f$getOrPut = false;
        Conversation value$iv = $this$getOrPut$iv.get(project);
        if (value$iv == null) {
            boolean bl = false;
            String string = Ksuid.generate();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"generate(...)");
            Conversation answer$iv = new Conversation(string, null, System.currentTimeMillis(), 0L, ModelsConfiguration.Companion.getInstance().getCurrentChatModelId(), ChatHandler.getChatTitle$default(INSTANCE, null, null, 3, null), new LinkedHashMap(), null, null, 384, null);
            $this$getOrPut$iv.put(project, answer$iv);
            conversation = answer$iv;
        } else {
            conversation = value$iv;
        }
        Conversation conversation2 = conversation;
        conversation2.setModel(ModelsConfiguration.Companion.getInstance().getCurrentChatModelId());
        return conversation2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void handleChatSubmit(@NotNull Project project, @NotNull ChatPayload payload, @Nullable String commandType) {
        String string;
        String string2;
        Conversation conv;
        block22: {
            String currNode;
            block21: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
                CockpitConfiguration.PluginState state = CockpitConfiguration.Companion.getInstance().getState();
                if (!state.getChatEnabled()) {
                    return;
                }
                conv = this.getConversation(project);
                String string3 = conv.getCurrentNode();
                if (string3 == null) {
                    string3 = currNode = "";
                }
                if ((string2 = payload.getParentId()) == null) break block21;
                String string4 = string = string2;
                boolean bl = false;
                string2 = !StringsKt.isBlank((CharSequence)string4) ? string : null;
                if (string2 != null) break block22;
            }
            string2 = currNode;
        }
        String parentId = string2;
        List<String> kbIds = payload.getKbProjectId();
        string = Ksuid.generate();
        Speaker speaker = Speaker.human;
        String string5 = payload.getText();
        String string6 = payload.getDisplayText();
        long l = System.currentTimeMillis();
        Status status = Status.finished;
        String string7 = payload.getEditorMessageState();
        ChatMessage humanMsg = new ChatMessage(string, null, l, speaker, status, null, string5, string6, parentId, commandType, string7, null, kbIds, 2082, null);
        this.insertMessage(project, humanMsg);
        conv = this.getConversation(project);
        String string8 = humanMsg.getMsgId();
        if (string8 == null) {
            string8 = "";
        }
        String currentNode = string8;
        string5 = Ksuid.generate();
        string6 = humanMsg.getMsgId();
        Speaker speaker2 = Speaker.assistant;
        long l2 = System.currentTimeMillis();
        Status status2 = Status.streaming;
        String string9 = payload.getCommandType();
        ChatMessage chatMessage = new ChatMessage(string5, null, l2, speaker2, status2, null, "", null, string6, string9, null, null, null, 7330, null);
        string5 = payload.getCommandType();
        if (string5 != null) {
            int n = -1;
            switch (string5.hashCode()) {
                case -435357073: {
                    if (!string5.equals("smell-code")) break;
                    n = 1;
                    break;
                }
                case 893131593: {
                    if (!string5.equals("docstring")) break;
                    n = 2;
                    break;
                }
                case 1538881375: {
                    if (!string5.equals("document-code")) break;
                    n = 3;
                    break;
                }
                case 1697935850: {
                    if (!string5.equals("generate-test")) break;
                    n = 4;
                    break;
                }
                case -1912694832: {
                    if (!string5.equals("edit-code")) break;
                    n = 5;
                    break;
                }
            }
            switch (n) {
                case 4: {
                    ActionsKt.invokeLater$default(null, () -> ChatHandler.handleChatSubmit$lambda$2(chatMessage, payload, project), (int)1, null);
                    return;
                }
                case 1: {
                    ActionsKt.invokeLater$default(null, () -> ChatHandler.handleChatSubmit$lambda$3(chatMessage, payload, project), (int)1, null);
                    return;
                }
                case 5: {
                    String string10 = payload.getText();
                    if (string10 == null) return;
                    String it = string10;
                    boolean bl = false;
                    ActionsKt.invokeLater$default(null, () -> ChatHandler.handleChatSubmit$lambda$5$lambda$4(chatMessage, payload, project, it), (int)1, null);
                    return;
                }
                case 3: {
                    ActionsKt.invokeLater$default(null, () -> ChatHandler.handleChatSubmit$lambda$6(chatMessage, payload, project), (int)1, null);
                    return;
                }
                case 2: {
                    ActionsKt.invokeLater$default(null, () -> ChatHandler.handleChatSubmit$lambda$7(chatMessage, payload, project), (int)1, null);
                    return;
                }
            }
        }
        this.insertMessage(project, chatMessage);
        this.getRagAndCall(project, payload.getText(), conv, chatMessage, currentNode, kbIds);
    }

    public static /* synthetic */ void handleChatSubmit$default(ChatHandler chatHandler, Project project, ChatPayload chatPayload, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = "chat";
        }
        chatHandler.handleChatSubmit(project, chatPayload, string);
    }

    /*
     * WARNING - void declaration
     */
    private final void executeFileMention(List<FileMention> fileMentions, Function1<? super FileMention, Unit> callback) {
        void $this$distinctBy$iv;
        Iterable $this$sortedByDescending$iv;
        Iterable iterable = fileMentions;
        boolean $i$f$sortedByDescending = false;
        $this$sortedByDescending$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                FileMention it = (FileMention)b;
                boolean bl = false;
                String string = it.getData().getLabel();
                it = (FileMention)a;
                Comparable comparable = Integer.valueOf(string != null ? string.length() : 0);
                bl = false;
                String string2 = it.getData().getLabel();
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(string2 != null ? string2.length() : 0));
            }
        });
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            FileMention it = (FileMention)e$iv;
            boolean bl = false;
            String key$iv = it.getData().getCodePath();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        List sortedAndDistinctFileMentions = list$iv;
        Iterable $this$forEach$iv = CollectionsKt.take((Iterable)sortedAndDistinctFileMentions, (int)5);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FileMention it = (FileMention)element$iv;
            boolean bl = false;
            callback.invoke((Object)it);
        }
    }

    private final void handleEditCode(ChatMessage botMsg, MessageExtra messageExtra, Project project, String prompt, String text) {
        ChatMessage chatMessage;
        Ref.ObjectRef message = new Ref.ObjectRef();
        message.element = I18nKt.getMessage("code.improvement.suggestions.generating");
        ChatMessage $this$handleEditCode_u24lambda_u2411 = chatMessage = botMsg;
        boolean bl = false;
        $this$handleEditCode_u24lambda_u2411.setDisplayText((String)message.element);
        $this$handleEditCode_u24lambda_u2411.setStatus(Status.finished);
        this.insertMessage(project, botMsg);
        List references = new ArrayList();
        Conversation conv = this.getConversation(project);
        Object object = messageExtra;
        if (object == null || (object = ((MessageExtra)object).getFileMentions()) == null) {
            object = CollectionsKt.emptyList();
        }
        this.executeFileMention((List<FileMention>)object, (Function1<? super FileMention, Unit>)((Function1)arg_0 -> ChatHandler.handleEditCode$lambda$17(project, text, prompt, references, botMsg, conv, message, arg_0)));
        Object object2 = conv.getMessages().get(botMsg.getParentId());
        if (object2 == null || (object2 = ((ChatMessage)object2).getText()) == null) {
            object2 = botMsg.getDisplayText();
        }
        Object text2 = object2;
    }

    static /* synthetic */ void handleEditCode$default(ChatHandler chatHandler, ChatMessage chatMessage, MessageExtra messageExtra, Project project, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            messageExtra = null;
        }
        chatHandler.handleEditCode(chatMessage, messageExtra, project, string, string2);
    }

    private final void handleGenerateTests(ChatMessage botMsg, MessageExtra messageExtra, Project project, String text) {
        ChatMessage chatMessage;
        Ref.ObjectRef message = new Ref.ObjectRef();
        message.element = I18nKt.getMessage("code.unit.tests.generating");
        ChatMessage $this$handleGenerateTests_u24lambda_u2418 = chatMessage = botMsg;
        boolean bl = false;
        $this$handleGenerateTests_u24lambda_u2418.setDisplayText((String)message.element);
        $this$handleGenerateTests_u24lambda_u2418.setStatus(Status.finished);
        this.insertMessage(project, botMsg);
        List references = new ArrayList();
        Conversation conv = this.getConversation(project);
        Object object = messageExtra;
        if (object == null || (object = ((MessageExtra)object).getFileMentions()) == null) {
            object = CollectionsKt.emptyList();
        }
        this.executeFileMention((List<FileMention>)object, (Function1<? super FileMention, Unit>)((Function1)arg_0 -> ChatHandler.handleGenerateTests$lambda$23(project, text, references, botMsg, conv, message, arg_0)));
        Object object2 = conv.getMessages().get(botMsg.getParentId());
        if (object2 == null || (object2 = ((ChatMessage)object2).getText()) == null) {
            object2 = botMsg.getDisplayText();
        }
        Object text2 = object2;
    }

    static /* synthetic */ void handleGenerateTests$default(ChatHandler chatHandler, ChatMessage chatMessage, MessageExtra messageExtra, Project project, String string, int n, Object object) {
        if ((n & 2) != 0) {
            messageExtra = null;
        }
        chatHandler.handleGenerateTests(chatMessage, messageExtra, project, string);
    }

    private final void handleSmellCode(ChatMessage botMsg, MessageExtra messageExtra, Project project, String text) {
        ChatMessage chatMessage;
        Ref.ObjectRef message = new Ref.ObjectRef();
        message.element = I18nKt.getMessage("code.optimization.suggestions.generating");
        ChatMessage $this$handleSmellCode_u24lambda_u2424 = chatMessage = botMsg;
        boolean bl = false;
        $this$handleSmellCode_u24lambda_u2424.setDisplayText((String)message.element);
        $this$handleSmellCode_u24lambda_u2424.setStatus(Status.finished);
        this.insertMessage(project, botMsg);
        List references = new ArrayList();
        Conversation conv = this.getConversation(project);
        Object object = messageExtra;
        if (object == null || (object = ((MessageExtra)object).getFileMentions()) == null) {
            object = CollectionsKt.emptyList();
        }
        this.executeFileMention((List<FileMention>)object, (Function1<? super FileMention, Unit>)((Function1)arg_0 -> ChatHandler.handleSmellCode$lambda$30(project, text, references, botMsg, conv, message, arg_0)));
        Object object2 = conv.getMessages().get(botMsg.getParentId());
        if (object2 == null || (object2 = ((ChatMessage)object2).getText()) == null) {
            object2 = botMsg.getDisplayText();
        }
        Object text2 = object2;
    }

    static /* synthetic */ void handleSmellCode$default(ChatHandler chatHandler, ChatMessage chatMessage, MessageExtra messageExtra, Project project, String string, int n, Object object) {
        if ((n & 2) != 0) {
            messageExtra = null;
        }
        chatHandler.handleSmellCode(chatMessage, messageExtra, project, string);
    }

    private final void handleDocumentCode(ChatMessage botMsg, MessageExtra messageExtra, Project project, String text, boolean isDocstring) {
        ChatMessage chatMessage;
        String message = isDocstring ? I18nKt.getMessage("code.docstrings.generating") : I18nKt.getMessage("code.comments.generating");
        ChatMessage $this$handleDocumentCode_u24lambda_u2431 = chatMessage = botMsg;
        boolean bl = false;
        $this$handleDocumentCode_u24lambda_u2431.setDisplayText(message);
        $this$handleDocumentCode_u24lambda_u2431.setStatus(Status.finished);
        this.insertMessage(project, botMsg);
        List references = new ArrayList();
        Conversation conv = this.getConversation(project);
        Object object = messageExtra;
        if (object == null || (object = ((MessageExtra)object).getFileMentions()) == null) {
            object = CollectionsKt.emptyList();
        }
        this.executeFileMention((List<FileMention>)object, (Function1<? super FileMention, Unit>)((Function1)arg_0 -> ChatHandler.handleDocumentCode$lambda$37(project, isDocstring, text, references, botMsg, conv, message, arg_0)));
        Object object2 = conv.getMessages().get(botMsg.getParentId());
        if (object2 == null || (object2 = ((ChatMessage)object2).getText()) == null) {
            object2 = botMsg.getDisplayText();
        }
        Object text2 = object2;
    }

    static /* synthetic */ void handleDocumentCode$default(ChatHandler chatHandler, ChatMessage chatMessage, MessageExtra messageExtra, Project project, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            messageExtra = null;
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        chatHandler.handleDocumentCode(chatMessage, messageExtra, project, string, bl);
    }

    private final Pair<Integer, Integer> getStartLineAndEndLine(FileMention fileMention, Document document) {
        String label = fileMention.getData().getLabel();
        if (label != null && StringsKt.contains$default((CharSequence)label, (CharSequence)":", (boolean)false, (int)2, null)) {
            String[] stringArray = new String[]{":"};
            CharSequence charSequence = (CharSequence)StringsKt.split$default((CharSequence)label, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(1);
            stringArray = new String[]{"-"};
            List parts = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            int startLine = Math.max(Integer.parseInt((String)parts.get(0)) - 1, 0);
            int endLine = Math.max(Integer.parseInt((String)parts.get(1)) - 1, 0);
            return new Pair((Object)startLine, (Object)endLine);
        }
        int startLine = 0;
        int endLine = Math.max(document.getLineCount() - 1, 0);
        return new Pair((Object)startLine, (Object)endLine);
    }

    private final EditStreamHandler generateVirtualFileWithDiffStreamHandler(Editor editor, Project project, Editor newEditor, Integer targetStartLine, int startLine, int endLine, String oldFilePath) {
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String taskId = string;
        LensesService lensesService = LensesService.Companion.getInstance(project);
        int expandedStartOffset = editor.getDocument().getLineStartOffset(startLine);
        int expandedEndOffset = editor.getDocument().getLineEndOffset(endLine);
        Editor targetEditor = newEditor;
        return new EditStreamHandler(() -> ChatHandler.generateVirtualFileWithDiffStreamHandler$lambda$38(lensesService, targetEditor), () -> ChatHandler.generateVirtualFileWithDiffStreamHandler$lambda$41(expandedStartOffset, expandedEndOffset, targetEditor, targetStartLine, lensesService, taskId), project, targetEditor, startLine, endLine, ChatHandler::generateVirtualFileWithDiffStreamHandler$lambda$42, () -> ChatHandler.generateVirtualFileWithDiffStreamHandler$lambda$43(newEditor, project, oldFilePath), editor.getVirtualFile().getPath(), editor.getDocument().getText(), expandedStartOffset, expandedEndOffset, editor, targetStartLine, null, oldFilePath, 16384, null);
    }

    static /* synthetic */ EditStreamHandler generateVirtualFileWithDiffStreamHandler$default(ChatHandler chatHandler, Editor editor, Project project, Editor editor2, Integer n, int n2, int n3, String string, int n4, Object object) {
        if ((n4 & 8) != 0) {
            n = null;
        }
        return chatHandler.generateVirtualFileWithDiffStreamHandler(editor, project, editor2, n, n2, n3, string);
    }

    private final EditStreamHandler generateDiffStreamHandler(Editor editor, Project project, Editor newEditor, Integer targetStartLine, int startLine, int endLine) {
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String taskId = string;
        LensesService lensesService = LensesService.Companion.getInstance(project);
        int expandedStartOffset = editor.getDocument().getLineStartOffset(startLine);
        int expandedEndOffset = editor.getDocument().getLineEndOffset(endLine);
        Editor editor2 = newEditor;
        if (editor2 == null) {
            editor2 = editor;
        }
        Editor targetEditor = editor2;
        EditStreamHandler editStreamHandler = new EditStreamHandler(() -> ChatHandler.generateDiffStreamHandler$lambda$44(lensesService, targetEditor), () -> ChatHandler.generateDiffStreamHandler$lambda$47(expandedStartOffset, expandedEndOffset, targetEditor, targetStartLine, lensesService, taskId), project, targetEditor, startLine, endLine, ChatHandler::generateDiffStreamHandler$lambda$48, () -> ChatHandler.generateDiffStreamHandler$lambda$51(expandedStartOffset, expandedEndOffset, targetEditor, targetStartLine, lensesService, taskId), editor.getVirtualFile().getPath(), editor.getDocument().getText(), expandedStartOffset, expandedEndOffset, editor, targetStartLine, null, null, 49152, null);
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<EditInlineStreamService> serviceClass$iv = EditInlineStreamService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ((EditInlineStreamService)object).register(editStreamHandler, targetEditor);
        return editStreamHandler;
    }

    static /* synthetic */ EditStreamHandler generateDiffStreamHandler$default(ChatHandler chatHandler, Editor editor, Project project, Editor editor2, Integer n, int n2, int n3, int n4, Object object) {
        if ((n4 & 4) != 0) {
            editor2 = null;
        }
        if ((n4 & 8) != 0) {
            n = null;
        }
        return chatHandler.generateDiffStreamHandler(editor, project, editor2, n, n2, n3);
    }

    private final void getRagAndCall(Project project, String payloadTextInput, Conversation conv, ChatMessage botMsg, String currentNode, List<String> kbIds) {
        Logger.debug$default(ConstantsKt.getLogger(), "getRagAndCall begin", null, 2, null);
        String payloadText = payloadTextInput;
        boolean useProjectMemory = this.useProjectMemory(botMsg.getCommandType(), project);
        Ref.ObjectRef ragResult = new Ref.ObjectRef();
        if (kbIds != null && !((Collection)kbIds).isEmpty()) {
            for (String kbId : kbIds) {
                Rag rag = CockpitConfiguration.Companion.getInstance().getRagByKbId(kbId);
                if (rag == null) continue;
                String string = payloadTextInput;
                payloadText = string != null ? StringsKt.replace$default((String)string, (String)("@" + rag.getPath()), (String)"", (boolean)false, (int)4, null) : null;
            }
            if (!useProjectMemory) {
                CoderiderClient coderiderClient = CoderiderClientKt.getCoderiderClient();
                String string = payloadText;
                if (string == null) {
                    string = "";
                }
                ragResult.element = coderiderClient.retrieveRagDocuments(new RetrieveRagRequest(string, kbIds, 0, false, 0, 0.0, 60, null));
            }
        }
        long startTime = System.currentTimeMillis();
        ModelsConfiguration.ModelConfig modelConfig = ModelsConfiguration.Companion.getInstance().getChatModels().get(conv.getModel());
        Intrinsics.checkNotNull((Object)modelConfig);
        ModelsConfiguration.ModelConfig model = modelConfig;
        Logger.debug$default(ConstantsKt.getLogger(), "getRagAndCall callbacks generate begin", null, 2, null);
        GenerationCallbacks callbacks2 = new GenerationCallbacks(botMsg, conv, project, startTime, (Ref.ObjectRef<RetrieveRagResponse>)ragResult){
            private boolean first;
            final /* synthetic */ ChatMessage $botMsg;
            final /* synthetic */ Conversation $conv;
            final /* synthetic */ Project $project;
            final /* synthetic */ long $startTime;
            final /* synthetic */ Ref.ObjectRef<RetrieveRagResponse> $ragResult;
            {
                this.$botMsg = $botMsg;
                this.$conv = $conv;
                this.$project = $project;
                this.$startTime = $startTime;
                this.$ragResult = $ragResult;
                this.first = true;
            }

            public final boolean getFirst() {
                return this.first;
            }

            public final void setFirst(boolean bl) {
                this.first = bl;
            }

            public void onChange(String text, String reasonText) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                CockpitWidgetFactoryKt.updateCodeRiderStatus(CodeRiderStatus.THINKING);
                this.$botMsg.setText(text);
                this.$botMsg.setReasoningText(reasonText);
                this.$botMsg.setDisplayText(text);
                ChatHandler.updateMessage$default(ChatHandler.INSTANCE, this.$conv, false, this.$project, this.$botMsg, null, 16, null);
                if (this.first) {
                    try {
                        long endTime = System.currentTimeMillis();
                        V v = ChatHandler.access$getConversations$p().get(this.$project);
                        Intrinsics.checkNotNull(v);
                        TrackService.INSTANCE.TTFT(((Conversation)v).getModel(), endTime - this.$startTime, endTime);
                    }
                    catch (Throwable e) {
                        Logger.error$default(ConstantsKt.getLogger(), e.getMessage(), null, 2, null);
                    }
                    this.first = false;
                }
            }

            /*
             * WARNING - void declaration
             */
            public void onComplete(String text, String reasonText) {
                this.$botMsg.setStatus(Status.finished);
                if (this.$ragResult.element != null && !((Collection)((RetrieveRagResponse)this.$ragResult.element).getUrls()).isEmpty()) {
                    void $this$mapIndexedTo$iv$iv;
                    List<String> ragReference = ((RetrieveRagResponse)this.$ragResult.element).getUrls();
                    int urlCount = ragReference.size();
                    Iterable $this$mapIndexed$iv = ragReference;
                    boolean $i$f$mapIndexed = false;
                    Iterable iterable = $this$mapIndexed$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
                    boolean $i$f$mapIndexedTo = false;
                    int index$iv$iv = 0;
                    for (T item$iv$iv : $this$mapIndexedTo$iv$iv) {
                        void index;
                        void url;
                        int n;
                        if ((n = index$iv$iv++) < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        String string = (String)item$iv$iv;
                        int n2 = n;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        CharSequence charSequence = (CharSequence)url;
                        Regex regex = new Regex("^https?://");
                        String string2 = "";
                        charSequence = regex.replace(charSequence, string2);
                        regex = new Regex("/$");
                        string2 = "";
                        String displayText = StringsKt.substringAfterLast$default((String)regex.replace(charSequence, string2), (String)"/", null, (int)2, null);
                        collection.add(" <li style=\"margin: 4px 0;\">\n                        <span style=\"opacity: 0.7; margin-right: 6px;\">" + (int)(index + true) + ".</span>\n                        <a href=\"" + (String)url + "\" target=\"_blank\" rel=\"noopener noreferrer\"\n                          style=\"color: var(--vscode-textLink-foreground, #0066cc); text-decoration: none;\">\n                          " + displayText + "\n                        </a>\n                      </li>");
                    }
                    String urlListHtml = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
                    String referencesText = "\n\n<details style=\"margin: 12px 0;\">\n                                    <summary style=\"cursor: pointer; opacity: 0.8; user-select: none; list-style: none; position: relative;width: fit-content;\">\n                                      <svg class=\"arrow-icon\" width=\"12\" height=\"12\" xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 16 16\" style=\"display: inline-block; position: absolute; right: -16px; top:4px; transition: transform 0.2s ease; vertical-align: middle;\">\n                                        <path fill=\"none\" stroke=\"currentColor\" stroke-width=\"2\" stroke-linecap=\"round\" stroke-linejoin=\"round\" d=\"m4 6 4 4 4-4\"></path>\n                                      </svg>\n                                  " + I18nKt.getMessage("rag.reference.title") + " (" + urlCount + ")\n                                    </summary>\n                                    <ul style=\"list-style: none; padding: 0; margin: 8px 0 0 0;\">\n                                  " + urlListHtml + "\n                                    </ul>\n                                 </details>\n\n";
                    this.$botMsg.setReasoningText(reasonText);
                    this.$botMsg.setDisplayText(text + referencesText);
                }
                ChatHandler.access$updateMessage(ChatHandler.INSTANCE, this.$conv, true, this.$project, this.$botMsg, true);
                CockpitWidgetFactoryKt.updateCodeRiderStatus(CodeRiderStatus.LOGGED_IN);
                ChatHandler.access$setRequestCanceller$p(null);
            }

            public void onError(String text, Throwable error2) {
                block7: {
                    block8: {
                        block6: {
                            Intrinsics.checkNotNullParameter((Object)error2, (String)"error");
                            if (!(error2 instanceof CustomException)) break block6;
                            String string = ((CustomException)error2).getMessage();
                            if (string != null) {
                                String string2 = string;
                                Project project = this.$project;
                                String it = string2;
                                boolean bl = false;
                                ChatHandler.INSTANCE.insertError(project, it);
                            }
                            break block7;
                        }
                        if (!(error2 instanceof StreamResetException)) break block8;
                        String string = error2.getMessage();
                        if (string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"CANCEL", (boolean)false, (int)2, null) : false) break block7;
                    }
                    error2.printStackTrace();
                    MessageTip msg = new MessageTip(null, "error", String.valueOf(error2.getMessage()), 1, null);
                    CockpitChatPluginService cockpitChatPluginService = (CockpitChatPluginService)this.$project.getService(CockpitChatPluginService.class);
                }
                Function0 function0 = ChatHandler.access$getRequestCanceller$p();
                if (function0 != null) {
                    function0.invoke();
                }
                this.$botMsg.setStatus(Status.aborted);
                ChatHandler.access$updateMessage(ChatHandler.INSTANCE, this.$conv, true, this.$project, this.$botMsg, true);
                CockpitWidgetFactoryKt.updateCodeRiderStatus(CodeRiderStatus.LOGGED_IN);
                ChatHandler.access$setRequestCanceller$p(null);
            }

            public void onSensitive() {
                this.$botMsg.setText(I18nKt.getMessage("sensitive_response"));
                this.$botMsg.setDisplayText(I18nKt.getMessage("sensitive_response"));
                this.$botMsg.setStatus(Status.finished);
                ChatHandler.access$updateMessage(ChatHandler.INSTANCE, this.$conv, true, this.$project, this.$botMsg, true);
            }

            public void metric(Long tokensIn, Long tokensOut) {
                GenerationCallbacks.DefaultImpls.metric(this, tokensIn, tokensOut);
            }
        };
        try {
            Object object;
            Logger.debug$default(ConstantsKt.getLogger(), "getRagAndCall callbacks getLinearMessages ", null, 2, null);
            List<ChatMessage> linearMessages = this.getLinearMessages(currentNode, conv.getMessages());
            Logger.debug$default(ConstantsKt.getLogger(), "getRagAndCall callbacks forgeChatPrompt ", null, 2, null);
            ChatPromptResult llmMessages = ChatPrompterKt.forgeChatPrompt(linearMessages, useProjectMemory, model.getId(), project);
            List messages = new ArrayList();
            Stream<Object> stream = kbIds;
            if (stream == null || stream.isEmpty()) {
                stream = llmMessages.getCompletionMessages().stream().filter(arg_0 -> ChatHandler.getRagAndCall$lambda$53(ChatHandler::getRagAndCall$lambda$52, arg_0));
                if (stream != null && (object = stream.map(arg_0 -> ChatHandler.getRagAndCall$lambda$55(ChatHandler::getRagAndCall$lambda$54, arg_0))) != null) {
                    object.forEach(arg_0 -> ChatHandler.getRagAndCall$lambda$56((Function1)new Function1<Message, Unit>((Object)messages){

                        public final void invoke(Message p0) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            ((List)this.receiver).add(p0);
                        }
                    }, arg_0));
                }
            } else {
                messages.add(new Message(Role.system, I18nKt.getPrompt("rag.system.text") + llmMessages.getCompletionMessages().get(0).getText(), null, 0L, false, 28, null));
                if (payloadText != null) {
                    boolean bl = ragResult.element != null ? messages.add(new Message(Role.user, ((RetrieveRagResponse)ragResult.element).getContent(), null, 0L, false, 28, null)) : messages.add(new Message(Role.user, payloadText, null, 0L, false, 28, null));
                }
            }
            object = llmMessages.getStopWords();
            String string = model.getId();
            Object object2 = ModelsConfiguration.ModelConfig.getParams$default(model, false, 1, null);
            Double d = object2 != null && (object2 = ((LLMParam)object2).getTemperature()) != null ? Double.valueOf(Double.parseDouble((String)object2)) : null;
            String string2 = conv.getConversationId();
            ChatParameters param = new ChatParameters(messages, 0, d, (List)object, null, null, string, null, false, false, string2, null, 2994, null);
            Logger.debug$default(ConstantsKt.getLogger(), "getRagAndCall chat begin", null, 2, null);
            requestCanceller = this.getLLMClient(model.getKey()).chat(param, callbacks2);
        }
        catch (Throwable e) {
            Function0<Unit> function0 = requestCanceller;
            if (function0 != null) {
                function0.invoke();
            }
            botMsg.setStatus(Status.aborted);
            this.updateMessage(conv, true, project, botMsg, true);
            CockpitWidgetFactoryKt.updateCodeRiderStatus(CodeRiderStatus.LOGGED_IN);
            throw new CustomException(e.getMessage());
        }
    }

    static /* synthetic */ void getRagAndCall$default(ChatHandler chatHandler, Project project, String string, Conversation conversation, ChatMessage chatMessage, String string2, List list, int n, Object object) {
        if ((n & 0x20) != 0) {
            list = null;
        }
        chatHandler.getRagAndCall(project, string, conversation, chatMessage, string2, list);
    }

    private final boolean useProjectMemory(String commandType, Project project) {
        if (!Intrinsics.areEqual((Object)commandType, (Object)"on-boarding")) {
            return false;
        }
        if (!CockpitConfiguration.Companion.getInstance().getState().getMemoryOpen()) {
            return false;
        }
        if (!UserMemoryStorage.Companion.getInstance().userChatProjectMemoryState()) {
            return false;
        }
        String string = project.getBasePath();
        if (string == null) {
            string = "";
        }
        return ProjectMemoryPrompterKt.existProjectMemory(string);
    }

    @NotNull
    public final ChatClient getLLMClient(@Nullable String modelKey) {
        String provider;
        ChatClient chatClient;
        String string = modelKey;
        if (string == null) {
            string = ModelsConfiguration.Companion.getInstance().getDefaultChatModel().getKey();
        }
        if ((chatClient = llmClients.get(provider = StringsKt.substringBefore$default((String)string, (String)"/", null, (int)2, null))) == null) {
            chatClient = new OpenAiClient();
        }
        return chatClient;
    }

    public static /* synthetic */ ChatClient getLLMClient$default(ChatHandler chatHandler, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return chatHandler.getLLMClient(string);
    }

    private final void updateMessage(Conversation conv, Boolean storeConv, Project project, ChatMessage msg, Boolean setAsCurrentNode) {
        Conversation conversation = conv;
        if (conversation == null) {
            conversation = this.getConversation(project);
        }
        Conversation oldConv = conversation;
        Conversation currentConv = this.getConversation(project);
        String string = msg.getMsgId();
        if (string != null) {
            String it = string;
            boolean bl = false;
            oldConv.getMessages().put(it, msg);
        }
        msg.setUpdatedAt(System.currentTimeMillis());
        if (Intrinsics.areEqual((Object)setAsCurrentNode, (Object)true)) {
            String string2 = msg.getMsgId();
            Intrinsics.checkNotNull((Object)string2);
            oldConv.setCurrentNode(string2);
        }
    }

    static /* synthetic */ void updateMessage$default(ChatHandler chatHandler, Conversation conversation, Boolean bl, Project project, ChatMessage chatMessage, Boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            conversation = null;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        chatHandler.updateMessage(conversation, bl, project, chatMessage, bl2);
    }

    private final List<ChatMessage> getLinearMessages(String currentNode, Map<String, ? extends ChatMessage> messages) {
        if (((CharSequence)currentNode).length() == 0) {
            return new ArrayList();
        }
        List reversed = new ArrayList();
        String cursor = currentNode;
        while (true) {
            ChatMessage current;
            block7: {
                block6: {
                    if (messages.get(cursor) == null) {
                        throw new NoSuchElementException("No message found for id " + cursor);
                    }
                    if (current.getSpeaker() != Speaker.system) break block6;
                    String string = current.getText();
                    if (string != null ? ((CharSequence)string).length() == 0 : false) break block7;
                }
                reversed.add(current);
            }
            if (Strings.isBlank((String)current.getParentId()) || messages.get(current.getParentId()) == null) break;
            Intrinsics.checkNotNull((Object)current.getParentId());
        }
        return CollectionsKt.asReversedMutable((List)reversed);
    }

    public final void insertError(@NotNull Project project, @NotNull String errorMsg) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)errorMsg, (String)"errorMsg");
        Conversation conv = this.getConversation(project);
        ChatMessage chatMessage = conv.getMessages().get(conv.getCurrentNode());
        Map<String, ChatMessage> map = conv.getMessages();
        String string = conv.getCurrentNode();
        TypeIntrinsics.asMutableMap(map).remove(string);
        string = Ksuid.generate();
        ChatMessage chatMessage2 = chatMessage;
        String string2 = chatMessage2 != null ? chatMessage2.getParentId() : null;
        Speaker speaker = Speaker.assistant;
        long l = System.currentTimeMillis();
        Status status = Status.error;
        ChatMessage botMsg = new ChatMessage(string, null, l, speaker, status, errorMsg, "", null, string2, null, null, null, null, 7810, null);
        this.insertMessage(project, botMsg);
    }

    private final void insertMessage(Project project, ChatMessage msg) {
        String it;
        Object[] objectArray;
        String rootId;
        if (Strings.isBlank((String)msg.getMsgId())) {
            throw new Exception("ChatHandler: msgId is required by method insertMessage");
        }
        long now = System.currentTimeMillis();
        msg.setUpdatedAt(now);
        Conversation conv = this.getConversation(project);
        if (conv.getCurrentNode() != null) {
            String string = conv.getCurrentNode();
            v1 = string;
            Intrinsics.checkNotNull((Object)string);
        } else {
            String string = Ksuid.generate();
            Intrinsics.checkNotNull((Object)string);
            v1 = rootId = string;
        }
        if (Strings.isBlank((String)conv.getCurrentNode())) {
            Speaker speaker = Speaker.system;
            objectArray = Status.finished;
            ChatMessage rootMsg = new ChatMessage(rootId, null, 0L, speaker, (Status)objectArray, null, "", null, null, null, null, null, null, 8098, null);
            String string = rootMsg.getMsgId();
            if (string != null) {
                it = string;
                boolean bl = false;
                conv.getMessages().put(it, rootMsg);
            }
            if (Strings.isNotBlank((String)msg.getParentId())) {
                throw new Exception("ChatHandler: parentId is required by method insertMessage");
            }
            msg.setParentId(rootMsg.getMsgId());
        }
        ChatMessage parent = null;
        if (Strings.isNotBlank((String)msg.getParentId()) && (parent = conv.getMessages().get(msg.getParentId())) == null) {
            throw new Exception("ChatHandler: parent message with id " + msg.getParentId() + " not found");
        }
        if (parent != null) {
            if (((ChatMessage)parent).getChildren() == null) {
                parent.setChildren(new ArrayList());
            }
            String string = msg.getMsgId();
            if (string != null) {
                it = string;
                boolean bl = false;
                List<String> list = parent.getChildren();
                if (list != null) {
                    list.add(it);
                }
            }
        }
        String string = msg.getMsgId();
        if (string != null) {
            it = string;
            boolean bl = false;
            conv.getMessages().put(it, msg);
        }
        conv.setUpdatedAt(System.currentTimeMillis());
        String string2 = msg.getMsgId();
        Intrinsics.checkNotNull((Object)string2);
        conv.setCurrentNode(string2);
        objectArray = new ChatMessage[]{msg};
        List msgs = CollectionsKt.mutableListOf((Object[])objectArray);
        if (parent != null) {
            msgs.add(parent);
        }
    }

    public final boolean cancelInflightRequests(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Iterable $this$forEach$iv = this.getConversation(project).getMessages().values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ChatMessage it = (ChatMessage)element$iv;
            boolean bl = false;
            if (it.getStatus() != Status.streaming) continue;
            it.setStatus(Status.aborted);
            ChatHandler.updateMessage$default(INSTANCE, null, true, project, it, null, 16, null);
        }
        if (requestCanceller == null) {
            if (!CockpitConfiguration.Companion.getInstance().isLogin()) {
                return false;
            }
            return false;
        }
        Function0<Unit> function0 = requestCanceller;
        if (function0 != null) {
            function0.invoke();
        }
        requestCanceller = null;
        CockpitWidgetFactoryKt.updateCodeRiderStatus(CodeRiderStatus.LOGGED_IN);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ChatConfig getChatConfig(@NotNull Conversation conv) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)conv, (String)"conv");
        List list = CollectionsKt.listOf((Object)"");
        String string = conv.getModel();
        Iterable $this$map$iv = ModelsConfiguration.Companion.getInstance().getChatModels().values();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ModelsConfiguration.ModelConfig modelConfig = (ModelsConfiguration.ModelConfig)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ChatModel.Companion.fromModelConfig((ModelsConfiguration.ModelConfig)it));
        }
        List list2 = (List)destination$iv$iv;
        List<RagSelectItem> list3 = CockpitConfiguration.Companion.getInstance().getSelectedRags();
        return new ChatConfig(string, list, list2, null, list3, 8, null);
    }

    public final void handleChatChangeModel(@NotNull Project project, @NotNull String modelKey) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)modelKey, (String)"modelKey");
        Conversation conv = this.getConversation(project);
        conv.setModel(modelKey);
    }

    public final void handleChatRegenerate(@NotNull Project project, @NotNull String msgId, boolean inPlace) {
        block2: {
            ChatMessage originMsg;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)msgId, (String)"msgId");
            Conversation conv = this.getConversation(project);
            ChatMessage chatMessage = originMsg = conv.getMessages().get(msgId);
            String parentId = chatMessage != null ? chatMessage.getParentId() : null;
            ChatMessage parentMsg = conv.getMessages().get(parentId);
            String string = Ksuid.generate();
            Speaker speaker = Speaker.assistant;
            long l = System.currentTimeMillis();
            Status status = Status.streaming;
            ChatMessage chatMessage2 = originMsg;
            String string2 = chatMessage2 != null ? chatMessage2.getCommandType() : null;
            ChatMessage botMsg = new ChatMessage(string, null, l, speaker, status, null, "", null, parentId, string2, null, null, null, 7330, null);
            if (inPlace) {
                this.updateMessage(conv, true, project, botMsg, true);
            } else {
                this.insertMessage(project, botMsg);
            }
            ChatMessage chatMessage3 = parentMsg;
            String string3 = chatMessage3 != null ? chatMessage3.getText() : null;
            String string4 = parentId;
            Intrinsics.checkNotNull((Object)string4);
            ChatMessage chatMessage4 = parentMsg;
            this.getRagAndCall(project, string3, conv, botMsg, string4, chatMessage4 != null ? chatMessage4.getKbIds() : null);
            String string5 = originMsg.getCommandType();
            if (string5 == null) break block2;
            String it = string5;
            boolean bl = false;
            TrackService.INSTANCE.codeBlockCommandUsage(conv.getModel(), it, "regenerate");
        }
    }

    public final void chatClearContext(@NotNull Project project, @NotNull String msgId) {
        ChatMessage robotNode;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)msgId, (String)"msgId");
        Conversation conv = this.getConversation(project);
        ChatMessage chatMessage = robotNode = conv.getMessages().get(msgId);
        String currentNodeId = chatMessage != null ? chatMessage.getParentId() : null;
        ChatMessage userNode = conv.getMessages().get(currentNodeId);
        conv.getMessages().remove(msgId);
        if (userNode != null) {
            Map<String, ChatMessage> map = conv.getMessages();
            String string = userNode.getMsgId();
            TypeIntrinsics.asMutableMap(map).remove(string);
        }
        if (userNode != null) {
            conv.setCurrentNode(userNode.getParentId());
        }
        ConversationReq conversationReq = new ConversationReq(null, conv, 1, null);
    }

    private static final Unit handleChatSubmit$lambda$2(ChatMessage $botMsg, ChatPayload $payload, Project $project) {
        INSTANCE.handleGenerateTests($botMsg, $payload.getMessageExtra(), $project, $payload.getText());
        return Unit.INSTANCE;
    }

    private static final Unit handleChatSubmit$lambda$3(ChatMessage $botMsg, ChatPayload $payload, Project $project) {
        INSTANCE.handleSmellCode($botMsg, $payload.getMessageExtra(), $project, $payload.getText());
        return Unit.INSTANCE;
    }

    private static final Unit handleChatSubmit$lambda$5$lambda$4(ChatMessage $botMsg, ChatPayload $payload, Project $project, String $it) {
        INSTANCE.handleEditCode($botMsg, $payload.getMessageExtra(), $project, $it, $payload.getText());
        return Unit.INSTANCE;
    }

    private static final Unit handleChatSubmit$lambda$6(ChatMessage $botMsg, ChatPayload $payload, Project $project) {
        INSTANCE.handleDocumentCode($botMsg, $payload.getMessageExtra(), $project, $payload.getText(), false);
        return Unit.INSTANCE;
    }

    private static final Unit handleChatSubmit$lambda$7(ChatMessage $botMsg, ChatPayload $payload, Project $project) {
        INSTANCE.handleDocumentCode($botMsg, $payload.getMessageExtra(), $project, $payload.getText(), true);
        return Unit.INSTANCE;
    }

    private static final Unit handleEditCode$lambda$17$lambda$16$lambda$15$lambda$14$lambda$13(List $references, ChatMessage $botMsg, Conversation $conv, Project $project, Ref.ObjectRef $message, List it) {
        ChatMessage chatMessage;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $references.addAll(it);
        String referencesStr = ChatHandlerKt.formatFileRefInfo($references);
        ChatMessage $this$handleEditCode_u24lambda_u2417_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414_u24lambda_u2413_u24lambda_u2412 = chatMessage = $botMsg;
        boolean bl = false;
        $this$handleEditCode_u24lambda_u2417_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414_u24lambda_u2413_u24lambda_u2412.setDisplayText(referencesStr + "\n" + $message.element);
        $botMsg.setText($this$handleEditCode_u24lambda_u2417_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414_u24lambda_u2413_u24lambda_u2412.getDisplayText());
        $this$handleEditCode_u24lambda_u2417_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414_u24lambda_u2413_u24lambda_u2412.setStatus(Status.finished);
        ChatHandler.updateMessage$default(INSTANCE, $conv, true, $project, $botMsg, null, 16, null);
        return Unit.INSTANCE;
    }

    private static final void handleEditCode$lambda$17$lambda$16$lambda$15$lambda$14(String $text, EditStreamHandler $diffStreamHandler, String $prompt, List $references, ChatMessage $botMsg, Conversation $conv, Project $project, Ref.ObjectRef $message) {
        String string = $text;
        if (string == null) {
            string = "";
        }
        Set<String> manualRules = ChatPrompterKt.extractManualRulesFromPrompt(string);
        EditStreamHandler.streamDiffLinesToEditorWithFileRef$default($diffStreamHandler, $prompt, true, null, manualRules, arg_0 -> ChatHandler.handleEditCode$lambda$17$lambda$16$lambda$15$lambda$14$lambda$13($references, $botMsg, $conv, $project, $message, arg_0), 4, null);
    }

    private static final Unit handleEditCode$lambda$17(Project $project, String $text, String $prompt, List $references, ChatMessage $botMsg, Conversation $conv, Ref.ObjectRef $message, FileMention fileMention) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)fileMention, (String)"fileMention");
            String string = fileMention.getData().getCodePath();
            if (string == null) break block1;
            String codePath = string;
            boolean bl = false;
            Editor editor = CockpitInlineQuickCommandRenderKt.openFileInEditor($project, codePath);
            if (editor != null) {
                Editor editor2 = editor;
                boolean bl2 = false;
                Document document = editor2.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
                Pair<Integer, Integer> pair = INSTANCE.getStartLineAndEndLine(fileMention, document);
                int startLine = ((Number)pair.component1()).intValue();
                int endLine = ((Number)pair.component2()).intValue();
                EditStreamHandler diffStreamHandler = INSTANCE.generateDiffStreamHandler(editor2, $project, editor2, startLine, startLine, endLine);
                ApplicationManager.getApplication().runWriteAction(() -> ChatHandler.handleEditCode$lambda$17$lambda$16$lambda$15$lambda$14($text, diffStreamHandler, $prompt, $references, $botMsg, $conv, $project, $message));
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit handleGenerateTests$lambda$23$lambda$22$lambda$21$lambda$20(List $references, ChatMessage $botMsg, Conversation $conv, Project $project, Ref.ObjectRef $message, List it) {
        ChatMessage chatMessage;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $references.addAll(it);
        String referencesStr = ChatHandlerKt.formatFileRefInfo($references);
        ChatMessage $this$handleGenerateTests_u24lambda_u2423_u24lambda_u2422_u24lambda_u2421_u24lambda_u2420_u24lambda_u2419 = chatMessage = $botMsg;
        boolean bl = false;
        $this$handleGenerateTests_u24lambda_u2423_u24lambda_u2422_u24lambda_u2421_u24lambda_u2420_u24lambda_u2419.setDisplayText(referencesStr + "\n" + $message.element);
        $botMsg.setText($this$handleGenerateTests_u24lambda_u2423_u24lambda_u2422_u24lambda_u2421_u24lambda_u2420_u24lambda_u2419.getDisplayText());
        $this$handleGenerateTests_u24lambda_u2423_u24lambda_u2422_u24lambda_u2421_u24lambda_u2420_u24lambda_u2419.setStatus(Status.finished);
        ChatHandler.updateMessage$default(INSTANCE, $conv, true, $project, $botMsg, null, 16, null);
        return Unit.INSTANCE;
    }

    private static final void handleGenerateTests$lambda$23$lambda$22$lambda$21(EditStreamHandler $diffStreamHandler, String $prompt, String $text, List $references, ChatMessage $botMsg, Conversation $conv, Project $project, Ref.ObjectRef $message) {
        Boolean bl = false;
        String string = $text;
        if (string == null) {
            string = "";
        }
        EditStreamHandler.streamDiffLinesToEditorWithFileRef$default($diffStreamHandler, $prompt, bl, null, ChatPrompterKt.extractManualRulesFromPrompt(string), arg_0 -> ChatHandler.handleGenerateTests$lambda$23$lambda$22$lambda$21$lambda$20($references, $botMsg, $conv, $project, $message, arg_0), 4, null);
    }

    private static final Unit handleGenerateTests$lambda$23$lambda$22(Project $project, FileMention $fileMention, Editor $editor, String $text, List $references, ChatMessage $botMsg, Conversation $conv, Ref.ObjectRef $message, String newFile) {
        Intrinsics.checkNotNullParameter((Object)newFile, (String)"newFile");
        boolean fileExists = CockpitInlineQuickCommandRenderKt.fileExists(newFile);
        Editor editor = !fileExists ? CockpitInlineQuickCommandRenderKt.createNewFileEditor($project, newFile) : CockpitInlineQuickCommandRenderKt.createTemporaryVirtualFileAndOpen$default($project, newFile, null, 4, null);
        if (editor == null) {
            return Unit.INSTANCE;
        }
        Editor newEditor = editor;
        Document document = $editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Pair<Integer, Integer> pair = INSTANCE.getStartLineAndEndLine($fileMention, document);
        int startLine = ((Number)pair.component1()).intValue();
        int endLine = ((Number)pair.component2()).intValue();
        EditStreamHandler diffStreamHandler = !fileExists ? INSTANCE.generateDiffStreamHandler($editor, $project, newEditor, 0, startLine, endLine) : INSTANCE.generateVirtualFileWithDiffStreamHandler($editor, $project, newEditor, 0, startLine, endLine, newFile);
        String string = $editor.getVirtualFile().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String path = string;
        String string2 = I18nKt.getInlinePrompt("prompt.generate.test");
        Object[] objectArray = new Object[]{path, LanguageUtilsKt.getLanguageFromPath(path), $fileMention.getData().getCodeContent()};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        String prompt = string3;
        ApplicationManager.getApplication().runWriteAction(() -> ChatHandler.handleGenerateTests$lambda$23$lambda$22$lambda$21(diffStreamHandler, prompt, $text, $references, $botMsg, $conv, $project, $message));
        return Unit.INSTANCE;
    }

    private static final Unit handleGenerateTests$lambda$23(Project $project, String $text, List $references, ChatMessage $botMsg, Conversation $conv, Ref.ObjectRef $message, FileMention fileMention) {
        Intrinsics.checkNotNullParameter((Object)fileMention, (String)"fileMention");
        String string = fileMention.getData().getCodePath();
        if (string == null) {
            return Unit.INSTANCE;
        }
        String codePath = string;
        Editor editor = CockpitInlineQuickCommandRenderKt.openFileInEditor($project, codePath);
        if (editor == null) {
            return Unit.INSTANCE;
        }
        Editor editor2 = editor;
        CockpitInlineQuickCommandRenderKt.createTestFileNameSafe($project, editor2.getVirtualFile(), codePath, (Function1<? super String, Unit>)((Function1)arg_0 -> ChatHandler.handleGenerateTests$lambda$23$lambda$22($project, fileMention, editor2, $text, $references, $botMsg, $conv, $message, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit handleSmellCode$lambda$30$lambda$29$lambda$28$lambda$27$lambda$26(List $references, ChatMessage $botMsg, Conversation $conv, Project $project, Ref.ObjectRef $message, List it) {
        ChatMessage chatMessage;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $references.addAll(it);
        String referencesStr = ChatHandlerKt.formatFileRefInfo($references);
        ChatMessage $this$handleSmellCode_u24lambda_u2430_u24lambda_u2429_u24lambda_u2428_u24lambda_u2427_u24lambda_u2426_u24lambda_u2425 = chatMessage = $botMsg;
        boolean bl = false;
        $this$handleSmellCode_u24lambda_u2430_u24lambda_u2429_u24lambda_u2428_u24lambda_u2427_u24lambda_u2426_u24lambda_u2425.setDisplayText(referencesStr + "\n" + $message.element);
        $botMsg.setText($this$handleSmellCode_u24lambda_u2430_u24lambda_u2429_u24lambda_u2428_u24lambda_u2427_u24lambda_u2426_u24lambda_u2425.getDisplayText());
        $this$handleSmellCode_u24lambda_u2430_u24lambda_u2429_u24lambda_u2428_u24lambda_u2427_u24lambda_u2426_u24lambda_u2425.setStatus(Status.finished);
        ChatHandler.updateMessage$default(INSTANCE, $conv, true, $project, $botMsg, null, 16, null);
        return Unit.INSTANCE;
    }

    private static final void handleSmellCode$lambda$30$lambda$29$lambda$28$lambda$27(EditStreamHandler $diffStreamHandler, String $path, FileMention $fileMention, String $text, List $references, ChatMessage $botMsg, Conversation $conv, Project $project, Ref.ObjectRef $message) {
        String string = I18nKt.getInlinePrompt("prompt.smell.code");
        Object[] objectArray = new Object[4];
        objectArray[0] = $path;
        objectArray[1] = LanguageUtilsKt.getLanguageFromPath($path);
        objectArray[2] = $fileMention.getData().getCodeContent();
        String string2 = $text;
        if (string2 == null) {
            string2 = "";
        }
        objectArray[3] = ChatPrompterKt.extractManualRulesFromPrompt(string2);
        String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        EditStreamHandler.streamDiffLinesToEditorWithFileRef$default($diffStreamHandler, string3, true, null, null, arg_0 -> ChatHandler.handleSmellCode$lambda$30$lambda$29$lambda$28$lambda$27$lambda$26($references, $botMsg, $conv, $project, $message, arg_0), 12, null);
    }

    private static final Unit handleSmellCode$lambda$30(Project $project, String $text, List $references, ChatMessage $botMsg, Conversation $conv, Ref.ObjectRef $message, FileMention fileMention) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)fileMention, (String)"fileMention");
            String string = fileMention.getData().getCodePath();
            if (string == null) break block1;
            String codePath = string;
            boolean bl = false;
            Editor editor = CockpitInlineQuickCommandRenderKt.openFileInEditor($project, codePath);
            if (editor != null) {
                Editor editor2 = editor;
                boolean bl2 = false;
                Document document = editor2.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
                Pair<Integer, Integer> pair = INSTANCE.getStartLineAndEndLine(fileMention, document);
                int startLine = ((Number)pair.component1()).intValue();
                int endLine = ((Number)pair.component2()).intValue();
                EditStreamHandler diffStreamHandler = INSTANCE.generateDiffStreamHandler(editor2, $project, editor2, startLine, startLine, endLine);
                String string2 = editor2.getVirtualFile().getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
                String path = string2;
                ApplicationManager.getApplication().runWriteAction(() -> ChatHandler.handleSmellCode$lambda$30$lambda$29$lambda$28$lambda$27(diffStreamHandler, path, fileMention, $text, $references, $botMsg, $conv, $project, $message));
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit handleDocumentCode$lambda$37$lambda$36$lambda$35$lambda$34$lambda$33(List $references, ChatMessage $botMsg, Conversation $conv, Project $project, String $message, List it) {
        ChatMessage chatMessage;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $references.addAll(it);
        String referencesStr = ChatHandlerKt.formatFileRefInfo($references);
        ChatMessage $this$handleDocumentCode_u24lambda_u2437_u24lambda_u2436_u24lambda_u2435_u24lambda_u2434_u24lambda_u2433_u24lambda_u2432 = chatMessage = $botMsg;
        boolean bl = false;
        $this$handleDocumentCode_u24lambda_u2437_u24lambda_u2436_u24lambda_u2435_u24lambda_u2434_u24lambda_u2433_u24lambda_u2432.setDisplayText(referencesStr + "\n" + $message);
        $botMsg.setText($this$handleDocumentCode_u24lambda_u2437_u24lambda_u2436_u24lambda_u2435_u24lambda_u2434_u24lambda_u2433_u24lambda_u2432.getDisplayText());
        $this$handleDocumentCode_u24lambda_u2437_u24lambda_u2436_u24lambda_u2435_u24lambda_u2434_u24lambda_u2433_u24lambda_u2432.setStatus(Status.finished);
        ChatHandler.updateMessage$default(INSTANCE, $conv, true, $project, $botMsg, null, 16, null);
        return Unit.INSTANCE;
    }

    private static final void handleDocumentCode$lambda$37$lambda$36$lambda$35$lambda$34(boolean $isDocstring, EditStreamHandler $diffStreamHandler, String $path, FileMention $fileMention, String $text, List $references, ChatMessage $botMsg, Conversation $conv, Project $project, String $message) {
        String promptKey = $isDocstring ? "prompt.generate.docstrings" : "prompt.document.code";
        String string = I18nKt.getPrompt(promptKey);
        Object[] objectArray = new Object[]{$path, LanguageUtilsKt.getLanguageFromPath($path), $fileMention.getData().getCodeContent()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        Boolean bl = true;
        Boolean bl2 = false;
        String string3 = $text;
        if (string3 == null) {
            string3 = "";
        }
        $diffStreamHandler.streamDiffLinesToEditorWithFileRef(string2, bl, bl2, ChatPrompterKt.extractManualRulesFromPrompt(string3), (Function1<? super List<ContextSnippet>, Unit>)((Function1)arg_0 -> ChatHandler.handleDocumentCode$lambda$37$lambda$36$lambda$35$lambda$34$lambda$33($references, $botMsg, $conv, $project, $message, arg_0)));
    }

    private static final Unit handleDocumentCode$lambda$37(Project $project, boolean $isDocstring, String $text, List $references, ChatMessage $botMsg, Conversation $conv, String $message, FileMention fileMention) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)fileMention, (String)"fileMention");
            String string = fileMention.getData().getCodePath();
            if (string == null) break block1;
            String codePath = string;
            boolean bl = false;
            Editor editor = CockpitInlineQuickCommandRenderKt.openFileInEditor($project, codePath);
            if (editor != null) {
                Editor editor2 = editor;
                boolean bl2 = false;
                Document document = editor2.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
                Pair<Integer, Integer> pair = INSTANCE.getStartLineAndEndLine(fileMention, document);
                int startLine = ((Number)pair.component1()).intValue();
                int endLine = ((Number)pair.component2()).intValue();
                EditStreamHandler diffStreamHandler = INSTANCE.generateDiffStreamHandler(editor2, $project, editor2, startLine, startLine, endLine);
                String string2 = editor2.getVirtualFile().getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
                String path = string2;
                ApplicationManager.getApplication().runWriteAction(() -> ChatHandler.handleDocumentCode$lambda$37$lambda$36$lambda$35$lambda$34($isDocstring, diffStreamHandler, path, fileMention, $text, $references, $botMsg, $conv, $project, $message));
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit generateVirtualFileWithDiffStreamHandler$lambda$38(LensesService $lensesService, Editor $targetEditor) {
        $lensesService.clearLenses($targetEditor);
        return Unit.INSTANCE;
    }

    private static final Unit generateVirtualFileWithDiffStreamHandler$lambda$41(int $expandedStartOffset, int $expandedEndOffset, Editor $targetEditor, Integer $targetStartLine, LensesService $lensesService, String $taskId) {
        block1: {
            Range range;
            Range $this$generateVirtualFileWithDiffStreamHandler_u24lambda_u2441_u24lambda_u2439 = range = new Range($expandedStartOffset, $expandedEndOffset);
            boolean bl = false;
            Integer n = $targetStartLine;
            if (n != null && n == 0) {
                $this$generateVirtualFileWithDiffStreamHandler_u24lambda_u2441_u24lambda_u2439.setStart(0);
                $this$generateVirtualFileWithDiffStreamHandler_u24lambda_u2441_u24lambda_u2439.setEnd(0);
            }
            Range r = range;
            VirtualFile virtualFile = FileDocumentManager.getInstance().getFile($targetEditor.getDocument());
            if (virtualFile == null) break block1;
            VirtualFile virtualFile2 = virtualFile;
            boolean bl2 = false;
            String string = virtualFile2.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
            $lensesService.updateLenses($targetEditor, string, virtualFile2, $lensesService.generateInlineEditStartLense(r, $taskId));
        }
        return Unit.INSTANCE;
    }

    private static final Unit generateVirtualFileWithDiffStreamHandler$lambda$42() {
        return Unit.INSTANCE;
    }

    private static final Unit generateVirtualFileWithDiffStreamHandler$lambda$43(Editor $newEditor, Project $project, String $oldFilePath) {
        try {
            DiffStreamUtilsKt.generateTestDiffFile($newEditor, $project, $oldFilePath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Unit.INSTANCE;
    }

    private static final Unit generateDiffStreamHandler$lambda$44(LensesService $lensesService, Editor $targetEditor) {
        $lensesService.clearLenses($targetEditor);
        return Unit.INSTANCE;
    }

    private static final Unit generateDiffStreamHandler$lambda$47(int $expandedStartOffset, int $expandedEndOffset, Editor $targetEditor, Integer $targetStartLine, LensesService $lensesService, String $taskId) {
        block1: {
            Range range;
            Range $this$generateDiffStreamHandler_u24lambda_u2447_u24lambda_u2445 = range = new Range($expandedStartOffset, $expandedEndOffset);
            boolean bl = false;
            Integer n = $targetStartLine;
            if (n != null && n == 0) {
                $this$generateDiffStreamHandler_u24lambda_u2447_u24lambda_u2445.setStart(0);
                $this$generateDiffStreamHandler_u24lambda_u2447_u24lambda_u2445.setEnd(0);
            }
            Range r = range;
            VirtualFile virtualFile = FileDocumentManager.getInstance().getFile($targetEditor.getDocument());
            if (virtualFile == null) break block1;
            VirtualFile virtualFile2 = virtualFile;
            boolean bl2 = false;
            String string = virtualFile2.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
            $lensesService.updateLenses($targetEditor, string, virtualFile2, $lensesService.generateInlineEditStartLense(r, $taskId));
        }
        return Unit.INSTANCE;
    }

    private static final Unit generateDiffStreamHandler$lambda$48() {
        return Unit.INSTANCE;
    }

    private static final Unit generateDiffStreamHandler$lambda$51(int $expandedStartOffset, int $expandedEndOffset, Editor $targetEditor, Integer $targetStartLine, LensesService $lensesService, String $taskId) {
        block1: {
            Range range;
            Range $this$generateDiffStreamHandler_u24lambda_u2451_u24lambda_u2449 = range = new Range($expandedStartOffset, $expandedEndOffset);
            boolean bl = false;
            Integer n = $targetStartLine;
            if (n != null && n == 0) {
                $this$generateDiffStreamHandler_u24lambda_u2451_u24lambda_u2449.setStart(0);
                $this$generateDiffStreamHandler_u24lambda_u2451_u24lambda_u2449.setEnd(0);
            }
            Range r = range;
            VirtualFile virtualFile = FileDocumentManager.getInstance().getFile($targetEditor.getDocument());
            if (virtualFile == null) break block1;
            VirtualFile virtualFile2 = virtualFile;
            boolean bl2 = false;
            String string = virtualFile2.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
            $lensesService.updateLenses($targetEditor, string, virtualFile2, $lensesService.generateInlineEditEndLense(r, $taskId));
        }
        return Unit.INSTANCE;
    }

    private static final boolean getRagAndCall$lambda$52(LLMChatMessage it) {
        return Strings.isNotBlank((String)it.getText());
    }

    private static final boolean getRagAndCall$lambda$53(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Message getRagAndCall$lambda$54(LLMChatMessage it) {
        Role role = ChatDtoKt.speakerToRole(it.getSpeaker());
        String string = it.getText();
        Intrinsics.checkNotNull((Object)string);
        return new Message(role, string, null, 0L, false, 28, null);
    }

    private static final Message getRagAndCall$lambda$55(Function1 $tmp0, Object p0) {
        return (Message)$tmp0.invoke(p0);
    }

    private static final void getRagAndCall$lambda$56(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ Map access$getConversations$p() {
        return conversations;
    }

    public static final /* synthetic */ void access$updateMessage(ChatHandler $this, Conversation conv, Boolean storeConv, Project project, ChatMessage msg, Boolean setAsCurrentNode) {
        $this.updateMessage(conv, storeConv, project, msg, setAsCurrentNode);
    }

    public static final /* synthetic */ void access$setRequestCanceller$p(Function0 function0) {
        requestCanceller = function0;
    }

    public static final /* synthetic */ Function0 access$getRequestCanceller$p() {
        return requestCanceller;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"ollama", (Object)new OllamaClient()), TuplesKt.to((Object)"lmstudio", (Object)new OpenAiClient()), TuplesKt.to((Object)"deepseek", (Object)new OpenAiClient()), TuplesKt.to((Object)"maas", (Object)new OpenAiClient()), TuplesKt.to((Object)"server", (Object)new OpenAiClient())};
        llmClients = MapsKt.mapOf((Pair[])pairArray);
    }
}

