/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.autocomplete;

import cn.gitlab.kilo.jetbrains.autocomplete.AutocompleteServiceKt;
import cn.gitlab.kilo.jetbrains.autocomplete.CockpitCustomElementRenderer;
import cn.gitlab.kilo.jetbrains.autocomplete.CockpitMultilineCustomElementRenderer;
import cn.gitlab.kilo.jetbrains.autocomplete.PendingCompletion;
import cn.gitlab.kilo.jetbrains.chat.ChatHandler;
import cn.gitlab.kilo.jetbrains.client.CoderiderClient;
import cn.gitlab.kilo.jetbrains.common.GenerateMetrics;
import cn.gitlab.kilo.jetbrains.common.GenerateResult;
import cn.gitlab.kilo.jetbrains.common.LLMParam;
import cn.gitlab.kilo.jetbrains.common.Logger;
import cn.gitlab.kilo.jetbrains.config.CockpitConfiguration;
import cn.gitlab.kilo.jetbrains.config.ModelsConfiguration;
import cn.gitlab.kilo.jetbrains.edit.EditInlineStreamService;
import cn.gitlab.kilo.jetbrains.factories.CockpitWidgetFactoryKt;
import cn.gitlab.kilo.jetbrains.listener.CodeCompletionHint;
import cn.gitlab.kilo.jetbrains.llmClient.ChatClient;
import cn.gitlab.kilo.jetbrains.psi.PsiUtils;
import cn.gitlab.kilo.jetbrains.services.CodeRiderStatus;
import cn.gitlab.kilo.jetbrains.services.CoderiderTrackClient;
import cn.gitlab.kilo.jetbrains.services.TrackService;
import cn.gitlab.kilo.jetbrains.services.context.ContextMixer;
import cn.gitlab.kilo.jetbrains.services.context.ContextResult;
import cn.gitlab.kilo.jetbrains.services.context.ContextSnippet;
import cn.gitlab.kilo.jetbrains.services.context.ContextUtilsKt;
import cn.gitlab.kilo.jetbrains.services.context.JaccardSimilarityRetrieverKt;
import cn.gitlab.kilo.jetbrains.services.context.LanguageUtilsKt;
import cn.gitlab.kilo.jetbrains.utils.UpdateFileSilentUtilsKt;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayProperties;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\r\b\u0007\u0018\u00002\u00020\u0001:\u0001>B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J6\u0010\b\u001a\u00020\t2'\u0010\n\u001a#\b\u0001\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000b\u00a2\u0006\u0002\b\u000eH\u0002\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010 \u001a\u00020\r2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001bJ\u0012\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010!\u001a\u00020\"H\u0002J \u0010&\u001a\u00020\r2\u0006\u0010!\u001a\u00020\"2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0002J$\u0010+\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020*0,2\u0006\u0010)\u001a\u00020*2\u0006\u0010-\u001a\u00020*H\u0002J\u0018\u0010.\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010/\u001a\u00020%H\u0002J\u0006\u00100\u001a\u00020\rJ \u00101\u001a\b\u0012\u0004\u0012\u00020*022\u0006\u00103\u001a\u00020*2\b\b\u0002\u00104\u001a\u00020*H\u0002J\u0006\u00105\u001a\u00020\rJ\u0006\u00106\u001a\u00020\rJ\u0010\u00107\u001a\u00020\r2\u0006\u0010)\u001a\u00020\u0015H\u0002J\u000e\u00108\u001a\u00020\r2\u0006\u0010!\u001a\u00020\"J\u0010\u00109\u001a\u00020\r2\u0006\u0010!\u001a\u00020\"H\u0002J\u000e\u0010:\u001a\u00020\r2\u0006\u0010!\u001a\u00020\"J\u0010\u0010;\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\"H\u0002J\u000e\u0010<\u001a\u00020\r2\u0006\u0010!\u001a\u00020\"J\u001e\u0010=\u001a\u00020\r2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001b2\u0006\u0010/\u001a\u00020%R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001f\u00a8\u0006?"}, d2={"Lcn/gitlab/kilo/jetbrains/autocomplete/AutocompleteService;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "launchInScope", "Lkotlinx/coroutines/Job;", "block", "Lkotlin/Function2;", "Lkotlin/coroutines/Continuation;", "", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function2;)Lkotlinx/coroutines/Job;", "logger", "Lcn/gitlab/kilo/jetbrains/common/Logger;", "contextMixer", "Lcn/gitlab/kilo/jetbrains/services/context/ContextMixer;", "pendingCompletion", "Lcn/gitlab/kilo/jetbrains/autocomplete/PendingCompletion;", "getPendingCompletion", "()Lcn/gitlab/kilo/jetbrains/autocomplete/PendingCompletion;", "setPendingCompletion", "(Lcn/gitlab/kilo/jetbrains/autocomplete/PendingCompletion;)V", "lastChangeWasPartialAccept", "", "getLastChangeWasPartialAccept", "()Z", "setLastChangeWasPartialAccept", "(Z)V", "triggerCompletion", "editor", "Lcom/intellij/openapi/editor/Editor;", "shouldDoMultiline", "getCaretInfo", "Lcn/gitlab/kilo/jetbrains/autocomplete/AutocompleteService$CaretInfo;", "renderCompletion", "offset", "", "completion", "", "trimCommonPrefixAndSuffix", "Lkotlin/Pair;", "original", "preflightCheck", "caretInfo", "accept", "splitKeepingDelimiters", "", "input", "delimiterPattern", "partialAccept", "refreshPending", "cancelCompletion", "cleanCompletions", "disposeInlays", "cleanRenders", "isInjectedFile", "hideCompletions", "getSuggestion", "CaretInfo", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nAutocompleteService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AutocompleteService.kt\ncn/gitlab/kilo/jetbrains/autocomplete/AutocompleteService\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,436:1\n31#2,2:437\n31#2,2:439\n31#2,2:441\n1#3:443\n967#4,7:444\n774#4:451\n865#4,2:452\n774#4:454\n865#4,2:455\n1869#4,2:457\n774#4:459\n865#4,2:460\n1869#4,2:462\n*S KotlinDebug\n*F\n+ 1 AutocompleteService.kt\ncn/gitlab/kilo/jetbrains/autocomplete/AutocompleteService\n*L\n80#1:437,2\n96#1:439,2\n107#1:441,2\n176#1:444,7\n243#1:451\n243#1:452,2\n311#1:454\n311#1:455,2\n312#1:457,2\n315#1:459\n315#1:460,2\n316#1:462,2\n*E\n"})
public final class AutocompleteService {
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final Logger logger;
    @NotNull
    private ContextMixer contextMixer;
    @Nullable
    private volatile PendingCompletion pendingCompletion;
    private boolean lastChangeWasPartialAccept;

    public AutocompleteService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getDefault()));
        this.logger = Logger.Companion.getInstance("inlineCompletion");
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<ContextMixer> serviceClass$iv = ContextMixer.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.contextMixer = (ContextMixer)object;
        new CoderiderClient(null, 1, null).syncModelConfig();
    }

    private final Job launchInScope(Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object> block) {
        return BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, block, (int)3, null);
    }

    @Nullable
    public final PendingCompletion getPendingCompletion() {
        return this.pendingCompletion;
    }

    public final void setPendingCompletion(@Nullable PendingCompletion pendingCompletion) {
        this.pendingCompletion = pendingCompletion;
    }

    public final boolean getLastChangeWasPartialAccept() {
        return this.lastChangeWasPartialAccept;
    }

    public final void setLastChangeWasPartialAccept(boolean bl) {
        this.lastChangeWasPartialAccept = bl;
    }

    public final void triggerCompletion(@NotNull Editor editor, boolean shouldDoMultiline) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<EditInlineStreamService> serviceClass$iv = EditInlineStreamService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        if (((EditInlineStreamService)object).isOnBusy(editor)) {
            return;
        }
        CockpitConfiguration config2 = CockpitConfiguration.Companion.getInstance();
        if (!config2.getState().getCodeCompletionEnabled()) {
            return;
        }
        CaretInfo caretInfo = this.getCaretInfo(editor);
        if (caretInfo == null || !this.preflightCheck(editor, caretInfo)) {
            return;
        }
        if (config2.needLogin()) {
            return;
        }
        ComponentManager $this$service$iv2 = (ComponentManager)this.project;
        boolean $i$f$service2 = false;
        Class<CodeCompletionHint> serviceClass$iv2 = CodeCompletionHint.class;
        Object object2 = $this$service$iv2.getService(serviceClass$iv2);
        if (object2 == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv2, serviceClass$iv2);
        }
        CodeCompletionHint codeCompletionHint = (CodeCompletionHint)object2;
        Caret caret = editor.getCaretModel().getCurrentCaret();
        Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"getCurrentCaret(...)");
        codeCompletionHint.showHint(editor, caret);
        PendingCompletion pendingCompletion = this.pendingCompletion;
        if (pendingCompletion != null) {
            PendingCompletion it = pendingCompletion;
            boolean bl = false;
            this.cleanCompletions(it.getEditor());
        }
        this.getSuggestion(editor, shouldDoMultiline, caretInfo);
    }

    private final CaretInfo getCaretInfo(Editor editor) {
        return (CaretInfo)ActionsKt.runReadAction(() -> AutocompleteService.getCaretInfo$lambda$1(editor));
    }

    private final void renderCompletion(Editor editor, int offset, String completion) {
        if (((CharSequence)completion).length() == 0) {
            return;
        }
        if (this.isInjectedFile(editor)) {
            return;
        }
        ActionsKt.invokeLater$default(null, () -> AutocompleteService.renderCompletion$lambda$3(editor, offset, this, completion), (int)1, null);
    }

    private final Pair<Integer, String> trimCommonPrefixAndSuffix(String completion, String original) {
        int endIndex;
        Iterable $this$takeWhile$iv = StringsKt.zip((CharSequence)completion, (CharSequence)original);
        boolean $i$f$takeWhile = false;
        ArrayList list$iv = new ArrayList();
        for (Object item$iv : $this$takeWhile$iv) {
            char o;
            Pair pair = (Pair)item$iv;
            boolean bl = false;
            char c = ((Character)pair.component1()).charValue();
            if (!(c == (o = ((Character)pair.component2()).charValue()))) break;
            list$iv.add(item$iv);
        }
        int startIndex = ((List)list$iv).size();
        for (endIndex = completion.length(); endIndex > startIndex && original.length() - (completion.length() - endIndex) > 0 && completion.charAt(endIndex - 1) == original.charAt(original.length() - (completion.length() - endIndex) - 1); --endIndex) {
        }
        Integer n = startIndex;
        String string = completion.substring(startIndex, endIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return TuplesKt.to((Object)n, (Object)string);
    }

    private final boolean preflightCheck(Editor editor, CaretInfo caretInfo) {
        PsiFile psiFile;
        CockpitConfiguration config2 = CockpitConfiguration.Companion.getInstance();
        if (!config2.getState().getCodeCompletionEnabled() || config2.needLogin()) {
            return false;
        }
        if (!config2.getState().getCommentCompletionEnabled() && (psiFile = (PsiFile)ActionsKt.runReadAction(() -> AutocompleteService.preflightCheck$lambda$5(this, editor))) != null && PsiUtils.INSTANCE.isInComment(psiFile, caretInfo.getOffset())) {
            return false;
        }
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        String string = document2.getText(new TextRange(document2.getLineStartOffset(caretInfo.getLineNumber()), caretInfo.getOffset()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String prefixInLine = string;
        String string2 = document2.getText(new TextRange(caretInfo.getOffset(), document2.getLineEndOffset(caretInfo.getLineNumber())));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        String suffixInLine = string2;
        return !new Regex("\\w").containsMatchIn((CharSequence)suffixInLine) && !new Regex("[);\\]}]$").containsMatchIn((CharSequence)((Object)StringsKt.trim((CharSequence)prefixInLine)).toString());
    }

    public final void accept() {
        PendingCompletion pendingCompletion = this.pendingCompletion;
        if (pendingCompletion == null) {
            return;
        }
        PendingCompletion completion = pendingCompletion;
        String string = completion.getText();
        if (string == null) {
            return;
        }
        String text = string;
        Editor editor = completion.getEditor();
        int offset = completion.getOffset();
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        int lineEndOffset = document2.getLineEndOffset(completion.getCaretLineNumber());
        int firstLineEndOffset = Math.min(lineEndOffset, offset + text.length());
        String string2 = document2.getText(new TextRange(offset, firstLineEndOffset));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        String suffix = string2;
        UpdateFileSilentUtilsKt.replaceString(document2, offset, firstLineEndOffset, text);
        editor.getCaretModel().moveToOffset(offset + text.length());
        if (!StringsKt.contains$default((CharSequence)text, (CharSequence)suffix, (boolean)false, (int)2, null)) {
            int afterInsertFirstLineOffset = offset + ((String)CollectionsKt.first((List)StringsKt.lines((CharSequence)text))).length();
            UpdateFileSilentUtilsKt.insertString(document2, afterInsertFirstLineOffset, suffix);
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        ActionsKt.invokeLater$default(null, () -> AutocompleteService.accept$lambda$6(this, editor), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> splitKeepingDelimiters(String input, String delimiterPattern) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Object object = input;
        Regex regex = new Regex("(?<=" + delimiterPattern + ")|(?=" + delimiterPattern + ")");
        int n = 0;
        object = regex.split((CharSequence)object, n);
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)it).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List initialSplit = (List)destination$iv$iv;
        List result2 = new ArrayList();
        Object currentDelimiter = "";
        for (String part : initialSplit) {
            CharSequence charSequence = part;
            if (new Regex(delimiterPattern).matches(charSequence)) {
                currentDelimiter = (String)currentDelimiter + part;
                continue;
            }
            if (((CharSequence)currentDelimiter).length() > 0) {
                result2.add(currentDelimiter);
                currentDelimiter = "";
            }
            result2.add(part);
        }
        if (((CharSequence)currentDelimiter).length() > 0) {
            result2.add(currentDelimiter);
        }
        return result2;
    }

    static /* synthetic */ List splitKeepingDelimiters$default(AutocompleteService autocompleteService, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "\\s+";
        }
        return autocompleteService.splitKeepingDelimiters(string, string2);
    }

    public final void partialAccept() {
        PendingCompletion pendingCompletion = this.pendingCompletion;
        if (pendingCompletion == null) {
            return;
        }
        PendingCompletion completion = pendingCompletion;
        String string = completion.getText();
        if (string == null) {
            return;
        }
        String text = string;
        Editor editor = completion.getEditor();
        int offset = completion.getOffset();
        this.lastChangeWasPartialAccept = true;
        List words = AutocompleteService.splitKeepingDelimiters$default(this, text, null, 2, null);
        if (words.isEmpty()) {
            return;
        }
        String word = (String)words.get(0);
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        UpdateFileSilentUtilsKt.insertString(document, offset, word);
        editor.getCaretModel().moveToOffset(offset + word.length());
        this.hideCompletions(editor);
        String string2 = text.substring(word.length());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        completion.setText(string2);
        completion.setOffset(completion.getOffset() + word.length());
        this.launchInScope((Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, editor, completion, null){
            int label;
            final /* synthetic */ AutocompleteService this$0;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ PendingCompletion $completion;
            {
                this.this$0 = $receiver;
                this.$editor = $editor;
                this.$completion = $completion;
                super(2, $completion2);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        int n = this.$completion.getOffset();
                        String string = this.$completion.getText();
                        Intrinsics.checkNotNull((Object)string);
                        AutocompleteService.access$renderCompletion(this.this$0, this.$editor, n, string);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    public final void refreshPending() {
        PendingCompletion pendingCompletion = this.pendingCompletion;
        if (pendingCompletion == null) {
            return;
        }
        PendingCompletion completion = pendingCompletion;
        Editor editor = completion.getEditor();
        this.hideCompletions(editor);
        int offset = completion.getOffset();
        String string = completion.getText();
        Intrinsics.checkNotNull((Object)string);
        this.renderCompletion(editor, offset, string);
    }

    private final void cancelCompletion(PendingCompletion completion) {
    }

    public final void cleanCompletions(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        PendingCompletion pendingCompletion = this.pendingCompletion;
        if (pendingCompletion != null) {
            PendingCompletion it = pendingCompletion;
            boolean bl = false;
            this.cancelCompletion(it);
            this.pendingCompletion = null;
        }
        this.cleanRenders(editor);
    }

    private final void disposeInlays(Editor editor) {
        Inlay it;
        Object element$iv$iv;
        Iterable $this$filterTo$iv$iv;
        List list = editor.getInlayModel().getInlineElementsInRange(0, editor.getDocument().getTextLength());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getInlineElementsInRange(...)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = iterator.next();
            it = (Inlay)element$iv$iv;
            boolean bl = false;
            if (!(it.getRenderer() instanceof CockpitCustomElementRenderer)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Inlay it2 = (Inlay)element$iv;
            boolean bl = false;
            it2.dispose();
        }
        List list2 = editor.getInlayModel().getBlockElementsInRange(0, editor.getDocument().getTextLength());
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getBlockElementsInRange(...)");
        $this$filter$iv = list2;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        Iterator bl = $this$filterTo$iv$iv.iterator();
        while (bl.hasNext()) {
            element$iv$iv = bl.next();
            it = (Inlay)element$iv$iv;
            boolean bl2 = false;
            if (!(it.getRenderer() instanceof CockpitMultilineCustomElementRenderer)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$forEach$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Inlay it3 = (Inlay)element$iv;
            boolean bl3 = false;
            it3.dispose();
        }
    }

    public final void cleanRenders(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        ApplicationManager.getApplication().invokeLater(() -> AutocompleteService.cleanRenders$lambda$13(this, editor));
    }

    private final boolean isInjectedFile(Editor editor) {
        boolean bl;
        try {
            boolean bl2;
            PsiFile psiFile;
            PsiFile psiFile2 = psiFile = (PsiFile)ActionsKt.runReadAction(() -> AutocompleteService.isInjectedFile$lambda$14(this, editor));
            if (psiFile2 != null) {
                PsiFile it = psiFile2;
                boolean bl3 = false;
                bl2 = (Boolean)ActionsKt.runReadAction(() -> AutocompleteService.isInjectedFile$lambda$16$lambda$15(it));
            } else {
                bl2 = false;
            }
            bl = bl2;
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public final void hideCompletions(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (this.isInjectedFile(editor)) {
            return;
        }
        this.disposeInlays(editor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void getSuggestion(@NotNull Editor editor, boolean shouldDoMultiline, @NotNull CaretInfo caretInfo) {
        block11: {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)caretInfo, (String)"caretInfo");
            String string = editor.getVirtualFile().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            String language = LanguageUtilsKt.getLanguageFromPath(string);
            String string2 = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            String uuid = string2;
            CockpitWidgetFactoryKt.updateCodeRiderStatus(CodeRiderStatus.THINKING);
            long startTime = System.currentTimeMillis();
            Logger.debug$default(this.logger, "Code Completion " + uuid + " start: " + startTime, null, 2, null);
            int caretOffset = caretInfo.getOffset();
            int caretLineNumber = caretInfo.getLineNumber();
            Document document = editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            Document document2 = document;
            String string3 = document2.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
            String documentText = string3;
            String originLine = (String)StringsKt.lines((CharSequence)documentText).get(caretLineNumber);
            String string4 = documentText.substring(0, caretOffset);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            String prefix = string4;
            String string5 = documentText.substring(caretOffset);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
            String suffix = string5;
            String modelKey = ModelsConfiguration.Companion.getInstance().getCurrentCodeModel();
            ModelsConfiguration.ModelConfig modelConfig = ModelsConfiguration.Companion.getInstance().getCodeModels().get(modelKey);
            LLMParam llmParam = modelConfig != null ? modelConfig.getParams(false) : null;
            Object object = llmParam;
            int maxTokens = object != null && (object = ((LLMParam)object).getContextWindow()) != null && (object = (String)object.get("input")) != null ? Integer.parseInt((String)object) : 1024;
            int totalChars = ContextUtilsKt.standardContextSizeHints(maxTokens).component1();
            ContextResult contextResult = ContextMixer.getContext$default(this.contextMixer, editor, totalChars - documentText.length(), null, 4, null);
            long endTime = System.currentTimeMillis();
            Logger.debug$default(this.logger, "Code Completion " + uuid + " get context: " + endTime + ", duration: " + (endTime - startTime) + "ms", null, 2, null);
            ChatClient llmClient = ChatHandler.INSTANCE.getLLMClient(modelKey);
            List<ContextSnippet> context = contextResult.getContext();
            try {
                Object object2;
                CharSequence charSequence;
                String string6 = JaccardSimilarityRetrieverKt.getFilePathFromDocument(document2);
                if (string6 == null) {
                    string6 = "";
                }
                GenerateResult codeCompletionResult = llmClient.codeCompletion(modelKey, language, prefix, suffix, context, string6, shouldDoMultiline);
                CaretInfo newCaretInfo = this.getCaretInfo(editor);
                String resultText = codeCompletionResult.getText();
                long endTime2 = System.currentTimeMillis();
                Document document3 = editor.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document3, (String)"getDocument(...)");
                Logger.debug$default(this.logger, "Code Completion " + uuid + " end: " + endTime2 + ", duration: " + (endTime2 - startTime) + "ms, outputs: " + resultText + ", filename: " + JaccardSimilarityRetrieverKt.getFileNameFromDocument(document3) + ", offset: " + caretOffset, null, 2, null);
                if (newCaretInfo == null || newCaretInfo.getOffset() != caretOffset || (charSequence = (CharSequence)resultText) == null || StringsKt.isBlank((CharSequence)charSequence)) {
                    CockpitWidgetFactoryKt.updateCodeRiderStatus(CodeRiderStatus.LOGGED_IN);
                    return;
                }
                Object object3 = codeCompletionResult.getMetrics();
                int tokenCount = object3 != null && (object3 = ((GenerateMetrics)object3).getEvalCount()) != null ? (Integer)object3 : 0;
                int lineCount = StringsKt.lines((CharSequence)resultText).size();
                this.renderCompletion(editor, caretOffset, resultText);
                if (this.pendingCompletion != null) break block11;
                Object object4 = this;
                try {
                    AutocompleteService $this$getSuggestion_u24lambda_u2417 = object4;
                    boolean bl = false;
                    String completionType = shouldDoMultiline ? "multiline" : "singleline";
                    TrackService.INSTANCE.completionDisplay(completionType, modelKey, lineCount, tokenCount, uuid);
                    TrackService.INSTANCE.commandUsage(modelKey, CoderiderTrackClient.CommandType.completion);
                    object2 = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable bl) {
                    object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                }
                object4 = object2;
                Throwable throwable = Result.exceptionOrNull-impl((Object)object4);
                if (throwable != null) {
                    Object it = object2 = throwable;
                    boolean bl = false;
                    Logger.error$default(this.logger, "Error tracking completion data: " + ((Throwable)it).getMessage(), null, 2, null);
                }
                Logger.debug$default(this.logger, "Code Completion " + uuid + " Insertion end: " + System.currentTimeMillis() + ", duration: " + (System.currentTimeMillis() - startTime) + "ms, outputs: " + resultText + ", line: " + caretLineNumber, null, 2, null);
                ActionsKt.invokeLater$default(null, () -> AutocompleteService.getSuggestion$lambda$19(this, editor, caretOffset, caretLineNumber, uuid, resultText, originLine, lineCount, tokenCount, modelKey, language), (int)1, null);
            }
            catch (Throwable e) {
                e.printStackTrace();
                Logger.error$default(this.logger, "Error during code completion: " + e.getMessage(), null, 2, null);
                CockpitWidgetFactoryKt.updateCodeRiderStatus(CodeRiderStatus.LOGGED_IN);
                return;
            }
            finally {
                CockpitWidgetFactoryKt.updateCodeRiderStatus(CodeRiderStatus.LOGGED_IN);
            }
        }
    }

    private static final CaretInfo getCaretInfo$lambda$1(Editor $editor) {
        int offset = $editor.getCaretModel().getOffset();
        return new CaretInfo(offset, $editor.getDocument().getLineNumber(offset));
    }

    private static final void renderCompletion$lambda$3$lambda$2(AutocompleteService this$0, Editor $editor, String $completion, int $offset) {
        this$0.hideCompletions($editor);
        InlayProperties properties = new InlayProperties();
        properties.relatesToPrecedingText(true);
        properties.disableSoftWrapping(true);
        properties.priority(Integer.MAX_VALUE);
        List completionLines = StringsKt.lines((CharSequence)$completion);
        if (completionLines.size() > 1) {
            $editor.getInlayModel().addBlockElement($offset, properties, (EditorCustomElementRenderer)new CockpitMultilineCustomElementRenderer($editor, $completion));
            String firstLine = (String)CollectionsKt.first((List)completionLines);
            if (((CharSequence)firstLine).length() > 0) {
                int lineEndOffset = $editor.getDocument().getLineEndOffset($editor.getDocument().getLineNumber($offset));
                String string = $editor.getDocument().getText(new TextRange($offset, lineEndOffset));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                Pair<Integer, String> pair = this$0.trimCommonPrefixAndSuffix(firstLine, string);
                int inlayOffset = ((Number)pair.component1()).intValue();
                String completionText = (String)pair.component2();
                $editor.getInlayModel().addInlineElement($offset + inlayOffset, properties, (EditorCustomElementRenderer)new CockpitCustomElementRenderer($editor, completionText));
            }
        } else {
            int lineEndOffset = $editor.getDocument().getLineEndOffset($editor.getDocument().getLineNumber($offset));
            String string = $editor.getDocument().getText(new TextRange($offset, lineEndOffset));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            Pair<Integer, String> pair = this$0.trimCommonPrefixAndSuffix($completion, string);
            int inlayOffset = ((Number)pair.component1()).intValue();
            String completionText = (String)pair.component2();
            if (((CharSequence)completionText).length() > 0) {
                $editor.getInlayModel().addInlineElement($offset + inlayOffset, properties, (EditorCustomElementRenderer)new CockpitCustomElementRenderer($editor, completionText));
            }
        }
    }

    private static final Unit renderCompletion$lambda$3(Editor $editor, int $offset, AutocompleteService this$0, String $completion) {
        int currentCaretOffset = $editor.getCaretModel().getOffset();
        if ($offset != currentCaretOffset) {
            return Unit.INSTANCE;
        }
        WriteAction.run(() -> AutocompleteService.renderCompletion$lambda$3$lambda$2(this$0, $editor, $completion, $offset));
        return Unit.INSTANCE;
    }

    private static final PsiFile preflightCheck$lambda$5(AutocompleteService this$0, Editor $editor) {
        return PsiDocumentManager.getInstance((Project)this$0.project).getPsiFile($editor.getDocument());
    }

    private static final Unit accept$lambda$6(AutocompleteService this$0, Editor $editor) {
        this$0.cleanCompletions($editor);
        return Unit.INSTANCE;
    }

    private static final void cleanRenders$lambda$13(AutocompleteService this$0, Editor $editor) {
        try {
            this$0.disposeInlays($editor);
        }
        catch (Exception e) {
            this$0.logger.error("Error while clearing completions: " + e.getMessage(), e);
        }
    }

    private static final PsiFile isInjectedFile$lambda$14(AutocompleteService this$0, Editor $editor) {
        return PsiDocumentManager.getInstance((Project)this$0.project).getPsiFile($editor.getDocument());
    }

    private static final boolean isInjectedFile$lambda$16$lambda$15(PsiFile $it) {
        return AutocompleteServiceKt.isInjectedText((PsiElement)$it);
    }

    private static final Unit getSuggestion$lambda$19(AutocompleteService this$0, Editor $editor, int $caretOffset, int $caretLineNumber, String $uuid, String $resultText, String $originLine, int $lineCount, int $tokenCount, String $modelKey, String $language) {
        this$0.pendingCompletion = new PendingCompletion($editor, $caretOffset, $caretLineNumber, $uuid, $resultText, $originLine, $lineCount, $tokenCount, $modelKey, false, $language, 512, null);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$renderCompletion(AutocompleteService $this, Editor editor, int offset, String completion) {
        $this.renderCompletion(editor, offset, completion);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lcn/gitlab/kilo/jetbrains/autocomplete/AutocompleteService$CaretInfo;", "", "offset", "", "lineNumber", "<init>", "(II)V", "getOffset", "()I", "getLineNumber", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "coderider-kilo-jetbrains"})
    public static final class CaretInfo {
        private final int offset;
        private final int lineNumber;

        public CaretInfo(int offset, int lineNumber) {
            this.offset = offset;
            this.lineNumber = lineNumber;
        }

        public final int getOffset() {
            return this.offset;
        }

        public final int getLineNumber() {
            return this.lineNumber;
        }

        public final int component1() {
            return this.offset;
        }

        public final int component2() {
            return this.lineNumber;
        }

        @NotNull
        public final CaretInfo copy(int offset, int lineNumber) {
            return new CaretInfo(offset, lineNumber);
        }

        public static /* synthetic */ CaretInfo copy$default(CaretInfo caretInfo, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = caretInfo.offset;
            }
            if ((n3 & 2) != 0) {
                n2 = caretInfo.lineNumber;
            }
            return caretInfo.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "CaretInfo(offset=" + this.offset + ", lineNumber=" + this.lineNumber + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.offset);
            result2 = result2 * 31 + Integer.hashCode(this.lineNumber);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CaretInfo)) {
                return false;
            }
            CaretInfo caretInfo = (CaretInfo)other;
            if (this.offset != caretInfo.offset) {
                return false;
            }
            return this.lineNumber == caretInfo.lineNumber;
        }
    }
}

