/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.autocomplete;

import cn.gitlab.kilo.jetbrains.autocomplete.AutocompleteService;
import cn.gitlab.kilo.jetbrains.autocomplete.AutocompleteServiceKt;
import cn.gitlab.kilo.jetbrains.autocomplete.PendingCompletion;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcn/gitlab/kilo/jetbrains/autocomplete/AutocompleteCaretListener;", "Lcom/intellij/openapi/editor/event/CaretListener;", "<init>", "()V", "caretPositionChanged", "", "event", "Lcom/intellij/openapi/editor/event/CaretEvent;", "coderider-kilo-jetbrains"})
public final class AutocompleteCaretListener
implements CaretListener {
    @NotNull
    public static final AutocompleteCaretListener INSTANCE = new AutocompleteCaretListener();

    private AutocompleteCaretListener() {
    }

    public void caretPositionChanged(@NotNull CaretEvent event2) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
            Caret caret = event2.getCaret();
            if (caret == null) {
                return;
            }
            Caret caret2 = caret;
            Editor editor = caret2.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
            Editor editor2 = editor;
            int line = editor2.getDocument().getLineNumber(caret2.getOffset());
            AutocompleteService autocompleteService = AutocompleteServiceKt.getAutocompleteService(editor2);
            if (autocompleteService == null) {
                return;
            }
            AutocompleteService autocompleteService2 = autocompleteService;
            if (autocompleteService2.getLastChangeWasPartialAccept()) {
                autocompleteService2.setLastChangeWasPartialAccept(false);
                return;
            }
            PendingCompletion pendingCompletion = autocompleteService2.getPendingCompletion();
            if (pendingCompletion == null) break block4;
            PendingCompletion pending = pendingCompletion;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)pending.getEditor(), (Object)editor2) || pending.getCaretLineNumber() != line) {
                autocompleteService2.cleanRenders(editor2);
            }
        }
    }
}

