/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.actions;

import cn.gitlab.kilo.jetbrains.chat.ChatHandler;
import cn.gitlab.kilo.jetbrains.common.ChatPayload;
import cn.gitlab.kilo.jetbrains.common.Conversation;
import cn.gitlab.kilo.jetbrains.config.CockpitConfiguration;
import cn.gitlab.kilo.jetbrains.services.CoderiderTrackClient;
import cn.gitlab.kilo.jetbrains.services.TrackService;
import cn.gitlab.kilo.jetbrains.utils.GitUtilsKt;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContentBase;
import com.intellij.diff.contents.FileDocumentContentImpl;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.actions.diff.lst.LocalChangeListDiffRequest;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import java.util.Collection;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.optionals.OptionalsKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0007H\u0016J\"\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eJ.\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000eJ\b\u0010\u0013\u001a\u00020\u0014H\u0016\u00a8\u0006\u0015"}, d2={"Lcn/gitlab/kilo/jetbrains/actions/GeneratePreviewAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "event", "submitDiffReviewChat", "project", "Lcom/intellij/openapi/project/Project;", "beforePath", "", "afterPath", "submitVirtualReviewChat", "beforeContent", "afterContent", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "coderider-kilo-jetbrains"})
public final class GeneratePreviewAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabledAndVisible(!CockpitConfiguration.Companion.getInstance().needLogin());
    }

    public void actionPerformed(@NotNull AnActionEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        Project project = event2.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(project2);
        ToolWindow toolWindow = toolWindowManager.getToolWindow("CodeRider-Kilo");
        if (toolWindow != null && !toolWindow.isVisible()) {
            toolWindow.activate(null);
        }
        DataContext dataContext = event2.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        DataContext dataContext2 = dataContext;
        DiffRequest req = (DiffRequest)dataContext2.getData(DiffDataKeys.DIFF_REQUEST);
        if (req instanceof LocalChangeListDiffRequest) {
            Object object = dataContext2.getData(DiffDataKeys.DIFF_REQUEST);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.openapi.vcs.changes.actions.diff.lst.LocalChangeListDiffRequest");
            LocalChangeListDiffRequest request = (LocalChangeListDiffRequest)object;
            Ref.ObjectRef filePath = new Ref.ObjectRef();
            String string = request.getVirtualFile().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            filePath.element = string;
            ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project2);
            Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"getInstance(...)");
            ChangeListManager changeListManager2 = changeListManager;
            Collection collection = changeListManager2.getAllChanges();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getAllChanges(...)");
            Collection changes = collection;
            Optional<Object> optional = changes.stream().filter(arg_0 -> GeneratePreviewAction.actionPerformed$lambda$1(arg_0 -> GeneratePreviewAction.actionPerformed$lambda$0(filePath, arg_0), arg_0)).findAny();
            Intrinsics.checkNotNullExpressionValue(optional, (String)"findAny(...)");
            Change change = (Change)OptionalsKt.getOrNull(optional);
            if (change != null) {
                ContentRevision contentRevision;
                ContentRevision contentRevision2 = change.getBeforeRevision();
                this.submitDiffReviewChat(project2, contentRevision2 != null && (contentRevision2 = contentRevision2.getFile()) != null ? contentRevision2.getPath() : null, (contentRevision = change.getAfterRevision()) != null && (contentRevision = contentRevision.getFile()) != null ? contentRevision.getPath() : null);
            }
        } else if (req instanceof SimpleDiffRequest) {
            SimpleDiffRequest request = (SimpleDiffRequest)req;
            DiffContent beforeContent = (DiffContent)request.getContents().get(0);
            DiffContent afterContent = (DiffContent)request.getContents().get(1);
            if (beforeContent instanceof FileDocumentContentImpl) {
                this.submitDiffReviewChat(project2, ((FileDocumentContentImpl)beforeContent).getFile().getPath(), null);
                return;
            }
            if (afterContent instanceof FileDocumentContentImpl) {
                this.submitDiffReviewChat(project2, null, ((FileDocumentContentImpl)afterContent).getFile().getPath());
                return;
            }
            try {
                DiffContent diffContent = beforeContent;
                Intrinsics.checkNotNull((Object)diffContent, (String)"null cannot be cast to non-null type com.intellij.diff.contents.DocumentContentBase");
                String string = ((DocumentContentBase)diffContent).getDocument().getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                DiffContent diffContent2 = afterContent;
                Intrinsics.checkNotNull((Object)diffContent2, (String)"null cannot be cast to non-null type com.intellij.diff.contents.DocumentContentBase");
                String string2 = ((DocumentContentBase)diffContent2).getDocument().getText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                this.submitVirtualReviewChat(project2, "Base", "Current", string, string2);
                return;
            }
            catch (Throwable throwable) {
                return;
            }
        }
    }

    public final void submitDiffReviewChat(@NotNull Project project, @Nullable String beforePath, @Nullable String afterPath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ApplicationManager.getApplication().executeOnPooledThread(() -> GeneratePreviewAction.submitDiffReviewChat$lambda$2(project, beforePath, afterPath));
    }

    public final void submitVirtualReviewChat(@NotNull Project project, @NotNull String beforePath, @NotNull String afterPath, @NotNull String beforeContent, @NotNull String afterContent) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)beforePath, (String)"beforePath");
        Intrinsics.checkNotNullParameter((Object)afterPath, (String)"afterPath");
        Intrinsics.checkNotNullParameter((Object)beforeContent, (String)"beforeContent");
        Intrinsics.checkNotNullParameter((Object)afterContent, (String)"afterContent");
        ApplicationManager.getApplication().executeOnPooledThread(() -> GeneratePreviewAction.submitVirtualReviewChat$lambda$3(project, beforePath, afterPath, beforeContent, afterContent));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    private static final boolean actionPerformed$lambda$0(Ref.ObjectRef $filePath, Change it) {
        ContentRevision contentRevision;
        ContentRevision contentRevision2 = it.getBeforeRevision();
        return Intrinsics.areEqual((Object)$filePath.element, contentRevision2 != null && (contentRevision2 = contentRevision2.getFile()) != null ? contentRevision2.getPath() : null) || Intrinsics.areEqual((Object)$filePath.element, (contentRevision = it.getAfterRevision()) != null && (contentRevision = contentRevision.getFile()) != null ? contentRevision.getPath() : null);
    }

    private static final boolean actionPerformed$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void submitDiffReviewChat$lambda$2(Project $project, String $beforePath, String $afterPath) {
        ChatHandler.INSTANCE.cancelInflightRequests($project);
        if ($beforePath != null && $afterPath != null) {
            String gitDiff = GitUtilsKt.getGitDiff($project, $beforePath, $afterPath);
            String prompt = "\u6211\u73b0\u5728\u6709\u8fd9\u4e9b\u53d8\u5316" + gitDiff + "\uff0c\u9ebb\u70e6\u5e2e\u6211review\u4e00\u4e0b";
            Conversation conv = ChatHandler.INSTANCE.getConversation($project);
            TrackService.INSTANCE.commandUsage(conv.getModel(), CoderiderTrackClient.CommandType.codereview);
            ChatHandler.handleChatSubmit$default(ChatHandler.INSTANCE, $project, new ChatPayload(conv.getCurrentNode(), prompt, "preview", null, null, null, null, 120, null), null, 4, null);
        } else if ($beforePath != null) {
            byte[] byteArray;
            VirtualFile virtualFile;
            VirtualFile virtualFile2 = virtualFile = LocalFileSystem.getInstance().findFileByPath($beforePath);
            byte[] byArray = byteArray = (byte[])(virtualFile2 != null ? virtualFile2.contentsToByteArray() : null);
            if (byteArray == null) {
                byArray = new byte[]{};
            }
            String content2 = new String(byArray, Charsets.UTF_8);
            String prompt = "\u6211\u73b0\u5728\u5220\u9664\u4e86" + content2 + "\uff0c\u9ebb\u70e6\u5e2e\u6211review\u4e00\u4e0b";
            Conversation conv = ChatHandler.INSTANCE.getConversation($project);
            TrackService.INSTANCE.commandUsage(conv.getModel(), CoderiderTrackClient.CommandType.codereview);
            ChatHandler.handleChatSubmit$default(ChatHandler.INSTANCE, $project, new ChatPayload(conv.getCurrentNode(), prompt, "preview", null, null, null, null, 120, null), null, 4, null);
        } else if ($afterPath != null) {
            VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath($afterPath);
            if (virtualFile == null) {
                return;
            }
            VirtualFile virtualFile3 = virtualFile;
            byte[] byArray = virtualFile3.contentsToByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"contentsToByteArray(...)");
            byte[] byteArray = byArray;
            String content3 = new String(byteArray, Charsets.UTF_8);
            String prompt = "\u6211\u73b0\u5728\u65b0\u589e\u4e86\u6587\u4ef6" + content3 + "\uff0c\u9ebb\u70e6\u5e2e\u6211review\u4e00\u4e0b";
            Conversation conv = ChatHandler.INSTANCE.getConversation($project);
            TrackService.INSTANCE.commandUsage(conv.getModel(), CoderiderTrackClient.CommandType.codereview);
            ChatHandler.handleChatSubmit$default(ChatHandler.INSTANCE, $project, new ChatPayload(conv.getCurrentNode(), prompt, "preview", null, null, null, null, 120, null), null, 4, null);
        }
    }

    private static final void submitVirtualReviewChat$lambda$3(Project $project, String $beforePath, String $afterPath, String $beforeContent, String $afterContent) {
        ChatHandler.INSTANCE.cancelInflightRequests($project);
        try {
            String gitDiff = GitUtilsKt.getDiffByPathAndContent($project, $beforePath, $afterPath, $beforeContent, $afterContent);
            String prompt = "\u6211\u73b0\u5728\u6709\u8fd9\u4e9b\u53d8\u5316" + gitDiff + "\uff0c\u9ebb\u70e6\u5e2e\u6211review\u4e00\u4e0b";
            Conversation conv = ChatHandler.INSTANCE.getConversation($project);
            ChatHandler.handleChatSubmit$default(ChatHandler.INSTANCE, $project, new ChatPayload(conv.getCurrentNode(), prompt, "preview", null, null, null, null, 120, null), null, 4, null);
        }
        finally {
            return;
        }
    }
}

