/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.actions;

import cn.gitlab.kilo.jetbrains.actions.GenerateCommitMessageActionKt;
import cn.gitlab.kilo.jetbrains.chat.ChatHandler;
import cn.gitlab.kilo.jetbrains.common.Message;
import cn.gitlab.kilo.jetbrains.common.Role;
import cn.gitlab.kilo.jetbrains.config.CockpitConfiguration;
import cn.gitlab.kilo.jetbrains.config.ModelsConfiguration;
import cn.gitlab.kilo.jetbrains.llmClient.ChatClient;
import cn.gitlab.kilo.jetbrains.prompt.CommitPrompter;
import cn.gitlab.kilo.jetbrains.services.CoderiderTrackClient;
import cn.gitlab.kilo.jetbrains.services.GenerationCallbacks;
import cn.gitlab.kilo.jetbrains.services.TrackService;
import cn.gitlab.kilo.jetbrains.utils.ChatParameters;
import cn.gitlab.kilo.jetbrains.utils.GitUtilsKt;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.vcs.commit.AbstractCommitWorkflowHandler;
import com.intellij.vcs.commit.CommitWorkflowHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0007H\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u0007H\u0002J\u0018\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\t\u001a\u00020\u0007H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0014H\u0002J\u0018\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u00a8\u0006\u001b"}, d2={"Lcn/gitlab/kilo/jetbrains/actions/GenerateCommitMessageAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "event", "fileChanges", "", "Lcn/gitlab/kilo/jetbrains/prompt/CommitPrompter$FileChange;", "project", "Lcom/intellij/openapi/project/Project;", "getSelectedFileChanges", "generateFileChange", "change", "Lcom/intellij/openapi/vcs/changes/Change;", "getCommitMessage", "Lcom/intellij/openapi/vcs/ui/CommitMessage;", "createGenerationCallbacks", "Lcn/gitlab/kilo/jetbrains/services/GenerationCallbacks;", "commitMessage", "updateCommitMessage", "message", "", "coderider-kilo-jetbrains"})
public final class GenerateCommitMessageAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabledAndVisible(!CockpitConfiguration.Companion.getInstance().needLogin());
    }

    public void actionPerformed(@NotNull AnActionEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        Project project = event2.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        String string = GenerateCommitMessageActionKt.getProjectLanguage(project2);
        if (string == null) {
            string = "";
        }
        String language = string;
        ApplicationManager.getApplication().executeOnPooledThread(() -> GenerateCommitMessageAction.actionPerformed$lambda$0(this, event2, project2, language));
    }

    private final List<CommitPrompter.FileChange> fileChanges(Project project) {
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"getInstance(...)");
        ChangeListManager changeListManager2 = changeListManager;
        Collection collection = changeListManager2.getAllChanges();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getAllChanges(...)");
        Collection changes = collection;
        List<CommitPrompter.FileChange> list = changes.stream().map(arg_0 -> GenerateCommitMessageAction.fileChanges$lambda$2(arg_0 -> GenerateCommitMessageAction.fileChanges$lambda$1(this, project, arg_0), arg_0)).collect(Collectors.toList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"collect(...)");
        return list;
    }

    private final List<CommitPrompter.FileChange> getSelectedFileChanges(Project project, AnActionEvent event2) {
        CommitWorkflowHandler commitWorkflowHandler = (CommitWorkflowHandler)event2.getDataContext().getData(VcsDataKeys.COMMIT_WORKFLOW_HANDLER);
        if (commitWorkflowHandler == null) {
            return this.fileChanges(project);
        }
        CommitWorkflowHandler workflowHandler = commitWorkflowHandler;
        List changeList = new ArrayList();
        if (workflowHandler instanceof AbstractCommitWorkflowHandler) {
            List includedChanges = ((AbstractCommitWorkflowHandler)workflowHandler).getUi().getIncludedChanges();
            if (CollectionUtils.isNotEmpty((Collection)includedChanges)) {
                changeList.addAll(includedChanges);
            }
            List filePaths = ((AbstractCommitWorkflowHandler)workflowHandler).getUi().getIncludedUnversionedFiles();
            for (FilePath filePath : filePaths) {
                Change change = new Change(null, (ContentRevision)new CurrentContentRevision(filePath));
                changeList.add(change);
            }
            if (changeList.isEmpty()) {
                return this.fileChanges(project);
            }
            List<CommitPrompter.FileChange> list = changeList.stream().map(arg_0 -> GenerateCommitMessageAction.getSelectedFileChanges$lambda$4(arg_0 -> GenerateCommitMessageAction.getSelectedFileChanges$lambda$3(this, project, arg_0), arg_0)).collect(Collectors.toList());
            Intrinsics.checkNotNullExpressionValue(list, (String)"collect(...)");
            return list;
        }
        return this.fileChanges(project);
    }

    private final CommitPrompter.FileChange generateFileChange(Project project, Change change) {
        ContentRevision contentRevision;
        Object object;
        Object object2;
        Object object3;
        List diffs2 = CollectionsKt.emptyList();
        if (change.getType() == Change.Type.NEW && ((object3 = change.getAfterRevision()) == null || (object3 = object3.getContent()) == null || (object3 = StringsKt.lines((CharSequence)((CharSequence)object3))) == null)) {
            object3 = diffs2 = CollectionsKt.emptyList();
        }
        if (change.getType() == Change.Type.DELETED && ((object2 = change.getBeforeRevision()) == null || (object2 = object2.getContent()) == null || (object2 = StringsKt.lines((CharSequence)((CharSequence)object2))) == null)) {
            object2 = diffs2 = CollectionsKt.emptyList();
        }
        if (change.getType() == Change.Type.MODIFICATION) {
            ContentRevision contentRevision2;
            ContentRevision contentRevision3 = change.getBeforeRevision();
            diffs2 = StringsKt.lines((CharSequence)GitUtilsKt.getGitDiff(project, contentRevision3 != null && (contentRevision3 = contentRevision3.getFile()) != null ? contentRevision3.getPath() : null, (contentRevision2 = change.getAfterRevision()) != null && (contentRevision2 = contentRevision2.getFile()) != null ? contentRevision2.getPath() : null));
        }
        if (((object = change.getVirtualFile()) == null || (object = object.getPath()) == null) && ((contentRevision = change.getBeforeRevision()) != null && (contentRevision = contentRevision.getFile()) != null ? contentRevision.getPath() : (object = null)) == null) {
            object = "";
        }
        Change.Type type2 = change.getType();
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"getType(...)");
        return new CommitPrompter.FileChange((String)object, type2, diffs2);
    }

    private final CommitMessage getCommitMessage(AnActionEvent event2) {
        Object object = event2.getData(VcsDataKeys.COMMIT_MESSAGE_CONTROL);
        return object instanceof CommitMessage ? (CommitMessage)object : null;
    }

    private final GenerationCallbacks createGenerationCallbacks(CommitMessage commitMessage) {
        return new GenerationCallbacks(this, commitMessage){
            final /* synthetic */ GenerateCommitMessageAction this$0;
            final /* synthetic */ CommitMessage $commitMessage;
            {
                this.this$0 = $receiver;
                this.$commitMessage = $commitMessage;
            }

            public void onChange(String text, String reasonText) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                GenerateCommitMessageAction.access$updateCommitMessage(this.this$0, this.$commitMessage, text);
            }

            public void onComplete(String text, String reasonText) {
                String string = text;
                if (string == null) {
                    string = "";
                }
                GenerateCommitMessageAction.access$updateCommitMessage(this.this$0, this.$commitMessage, string);
            }

            public void onError(String text, Throwable error2) {
                Intrinsics.checkNotNullParameter((Object)error2, (String)"error");
                GenerateCommitMessageAction.access$updateCommitMessage(this.this$0, this.$commitMessage, "");
            }

            public void onSensitive() {
                GenerateCommitMessageAction.access$updateCommitMessage(this.this$0, this.$commitMessage, "");
            }

            public void metric(Long tokensIn, Long tokensOut) {
                GenerationCallbacks.DefaultImpls.metric(this, tokensIn, tokensOut);
            }
        };
    }

    private final void updateCommitMessage(CommitMessage commitMessage, String message) {
        ApplicationManager.getApplication().invokeLater(() -> GenerateCommitMessageAction.updateCommitMessage$lambda$6(commitMessage, message));
    }

    private static final void actionPerformed$lambda$0(GenerateCommitMessageAction this$0, AnActionEvent $event, Project $project, String $language) {
        CommitMessage commitMessage = this$0.getCommitMessage($event);
        List<CommitPrompter.FileChange> fileChanges = this$0.getSelectedFileChanges($project, $event);
        if (commitMessage != null && !((Collection)fileChanges).isEmpty()) {
            GenerationCallbacks callbacks2 = this$0.createGenerationCallbacks(commitMessage);
            ChatClient client = ChatHandler.getLLMClient$default(ChatHandler.INSTANCE, null, 1, null);
            ModelsConfiguration.ModelConfig defaultModel = ModelsConfiguration.Companion.getInstance().getDefaultChatModel();
            TrackService.INSTANCE.commandUsage(defaultModel.getKey(), CoderiderTrackClient.CommandType.commit_message);
            Object[] objectArray = new Message[]{new Message(Role.user, CommitPrompter.generateSummaryPrompt$default(CommitPrompter.INSTANCE, fileChanges, $language, null, 4, null), null, 0L, false, 28, null)};
            ChatParameters chatParameters = new ChatParameters(CollectionsKt.mutableListOf((Object[])objectArray), 0, null, null, null, null, defaultModel.getId(), null, false, false, null, null, 3518, null);
            client.chat(chatParameters, callbacks2);
        }
    }

    private static final CommitPrompter.FileChange fileChanges$lambda$1(GenerateCommitMessageAction this$0, Project $project, Change it) {
        Intrinsics.checkNotNull((Object)it);
        return this$0.generateFileChange($project, it);
    }

    private static final CommitPrompter.FileChange fileChanges$lambda$2(Function1 $tmp0, Object p0) {
        return (CommitPrompter.FileChange)$tmp0.invoke(p0);
    }

    private static final CommitPrompter.FileChange getSelectedFileChanges$lambda$3(GenerateCommitMessageAction this$0, Project $project, Change it) {
        Intrinsics.checkNotNull((Object)it);
        return this$0.generateFileChange($project, it);
    }

    private static final CommitPrompter.FileChange getSelectedFileChanges$lambda$4(Function1 $tmp0, Object p0) {
        return (CommitPrompter.FileChange)$tmp0.invoke(p0);
    }

    private static final void updateCommitMessage$lambda$6$lambda$5(CommitMessage $commitMessage, String $message) {
        $commitMessage.setCommitMessage(StringsKt.removeSuffix((String)StringsKt.removePrefix((String)$message, (CharSequence)"<"), (CharSequence)">"));
        $commitMessage.getEditorField().selectAll();
    }

    private static final void updateCommitMessage$lambda$6(CommitMessage $commitMessage, String $message) {
        ApplicationManager.getApplication().runWriteAction(() -> GenerateCommitMessageAction.updateCommitMessage$lambda$6$lambda$5($commitMessage, $message));
    }

    public static final /* synthetic */ void access$updateCommitMessage(GenerateCommitMessageAction $this, CommitMessage commitMessage, String message) {
        $this.updateCommitMessage(commitMessage, message);
    }
}

