/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.font.otf;

import com.itextpdf.io.font.otf.Glyph;
import com.itextpdf.io.font.otf.GlyphLine;
import com.itextpdf.io.font.otf.OpenTypeFontTableReader;
import java.io.IOException;

public abstract class OpenTableLookup {
    protected int lookupFlag;
    protected int[] subTableLocations;
    protected OpenTypeFontTableReader openReader;

    protected OpenTableLookup(OpenTypeFontTableReader openReader, int lookupFlag, int[] subTableLocations) {
        this.lookupFlag = lookupFlag;
        this.subTableLocations = subTableLocations;
        this.openReader = openReader;
    }

    public int getLookupFlag() {
        return this.lookupFlag;
    }

    public abstract boolean transformOne(GlyphLine var1);

    public boolean transformLine(GlyphLine line) {
        boolean changed = false;
        line.setIdx(line.getStart());
        while (line.getIdx() < line.getEnd() && line.getIdx() >= line.getStart()) {
            changed = this.transformOne(line) || changed;
        }
        return changed;
    }

    public boolean hasSubstitution(int index) {
        return false;
    }

    protected void readSubTables() throws IOException {
        for (int subTableLocation : this.subTableLocations) {
            this.readSubTable(subTableLocation);
        }
    }

    protected abstract void readSubTable(int var1) throws IOException;

    public static class GlyphIndexer {
        private GlyphLine line;
        private Glyph glyph;
        private int idx;

        public GlyphLine getLine() {
            return this.line;
        }

        public void setLine(GlyphLine line) {
            this.line = line;
        }

        public Glyph getGlyph() {
            return this.glyph;
        }

        public void setGlyph(Glyph glyph) {
            this.glyph = glyph;
        }

        public int getIdx() {
            return this.idx;
        }

        public void setIdx(int idx) {
            this.idx = idx;
        }

        public void nextGlyph(OpenTypeFontTableReader openReader, int lookupFlag) {
            this.glyph = null;
            while (++this.idx < this.line.getEnd()) {
                Glyph g = this.line.get(this.idx);
                if (openReader.isSkip(g.getCode(), lookupFlag)) continue;
                this.glyph = g;
                break;
            }
        }

        public void previousGlyph(OpenTypeFontTableReader openReader, int lookupFlag) {
            this.glyph = null;
            while (--this.idx >= this.line.getStart()) {
                Glyph g = this.line.get(this.idx);
                if (openReader.isSkip(g.getCode(), lookupFlag)) continue;
                this.glyph = g;
                break;
            }
        }
    }
}

