/*
 * Decompiled with CFR 0.152.
 */
package com.github.ksuid;

import com.github.ksuid.Ksuid;
import java.security.SecureRandom;
import java.time.Instant;
import java.util.Random;
import java.util.function.Supplier;

public class KsuidGenerator {
    private static final KsuidGenerator INSTANCE = new KsuidGenerator(new SecureRandom());
    private final Supplier<byte[]> payloadSupplier;

    public static String generate() {
        return KsuidGenerator.createKsuid().toString();
    }

    static KsuidGenerator getInstance() {
        return INSTANCE;
    }

    static Ksuid createKsuid() {
        return INSTANCE.newKsuid();
    }

    public KsuidGenerator(Random random) {
        this(() -> {
            byte[] payload = new byte[16];
            random.nextBytes(payload);
            return payload;
        });
    }

    public KsuidGenerator(Supplier<byte[]> payloadSupplier) {
        if (payloadSupplier.get().length != 16) {
            throw new IllegalArgumentException("payloadBytesSupplier must supply byte arrays of length 16");
        }
        this.payloadSupplier = payloadSupplier;
    }

    public Ksuid newKsuid() {
        return this.newKsuid(Instant.now());
    }

    public Ksuid newKsuid(Instant instant) {
        return Ksuid.newBuilder().withTimestamp((int)(instant.toEpochMilli() / 1000L - 1400000000L)).withPayload(this.payloadSupplier.get()).build();
    }
}

