/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.xobject;

import com.itextpdf.io.codec.PngWriter;
import com.itextpdf.io.codec.TiffWriter;
import com.itextpdf.kernel.actions.data.ITextCoreProductData;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.colorspace.PdfSpecialCs;
import com.itextpdf.kernel.pdf.function.IPdfFunction;
import com.itextpdf.kernel.pdf.function.PdfFunctionFactory;
import com.itextpdf.kernel.pdf.xobject.PdfImageXObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class ImagePdfBytesInfo {
    private static final String TIFFTAG_SOFTWARE_VALUE = "iText\u00ae " + ITextCoreProductData.getInstance().getVersion() + " \u00a9" + ITextCoreProductData.getInstance().getSinceCopyrightYear() + "-" + ITextCoreProductData.getInstance().getToCopyrightYear() + " Apryse Group NV";
    private final int bpc;
    private final int width;
    private final int height;
    private final PdfObject colorspace;
    private final PdfArray decode;
    private int pngColorType = -1;
    private int pngBitDepth;
    private byte[] palette;
    private byte[] icc;
    private int stride;

    public ImagePdfBytesInfo(PdfImageXObject imageXObject) {
        this.pngBitDepth = this.bpc = ((PdfStream)imageXObject.getPdfObject()).getAsNumber(PdfName.BitsPerComponent).intValue();
        this.palette = null;
        this.icc = null;
        this.stride = 0;
        this.width = (int)imageXObject.getWidth();
        this.height = (int)imageXObject.getHeight();
        this.colorspace = ((PdfStream)imageXObject.getPdfObject()).get(PdfName.ColorSpace);
        this.decode = ((PdfStream)imageXObject.getPdfObject()).getAsArray(PdfName.Decode);
        this.findColorspace(this.colorspace, false);
    }

    public int getPngColorType() {
        return this.pngColorType;
    }

    public byte[] decodeTiffAndPngBytes(byte[] imageBytes) throws IOException {
        PdfArray ca;
        PdfObject tyca;
        if (this.pngColorType < 0) {
            if (this.bpc != 8) {
                throw new com.itextpdf.io.exceptions.IOException("The color depth {0} is not supported.").setMessageParams(new Object[]{this.bpc});
            }
            if (this.colorspace instanceof PdfArray) {
                PdfArray ca2 = (PdfArray)this.colorspace;
                PdfObject tyca2 = ca2.get(0);
                if (!PdfName.ICCBased.equals(tyca2)) {
                    throw new com.itextpdf.io.exceptions.IOException("The color space {0} is not supported.").setMessageParams(new Object[]{tyca2.toString()});
                }
                PdfStream pr = (PdfStream)ca2.get(1);
                int n = pr.getAsNumber(PdfName.N).intValue();
                if (n != 4) {
                    throw new com.itextpdf.io.exceptions.IOException("N value {0} is not supported.").setMessageParams(new Object[]{n});
                }
                this.icc = pr.getBytes();
            } else if (!PdfName.DeviceCMYK.equals(this.colorspace)) {
                throw new com.itextpdf.io.exceptions.IOException("The color space {0} is not supported.").setMessageParams(new Object[]{this.colorspace.toString()});
            }
            ByteArrayOutputStream ms = new ByteArrayOutputStream();
            this.stride = 4 * this.width;
            TiffWriter wr = new TiffWriter();
            wr.addField((TiffWriter.FieldBase)new TiffWriter.FieldShort(277, 4));
            wr.addField((TiffWriter.FieldBase)new TiffWriter.FieldShort(258, new int[]{8, 8, 8, 8}));
            wr.addField((TiffWriter.FieldBase)new TiffWriter.FieldShort(262, 5));
            wr.addField((TiffWriter.FieldBase)new TiffWriter.FieldLong(256, this.width));
            wr.addField((TiffWriter.FieldBase)new TiffWriter.FieldLong(257, this.height));
            wr.addField((TiffWriter.FieldBase)new TiffWriter.FieldShort(259, 5));
            wr.addField((TiffWriter.FieldBase)new TiffWriter.FieldShort(317, 2));
            wr.addField((TiffWriter.FieldBase)new TiffWriter.FieldLong(278, this.height));
            wr.addField((TiffWriter.FieldBase)new TiffWriter.FieldRational(282, new int[]{300, 1}));
            wr.addField((TiffWriter.FieldBase)new TiffWriter.FieldRational(283, new int[]{300, 1}));
            wr.addField((TiffWriter.FieldBase)new TiffWriter.FieldShort(296, 2));
            wr.addField((TiffWriter.FieldBase)new TiffWriter.FieldAscii(305, TIFFTAG_SOFTWARE_VALUE));
            ByteArrayOutputStream comp = new ByteArrayOutputStream();
            TiffWriter.compressLZW((OutputStream)comp, (int)2, (byte[])imageBytes, (int)this.height, (int)4, (int)this.stride);
            byte[] buf = comp.toByteArray();
            wr.addField((TiffWriter.FieldBase)new TiffWriter.FieldImage(buf));
            wr.addField((TiffWriter.FieldBase)new TiffWriter.FieldLong(279, buf.length));
            if (this.icc != null) {
                wr.addField((TiffWriter.FieldBase)new TiffWriter.FieldUndefined(34675, this.icc));
            }
            wr.writeFile((OutputStream)ms);
            imageBytes = ms.toByteArray();
            return imageBytes;
        }
        if (this.colorspace instanceof PdfArray && PdfName.Separation.equals(tyca = (ca = (PdfArray)this.colorspace).get(0))) {
            return this.processSeperationColor(imageBytes, ca);
        }
        return this.processPng(imageBytes, this.pngBitDepth, this.pngColorType);
    }

    private byte[] processSeperationColor(byte[] imageBytes, PdfArray colorSpaceArray) throws IOException {
        PdfSpecialCs.Separation scs = new PdfSpecialCs.Separation(colorSpaceArray);
        byte[] newImageBytes = scs.getTintTransformation().calculateFromByteArray(imageBytes, 0, imageBytes.length, 8, 8);
        if (scs.getBaseCs().getNumberOfComponents() > 3) {
            throw new UnsupportedOperationException("Only RGB alternate color spaces are currently supported for extracting separation color images");
        }
        this.stride = (this.width * this.bpc * 3 + 7) / 8;
        return this.processPng(newImageBytes, this.pngBitDepth, 2);
    }

    private byte[] processPng(byte[] imageBytes, int pngBitDepth, int pngColorType) throws IOException {
        ByteArrayOutputStream ms = new ByteArrayOutputStream();
        PngWriter png = new PngWriter((OutputStream)ms);
        if (this.decode != null && pngBitDepth == 1 && this.decode.getAsNumber(0).intValue() == 1 && this.decode.getAsNumber(1).intValue() == 0) {
            int len = imageBytes.length;
            int t = 0;
            while (t < len) {
                int n = t++;
                imageBytes[n] = (byte)(imageBytes[n] ^ 0xFF);
            }
        }
        png.writeHeader(this.width, this.height, pngBitDepth, pngColorType);
        if (this.icc != null) {
            png.writeIccProfile(this.icc);
        }
        if (this.palette != null) {
            png.writePalette(this.palette);
        }
        png.writeData(imageBytes, this.stride);
        png.writeEnd();
        imageBytes = ms.toByteArray();
        return imageBytes;
    }

    private void findColorspace(PdfObject csObj, boolean checkIndexedBase) {
        if (PdfName.DeviceGray.equals(csObj) || csObj == null && this.bpc == 1) {
            this.stride = (this.width * this.bpc + 7) / 8;
            this.pngColorType = 0;
        } else if (PdfName.DeviceRGB.equals(csObj)) {
            if (this.bpc == 8 || this.bpc == 16 || checkIndexedBase) {
                this.stride = (this.width * this.bpc * 3 + 7) / 8;
                this.pngColorType = 2;
            }
        } else if (csObj instanceof PdfArray) {
            PdfArray ca = (PdfArray)csObj;
            PdfObject tyca = ca.get(0);
            if (PdfName.CalGray.equals(tyca)) {
                this.stride = (this.width * this.bpc + 7) / 8;
                this.pngColorType = 0;
            } else if (PdfName.CalRGB.equals(tyca)) {
                if (this.bpc == 8 || this.bpc == 16 || checkIndexedBase) {
                    this.stride = (this.width * this.bpc * 3 + 7) / 8;
                    this.pngColorType = 2;
                }
            } else if (PdfName.ICCBased.equals(tyca)) {
                PdfStream pr = (PdfStream)ca.get(1);
                int n = pr.getAsNumber(PdfName.N).intValue();
                if (n == 1) {
                    this.stride = (this.width * this.bpc + 7) / 8;
                    this.pngColorType = 0;
                    this.icc = pr.getBytes();
                } else if (n == 3) {
                    this.stride = (this.width * this.bpc * 3 + 7) / 8;
                    this.pngColorType = 2;
                    this.icc = pr.getBytes();
                }
            } else if (!checkIndexedBase && PdfName.Indexed.equals(tyca)) {
                this.findColorspace(ca.get(1), true);
                if (this.pngColorType == 2) {
                    PdfObject lookupObj = ca.get(3);
                    if (lookupObj instanceof PdfString) {
                        this.palette = ((PdfString)lookupObj).getValueBytes();
                    } else if (lookupObj instanceof PdfStream) {
                        this.palette = ((PdfStream)lookupObj).getBytes();
                    }
                    this.stride = (this.width * this.bpc + 7) / 8;
                    this.pngColorType = 3;
                }
            } else if (PdfName.Separation.equals(tyca)) {
                IPdfFunction fct = PdfFunctionFactory.create(ca.get(3));
                int components = fct.getOutputSize();
                this.pngColorType = components == 1 ? 1 : 2;
                this.pngBitDepth = 8;
            }
        }
    }
}

