/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.layer;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfIndirectReference;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfObjectWrapper;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.layer.PdfLayer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfOCProperties
extends PdfObjectWrapper<PdfDictionary> {
    static final String OC_CONFIG_NAME_PATTERN = "OCConfigName";
    private List<PdfLayer> layers = new ArrayList<PdfLayer>();

    public PdfOCProperties(PdfDocument document) {
        this((PdfDictionary)new PdfDictionary().makeIndirect(document));
    }

    public PdfOCProperties(PdfDictionary ocPropertiesDict) {
        super(ocPropertiesDict);
        PdfOCProperties.ensureObjectIsAddedToDocument(ocPropertiesDict);
        this.readLayersFromDictionary();
    }

    public void addOCGRadioGroup(List<PdfLayer> group) {
        PdfArray ar = new PdfArray();
        for (PdfLayer layer : group) {
            if (layer.getTitle() != null) continue;
            ar.add(((PdfDictionary)layer.getPdfObject()).getIndirectReference());
        }
        if (ar.size() != 0) {
            PdfArray radioButtonGroups;
            PdfDictionary d = ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.D);
            if (d == null) {
                d = new PdfDictionary();
                ((PdfDictionary)this.getPdfObject()).put(PdfName.D, d);
            }
            if ((radioButtonGroups = d.getAsArray(PdfName.RBGroups)) == null) {
                radioButtonGroups = new PdfArray();
                d.put(PdfName.RBGroups, radioButtonGroups);
                d.setModified();
            } else {
                radioButtonGroups.setModified();
            }
            radioButtonGroups.add(ar);
        }
    }

    public PdfObject fillDictionary() {
        return this.fillDictionary(true);
    }

    public PdfObject fillDictionary(boolean removeNonDocumentOcgs) {
        PdfArray gr = new PdfArray();
        for (PdfLayer layer : this.layers) {
            if (layer.getTitle() != null) continue;
            gr.add(layer.getIndirectReference());
        }
        ((PdfDictionary)this.getPdfObject()).put(PdfName.OCGs, gr);
        PdfDictionary filledDDictionary = new PdfDictionary();
        PdfDictionary dDictionary = ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.D);
        if (dDictionary != null) {
            PdfOCProperties.copyDDictionaryField(PdfName.RBGroups, dDictionary, filledDDictionary);
            PdfOCProperties.copyDDictionaryField(PdfName.Name, dDictionary, filledDDictionary);
            PdfOCProperties.copyDDictionaryField(PdfName.BaseState, dDictionary, filledDDictionary);
            PdfOCProperties.copyDDictionaryField(PdfName.Intent, dDictionary, filledDDictionary);
            PdfOCProperties.copyDDictionaryField(PdfName.ListMode, dDictionary, filledDDictionary);
        }
        if (filledDDictionary.get(PdfName.Name) == null) {
            filledDDictionary.put(PdfName.Name, new PdfString(this.createUniqueName(), "UnicodeBig"));
        }
        ((PdfDictionary)this.getPdfObject()).put(PdfName.D, filledDDictionary);
        ArrayList<PdfLayer> docOrder = new ArrayList<PdfLayer>(this.layers);
        for (int i = 0; i < docOrder.size(); ++i) {
            PdfLayer layer = (PdfLayer)docOrder.get(i);
            if (layer.getParents() == null) continue;
            docOrder.remove(layer);
            --i;
        }
        PdfArray order = new PdfArray();
        for (Object e : docOrder) {
            PdfLayer pdfLayer = (PdfLayer)e;
            PdfOCProperties.getOCGOrder(order, pdfLayer);
        }
        filledDDictionary.put(PdfName.Order, order);
        PdfArray off = new PdfArray();
        for (PdfLayer pdfLayer : this.layers) {
            PdfLayer layer = pdfLayer;
            if (layer.getTitle() != null || layer.isOn()) continue;
            off.add(layer.getIndirectReference());
        }
        if (off.size() > 0) {
            filledDDictionary.put(PdfName.OFF, off);
        }
        PdfArray pdfArray = new PdfArray();
        for (PdfLayer layer : this.layers) {
            if (layer.getTitle() != null || !layer.isLocked()) continue;
            pdfArray.add(layer.getIndirectReference());
        }
        if (pdfArray.size() > 0) {
            filledDDictionary.put(PdfName.Locked, pdfArray);
        }
        this.addASEvent(PdfName.View, PdfName.Zoom);
        this.addASEvent(PdfName.View, PdfName.View);
        this.addASEvent(PdfName.Print, PdfName.Print);
        this.addASEvent(PdfName.Export, PdfName.Export);
        if (removeNonDocumentOcgs) {
            this.removeNotRegisteredOcgs();
        }
        return this.getPdfObject();
    }

    public static boolean checkDDictonaryFieldValue(PdfName field, PdfObject value) {
        if (PdfName.BaseState.equals(field) && !PdfName.ON.equals(value)) {
            return false;
        }
        return !PdfName.Intent.equals(field) || PdfName.View.equals(value);
    }

    @Override
    public void flush() {
        this.fillDictionary();
        super.flush();
    }

    public List<PdfLayer> getLayers() {
        return new ArrayList<PdfLayer>(this.layers);
    }

    @Override
    protected boolean isWrappedObjectMustBeIndirect() {
        return true;
    }

    protected void registerLayer(PdfLayer layer) {
        if (layer == null) {
            throw new IllegalArgumentException("layer argument is null");
        }
        this.layers.add(layer);
    }

    protected PdfDocument getDocument() {
        return ((PdfDictionary)this.getPdfObject()).getIndirectReference().getDocument();
    }

    private static void getOCGOrder(PdfArray order, PdfLayer layer) {
        List<PdfLayer> children;
        if (!layer.isOnPanel()) {
            return;
        }
        if (layer.getTitle() == null) {
            order.add(((PdfDictionary)layer.getPdfObject()).getIndirectReference());
        }
        if ((children = layer.getChildren()) == null) {
            return;
        }
        PdfArray kids = new PdfArray();
        if (layer.getTitle() != null) {
            kids.add(new PdfString(layer.getTitle(), "UnicodeBig"));
        }
        for (PdfLayer child : children) {
            PdfOCProperties.getOCGOrder(kids, child);
        }
        if (kids.size() > 0) {
            order.add(kids);
        }
    }

    private static void copyDDictionaryField(PdfName fieldToAdd, PdfDictionary fromDictionary, PdfDictionary toDictionary) {
        PdfObject value = fromDictionary.get(fieldToAdd);
        if (value != null) {
            if (PdfOCProperties.checkDDictonaryFieldValue(fieldToAdd, value)) {
                toDictionary.put(fieldToAdd, value);
            } else {
                Logger logger = LoggerFactory.getLogger(PdfOCProperties.class);
                String warnText = MessageFormatUtil.format((String)"The default configuration dictionary field {0} has a value of {1}, which is not the required value for this field. The field will not be processed.", (Object[])new Object[]{fieldToAdd, value});
                logger.warn(warnText);
            }
        }
    }

    private void removeNotRegisteredOcgs() {
        PdfArray rbGroups;
        PdfDictionary dDict = ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.D);
        PdfDictionary ocProperties = ((PdfDictionary)this.getDocument().getCatalog().getPdfObject()).getAsDictionary(PdfName.OCProperties);
        HashSet<PdfIndirectReference> ocgsFromDocument = new HashSet<PdfIndirectReference>();
        if (ocProperties.getAsArray(PdfName.OCGs) != null) {
            PdfArray ocgs = ocProperties.getAsArray(PdfName.OCGs);
            for (PdfObject ocgObj : ocgs) {
                if (!ocgObj.isDictionary()) continue;
                ocgsFromDocument.add(ocgObj.getIndirectReference());
            }
        }
        if ((rbGroups = dDict.getAsArray(PdfName.RBGroups)) != null) {
            for (PdfObject rbGroupObj : rbGroups) {
                PdfArray rbGroup = (PdfArray)rbGroupObj;
                for (int i = rbGroup.size() - 1; i > -1; --i) {
                    if (ocgsFromDocument.contains(rbGroup.get(i).getIndirectReference())) continue;
                    rbGroup.remove(i);
                }
            }
        }
    }

    private void addASEvent(PdfName event, PdfName category) {
        PdfArray arr = new PdfArray();
        for (PdfLayer layer : this.layers) {
            PdfDictionary usage;
            if (layer.getTitle() != null || ((PdfDictionary)layer.getPdfObject()).isFlushed() || (usage = ((PdfDictionary)layer.getPdfObject()).getAsDictionary(PdfName.Usage)) == null || usage.get(category) == null) continue;
            arr.add(((PdfDictionary)layer.getPdfObject()).getIndirectReference());
        }
        if (arr.size() == 0) {
            return;
        }
        PdfDictionary d = ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.D);
        PdfArray arras = d.getAsArray(PdfName.AS);
        if (arras == null) {
            arras = new PdfArray();
            d.put(PdfName.AS, arras);
        }
        PdfDictionary as = new PdfDictionary();
        as.put(PdfName.Event, event);
        PdfArray categoryArray = new PdfArray();
        categoryArray.add(category);
        as.put(PdfName.Category, categoryArray);
        as.put(PdfName.OCGs, arr);
        arras.add(as);
    }

    private void readLayersFromDictionary() {
        PdfArray ocgs = ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.OCGs);
        if (ocgs == null || ocgs.isEmpty()) {
            return;
        }
        TreeMap<PdfIndirectReference, PdfLayer> layerMap = new TreeMap<PdfIndirectReference, PdfLayer>();
        for (int ind = 0; ind < ocgs.size(); ++ind) {
            PdfLayer currentLayer = new PdfLayer((PdfDictionary)ocgs.getAsDictionary(ind).makeIndirect(this.getDocument()));
            currentLayer.onPanel = false;
            layerMap.put(currentLayer.getIndirectReference(), currentLayer);
        }
        PdfDictionary d = ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.D);
        if (d != null && !d.isEmpty()) {
            PdfArray orderArray;
            PdfArray locked;
            PdfArray off = d.getAsArray(PdfName.OFF);
            if (off != null) {
                for (int i = 0; i < off.size(); ++i) {
                    PdfObject offLayer = off.get(i, false);
                    if (offLayer.isIndirectReference()) {
                        ((PdfLayer)layerMap.get((Object)((PdfIndirectReference)offLayer))).on = false;
                        continue;
                    }
                    ((PdfLayer)layerMap.get((Object)offLayer.getIndirectReference())).on = false;
                }
            }
            if ((locked = d.getAsArray(PdfName.Locked)) != null) {
                for (int i = 0; i < locked.size(); ++i) {
                    PdfObject lockedLayer = locked.get(i, false);
                    if (lockedLayer.isIndirectReference()) {
                        ((PdfLayer)layerMap.get((Object)((PdfIndirectReference)lockedLayer))).locked = true;
                        continue;
                    }
                    ((PdfLayer)layerMap.get((Object)lockedLayer.getIndirectReference())).locked = true;
                }
            }
            if ((orderArray = d.getAsArray(PdfName.Order)) != null && !orderArray.isEmpty()) {
                HashSet<PdfIndirectReference> layerReferences = new HashSet<PdfIndirectReference>();
                HashMap<PdfString, PdfLayer> titleLayers = new HashMap<PdfString, PdfLayer>();
                this.readOrderFromDictionary(null, orderArray, layerMap, layerReferences, titleLayers);
            }
        }
        for (PdfLayer layer : layerMap.values()) {
            if (layer.isOnPanel()) continue;
            this.layers.add(layer);
        }
    }

    private void readOrderFromDictionary(PdfLayer parent, PdfArray orderArray, Map<PdfIndirectReference, PdfLayer> layerMap, Set<PdfIndirectReference> layerReferences, Map<PdfString, PdfLayer> titleLayers) {
        for (int i = 0; i < orderArray.size(); ++i) {
            PdfArray subArray;
            PdfObject item = orderArray.get(i);
            if (item.getType() == 3) {
                PdfArray nextArray;
                PdfLayer layer = layerMap.get(item.getIndirectReference());
                if (layer == null) continue;
                if (!layerReferences.contains(layer.getIndirectReference())) {
                    layerReferences.add(layer.getIndirectReference());
                    this.layers.add(layer);
                    layer.onPanel = true;
                }
                if (parent != null) {
                    parent.addChild(layer);
                }
                if (i + 1 >= orderArray.size() || orderArray.get(i + 1).getType() != 1 || (nextArray = orderArray.getAsArray(i + 1)).size() <= 0 || nextArray.get(0).getType() == 10) continue;
                this.readOrderFromDictionary(layer, orderArray.getAsArray(i + 1), layerMap, layerReferences, titleLayers);
                ++i;
                continue;
            }
            if (item.getType() != 1 || (subArray = (PdfArray)item).isEmpty()) continue;
            PdfObject firstObj = subArray.get(0);
            if (firstObj.getType() == 10) {
                PdfString title = (PdfString)firstObj;
                PdfLayer titleLayer = titleLayers.get(title);
                if (titleLayer == null) {
                    titleLayer = PdfLayer.createTitleSilent(title.toUnicodeString(), this.getDocument());
                    titleLayer.onPanel = true;
                    this.layers.add(titleLayer);
                    titleLayers.put(title, titleLayer);
                }
                if (parent != null) {
                    parent.addChild(titleLayer);
                }
                this.readOrderFromDictionary(titleLayer, new PdfArray(subArray.subList(1, subArray.size())), layerMap, layerReferences, titleLayers);
                continue;
            }
            this.readOrderFromDictionary(parent, subArray, layerMap, layerReferences, titleLayers);
        }
    }

    private String createUniqueName() {
        int uniqueID = 0;
        HashSet<String> usedNames = new HashSet<String>();
        PdfArray configs = ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.Configs);
        if (null != configs) {
            for (int i = 0; i < configs.size(); ++i) {
                PdfDictionary alternateDictionary = configs.getAsDictionary(i);
                if (null == alternateDictionary || !alternateDictionary.containsKey(PdfName.Name)) continue;
                usedNames.add(alternateDictionary.getAsString(PdfName.Name).toUnicodeString());
            }
        }
        while (usedNames.contains(OC_CONFIG_NAME_PATTERN + uniqueID)) {
            ++uniqueID;
        }
        return OC_CONFIG_NAME_PATTERN + uniqueID;
    }
}

