/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.crypto.securityhandler;

import com.itextpdf.io.source.ByteUtils;
import com.itextpdf.io.util.StreamUtil;
import com.itextpdf.kernel.crypto.securityhandler.SecurityHandler;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfEncryption;
import com.itextpdf.kernel.pdf.PdfLiteral;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfString;
import java.security.MessageDigest;

public abstract class StandardSecurityHandler
extends SecurityHandler {
    protected static final int PERMS_MASK_1_FOR_REVISION_2 = -64;
    protected static final int PERMS_MASK_1_FOR_REVISION_3_OR_GREATER = -8000;
    protected static final int PERMS_MASK_2 = -4;
    protected int permissions;
    protected boolean usedOwnerPassword = true;

    public int getPermissions() {
        return this.permissions;
    }

    public void setPermissions(int permissions, PdfDictionary encryptionDictionary) {
        this.permissions = permissions;
        encryptionDictionary.put(PdfName.P, new PdfNumber(permissions));
    }

    public boolean isUsedOwnerPassword() {
        return this.usedOwnerPassword;
    }

    protected void setStandardHandlerDicEntries(PdfDictionary encryptionDictionary, byte[] userKey, byte[] ownerKey) {
        encryptionDictionary.put(PdfName.Filter, PdfName.Standard);
        encryptionDictionary.put(PdfName.O, new PdfLiteral(StreamUtil.createEscapedString((byte[])ownerKey)));
        encryptionDictionary.put(PdfName.U, new PdfLiteral(StreamUtil.createEscapedString((byte[])userKey)));
        encryptionDictionary.put(PdfName.P, new PdfNumber(this.permissions));
    }

    protected byte[] generateOwnerPasswordIfNullOrEmpty(byte[] ownerPassword) {
        if (ownerPassword == null || ownerPassword.length == 0) {
            try {
                MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
                ownerPassword = sha256.digest(PdfEncryption.generateNewDocumentId());
            }
            catch (Exception e) {
                throw new PdfException("PdfEncryption exception.", e);
            }
        }
        return ownerPassword;
    }

    protected byte[] getIsoBytes(PdfString string) {
        return ByteUtils.getIsoBytes((String)string.getValue());
    }

    protected static boolean equalsArray(byte[] ar1, byte[] ar2, int size) {
        for (int k = 0; k < size; ++k) {
            if (ar1[k] == ar2[k]) continue;
            return false;
        }
        return true;
    }
}

