/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.crypto;

import com.itextpdf.kernel.crypto.AESGCMCipher;
import com.itextpdf.kernel.crypto.OutputStreamEncryption;
import com.itextpdf.kernel.exceptions.PdfException;
import java.io.IOException;
import java.io.OutputStream;
import java.security.SecureRandom;

public class OutputStreamAesGcmEncryption
extends OutputStreamEncryption {
    private final AESGCMCipher cipher;
    private boolean finished;
    private static final SecureRandom rng = new SecureRandom();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStreamAesGcmEncryption(OutputStream out, byte[] key, byte[] noncePart) {
        super(out);
        byte[] iv = new byte[12];
        byte[] randomPart = new byte[5];
        SecureRandom secureRandom = rng;
        synchronized (secureRandom) {
            rng.nextBytes(randomPart);
        }
        System.arraycopy(randomPart, 0, iv, 0, 5);
        System.arraycopy(noncePart, 0, iv, 5, 7);
        this.cipher = new AESGCMCipher(true, key, iv);
        try {
            out.write(iv);
        }
        catch (IOException e) {
            throw new PdfException("PdfEncryption exception.", e);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        byte[] cipherBuffer = this.cipher.update(b, off, len);
        if (cipherBuffer.length != 0) {
            this.out.write(cipherBuffer, 0, cipherBuffer.length);
        }
    }

    @Override
    public void finish() {
        if (!this.finished) {
            this.finished = true;
            byte[] cipherBuffer = this.cipher.doFinal();
            try {
                this.out.write(cipherBuffer, 0, cipherBuffer.length);
            }
            catch (IOException e) {
                throw new PdfException("PdfEncryption exception.", e);
            }
        }
    }
}

