/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.config;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigList;
import io.ktor.server.config.HoconListDecoder;
import io.ktor.server.config.HoconMapDecoder;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.AbstractDecoder;
import kotlinx.serialization.encoding.CompositeDecoder;
import kotlinx.serialization.modules.SerializersModule;
import kotlinx.serialization.modules.SerializersModuleBuildersKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0010\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0012\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0011J\u000f\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000f\u0010\u0019\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u000f\u0010\u001c\u001a\u00020\u001bH\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u000f\u0010\u001f\u001a\u00020\u001eH\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\u000f\u0010\"\u001a\u00020!H\u0016\u00a2\u0006\u0004\b\"\u0010#J\u000f\u0010%\u001a\u00020$H\u0016\u00a2\u0006\u0004\b%\u0010&J\u000f\u0010'\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b'\u0010(J\u0017\u0010*\u001a\u00020\f2\u0006\u0010)\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b*\u0010\u000eJ\u0017\u0010,\u001a\u00020+2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b,\u0010-R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010.R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010/R\u001a\u0010\u0007\u001a\u00020\u00068\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0007\u00100\u001a\u0004\b1\u00102R\"\u00103\u001a\u00020\f8\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\b3\u00104\u001a\u0004\b5\u0010\u001a\"\u0004\b6\u00107R\"\u00108\u001a\u00020\u00048\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\b8\u0010/\u001a\u0004\b9\u0010(\"\u0004\b:\u0010;\u00a8\u0006<"}, d2={"Lio/ktor/server/config/HoconDecoder;", "Lkotlinx/serialization/encoding/AbstractDecoder;", "Lcom/typesafe/config/Config;", "config", "", "path", "Lkotlinx/serialization/modules/SerializersModule;", "serializersModule", "<init>", "(Lcom/typesafe/config/Config;Ljava/lang/String;Lkotlinx/serialization/modules/SerializersModule;)V", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "descriptor", "", "decodeElementIndex", "(Lkotlinx/serialization/descriptors/SerialDescriptor;)I", "", "decodeNotNullMark", "()Z", "decodeBoolean", "", "decodeByte", "()B", "", "decodeShort", "()S", "decodeInt", "()I", "", "decodeLong", "()J", "", "decodeFloat", "()F", "", "decodeDouble", "()D", "", "decodeChar", "()C", "decodeString", "()Ljava/lang/String;", "enumDescriptor", "decodeEnum", "Lkotlinx/serialization/encoding/CompositeDecoder;", "beginStructure", "(Lkotlinx/serialization/descriptors/SerialDescriptor;)Lkotlinx/serialization/encoding/CompositeDecoder;", "Lcom/typesafe/config/Config;", "Ljava/lang/String;", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "elementIndex", "I", "getElementIndex", "setElementIndex", "(I)V", "currentPath", "getCurrentPath", "setCurrentPath", "(Ljava/lang/String;)V", "ktor-server-core"})
public class HoconDecoder
extends AbstractDecoder {
    @NotNull
    private final Config config;
    @NotNull
    private final String path;
    @NotNull
    private final SerializersModule serializersModule;
    private int elementIndex;
    @NotNull
    private String currentPath;

    public HoconDecoder(@NotNull Config config, @NotNull String path, @NotNull SerializersModule serializersModule) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)serializersModule, (String)"serializersModule");
        this.config = config;
        this.path = path;
        this.serializersModule = serializersModule;
        this.currentPath = this.path;
    }

    public /* synthetic */ HoconDecoder(Config config, String string, SerializersModule serializersModule, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "";
        }
        if ((n & 4) != 0) {
            serializersModule = SerializersModuleBuildersKt.EmptySerializersModule();
        }
        this(config, string, serializersModule);
    }

    @NotNull
    public SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    protected final int getElementIndex() {
        return this.elementIndex;
    }

    protected final void setElementIndex(int n) {
        this.elementIndex = n;
    }

    @NotNull
    protected final String getCurrentPath() {
        return this.currentPath;
    }

    protected final void setCurrentPath(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.currentPath = string;
    }

    public int decodeElementIndex(@NotNull SerialDescriptor descriptor) {
        int n;
        String fullPath;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (this.elementIndex >= descriptor.getElementsCount()) {
            return -1;
        }
        int n2 = this.elementIndex;
        this.elementIndex = n2 + 1;
        int newIndex = n2;
        String name = descriptor.getElementName(newIndex);
        String string = fullPath = ((CharSequence)this.path).length() == 0 ? name : this.path + '.' + name;
        if (this.config.hasPath(fullPath)) {
            this.currentPath = fullPath;
            n = newIndex;
        } else {
            n = -1;
        }
        return n;
    }

    public boolean decodeNotNullMark() {
        return this.config.hasPath(this.currentPath) && !this.config.getIsNull(this.currentPath);
    }

    public boolean decodeBoolean() {
        return this.config.getBoolean(this.currentPath);
    }

    public byte decodeByte() {
        return (byte)this.config.getInt(this.currentPath);
    }

    public short decodeShort() {
        return (short)this.config.getInt(this.currentPath);
    }

    public int decodeInt() {
        return this.config.getInt(this.currentPath);
    }

    public long decodeLong() {
        return this.config.getLong(this.currentPath);
    }

    public float decodeFloat() {
        return (float)this.config.getDouble(this.currentPath);
    }

    public double decodeDouble() {
        return this.config.getDouble(this.currentPath);
    }

    public char decodeChar() {
        return this.config.getString(this.currentPath).charAt(0);
    }

    @NotNull
    public String decodeString() {
        String string = this.config.getString(this.currentPath);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        return string;
    }

    public int decodeEnum(@NotNull SerialDescriptor enumDescriptor) {
        Intrinsics.checkNotNullParameter((Object)enumDescriptor, (String)"enumDescriptor");
        return enumDescriptor.getElementIndex(this.decodeString());
    }

    @NotNull
    public CompositeDecoder beginStructure(@NotNull SerialDescriptor descriptor) {
        CompositeDecoder compositeDecoder;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        SerialKind serialKind = descriptor.getKind();
        Intrinsics.checkNotNull((Object)serialKind, (String)"null cannot be cast to non-null type kotlinx.serialization.descriptors.StructureKind");
        StructureKind structureKind = (StructureKind)serialKind;
        if (Intrinsics.areEqual((Object)structureKind, (Object)StructureKind.LIST.INSTANCE)) {
            ConfigList configList = this.config.getList(this.currentPath);
            Intrinsics.checkNotNullExpressionValue((Object)configList, (String)"getList(...)");
            compositeDecoder = (CompositeDecoder)new HoconListDecoder(configList, this.getSerializersModule());
        } else if (Intrinsics.areEqual((Object)structureKind, (Object)StructureKind.MAP.INSTANCE)) {
            Config config = this.config.getObject(this.currentPath).toConfig();
            Intrinsics.checkNotNullExpressionValue((Object)config, (String)"toConfig(...)");
            compositeDecoder = (CompositeDecoder)new HoconMapDecoder(config, this.getSerializersModule());
        } else if (Intrinsics.areEqual((Object)structureKind, (Object)StructureKind.CLASS.INSTANCE) || Intrinsics.areEqual((Object)structureKind, (Object)StructureKind.OBJECT.INSTANCE)) {
            compositeDecoder = (CompositeDecoder)new HoconDecoder(this.config, this.currentPath, this.getSerializersModule());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return compositeDecoder;
    }
}

