/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.utils;

import cn.gitlab.kilo.jetbrains.common.Credentials;
import cn.gitlab.kilo.jetbrains.common.KBType;
import cn.gitlab.kilo.jetbrains.common.Logger;
import cn.gitlab.kilo.jetbrains.common.Rag;
import cn.gitlab.kilo.jetbrains.common.ReviewParams;
import cn.gitlab.kilo.jetbrains.config.CockpitConfiguration;
import cn.gitlab.kilo.jetbrains.constants.GitlabContantsKt;
import cn.gitlab.kilo.jetbrains.editor.GitlabBrowserEditorKt;
import cn.gitlab.kilo.jetbrains.utils.ClientUtilsKt;
import cn.gitlab.kilo.jetbrains.utils.CustomURI;
import cn.gitlab.kilo.jetbrains.utils.FetchException;
import cn.gitlab.kilo.jetbrains.utils.GitUtilsKt;
import cn.gitlab.kilo.jetbrains.utils.HelpException;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffManager;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.LocalFilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000x\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\u001a\u000e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b\u001a\u0010\u0010\n\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0010\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0004\u001a\u00020\u0005\u001a0\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\b2\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u00102\b\b\u0002\u0010\u0012\u001a\u00020\b\u001a\u001e\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\b\u001a\u001e\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\b\u001a\u0016\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\b\u001a\u0016\u0010\u001a\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\b\u001a\u000e\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\r\u001a\u000e\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\r\u001a\u0006\u0010\u001f\u001a\u00020 \u001a\u000e\u0010!\u001a\u00020\"2\u0006\u0010\u0014\u001a\u00020\r\u001a\u001e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\b2\u0006\u0010&\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\r\u001a\u001c\u0010'\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u00102\u0006\u0010(\u001a\u00020)\u001a\u000e\u0010*\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\r\u001a\u000e\u0010+\u001a\u00020\b2\u0006\u0010,\u001a\u00020\r\u001a\u000e\u0010-\u001a\u00020\b2\u0006\u0010,\u001a\u00020\r\u001a\u000e\u0010.\u001a\u00020\"2\u0006\u0010,\u001a\u00020\r\u001a\u001c\u0010/\u001a\u00020\b2\u0014\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0010\u001a\u000e\u00100\u001a\u00020\b2\u0006\u0010(\u001a\u00020)\u001a$\u00101\u001a\u0002022\b\u00103\u001a\u0004\u0018\u00010\b2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0010\u001a\u0016\u00104\u001a\u00020\b2\u0006\u00105\u001a\u0002022\u0006\u00106\u001a\u000207\u001a:\u00108\u001a\u0002092\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010:\u001a\u0004\u0018\u00010\b2\u0006\u0010;\u001a\u00020\b2\b\u0010<\u001a\u0004\u0018\u00010\b2\u0006\u0010=\u001a\u00020\b2\u0006\u0010>\u001a\u00020\b\u001a\"\u0010?\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010@\u001a\u0004\u0018\u00010\b2\u0006\u00105\u001a\u000202\u001a\u000e\u0010A\u001a\u00020\b2\u0006\u0010&\u001a\u00020\r\u001a\u001c\u0010B\u001a\u00020\b2\u0014\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010\u001a\u000e\u0010H\u001a\u00020I2\u0006\u0010\t\u001a\u00020\b\u001a(\u0010J\u001a\u0002092\u0006\u0010\t\u001a\u00020\b2\u0006\u0010K\u001a\u00020I2\u0006\u0010L\u001a\u00020\b2\b\b\u0002\u0010M\u001a\u00020\b\u001a\u001c\u0010N\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00102\u0006\u0010O\u001a\u00020\b\u001a\u000e\u0010P\u001a\u00020\"2\u0006\u0010Q\u001a\u00020\r\u001a\u000e\u0010R\u001a\u00020E2\u0006\u0010K\u001a\u00020I\u001a\u001c\u0010S\u001a\u00020E2\u0014\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010\u001a\u0018\u0010T\u001a\u00020\b2\u0006\u0010U\u001a\u00020\b2\b\b\u0002\u0010V\u001a\u00020\b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001d\u0010C\u001a\u000e\u0012\u0004\u0012\u00020E\u0012\u0004\u0012\u00020\b0D\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u0010G\u00a8\u0006W"}, d2={"loggerGitlabUtils", "Lcn/gitlab/kilo/jetbrains/common/Logger;", "getWorkSpaceRagStatus", "Lcn/gitlab/kilo/jetbrains/common/Rag;", "project", "Lcom/intellij/openapi/project/Project;", "getRag", "extractGitlabPathFromUrl", "", "url", "getKbId", "getGitlabPath", "graphqlRequest", "Lcom/google/gson/JsonObject;", "query", "variables", "", "", "instanceUrl", "addHostToUrl", "discussion", "namespaceWithPath", "makeMarkdownLinksAbsolute", "body", "makeHtmlLinksAbsolute", "bodyHtml", "ensureAbsoluteAvatarUrl", "avatarUrl", "getIssuableGqlId", "issuable", "getNamespaceWithPath", "getCredentials", "Lcn/gitlab/kilo/jetbrains/common/Credentials;", "isTextDiffDiscussion", "", "uriForDiscussion", "Ljava/net/URI;", "rootFsPath", "mr", "toReviewParams", "params", "Lcn/gitlab/kilo/jetbrains/common/ReviewParams;", "firstNoteFrom", "pathFromPosition", "position", "commitFromPosition", "isOld", "jsonStringifyWithSortedKeys", "toReviewUri", "createCustomUri", "Lcn/gitlab/kilo/jetbrains/utils/CustomURI;", "path", "fetchFileContent", "uri", "rootPath", "Ljava/nio/file/Path;", "showDiffInJetbrains", "", "baseContentPath", "baseContent", "headContentPath", "headContent", "name", "getFileContentFromCommit", "commitHash", "restMrKey", "createQueryString", "getMrGqlId", "Lkotlin/Function1;", "", "getGetMrGqlId", "()Lkotlin/jvm/functions/Function1;", "crossFetch", "Lokhttp3/Response;", "handleFetchError", "response", "resourceName", "readMeSection", "safelyParseJson", "json", "isLabelEvent", "note", "getTotalPages", "getCurrentPage", "packCode", "content", "lang", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nGitlabUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitlabUtils.kt\ncn/gitlab/kilo/jetbrains/utils/GitlabUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,563:1\n1#2:564\n504#3,7:565\n126#4:572\n153#4,3:573\n*S KotlinDebug\n*F\n+ 1 GitlabUtils.kt\ncn/gitlab/kilo/jetbrains/utils/GitlabUtilsKt\n*L\n476#1:565,7\n476#1:572\n476#1:573,3\n*E\n"})
public final class GitlabUtilsKt {
    @NotNull
    private static final Logger loggerGitlabUtils = Logger.Companion.getInstance("GitlabUtils");
    @NotNull
    private static final Function1<Integer, String> getMrGqlId = GitlabUtilsKt::getMrGqlId$lambda$11;

    @NotNull
    public static final Rag getWorkSpaceRagStatus(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Rag rag = GitlabUtilsKt.getRag(project);
        if (rag == null) {
            throw new VcsException("\u5f53\u524d\u8fdc\u7a0b\u4ed3\u5e93\u4e0d\u662f\u4ee3\u7801\u77e5\u8bc6\u5e93");
        }
        Rag currentDocumentRag = rag;
        Object[] objectArray = new String[]{"CREATE_FAIL", "CREATING", "NE"};
        if (CollectionsKt.listOf((Object[])objectArray).contains(currentDocumentRag.getStatus())) {
            throw new VcsException("\u5f53\u524d\u4ed3\u5e93\u6240\u5728\u77e5\u8bc6\u5e93\u7684\u72b6\u6001\u4e3a " + currentDocumentRag.getStatus());
        }
        return currentDocumentRag.toRagStatus();
    }

    @Nullable
    public static final Rag getRag(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String gitlabUrl = GitUtilsKt.getRemoteRepositoryUrl(project);
        if (gitlabUrl != null) {
            String path = GitlabUtilsKt.extractGitlabPathFromUrl(gitlabUrl);
            List<Rag> rags2 = CockpitConfiguration.Companion.getInstance().getRags();
            if (rags2 != null) {
                Optional<Object> optional = rags2.stream().filter(arg_0 -> GitlabUtilsKt.getRag$lambda$1(arg_0 -> GitlabUtilsKt.getRag$lambda$0(path, arg_0), arg_0)).findAny();
                Intrinsics.checkNotNullExpressionValue(optional, (String)"findAny(...)");
                Rag findAny = (Rag)OptionalsKt.getOrNull(optional);
                return findAny;
            }
        }
        return null;
    }

    @NotNull
    public static final String extractGitlabPathFromUrl(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (StringsKt.startsWith$default((String)url, (String)"git@", (boolean)false, (int)2, null)) {
            return StringsKt.substringBeforeLast$default((String)StringsKt.substringAfter$default((String)url, (String)":", null, (int)2, null), (String)".git", null, (int)2, null);
        }
        return StringsKt.substringBeforeLast$default((String)StringsKt.substringAfter$default((String)StringsKt.substringAfter$default((String)url, (String)"://", null, (int)2, null), (String)"/", null, (int)2, null), (String)".git", null, (int)2, null);
    }

    @Nullable
    public static final String getKbId(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Rag rag = GitlabUtilsKt.getRag(project);
        return rag != null ? rag.getProjectId() : null;
    }

    @Nullable
    public static final String getGitlabPath(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String gitlabUrl = GitUtilsKt.getRemoteRepositoryUrl(project);
        if (gitlabUrl != null) {
            String path = GitlabUtilsKt.extractGitlabPathFromUrl(gitlabUrl);
            return path;
        }
        return null;
    }

    @Nullable
    public static final JsonObject graphqlRequest(@NotNull String query, @NotNull Map<String, ? extends Object> variables, @NotNull String instanceUrl) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        Intrinsics.checkNotNullParameter((Object)instanceUrl, (String)"instanceUrl");
        try {
            Object baseUrl = StringsKt.endsWith$default((String)instanceUrl, (String)"/", (boolean)false, (int)2, null) ? instanceUrl : instanceUrl + "/";
            String endpoint = (String)baseUrl + "api/graphql";
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"query", (Object)query), TuplesKt.to((Object)"variables", variables)};
            String bodyJson = new Gson().toJson((Object)MapsKt.mapOf((Pair[])pairArray));
            Intrinsics.checkNotNull((Object)bodyJson);
            RequestBody requestBody = RequestBody.Companion.create(bodyJson, MediaType.Companion.get("application/json; charset=utf-8"));
            Request request = new Request.Builder().url(endpoint).post(requestBody).header("Authorization", "Bearer " + CockpitConfiguration.Companion.getInstance().getState().getGitlabPAT()).build();
            OkHttpClient client = ClientUtilsKt.generateOkHttpClientBuilder().build();
            Response response = client.newCall(request).execute();
            if (response.isSuccessful()) {
                String responseBody;
                ResponseBody responseBody2 = response.body();
                String string = responseBody = responseBody2 != null ? responseBody2.string() : null;
                if (responseBody != null) {
                    return ((JsonObject)new Gson().fromJson(responseBody, JsonObject.class)).getAsJsonObject("data");
                }
                return null;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static /* synthetic */ JsonObject graphqlRequest$default(String string, Map map, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = CockpitConfiguration.Companion.getInstance().getState().getGitlabHost();
        }
        return GitlabUtilsKt.graphqlRequest(string, map, string2);
    }

    @NotNull
    public static final JsonObject addHostToUrl(@NotNull JsonObject discussion, @NotNull String namespaceWithPath, @NotNull String instanceUrl) {
        Intrinsics.checkNotNullParameter((Object)discussion, (String)"discussion");
        Intrinsics.checkNotNullParameter((Object)namespaceWithPath, (String)"namespaceWithPath");
        Intrinsics.checkNotNullParameter((Object)instanceUrl, (String)"instanceUrl");
        JsonArray notes = discussion.getAsJsonObject("notes").getAsJsonArray("nodes");
        int n = notes.size();
        for (int i = 0; i < n; ++i) {
            String string;
            String string2;
            JsonObject note = notes.get(i).getAsJsonObject();
            if (!note.get("body").isJsonNull()) {
                String string3 = note.get("body").getAsString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getAsString(...)");
                string2 = GitlabUtilsKt.makeMarkdownLinksAbsolute(string3, namespaceWithPath, instanceUrl);
            } else {
                string2 = null;
            }
            note.addProperty("body", string2);
            if (!note.get("bodyHtml").isJsonNull()) {
                String string4 = note.get("bodyHtml").getAsString();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getAsString(...)");
                string = GitlabUtilsKt.makeHtmlLinksAbsolute(string4, instanceUrl);
            } else {
                string = null;
            }
            note.addProperty("bodyHtml", string);
            JsonObject author = note.getAsJsonObject("author");
            JsonElement avatarUrl = author.get("avatarUrl");
            if (avatarUrl.isJsonNull()) continue;
            String string5 = avatarUrl.getAsString();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getAsString(...)");
            author.addProperty("avatarUrl", GitlabUtilsKt.ensureAbsoluteAvatarUrl(instanceUrl, string5));
        }
        return discussion;
    }

    @NotNull
    public static final String makeMarkdownLinksAbsolute(@NotNull String body, @NotNull String namespaceWithPath, @NotNull String instanceUrl) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)namespaceWithPath, (String)"namespaceWithPath");
        Intrinsics.checkNotNullParameter((Object)instanceUrl, (String)"instanceUrl");
        CharSequence charSequence = body;
        Regex regex = new Regex("\\[(.*?)\\]\\((?!http)(.*?)\\)");
        Function1 function1 = arg_0 -> GitlabUtilsKt.makeMarkdownLinksAbsolute$lambda$2(instanceUrl, namespaceWithPath, arg_0);
        return regex.replace(charSequence, function1);
    }

    @NotNull
    public static final String makeHtmlLinksAbsolute(@NotNull String bodyHtml, @NotNull String instanceUrl) {
        Intrinsics.checkNotNullParameter((Object)bodyHtml, (String)"bodyHtml");
        Intrinsics.checkNotNullParameter((Object)instanceUrl, (String)"instanceUrl");
        CharSequence charSequence = bodyHtml;
        Regex regex = new Regex("href=\"(?!http)(.*?)\"");
        Function1 function1 = arg_0 -> GitlabUtilsKt.makeHtmlLinksAbsolute$lambda$3(instanceUrl, arg_0);
        return regex.replace(charSequence, function1);
    }

    @NotNull
    public static final String ensureAbsoluteAvatarUrl(@NotNull String instanceUrl, @NotNull String avatarUrl) {
        Intrinsics.checkNotNullParameter((Object)instanceUrl, (String)"instanceUrl");
        Intrinsics.checkNotNullParameter((Object)avatarUrl, (String)"avatarUrl");
        return StringsKt.startsWith$default((String)avatarUrl, (String)"http", (boolean)false, (int)2, null) ? avatarUrl : instanceUrl + "/" + avatarUrl;
    }

    @NotNull
    public static final String getIssuableGqlId(@NotNull JsonObject issuable) {
        Intrinsics.checkNotNullParameter((Object)issuable, (String)"issuable");
        String type2 = GitlabBrowserEditorKt.isMr(issuable) ? "MergeRequest" : "Issue";
        return "gid://gitlab/" + type2 + "/" + issuable.get("id").getAsString();
    }

    @NotNull
    public static final String getNamespaceWithPath(@NotNull JsonObject issuable) {
        Intrinsics.checkNotNullParameter((Object)issuable, (String)"issuable");
        String string = issuable.get("web_url").getAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAsString(...)");
        return StringsKt.substringBeforeLast$default((String)StringsKt.removePrefix((String)string, (CharSequence)(CockpitConfiguration.Companion.getInstance().getState().getGitlabHost() + "/")), (String)"/-", null, (int)2, null);
    }

    @NotNull
    public static final Credentials getCredentials() {
        return new Credentials(CockpitConfiguration.Companion.getInstance().getState().getGitlabHost(), CockpitConfiguration.Companion.getInstance().getState().getGitlabAccessToken());
    }

    public static final boolean isTextDiffDiscussion(@NotNull JsonObject discussion) {
        JsonObject jsonObject2;
        Intrinsics.checkNotNullParameter((Object)discussion, (String)"discussion");
        JsonObject jsonObject3 = discussion.getAsJsonObject("notes");
        Object notes = jsonObject3 != null ? jsonObject3.getAsJsonArray("nodes") : null;
        JsonArray jsonArray = notes;
        if (jsonArray == null || (jsonArray = jsonArray.get(0)) == null || (jsonArray = jsonArray.getAsJsonObject()) == null) {
            return false;
        }
        JsonArray firstNote = jsonArray;
        JsonElement position = firstNote.get("position");
        return !position.isJsonNull() ? Intrinsics.areEqual((jsonObject2 = position.getAsJsonObject()) != null && (jsonObject2 = jsonObject2.get("positionType")) != null ? jsonObject2.getAsString() : null, (Object)"text") : false;
    }

    @NotNull
    public static final URI uriForDiscussion(@NotNull String rootFsPath, @NotNull JsonObject mr, @NotNull JsonObject discussion) {
        Intrinsics.checkNotNullParameter((Object)rootFsPath, (String)"rootFsPath");
        Intrinsics.checkNotNullParameter((Object)mr, (String)"mr");
        Intrinsics.checkNotNullParameter((Object)discussion, (String)"discussion");
        JsonObject position = GitlabUtilsKt.firstNoteFrom(discussion).getAsJsonObject("position");
        Intrinsics.checkNotNull((Object)position);
        Map<String, Object> reviewParams = GitlabUtilsKt.toReviewParams(new ReviewParams(GitlabUtilsKt.pathFromPosition(position), GitlabUtilsKt.commitFromPosition(position), rootFsPath, mr.get("project_id").getAsString(), mr.get("id").getAsString()));
        Object object = reviewParams.get("query");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.String>");
        String query = CollectionsKt.joinToString$default((Iterable)((Map)object).entrySet(), (CharSequence)"&", null, null, (int)0, null, GitlabUtilsKt::uriForDiscussion$lambda$4, (int)30, null);
        return new URI("review://" + reviewParams.get("path") + "?" + query);
    }

    @NotNull
    public static final Map<String, Object> toReviewParams(@NotNull ReviewParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"commit", (Object)params.getCommit()), TuplesKt.to((Object)"repositoryRoot", (Object)params.getRepositoryRoot()), TuplesKt.to((Object)"projectId", (Object)params.getProjectId()), TuplesKt.to((Object)"mrId", (Object)params.getMrId())};
        Map query = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)"path", (Object)params.getPath()), TuplesKt.to((Object)"query", (Object)query)};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @NotNull
    public static final JsonObject firstNoteFrom(@NotNull JsonObject discussion) {
        Intrinsics.checkNotNullParameter((Object)discussion, (String)"discussion");
        JsonObject jsonObject2 = discussion.getAsJsonObject("notes");
        if (jsonObject2 == null || (jsonObject2 = jsonObject2.getAsJsonArray("nodes")) == null) {
            throw new IllegalArgumentException("Discussion does not contain notes or nodes");
        }
        JsonObject notes = jsonObject2;
        if (notes.size() == 0) {
            throw new IllegalArgumentException("Discussion should contain at least one note");
        }
        JsonObject jsonObject3 = notes.get(0).getAsJsonObject();
        Intrinsics.checkNotNullExpressionValue((Object)jsonObject3, (String)"getAsJsonObject(...)");
        return jsonObject3;
    }

    @NotNull
    public static final String pathFromPosition(@NotNull JsonObject position) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        if (GitlabUtilsKt.isOld(position)) {
            object = position.get("oldPath");
            if (object == null || (object = object.getAsString()) == null) {
                throw new IllegalArgumentException("Position missing oldPath for old position");
            }
        } else {
            object = position.get("newPath");
            if (object == null || (object = object.getAsString()) == null) {
                throw new IllegalArgumentException("Position missing newPath for new position");
            }
        }
        return object;
    }

    @NotNull
    public static final String commitFromPosition(@NotNull JsonObject position) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        JsonObject jsonObject2 = position.getAsJsonObject("diffRefs");
        if (jsonObject2 == null) {
            throw new IllegalArgumentException("Position missing diffRefs");
        }
        JsonObject diffRefs = jsonObject2;
        if (GitlabUtilsKt.isOld(position)) {
            object = diffRefs.get("baseSha");
            if (object == null || (object = object.getAsString()) == null) {
                throw new IllegalArgumentException("diffRefs missing baseSha for old position");
            }
        } else {
            object = diffRefs.get("headSha");
            if (object == null || (object = object.getAsString()) == null) {
                throw new IllegalArgumentException("diffRefs missing headSha for new position");
            }
        }
        return object;
    }

    public static final boolean isOld(@NotNull JsonObject position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        JsonElement jsonElement = position.get("oldLine");
        return jsonElement != null ? !jsonElement.isJsonNull() : false;
    }

    @NotNull
    public static final String jsonStringifyWithSortedKeys(@NotNull Map<String, String> query) {
        Intrinsics.checkNotNullParameter(query, (String)"query");
        SortedMap sortedQuery = MapsKt.toSortedMap(query);
        String string = new Gson().toJson((Object)sortedQuery);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
        return string;
    }

    @NotNull
    public static final String toReviewUri(@NotNull ReviewParams params) {
        String string;
        String encodedQuery;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)params, (String)"params");
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"commit", (Object)params.getCommit()), TuplesKt.to((Object)"repositoryRoot", (Object)params.getRepositoryRoot()), TuplesKt.to((Object)"projectId", (Object)params.getProjectId()), TuplesKt.to((Object)"mrId", (Object)params.getMrId())};
                Map query = MapsKt.mapOf((Pair[])pairArray);
                String queryString = GitlabUtilsKt.jsonStringifyWithSortedKeys(query);
                encodedQuery = URLEncoder.encode(queryString, "UTF-8");
                string = params.getPath();
                if (string == null) break block2;
                String it = string;
                boolean bl = false;
                String string2 = ((Object)Paths.get(it, new String[0])).toString();
                string = string2;
                if (string2 != null) break block3;
            }
            string = "";
        }
        String path = string;
        String uri = GitlabContantsKt.getREVIEW_URI_SCHEME() + "://" + path + "?" + encodedQuery;
        return uri;
    }

    @NotNull
    public static final CustomURI createCustomUri(@Nullable String path, @NotNull Map<String, String> query) {
        Intrinsics.checkNotNullParameter(query, (String)"query");
        return new CustomURI("gl-review", null, path, query, null);
    }

    @NotNull
    public static final String fetchFileContent(@NotNull CustomURI uri, @NotNull Path rootPath) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)rootPath, (String)"rootPath");
        String string = uri.getPath();
        if (string == null) {
            return "";
        }
        String uriPath = string;
        String normalizedPath = ((Object)rootPath.resolve(uriPath)).toString();
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(normalizedPath);
        return virtualFile != null && (byArray = virtualFile.contentsToByteArray()) != null ? new String(byArray, Charsets.UTF_8) : "";
    }

    /*
     * WARNING - void declaration
     */
    public static final void showDiffInJetbrains(@NotNull Project project, @Nullable String baseContentPath, @NotNull String baseContent, @Nullable String headContentPath, @NotNull String headContent, @NotNull String name) {
        LocalFilePath localFilePath;
        LocalFilePath localFilePath2;
        LocalFilePath localFilePath3;
        DiffContentFactory diffContentFactory;
        Project project2;
        String string;
        DiffContentFactory diffContentFactory2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)baseContent, (String)"baseContent");
        Intrinsics.checkNotNullParameter((Object)headContent, (String)"headContent");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        DiffContentFactory diffContentFactory3 = DiffContentFactory.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)diffContentFactory3, (String)"getInstance(...)");
        DiffContentFactory diffContentFactory4 = diffContentFactory2 = diffContentFactory3;
        Project project3 = project;
        String string2 = baseContent;
        String string3 = baseContentPath;
        if (string3 != null) {
            void it;
            String string4 = string3;
            string = string2;
            project2 = project3;
            diffContentFactory = diffContentFactory4;
            boolean bl = false;
            localFilePath3 = new LocalFilePath((String)it, false);
            diffContentFactory4 = diffContentFactory;
            project3 = project2;
            string2 = string;
            localFilePath2 = localFilePath3;
        } else {
            localFilePath2 = null;
        }
        DocumentContent documentContent = diffContentFactory4.create(project3, string2, (FilePath)localFilePath2);
        Intrinsics.checkNotNullExpressionValue((Object)documentContent, (String)"create(...)");
        DocumentContent baseDiffContent = documentContent;
        DiffContentFactory diffContentFactory5 = diffContentFactory2;
        Project project4 = project;
        String string5 = headContent;
        String string6 = headContentPath;
        if (string6 != null) {
            void it;
            String bl = string6;
            string = string5;
            project2 = project4;
            diffContentFactory = diffContentFactory5;
            boolean bl2 = false;
            localFilePath3 = new LocalFilePath((String)it, false);
            diffContentFactory5 = diffContentFactory;
            project4 = project2;
            string5 = string;
            localFilePath = localFilePath3;
        } else {
            localFilePath = null;
        }
        DocumentContent documentContent2 = diffContentFactory5.create(project4, string5, (FilePath)localFilePath);
        Intrinsics.checkNotNullExpressionValue((Object)documentContent2, (String)"create(...)");
        DocumentContent headDiffContent = documentContent2;
        ContentDiffRequest diffRequest = (ContentDiffRequest)new SimpleDiffRequest(name, (DiffContent)baseDiffContent, (DiffContent)headDiffContent, baseContentPath, headContentPath);
        ActionsKt.invokeLater$default(null, () -> GitlabUtilsKt.showDiffInJetbrains$lambda$8(project, diffRequest), (int)1, null);
    }

    @Nullable
    public static final String getFileContentFromCommit(@NotNull Project project, @Nullable String commitHash2, @NotNull CustomURI uri) {
        String string;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        String string2 = uri.getPath();
        if (string2 == null) {
            return "";
        }
        String filePath = string2;
        GitRepositoryManager gitRepositoryManager = GitRepositoryManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)gitRepositoryManager, (String)"getInstance(...)");
        GitRepositoryManager repositoryManager = gitRepositoryManager;
        List list = repositoryManager.getRepositories();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getRepositories(...)");
        List repositories = list;
        if (repositories.isEmpty()) {
            Logger.info$default(loggerGitlabUtils, "No Git repositories found!", null, 2, null);
            return null;
        }
        GitRepository repository = (GitRepository)CollectionsKt.first((List)repositories);
        GitLineHandler handler = new GitLineHandler(project, repository.getRoot(), GitCommand.SHOW);
        handler.setSilent(true);
        String[] stringArray = new String[]{commitHash2 + ":" + filePath};
        handler.addParameters(stringArray);
        GitCommandResult gitCommandResult = Git.getInstance().runCommand(handler);
        Intrinsics.checkNotNullExpressionValue((Object)gitCommandResult, (String)"runCommand(...)");
        GitCommandResult result2 = gitCommandResult;
        if (result2.success()) {
            List list2 = result2.getOutput();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getOutput(...)");
            string = CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        } else {
            Logger.info$default(loggerGitlabUtils, "Failed to fetch file content: " + result2.getErrorOutput(), null, 2, null);
            string = null;
        }
        return string;
    }

    @NotNull
    public static final String restMrKey(@NotNull JsonObject mr) {
        Intrinsics.checkNotNullParameter((Object)mr, (String)"mr");
        JsonElement jsonElement = mr.get("source_branch");
        String sourceBranch = jsonElement != null ? jsonElement.getAsString() : null;
        JsonElement jsonElement2 = mr.get("sha");
        String sha = jsonElement2 != null ? jsonElement2.getAsString() : null;
        return "RestMr:" + sourceBranch + ":" + sha;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String createQueryString(@NotNull Map<String, ? extends Object> query) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(query, (String)"query");
        Map<String, ? extends Object> $this$filterValues$iv = query;
        boolean $i$f$filterValues = false;
        Map<String, Object> result$iv = new LinkedHashMap();
        for (Map.Entry<String, ? extends Object> entry$iv : $this$filterValues$iv.entrySet()) {
            Object it = entry$iv.getValue();
            boolean bl = false;
            if (!(it != null)) continue;
            ((HashMap)result$iv).put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map $this$map$iv = result$iv;
        boolean $i$f$map = false;
        result$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            collection.add(key + "=" + value);
        }
        String queryParams = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"&", null, null, (int)0, null, null, (int)62, null);
        return ((CharSequence)queryParams).length() > 0 ? "?" + queryParams : "";
    }

    @NotNull
    public static final Function1<Integer, String> getGetMrGqlId() {
        return getMrGqlId;
    }

    @NotNull
    public static final Response crossFetch(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Request.Builder requestBuilder = new Request.Builder().url(url).header("Authorization", "Bearer " + CockpitConfiguration.Companion.getInstance().getState().getGitlabPAT());
        Request request = requestBuilder.build();
        OkHttpClient client = ClientUtilsKt.generateOkHttpClientBuilder().build();
        return client.newCall(request).execute();
    }

    public static final void handleFetchError(@NotNull String url, @NotNull Response response, @NotNull String resourceName, @NotNull String readMeSection) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
        Intrinsics.checkNotNullParameter((Object)readMeSection, (String)"readMeSection");
        int responseCode = response.code();
        String responseBody = String.valueOf(response.body());
        if (!(200 <= responseCode ? responseCode < 300 : false)) {
            if (responseCode == 401 && responseBody != null) {
                Map<String, Object> errorJson;
                Map<String, Object> map = errorJson = GitlabUtilsKt.safelyParseJson(responseBody);
                if (Intrinsics.areEqual((Object)(map != null ? map.get("error") : null), (Object)"invalid_token")) {
                    String hostname = new URL(url).getHost();
                    throw new HelpException("Failed to access a remote repository on " + hostname + " due to an expired or revoked access token. You must create a new token.", readMeSection);
                }
            }
            throw new FetchException("Fetching " + resourceName + " from " + url + " failed", responseCode, responseBody);
        }
    }

    public static /* synthetic */ void handleFetchError$default(String string, Response response, String string2, String string3, int n, Object object) {
        if ((n & 8) != 0) {
            string3 = "";
        }
        GitlabUtilsKt.handleFetchError(string, response, string2, string3);
    }

    @Nullable
    public static final Map<String, Object> safelyParseJson(@NotNull String json) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        try {
            Gson gson = new Gson();
            Object object = gson.fromJson(json, Map.class);
            map = object instanceof Map ? (Map)object : null;
        }
        catch (JsonSyntaxException e) {
            map = null;
        }
        return map;
    }

    public static final boolean isLabelEvent(@NotNull JsonObject note) {
        Intrinsics.checkNotNullParameter((Object)note, (String)"note");
        return note.get("label") != null;
    }

    public static final int getTotalPages(@NotNull Response response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        String totalPages = Response.header$default((Response)response, (String)"x-total-pages", null, (int)2, null);
        Object object = totalPages;
        return object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 1;
    }

    public static final int getCurrentPage(@NotNull Map<String, ? extends Object> query) {
        Intrinsics.checkNotNullParameter(query, (String)"query");
        Object page = query.get("page");
        return page instanceof Integer ? ((Number)page).intValue() : 1;
    }

    @NotNull
    public static final String packCode(@NotNull String content2, @NotNull String lang) {
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        Intrinsics.checkNotNullParameter((Object)lang, (String)"lang");
        return "```" + lang + "\n" + content2 + "\n```\n";
    }

    public static /* synthetic */ String packCode$default(String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "";
        }
        return GitlabUtilsKt.packCode(string, string2);
    }

    private static final boolean getRag$lambda$0(String $path, Rag it) {
        return it.getKbType() == KBType.codebase && it.getPath().equals($path);
    }

    private static final boolean getRag$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final CharSequence makeMarkdownLinksAbsolute$lambda$2(String $instanceUrl, String $namespaceWithPath, MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String text = (String)it.getGroupValues().get(1);
        String relativeUrl = (String)it.getGroupValues().get(2);
        return "[" + text + "](" + $instanceUrl + "/" + $namespaceWithPath + "/" + relativeUrl + ")";
    }

    private static final CharSequence makeHtmlLinksAbsolute$lambda$3(String $instanceUrl, MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String relativeUrl = (String)it.getGroupValues().get(1);
        return "href=\"" + $instanceUrl + "/" + relativeUrl + "\"";
    }

    private static final CharSequence uriForDiscussion$lambda$4(Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getKey() + "=" + it.getValue();
    }

    private static final Unit showDiffInJetbrains$lambda$8(Project $project, ContentDiffRequest $diffRequest) {
        DiffManager.getInstance().showDiff($project, (DiffRequest)$diffRequest);
        return Unit.INSTANCE;
    }

    private static final String getMrGqlId$lambda$11(int id) {
        return "gid://gitlab/MergeRequest/" + id;
    }
}

