/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.utils;

import cn.gitlab.kilo.jetbrains.config.CockpitConfiguration;
import cn.gitlab.kilo.jetbrains.constants.ConstantsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.io.File;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\"\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0001\u001a.\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0001\u001a\u0010\u0010\t\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\n"}, d2={"getGitDiff", "", "project", "Lcom/intellij/openapi/project/Project;", "filePath1", "filePath2", "getDiffByPathAndContent", "fileContent1", "fileContent2", "getRemoteRepositoryUrl", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nGitUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitUtils.kt\ncn/gitlab/kilo/jetbrains/utils/GitUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,94:1\n1#2:95\n*E\n"})
public final class GitUtilsKt {
    @NotNull
    public static final String getGitDiff(@NotNull Project project, @Nullable String filePath1, @Nullable String filePath2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        List list = GitRepositoryManager.getInstance((Project)project).getRepositories();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getRepositories(...)");
        GitRepository gitRepository = (GitRepository)CollectionsKt.firstOrNull((List)list);
        if (gitRepository == null) {
            throw new IllegalStateException("No Git repository found in the project");
        }
        GitRepository repository = gitRepository;
        Git git = Git.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)git, (String)"getInstance(...)");
        Git git2 = git;
        GitLineHandler handler = new GitLineHandler(project, repository.getRoot(), GitCommand.DIFF);
        if (filePath1 != null) {
            object = new String[]{filePath1};
            handler.addParameters(object);
        }
        if (filePath2 != null) {
            object = new String[]{filePath2};
            handler.addParameters(object);
        }
        try {
            object = git2.runCommand(handler).getOutputOrThrow(new int[0]);
            Intrinsics.checkNotNull((Object)object);
        }
        catch (VcsException e) {
            object = "Error executing git diff: " + e.getMessage();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final String getDiffByPathAndContent(@NotNull Project project, @NotNull String filePath1, @NotNull String filePath2, @NotNull String fileContent1, @NotNull String fileContent2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)filePath1, (String)"filePath1");
        Intrinsics.checkNotNullParameter((Object)filePath2, (String)"filePath2");
        Intrinsics.checkNotNullParameter((Object)fileContent1, (String)"fileContent1");
        Intrinsics.checkNotNullParameter((Object)fileContent2, (String)"fileContent2");
        String separator = File.separator;
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Path path = Files.createTempFile(filePath1, null, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createTempFile(...)");
        Path file1 = path;
        GitLineHandler gitLineHandler = new GitLineHandler[]{};
        Path path2 = Files.createTempFile(filePath2, null, Arrays.copyOf(gitLineHandler, ((FileAttribute[])gitLineHandler).length));
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"createTempFile(...)");
        Path file2 = path2;
        try {
            PathsKt.writeText$default((Path)file1, (CharSequence)fileContent1, null, (OpenOption[])new OpenOption[0], (int)2, null);
            PathsKt.writeText$default((Path)file2, (CharSequence)fileContent2, null, (OpenOption[])new OpenOption[0], (int)2, null);
            GitLineHandler $this$getDiffByPathAndContent_u24lambda_u240 = gitLineHandler = new GitLineHandler(project, project.getBaseDir(), GitCommand.DIFF);
            boolean bl = false;
            String[] stringArray = new String[]{"--no-index"};
            $this$getDiffByPathAndContent_u24lambda_u240.addParameters(stringArray);
            stringArray = new String[]{((Object)file1.toAbsolutePath()).toString(), ((Object)file2.toAbsolutePath()).toString()};
            $this$getDiffByPathAndContent_u24lambda_u240.addParameters(stringArray);
            $this$getDiffByPathAndContent_u24lambda_u240.setStdoutSuppressed(true);
            GitLineHandler handler = gitLineHandler;
            GitCommandResult gitCommandResult = Git.getInstance().runCommand(handler);
            Intrinsics.checkNotNullExpressionValue((Object)gitCommandResult, (String)"runCommand(...)");
            GitCommandResult result2 = gitCommandResult;
            String string = result2.getOutputOrThrow(new int[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getOutputOrThrow(...)");
            String string2 = string;
            return string2;
        }
        catch (Exception e) {
            String string = "Error executing diff: " + e.getMessage();
            return string;
        }
        finally {
            Files.deleteIfExists(file1);
            Files.deleteIfExists(file2);
        }
    }

    @Nullable
    public static final String getRemoteRepositoryUrl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        try {
            GitRepositoryManager gitRepositoryManager = GitRepositoryManager.getInstance((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)gitRepositoryManager, (String)"getInstance(...)");
            GitRepositoryManager repositoryManager = gitRepositoryManager;
            List list = repositoryManager.getRepositories();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getRepositories(...)");
            List repositories = list;
            for (GitRepository repository : repositories) {
                for (GitRemote remote : repository.getRemotes()) {
                    String matchingUrl;
                    Object v4;
                    block10: {
                        Object object;
                        Object $i$a$-runCatching-GitUtilsKt$getRemoteRepositoryUrl$host$22;
                        List urls;
                        Intrinsics.checkNotNullExpressionValue((Object)remote.getUrls(), (String)"getUrls(...)");
                        if (!(!((Collection)urls).isEmpty())) continue;
                        CockpitConfiguration.PluginState state = CockpitConfiguration.Companion.getInstance().getState();
                        try {
                            boolean $i$a$-runCatching-GitUtilsKt$getRemoteRepositoryUrl$host$22 = false;
                            String string = new URI(state.getGitlabHost()).getHost();
                            if (string == null) {
                                string = state.getGitlabHost();
                            }
                            $i$a$-runCatching-GitUtilsKt$getRemoteRepositoryUrl$host$22 = Result.constructor-impl((Object)string);
                        }
                        catch (Throwable throwable) {
                            $i$a$-runCatching-GitUtilsKt$getRemoteRepositoryUrl$host$22 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                        }
                        if (Result.exceptionOrNull-impl((Object)$i$a$-runCatching-GitUtilsKt$getRemoteRepositoryUrl$host$22) == null) {
                            object = $i$a$-runCatching-GitUtilsKt$getRemoteRepositoryUrl$host$22;
                        } else {
                            boolean bl = false;
                            object = state.getGitlabHost();
                        }
                        String host = (String)object;
                        Iterable iterable = urls;
                        for (Object t : iterable) {
                            String it = (String)t;
                            boolean bl = false;
                            Intrinsics.checkNotNull((Object)it);
                            if (!StringsKt.contains((CharSequence)it, (CharSequence)host, (boolean)true)) continue;
                            v4 = t;
                            break block10;
                        }
                        v4 = null;
                    }
                    if ((matchingUrl = (String)v4) == null) continue;
                    return matchingUrl;
                }
            }
        }
        catch (Throwable e) {
            ConstantsKt.getLogger().error(e);
        }
        return null;
    }
}

