/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.utils;

import cn.gitlab.kilo.jetbrains.utils.Added;
import cn.gitlab.kilo.jetbrains.utils.Deleted;
import cn.gitlab.kilo.jetbrains.utils.DiffResult;
import com.github.difflib.algorithm.Change;
import com.github.difflib.algorithm.jgit.HistogramDiff;
import com.github.difflib.patch.AbstractDelta;
import com.github.difflib.patch.Chunk;
import com.github.difflib.patch.DeltaType;
import com.github.difflib.patch.Patch;
import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003\u001a$\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006\"\u0004\b\u0000\u0010\b*\b\u0012\u0004\u0012\u0002H\b0\tH\u0002\u001a\"\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003\u001a\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0002\u001a,\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002\u001a\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0011H\u0002\u001a\f\u0010\u0014\u001a\u00020\u0015*\u00020\u0011H\u0002\u001a\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0002\u001a\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\u00102\u0006\u0010\u0018\u001a\u00020\u0003H\u0002\u001a\"\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\r0\u001bH\u0002\u00a8\u0006\u001c"}, d2={"diffLines", "Lcn/gitlab/kilo/jetbrains/utils/DiffResult;", "oldText", "", "newText", "effectLineNumber", "Lkotlin/Pair;", "", "T", "Lcom/github/difflib/patch/Chunk;", "diffLineCounts", "patchWithJetBrain", "Lcom/github/difflib/patch/Patch;", "", "generatePatch", "fragments", "", "Lcom/intellij/diff/fragments/LineFragment;", "toChange", "Lcom/github/difflib/algorithm/Change;", "getDeltaType", "Lcom/github/difflib/patch/DeltaType;", "patch", "contentsToLines", "contents", "changeDiffCounts", "delta", "Lcom/github/difflib/patch/AbstractDelta;", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nDiffUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiffUtils.kt\ncn/gitlab/kilo/jetbrains/utils/DiffUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,239:1\n1563#2:240\n1634#2,3:241\n1563#2:244\n1634#2,3:245\n1869#2,2:248\n1869#2,2:250\n*S KotlinDebug\n*F\n+ 1 DiffUtils.kt\ncn/gitlab/kilo/jetbrains/utils/DiffUtilsKt\n*L\n112#1:240\n112#1:241,3\n122#1:244\n122#1:245,3\n186#1:248,2\n190#1:250,2\n*E\n"})
public final class DiffUtilsKt {
    @NotNull
    public static final DiffResult diffLines(@NotNull CharSequence oldText, @NotNull CharSequence newText) {
        Intrinsics.checkNotNullParameter((Object)oldText, (String)"oldText");
        Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
        Patch<String> patch = DiffUtilsKt.patchWithJetBrain(oldText, newText);
        List added = new ArrayList();
        List deleted = new ArrayList();
        List modified = new ArrayList();
        block6: for (AbstractDelta delta : patch.getDeltas()) {
            DeltaType deltaType = delta.getType();
            switch (deltaType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[deltaType.ordinal()]) {
                case 1: {
                    Chunk chunk = delta.getSource();
                    Intrinsics.checkNotNullExpressionValue((Object)chunk, (String)"getSource(...)");
                    Pair<Integer, Integer> pair = DiffUtilsKt.effectLineNumber(chunk);
                    int startLine1 = ((Number)pair.component1()).intValue();
                    int endLine1 = ((Number)pair.component2()).intValue();
                    Chunk chunk2 = delta.getTarget();
                    Intrinsics.checkNotNullExpressionValue((Object)chunk2, (String)"getTarget(...)");
                    Pair<Integer, Integer> pair2 = DiffUtilsKt.effectLineNumber(chunk2);
                    int startLine2 = ((Number)pair2.component1()).intValue();
                    int endLine2 = ((Number)pair2.component2()).intValue();
                    ((Collection)modified).add(TuplesKt.to((Object)RangesKt.until((int)startLine1, (int)endLine1), (Object)RangesKt.until((int)startLine2, (int)endLine2)));
                    continue block6;
                }
                case 2: {
                    Chunk chunk = delta.getSource();
                    Intrinsics.checkNotNullExpressionValue((Object)chunk, (String)"getSource(...)");
                    Pair<Integer, Integer> pair = DiffUtilsKt.effectLineNumber(chunk);
                    int start2 = ((Number)pair.component1()).intValue();
                    int end = ((Number)pair.component2()).intValue();
                    ((Collection)deleted).add(new Deleted(start2, end));
                    continue block6;
                }
                case 3: {
                    Chunk chunk = delta.getTarget();
                    Intrinsics.checkNotNullExpressionValue((Object)chunk, (String)"getTarget(...)");
                    Pair<Integer, Integer> pair = DiffUtilsKt.effectLineNumber(chunk);
                    int start2 = ((Number)pair.component1()).intValue();
                    int end = ((Number)pair.component2()).intValue();
                    ((Collection)added).add(new Added(start2, end));
                    continue block6;
                }
                case 4: {
                    continue block6;
                }
            }
            throw new NoWhenBranchMatchedException();
        }
        return new DiffResult(added, deleted, modified);
    }

    private static final <T> Pair<Integer, Integer> effectLineNumber(Chunk<T> $this$effectLineNumber) {
        int effectLines = $this$effectLineNumber.getLines().size();
        int end = effectLines > 0 ? $this$effectLineNumber.getPosition() + (effectLines - 1) : $this$effectLineNumber.getPosition();
        return new Pair((Object)$this$effectLineNumber.getPosition(), (Object)end);
    }

    @NotNull
    public static final Pair<Integer, Integer> diffLineCounts(@NotNull CharSequence oldText, @NotNull CharSequence newText) {
        Intrinsics.checkNotNullParameter((Object)oldText, (String)"oldText");
        Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
        if (Intrinsics.areEqual((Object)oldText, (Object)newText)) {
            return new Pair((Object)0, (Object)0);
        }
        if (oldText.length() == 0) {
            return new Pair((Object)StringsKt.lines((CharSequence)newText).size(), (Object)0);
        }
        if (newText.length() == 0) {
            return new Pair((Object)0, (Object)StringsKt.lines((CharSequence)oldText).size());
        }
        Patch<String> patch = DiffUtilsKt.patchWithJetBrain(oldText, newText);
        int added = 0;
        int deleted = 0;
        block6: for (AbstractDelta delta : patch.getDeltas()) {
            DeltaType deltaType = delta.getType();
            switch (deltaType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[deltaType.ordinal()]) {
                case 1: {
                    Pair pair = TuplesKt.to((Object)delta.getTarget().getLines().size(), (Object)delta.getSource().getLines().size());
                    int changedAdded = ((Number)pair.component1()).intValue();
                    int changedDeleted = ((Number)pair.component2()).intValue();
                    added += changedAdded;
                    deleted += changedDeleted;
                    continue block6;
                }
                case 2: {
                    deleted += delta.getSource().getLines().size();
                    continue block6;
                }
                case 3: {
                    added += delta.getTarget().getLines().size();
                    continue block6;
                }
                case 4: {
                    continue block6;
                }
            }
            throw new NoWhenBranchMatchedException();
        }
        return new Pair((Object)added, (Object)deleted);
    }

    /*
     * WARNING - void declaration
     */
    private static final Patch<String> patchWithJetBrain(CharSequence oldText, CharSequence newText) {
        void $this$mapTo$iv$iv;
        ComparisonManager comparisonManager = ComparisonManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)comparisonManager, (String)"getInstance(...)");
        ComparisonManager manager = comparisonManager;
        List list = manager.compareLinesInner(oldText, newText, ComparisonPolicy.DEFAULT, (ProgressIndicator)new EmptyProgressIndicator());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"compareLinesInner(...)");
        List fragments = list;
        List<List> rangeFragments = Collections.singletonList(fragments);
        Intrinsics.checkNotNull(rangeFragments);
        Iterable $this$map$iv = rangeFragments;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            List list2 = (List)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(manager.processBlocks((List)it, oldText, newText, ComparisonPolicy.DEFAULT, true, false));
        }
        List list3 = (List)CollectionsKt.firstOrNull((List)CollectionsKt.toList((Iterable)((List)destination$iv$iv)));
        if (list3 == null) {
            list3 = fragments;
        }
        List blockFragments = list3;
        return DiffUtilsKt.generatePatch(oldText, newText, blockFragments);
    }

    /*
     * WARNING - void declaration
     */
    private static final Patch<String> generatePatch(CharSequence oldText, CharSequence newText, List<? extends LineFragment> fragments) {
        void $this$mapTo$iv$iv;
        Pair pair = TuplesKt.to(DiffUtilsKt.contentsToLines(oldText), DiffUtilsKt.contentsToLines(newText));
        List oldLines = (List)pair.component1();
        List newLines = (List)pair.component2();
        Iterable $this$map$iv = fragments;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LineFragment lineFragment = (LineFragment)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(DiffUtilsKt.toChange((LineFragment)it));
        }
        List changes = (List)destination$iv$iv;
        Patch patch = Patch.generate((List)oldLines, (List)newLines, (List)changes);
        Intrinsics.checkNotNullExpressionValue((Object)patch, (String)"generate(...)");
        Patch patch2 = patch;
        return patch2;
    }

    private static final Change toChange(LineFragment $this$toChange) {
        return new Change(DiffUtilsKt.getDeltaType($this$toChange), $this$toChange.getStartLine1(), $this$toChange.getEndLine1(), $this$toChange.getStartLine2(), $this$toChange.getEndLine2());
    }

    private static final DeltaType getDeltaType(LineFragment $this$getDeltaType) {
        TextDiffType textDiffType = DiffUtil.getLineDiffType((LineFragment)$this$getDeltaType);
        return Intrinsics.areEqual((Object)textDiffType, (Object)TextDiffType.MODIFIED) ? DeltaType.CHANGE : (Intrinsics.areEqual((Object)textDiffType, (Object)TextDiffType.INSERTED) ? DeltaType.INSERT : (Intrinsics.areEqual((Object)textDiffType, (Object)TextDiffType.DELETED) ? DeltaType.DELETE : DeltaType.EQUAL));
    }

    private static final Patch<String> patch(CharSequence oldText, CharSequence newText) {
        List<String> oldLinesList = DiffUtilsKt.contentsToLines(oldText);
        List<String> newLinesList = DiffUtilsKt.contentsToLines(newText);
        Patch patch = Patch.generate(oldLinesList, newLinesList, (List)new HistogramDiff().computeDiff(oldLinesList, newLinesList, null));
        Intrinsics.checkNotNullExpressionValue((Object)patch, (String)"generate(...)");
        Patch patch2 = patch;
        return patch2;
    }

    private static final List<String> contentsToLines(CharSequence contents) {
        List lines = new ArrayList();
        for (String character : StringsKt.lines((CharSequence)contents)) {
            lines.add(character);
        }
        return lines;
    }

    private static final Pair<Integer, Integer> changeDiffCounts(AbstractDelta<String> delta) {
        List oldLines = delta.getSource().getLines();
        List newLines = delta.getTarget().getLines();
        Pair pair = oldLines.size() < newLines.size() ? new Pair((Object)oldLines, (Object)newLines) : new Pair((Object)newLines, (Object)oldLines);
        List lessLines = (List)pair.component1();
        List greaterLines = (List)pair.component2();
        Map counts = new LinkedHashMap();
        Intrinsics.checkNotNull((Object)lessLines);
        Iterable $this$forEach$iv = lessLines;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            Integer n = (Integer)counts.get(it);
            counts.put(it, (n != null ? n : 0) + 1);
        }
        int count = 0;
        Intrinsics.checkNotNull((Object)greaterLines);
        Iterable $this$forEach$iv2 = greaterLines;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            String it = (String)element$iv;
            boolean bl = false;
            String text = it;
            Integer n = (Integer)counts.get(text);
            if ((n != null ? n : 0) <= 0) continue;
            ++count;
            Intrinsics.checkNotNull((Object)text);
            Integer n2 = (Integer)counts.get(text);
            counts.put(text, (n2 != null ? n2 : 0) - 1);
        }
        int added = newLines.size() - count;
        int deleted = oldLines.size() - count;
        return new Pair((Object)added, (Object)deleted);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DeltaType.values().length];
            try {
                nArray[DeltaType.CHANGE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeltaType.DELETE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeltaType.INSERT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeltaType.EQUAL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

