/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.terminal;

import cn.gitlab.kilo.jetbrains.common.I18nKt;
import cn.gitlab.kilo.jetbrains.composer.ComposerProvider;
import cn.gitlab.kilo.jetbrains.services.CockpitChatWindow;
import cn.gitlab.kilo.jetbrains.toolWindow.CockpitToolWindowFactoryKt;
import cn.gitlab.kilo.jetbrains.utils.ThemeUtilKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.ProjectActivity;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.terminal.JBTerminalPanel;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.terminal.ui.TerminalWidget;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.jcef.JBCefBrowser;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.TerminalToolWindowManager;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 )2\u00020\u00012\u00020\u00022\u00020\u0003:\u0002)*B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0096@\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001a\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\f\u0010\u0017\u001a\u00020\u0018*\u00020\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u0019H\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010 \u001a\u00020\u00182\u0006\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u0019H\u0002J\u001a\u0010#\u001a\u00020\u00182\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020%H\u0002J \u0010'\u001a\u00020\n2\u0006\u0010!\u001a\u00020\u001d2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u0019H\u0002J\b\u0010(\u001a\u00020\nH\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcn/gitlab/kilo/jetbrains/terminal/TerminalContextMenuStartupActivity;", "Lcom/intellij/openapi/startup/ProjectActivity;", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "awtListeners", "", "Ljava/awt/event/AWTEventListener;", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "setupTerminalContextMenus", "setupDynamicMenuListenersWithRetry", "attempt", "", "registerTerminalActions", "setupDynamicMenuListeners", "addListenerToTerminalContent", "content", "Lcom/intellij/ui/content/Content;", "hasContextMenuListener", "", "Lcom/intellij/terminal/JBTerminalWidget;", "addPopupMenuListener", "widget", "findJPopupMenuInContainer", "Ljavax/swing/JPopupMenu;", "container", "Ljava/awt/Container;", "isPopupFromTerminal", "popupMenu", "terminalWidget", "isComponentInHierarchy", "child", "Ljava/awt/Component;", "parent", "addToClassicTerminalMenu", "dispose", "Companion", "TerminalAddToContextAction", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nTerminalContextMenuStartupActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalContextMenuStartupActivity.kt\ncn/gitlab/kilo/jetbrains/terminal/TerminalContextMenuStartupActivity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,237:1\n1617#2,9:238\n1869#2:247\n1870#2:249\n1626#2:250\n1869#2,2:251\n1869#2,2:258\n1#3:248\n1#3:253\n12637#4,2:254\n1321#5,2:256\n*S KotlinDebug\n*F\n+ 1 TerminalContextMenuStartupActivity.kt\ncn/gitlab/kilo/jetbrains/terminal/TerminalContextMenuStartupActivity\n*L\n71#1:238,9\n71#1:247\n71#1:249\n71#1:250\n72#1:251,2\n227#1:258,2\n71#1:248\n153#1:254,2\n169#1:256,2\n*E\n"})
public final class TerminalContextMenuStartupActivity
implements ProjectActivity,
Disposable,
DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<AWTEventListener> awtListeners = new LinkedHashSet();

    @Nullable
    public Object execute(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
        ApplicationManager.getApplication().invokeLater(() -> TerminalContextMenuStartupActivity.execute$lambda$0(this, project));
        return Unit.INSTANCE;
    }

    private final void setupTerminalContextMenus(Project project) {
        this.registerTerminalActions(project);
        TerminalContextMenuStartupActivity.setupDynamicMenuListenersWithRetry$default(this, project, 0, 2, null);
    }

    private final void setupDynamicMenuListenersWithRetry(Project project, int attempt) {
        TerminalToolWindowManager terminalManager = TerminalToolWindowManager.getInstance((Project)project);
        if (terminalManager.getToolWindow() == null && attempt < 5) {
            Timer timer;
            int delay = 1000 * (attempt + 1);
            Timer $this$setupDynamicMenuListenersWithRetry_u24lambda_u242 = timer = new Timer(delay, arg_0 -> TerminalContextMenuStartupActivity.setupDynamicMenuListenersWithRetry$lambda$1(this, project, attempt, arg_0));
            boolean bl = false;
            $this$setupDynamicMenuListenersWithRetry_u24lambda_u242.setRepeats(false);
            $this$setupDynamicMenuListenersWithRetry_u24lambda_u242.start();
            return;
        }
        this.setupDynamicMenuListeners(project);
    }

    static /* synthetic */ void setupDynamicMenuListenersWithRetry$default(TerminalContextMenuStartupActivity terminalContextMenuStartupActivity, Project project, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        terminalContextMenuStartupActivity.setupDynamicMenuListenersWithRetry(project, n);
    }

    /*
     * WARNING - void declaration
     */
    private final void registerTerminalActions(Project project) {
        String actionId;
        ActionManager actionManager = ActionManager.getInstance();
        if (actionManager.getAction(actionId = "coderider.terminal.addToContext") == null) {
            void $this$forEach$iv;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            TerminalAddToContextAction action = new TerminalAddToContextAction(project);
            actionManager.registerAction(actionId, (AnAction)action);
            Object object = new String[]{"Terminal.OutputContextMenu", "Terminal.ReworkedTerminalContextMenu"};
            object = CollectionsKt.listOf((Object[])object);
            boolean $i$f$mapNotNull = false;
            Iterator iterator = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                DefaultActionGroup it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                AnAction anAction = actionManager.getAction(it);
                if ((anAction instanceof DefaultActionGroup ? (DefaultActionGroup)anAction : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                DefaultActionGroup group = (DefaultActionGroup)element$iv;
                boolean bl = false;
                group.addSeparator();
                group.add((AnAction)action);
            }
        }
    }

    private final void setupDynamicMenuListeners(Project project) {
        TerminalToolWindowManager terminalManager = TerminalToolWindowManager.getInstance((Project)project);
        ToolWindow toolWindow = terminalManager.getToolWindow();
        if (toolWindow == null || (toolWindow = toolWindow.getContentManager()) == null) {
            return;
        }
        ToolWindow contentManager = toolWindow;
        int n = contentManager.getContentCount();
        for (int i = 0; i < n; ++i) {
            Content it;
            int i2 = i;
            boolean bl = false;
            if (contentManager.getContent(i2) == null) continue;
            boolean bl2 = false;
            this.addListenerToTerminalContent(project, it);
        }
        contentManager.addContentManagerListener(new ContentManagerListener(this, project){
            final /* synthetic */ TerminalContextMenuStartupActivity this$0;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$project = $project;
            }

            public void contentAdded(ContentManagerEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Content content2 = event.getContent();
                Intrinsics.checkNotNullExpressionValue((Object)content2, (String)"getContent(...)");
                TerminalContextMenuStartupActivity.access$addListenerToTerminalContent(this.this$0, this.$project, content2);
            }
        });
    }

    private final void addListenerToTerminalContent(Project project, Content content2) {
        block1: {
            JBTerminalWidget widget2;
            TerminalWidget terminalWidget = TerminalToolWindowManager.findWidgetByContent((Content)content2);
            JComponent jComponent = terminalWidget != null ? terminalWidget.getComponent() : null;
            JBTerminalWidget jBTerminalWidget = widget2 = jComponent instanceof JBTerminalWidget ? (JBTerminalWidget)jComponent : null;
            if (jBTerminalWidget != null ? this.hasContextMenuListener(jBTerminalWidget) : false) break block1;
            JBTerminalWidget jBTerminalWidget2 = widget2;
            if (jBTerminalWidget2 != null) {
                JBTerminalWidget it = jBTerminalWidget2;
                boolean bl = false;
                this.addPopupMenuListener(project, it);
            }
        }
    }

    private final boolean hasContextMenuListener(JBTerminalWidget $this$hasContextMenuListener) {
        return Intrinsics.areEqual((Object)$this$hasContextMenuListener.getClientProperty((Object)"coderider.contextmenu.added"), (Object)true);
    }

    private final void addPopupMenuListener(Project project, JBTerminalWidget widget2) {
        AWTEventListener eventListener = arg_0 -> TerminalContextMenuStartupActivity.addPopupMenuListener$lambda$11(this, widget2, project, arg_0);
        Toolkit.getDefaultToolkit().addAWTEventListener(eventListener, 1L);
        this.awtListeners.add(eventListener);
        widget2.putClientProperty((Object)"coderider.contextmenu.added", (Object)true);
        widget2.putClientProperty((Object)"coderider.awt.listener", (Object)eventListener);
    }

    private final JPopupMenu findJPopupMenuInContainer(Container container) {
        JPopupMenu jPopupMenu;
        block2: {
            Component[] componentArray = container.getComponents();
            Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
            Object[] objectArray = componentArray;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Component component = (Component)objectArray[i];
                boolean bl = false;
                Component component2 = component;
                JPopupMenu jPopupMenu2 = component2 instanceof JPopupMenu ? (JPopupMenu)component : (component2 instanceof Container ? this.findJPopupMenuInContainer((Container)component) : null);
                jPopupMenu = jPopupMenu2;
                if (jPopupMenu2 == null) {
                    continue;
                }
                break block2;
            }
            jPopupMenu = null;
        }
        return jPopupMenu;
    }

    private final boolean isPopupFromTerminal(JPopupMenu popupMenu, JBTerminalWidget terminalWidget) {
        boolean bl;
        Component component = popupMenu.getInvoker();
        if (component != null) {
            Component it = component;
            boolean bl2 = false;
            bl = it instanceof JBTerminalPanel || this.isComponentInHierarchy(it, (Component)terminalWidget);
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean isComponentInHierarchy(Component child, Component parent) {
        for (Component current = child; current != null; current = (Component)current.getParent()) {
            if (!Intrinsics.areEqual((Object)current, (Object)parent)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final void addToClassicTerminalMenu(JPopupMenu popupMenu, Project project, JBTerminalWidget widget2) {
        block6: {
            void $this$forEach$iv;
            boolean bl;
            String selectedText;
            block5: {
                String string = widget2.getSelectedText();
                if (string == null) {
                    return;
                }
                selectedText = string;
                Component[] componentArray = popupMenu.getComponents();
                Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
                Object[] $this$any$iv = componentArray;
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    Component it = (Component)element$iv;
                    boolean bl2 = false;
                    Object object = it instanceof JMenuItem ? (JMenuItem)it : null;
                    boolean bl3 = object != null && (object = ((AbstractButton)object).getText()) != null ? StringsKt.contains$default((CharSequence)((CharSequence)object), (CharSequence)"CodeRider-Kilo", (boolean)false, (int)2, null) : false;
                    if (!bl3) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
            if (bl) {
                return;
            }
            JMenuItem menuItem = new JMenuItem("CodeRider-Kilo - " + I18nKt.getMessage("terminal.add.to.context"));
            menuItem.setIcon(null);
            menuItem.setBorder(null);
            menuItem.addActionListener(arg_0 -> TerminalContextMenuStartupActivity.addToClassicTerminalMenu$lambda$15(selectedText, project, popupMenu, arg_0));
            popupMenu.insert(menuItem, 0);
            popupMenu.insert(new JPopupMenu.Separator(), 1);
            Sequence $i$f$any = SequencesKt.generateSequence((Object)popupMenu, TerminalContextMenuStartupActivity::addToClassicTerminalMenu$lambda$16);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Component component = (Component)element$iv;
                boolean bl4 = false;
                component.invalidate();
                if (component instanceof Container) {
                    ((Container)component).doLayout();
                }
                component.revalidate();
                component.repaint();
            }
            Window window = SwingUtilities.getWindowAncestor(popupMenu);
            if (window == null) break block6;
            window.pack();
        }
    }

    public void dispose() {
        Iterable $this$forEach$iv = this.awtListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AWTEventListener listener2 = (AWTEventListener)element$iv;
            boolean bl = false;
            try {
                Toolkit.getDefaultToolkit().removeAWTEventListener(listener2);
            }
            catch (Exception exception) {
            }
        }
        this.awtListeners.clear();
    }

    private static final void execute$lambda$0(TerminalContextMenuStartupActivity this$0, Project $project) {
        this$0.setupTerminalContextMenus($project);
    }

    private static final void setupDynamicMenuListenersWithRetry$lambda$1(TerminalContextMenuStartupActivity this$0, Project $project, int $attempt, ActionEvent it) {
        this$0.setupDynamicMenuListenersWithRetry($project, $attempt + 1);
    }

    private static final void addPopupMenuListener$lambda$11$lambda$10(TerminalContextMenuStartupActivity this$0, AWTEvent $event, JBTerminalWidget $widget, Project $project) {
        block1: {
            CharSequence charSequence;
            JPopupMenu jPopupMenu;
            JPopupMenu jPopupMenu2;
            Component component = ((ComponentEvent)$event).getComponent();
            Intrinsics.checkNotNull((Object)component, (String)"null cannot be cast to non-null type java.awt.Container");
            JPopupMenu jPopupMenu3 = this$0.findJPopupMenuInContainer((Container)component);
            if (jPopupMenu3 == null) break block1;
            JPopupMenu popup = jPopupMenu2 = jPopupMenu3;
            boolean bl = false;
            JPopupMenu jPopupMenu4 = jPopupMenu = popup.isShowing() && !((charSequence = (CharSequence)$widget.getSelectedText()) == null || charSequence.length() == 0) && this$0.isPopupFromTerminal(popup, $widget) ? jPopupMenu2 : null;
            if (jPopupMenu != null) {
                JPopupMenu it = jPopupMenu;
                boolean bl2 = false;
                this$0.addToClassicTerminalMenu(it, $project, $widget);
            }
        }
    }

    private static final void addPopupMenuListener$lambda$11(TerminalContextMenuStartupActivity this$0, JBTerminalWidget $widget, Project $project, AWTEvent event) {
        if (event instanceof ComponentEvent && ((ComponentEvent)event).getID() == 102 && Intrinsics.areEqual((Object)((ComponentEvent)event).getComponent().getClass().getSimpleName(), (Object)"HeavyWeightWindow")) {
            SwingUtilities.invokeLater(() -> TerminalContextMenuStartupActivity.addPopupMenuListener$lambda$11$lambda$10(this$0, event, $widget, $project));
        }
    }

    private static final void addToClassicTerminalMenu$lambda$15(String $selectedText, Project $project, JPopupMenu $popupMenu, ActionEvent it) {
        Companion.addTerminalOutputToChat($selectedText, $project);
        $popupMenu.setVisible(false);
    }

    private static final Component addToClassicTerminalMenu$lambda$16(Component it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getParent();
    }

    public static final /* synthetic */ void access$addListenerToTerminalContent(TerminalContextMenuStartupActivity $this, Project project, Content content2) {
        $this.addListenerToTerminalContent(project, content2);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcn/gitlab/kilo/jetbrains/terminal/TerminalContextMenuStartupActivity$Companion;", "", "<init>", "()V", "addTerminalOutputToChat", "", "selectedText", "", "project", "Lcom/intellij/openapi/project/Project;", "coderider-kilo-jetbrains"})
    @SourceDebugExtension(value={"SMAP\nTerminalContextMenuStartupActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalContextMenuStartupActivity.kt\ncn/gitlab/kilo/jetbrains/terminal/TerminalContextMenuStartupActivity$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,237:1\n31#2,2:238\n1#3:240\n*S KotlinDebug\n*F\n+ 1 TerminalContextMenuStartupActivity.kt\ncn/gitlab/kilo/jetbrains/terminal/TerminalContextMenuStartupActivity$Companion\n*L\n191#1:238,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void addTerminalOutputToChat(@NotNull String selectedText, @NotNull Project project) {
            block3: {
                Map message;
                String formattedContent;
                block2: {
                    Intrinsics.checkNotNullParameter((Object)selectedText, (String)"selectedText");
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(project);
                    ToolWindow toolWindow = toolWindowManager.getToolWindow("CodeRider-Kilo");
                    if (toolWindow != null) {
                        toolWindow.show();
                    }
                    formattedContent = "Terminal Output:\n```\n" + selectedText + "\n```\n";
                    Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"type", (Object)"setTerminalContent"), TuplesKt.to((Object)"append", (Object)true)};
                    message = MapsKt.mutableMapOf((Pair[])pairArray);
                    ComponentManager $this$service$iv = (ComponentManager)project;
                    boolean $i$f$service = false;
                    Class<ComposerProvider> serviceClass$iv = ComposerProvider.class;
                    Object object = $this$service$iv.getService(serviceClass$iv);
                    if (object == null) {
                        throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                    }
                    ComposerProvider composerProvider = (ComposerProvider)object;
                    if (!composerProvider.isActive()) break block2;
                    message.put("content", formattedContent);
                    String string = composerProvider.getTaskId();
                    if (string == null) break block3;
                    String it = string;
                    boolean bl = false;
                    composerProvider.postMessageToWebview(message, it);
                    break block3;
                }
                message.put("content", formattedContent);
                CockpitChatWindow cockpitChatWindow = CockpitToolWindowFactoryKt.getCockpitChatWindow(project);
                if (cockpitChatWindow == null || (cockpitChatWindow = cockpitChatWindow.getWebView()) == null) break block3;
                CockpitChatWindow it = cockpitChatWindow;
                boolean bl = false;
                ThemeUtilKt.sendToWebview((Map<String, ? extends Object>)message, (JBCefBrowser)it);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcn/gitlab/kilo/jetbrains/terminal/TerminalContextMenuStartupActivity$TerminalAddToContextAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "getSelectedTerminalText", "", "coderider-kilo-jetbrains"})
    @SourceDebugExtension(value={"SMAP\nTerminalContextMenuStartupActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalContextMenuStartupActivity.kt\ncn/gitlab/kilo/jetbrains/terminal/TerminalContextMenuStartupActivity$TerminalAddToContextAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,237:1\n1#2:238\n*E\n"})
    private static final class TerminalAddToContextAction
    extends AnAction
    implements DumbAware {
        @NotNull
        private final Project project;

        public TerminalAddToContextAction(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            super("CodeRider-Kilo - " + I18nKt.getMessage("terminal.add.to.context"));
            this.project = project;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                String string = this.getSelectedTerminalText(e);
                if (string == null) break block0;
                String selectedText = string;
                boolean bl = false;
                Companion.addTerminalOutputToChat(selectedText, this.project);
            }
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            CharSequence charSequence = this.getSelectedTerminalText(e);
            e.getPresentation().setEnabledAndVisible(!(charSequence == null || charSequence.length() == 0));
        }

        private final String getSelectedTerminalText(AnActionEvent e) {
            Object object;
            try {
                Object object2;
                block8: {
                    Object object3;
                    block7: {
                        Object object4;
                        object2 = (JBTerminalWidget)e.getDataContext().getData(JBTerminalWidget.TERMINAL_DATA_KEY);
                        if (object2 == null || (object2 = object2.getSelectedText()) == null) break block7;
                        Object it = object4 = object2;
                        boolean bl = false;
                        object2 = ((CharSequence)it).length() > 0 ? object4 : null;
                        if (object2 != null) break block8;
                    }
                    if ((object3 = (Editor)e.getData(CommonDataKeys.EDITOR)) != null && (object3 = object3.getSelectionModel()) != null && (object3 = object3.getSelectedText()) != null) {
                        Object object5;
                        Object it = object5 = object3;
                        boolean bl = false;
                        object2 = ((CharSequence)it).length() > 0 ? object5 : null;
                    } else {
                        object2 = null;
                    }
                }
                object = object2;
            }
            catch (Exception exception) {
                object = null;
            }
            return object;
        }
    }
}

