/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.services.context;

import cn.gitlab.kilo.jetbrains.services.context.CachedRetriever;
import cn.gitlab.kilo.jetbrains.services.context.ContextRetrieverOptions;
import cn.gitlab.kilo.jetbrains.services.context.ContextSnippet;
import cn.gitlab.kilo.jetbrains.services.context.FileIndexer;
import cn.gitlab.kilo.jetbrains.services.context.LanguageUtilsKt;
import cn.gitlab.kilo.jetbrains.services.context.LineEdit;
import cn.gitlab.kilo.jetbrains.services.context.RecentEditRetrieverOptions;
import cn.gitlab.kilo.jetbrains.services.context.TrackedFile;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\n\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u000fH\u0002J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u0007H\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00072\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\u0007H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcn/gitlab/kilo/jetbrains/services/context/RecentEditsRetriever;", "Lcn/gitlab/kilo/jetbrains/services/context/CachedRetriever;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "identifier", "", "getIdentifier", "()Ljava/lang/String;", "options", "Lcn/gitlab/kilo/jetbrains/services/context/RecentEditRetrieverOptions;", "fileIndexer", "Lcn/gitlab/kilo/jetbrains/services/context/FileIndexer;", "maxAgeMs", "", "doRetrieval", "", "Lcn/gitlab/kilo/jetbrains/services/context/ContextSnippet;", "Lcn/gitlab/kilo/jetbrains/services/context/ContextRetrieverOptions;", "generateLineDiff", "lineEdit", "Lcn/gitlab/kilo/jetbrains/services/context/LineEdit;", "calculateScore", "", "diff", "timeSinceActionMs", "shouldUseAsContext", "", "currentLanguage", "targetLanguage", "getDocumentPath", "document", "Lcom/intellij/openapi/editor/Document;", "isSupportedForLanguageId", "languageId", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nRecentEditsRetriever.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecentEditsRetriever.kt\ncn/gitlab/kilo/jetbrains/services/context/RecentEditsRetriever\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,131:1\n31#2,2:132\n1869#3:134\n1869#3,2:135\n1870#3:137\n1068#3:138\n1788#3,4:139\n*S KotlinDebug\n*F\n+ 1 RecentEditsRetriever.kt\ncn/gitlab/kilo/jetbrains/services/context/RecentEditsRetriever\n*L\n22#1:132,2\n32#1:134\n40#1:135,2\n32#1:137\n61#1:138\n105#1:139,4\n*E\n"})
public final class RecentEditsRetriever
extends CachedRetriever {
    @NotNull
    private final String identifier;
    @NotNull
    private final RecentEditRetrieverOptions options;
    @NotNull
    private final FileIndexer fileIndexer;
    private final long maxAgeMs;

    public RecentEditsRetriever(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.identifier = "RecentEditRetriever";
        this.options = new RecentEditRetrieverOptions(0L, 0, 0, 7, null);
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<FileIndexer> serviceClass$iv = FileIndexer.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.fileIndexer = (FileIndexer)object;
        this.maxAgeMs = this.options.getMaxAgeMs();
    }

    @Override
    @NotNull
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    @NotNull
    public List<ContextSnippet> doRetrieval(@NotNull ContextRetrieverOptions options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        long currentTime = System.currentTimeMillis();
        List matches = new ArrayList();
        String currentFilePath = this.getDocumentPath(options.getDocument());
        String currentLanguage = LanguageUtilsKt.getLanguageFromDocument(options.getDocument());
        Collection<TrackedFile> collection = this.fileIndexer.getTrackedFiles().values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TrackedFile trackedFile = (TrackedFile)element$iv;
            boolean bl = false;
            if (trackedFile.getEdits().isEmpty() || Intrinsics.areEqual((Object)trackedFile.getPath(), (Object)currentFilePath) || currentLanguage != null && !this.shouldUseAsContext(currentLanguage, trackedFile.getLanguage())) continue;
            Iterable $this$forEach$iv2 = trackedFile.getEdits();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String diff;
                LineEdit lineEdit = (LineEdit)element$iv2;
                boolean bl2 = false;
                long timeSinceEdit = currentTime - lineEdit.getTimestamp();
                if (timeSinceEdit >= this.maxAgeMs || !(!StringsKt.isBlank((CharSequence)(diff = this.generateLineDiff(lineEdit))))) continue;
                double score = this.calculateScore(diff, timeSinceEdit);
                matches.add(new ContextSnippet(trackedFile.getPath(), lineEdit.getStartLine(), lineEdit.getEndLine(), diff, score, null, null, 96, null));
            }
        }
        Iterable $this$sortedByDescending$iv = matches;
        boolean $i$f$sortedByDescending = false;
        return CollectionsKt.take((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ContextSnippet it = (ContextSnippet)b;
                boolean bl = false;
                Comparable comparable = Double.valueOf(it.getScore());
                it = (ContextSnippet)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(it.getScore()));
            }
        }), (int)20);
    }

    private final String generateLineDiff(LineEdit lineEdit) {
        List diffLines = new ArrayList();
        diffLines.add("@@ -" + (lineEdit.getStartLine() + 1) + "," + lineEdit.getBeforeLines().size() + " +" + (lineEdit.getStartLine() + 1) + "," + lineEdit.getAfterLines().size() + " @@");
        int maxLines = Math.max(lineEdit.getBeforeLines().size(), lineEdit.getAfterLines().size());
        for (int i = 0; i < maxLines; ++i) {
            String beforeLine = (String)CollectionsKt.getOrNull(lineEdit.getBeforeLines(), (int)i);
            String afterLine = (String)CollectionsKt.getOrNull(lineEdit.getAfterLines(), (int)i);
            if (beforeLine != null && afterLine != null) {
                if (!Intrinsics.areEqual((Object)beforeLine, (Object)afterLine)) {
                    if (!StringsKt.isBlank((CharSequence)beforeLine)) {
                        diffLines.add("-" + beforeLine);
                    }
                    if (!(!StringsKt.isBlank((CharSequence)afterLine))) continue;
                    diffLines.add("+" + afterLine);
                    continue;
                }
                if (!(!StringsKt.isBlank((CharSequence)beforeLine))) continue;
                diffLines.add(" " + beforeLine);
                continue;
            }
            if (beforeLine != null) {
                if (!(!StringsKt.isBlank((CharSequence)beforeLine))) continue;
                diffLines.add("-" + beforeLine);
                continue;
            }
            if (afterLine == null || !(!StringsKt.isBlank((CharSequence)afterLine))) continue;
            diffLines.add("+" + afterLine);
        }
        return CollectionsKt.joinToString$default((Iterable)diffLines, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    private final double calculateScore(String diff, long timeSinceActionMs) {
        int n;
        double timeScore = Math.max(0.0, 1.0 - (double)timeSinceActionMs / (double)this.options.getMaxAgeMs());
        double d = 1.0;
        Iterable $this$count$iv = StringsKt.lines((CharSequence)diff);
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (!(StringsKt.startsWith$default((String)it, (String)"+", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)it, (String)"-", (boolean)false, (int)2, null)) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        double d2 = (double)n / 10.0;
        double contentScore = Math.min(d, d2);
        return timeScore * 0.7 + contentScore * 0.3;
    }

    private final boolean shouldUseAsContext(String currentLanguage, String targetLanguage) {
        if (Intrinsics.areEqual((Object)currentLanguage, (Object)targetLanguage)) {
            return true;
        }
        Object[] objectArray = new String[]{"html", "css", "javascript", "typescript", "jsx", "tsx"};
        Set webLanguages = SetsKt.setOf((Object[])objectArray);
        Object[] objectArray2 = new String[]{"java", "kotlin", "groovy"};
        Set jvmLanguages = SetsKt.setOf((Object[])objectArray2);
        return webLanguages.contains(currentLanguage) && webLanguages.contains(targetLanguage) ? true : jvmLanguages.contains(currentLanguage) && jvmLanguages.contains(targetLanguage);
    }

    private final String getDocumentPath(Document document) {
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        return virtualFile != null ? virtualFile.getPath() : null;
    }

    @Override
    public boolean isSupportedForLanguageId(@NotNull String languageId) {
        Intrinsics.checkNotNullParameter((Object)languageId, (String)"languageId");
        return true;
    }
}

