/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.services.context;

import cn.gitlab.kilo.jetbrains.common.Range;
import cn.gitlab.kilo.jetbrains.services.context.DocumentContext;
import cn.gitlab.kilo.jetbrains.services.context.JaccardMatch;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000j\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u001a,\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000b2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003\u001a\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0003\u001a\u001e\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001j\u0002`\u00192\u0006\u0010\u001a\u001a\u00020\u0002\u001a\u001a\u0010\u001b\u001a\u00020\u00032\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u001d\u001a6\u0010\u001e\u001a\u00020\u00032\u0016\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001j\u0002`\u00192\u0016\u0010 \u001a\u0012\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001j\u0002`\u0019\u001ar\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\"2\u0016\u0010#\u001a\u0012\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001j\u0002`\u00192\u0016\u0010$\u001a\u0012\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001j\u0002`\u00192\u0016\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001j\u0002`\u00192\u0016\u0010%\u001a\u0012\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001j\u0002`\u0019\u001a\u000e\u0010&\u001a\u00020\u00022\u0006\u0010'\u001a\u00020\u0002\u001a\u000e\u0010(\u001a\u00020\u00022\u0006\u0010'\u001a\u00020\u0002\u001a\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b2\u0006\u0010'\u001a\u00020\u0002\u001a\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b2\u0006\u0010'\u001a\u00020\u0002\u001a\u0014\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b2\u0006\u0010,\u001a\u00020\u0002\u001a\u0010\u0010-\u001a\u0004\u0018\u00010\u00022\u0006\u0010.\u001a\u00020/\u001a\u0010\u00100\u001a\u0004\u0018\u00010\u00022\u0006\u0010.\u001a\u00020/\u001a\u001e\u00101\u001a\u00020\u00022\u0006\u0010.\u001a\u00020/2\u0006\u00102\u001a\u00020\u00032\u0006\u00103\u001a\u00020\u0003\u001a\u0016\u00104\u001a\u00020\u00022\u0006\u0010,\u001a\u00020\u00022\u0006\u00105\u001a\u00020\u0003\u001a\u0016\u00106\u001a\u0002072\u0006\u0010.\u001a\u00020/2\u0006\u00108\u001a\u000209\u001a>\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\u00022\u0012\u0010=\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\"2\u0006\u0010>\u001a\u00020\u00022\u0012\u0010?\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\"\"\u000e\u0010\u0004\u001a\u00020\u0003X\u0086T\u00a2\u0006\u0002\n\u0000\"-\u0010\u0005\u001a\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0006j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\"9\u0010\n\u001a*\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000b0\u0006j\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000b`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t*\"\u0010\u0000\"\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001\u00a8\u0006@"}, d2={"WordOccurrences", "", "", "", "MAX_STEM_CACHE_SIZE", "stemmerCache", "Ljava/util/LinkedHashMap;", "Lkotlin/collections/LinkedHashMap;", "getStemmerCache", "()Ljava/util/LinkedHashMap;", "breakCamelAndSnakeCaseCache", "", "getBreakCamelAndSnakeCaseCache", "bestJaccardMatches", "Lcn/gitlab/kilo/jetbrains/services/context/JaccardMatch;", "targetText", "matchText", "windowSize", "maxMatches", "jaccardSimilarity", "", "left", "right", "intersection", "getWordOccurrences", "Lcn/gitlab/kilo/jetbrains/services/context/WordOccurrences;", "s", "sumWordCounts", "words", "", "subtract", "minuend", "subtrahend", "add", "Lkotlin/Pair;", "target", "window", "newLine", "stemWithCache", "word", "stem", "breakCamelAndSnakeCase", "breakCamelAndSnakeCaseWithCache", "tokenizeAndSplit", "text", "getFilePathFromDocument", "document", "Lcom/intellij/openapi/editor/Document;", "getFileNameFromDocument", "getText", "startOffset", "endOffset", "lastNLines", "n", "getContextRange", "Lcn/gitlab/kilo/jetbrains/common/Range;", "context", "Lcn/gitlab/kilo/jetbrains/services/context/DocumentContext;", "startOrEndOverlapsLineRange", "", "uriA", "lineRangeA", "uriB", "lineRangeB", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nJaccardSimilarityRetriever.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JaccardSimilarityRetriever.kt\ncn/gitlab/kilo/jetbrains/services/context/JaccardSimilarityRetrieverKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,362:1\n1#2:363\n1563#3:364\n1634#3,3:365\n1021#3,2:368\n774#3:370\n865#3,2:371\n1374#3:387\n1460#3,5:388\n382#4,7:373\n382#4,7:380\n*S KotlinDebug\n*F\n+ 1 JaccardSimilarityRetriever.kt\ncn/gitlab/kilo/jetbrains/services/context/JaccardSimilarityRetrieverKt\n*L\n107#1:364\n107#1:365,3\n166#1:368,2\n207#1:370\n207#1:371,2\n308#1:387\n308#1:388,5\n266#1:373,7\n298#1:380,7\n*E\n"})
public final class JaccardSimilarityRetrieverKt {
    public static final int MAX_STEM_CACHE_SIZE = 30000;
    @NotNull
    private static final LinkedHashMap<String, String> stemmerCache = new LinkedHashMap<String, String>(){

        protected boolean removeEldestEntry(Map.Entry<String, String> eldest) {
            Intrinsics.checkNotNullParameter(eldest, (String)"eldest");
            return this.size() > 30000;
        }
    };
    @NotNull
    private static final LinkedHashMap<String, List<String>> breakCamelAndSnakeCaseCache = new LinkedHashMap<String, List<? extends String>>(){

        protected boolean removeEldestEntry(Map.Entry<String, ? extends List<String>> eldest) {
            Intrinsics.checkNotNullParameter(eldest, (String)"eldest");
            return this.size() > 30000;
        }
    };

    @NotNull
    public static final LinkedHashMap<String, String> getStemmerCache() {
        return stemmerCache;
    }

    @NotNull
    public static final LinkedHashMap<String, List<String>> getBreakCamelAndSnakeCaseCache() {
        return breakCamelAndSnakeCaseCache;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<JaccardMatch> bestJaccardMatches(@NotNull String targetText, @NotNull String matchText, int windowSize, int maxMatches) {
        Iterator iterator;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)targetText, (String)"targetText");
        Intrinsics.checkNotNullParameter((Object)matchText, (String)"matchText");
        if (!(windowSize > 0)) {
            boolean $i$a$-require-JaccardSimilarityRetrieverKt$bestJaccardMatches$232 = false;
            String $i$a$-require-JaccardSimilarityRetrieverKt$bestJaccardMatches$232 = "windowSize must be a positive integer";
            throw new IllegalArgumentException($i$a$-require-JaccardSimilarityRetrieverKt$bestJaccardMatches$232.toString());
        }
        Map<String, Integer> targetOccurrences = JaccardSimilarityRetrieverKt.getWordOccurrences(targetText);
        int targetWordCounts = JaccardSimilarityRetrieverKt.sumWordCounts(targetOccurrences);
        List lines = StringsKt.lines((CharSequence)matchText);
        Iterable $this$map$iv = lines;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object t : $this$mapTo$iv$iv) {
            void it;
            String string = (String)t;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(JaccardSimilarityRetrieverKt.getWordOccurrences((String)it));
        }
        List wordsForEachLine = (List)destination$iv$iv;
        int firstWindowStart = 0;
        int firstWindowEnd = Math.min(windowSize - 1, lines.size() - 1);
        Map windowOccurrences = new LinkedHashMap();
        int i = firstWindowStart;
        if (i <= firstWindowEnd) {
            while (true) {
                for (Map.Entry entry : ((Map)wordsForEachLine.get(i)).entrySet()) {
                    String string = (String)entry.getKey();
                    int wordInThisLineCount = ((Number)entry.getValue()).intValue();
                    Map bl = windowOccurrences;
                    Integer n = (Integer)windowOccurrences.get(string);
                    iterator = (n != null ? n : 0) + wordInThisLineCount;
                    bl.put(string, iterator);
                }
                if (i == firstWindowEnd) break;
                ++i;
            }
        }
        int windowWordCounts = JaccardSimilarityRetrieverKt.sumWordCounts(windowOccurrences);
        Map intersectionOccurrences = new LinkedHashMap();
        for (Map.Entry<String, Integer> entry : targetOccurrences.entrySet()) {
            String word = entry.getKey();
            int wordCount = ((Number)entry.getValue()).intValue();
            iterator = intersectionOccurrences;
            Integer n = (Integer)windowOccurrences.get(word);
            int n2 = n != null ? n : 0;
            Integer n3 = Math.min(wordCount, n2);
            iterator.put(word, n3);
        }
        int n = JaccardSimilarityRetrieverKt.sumWordCounts(intersectionOccurrences);
        Object[] word = new JaccardMatch[]{new JaccardMatch(JaccardSimilarityRetrieverKt.jaccardSimilarity(targetWordCounts, windowWordCounts, n), CollectionsKt.joinToString$default((Iterable)lines.subList(firstWindowStart, firstWindowEnd + 1), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), firstWindowStart, firstWindowEnd)};
        List list = CollectionsKt.mutableListOf((Object[])word);
        int i2 = 1;
        int wordCount = lines.size() - windowSize;
        if (i2 <= wordCount) {
            while (true) {
                windowWordCounts += JaccardSimilarityRetrieverKt.subtract(windowOccurrences, (Map)wordsForEachLine.get(i2 - 1));
                var13_23 += JaccardSimilarityRetrieverKt.subtract(intersectionOccurrences, (Map)wordsForEachLine.get(i2 - 1));
                iterator = JaccardSimilarityRetrieverKt.add(targetOccurrences, windowOccurrences, intersectionOccurrences, (Map)wordsForEachLine.get(i2 + windowSize - 1));
                int windowIncrease = ((Number)iterator.component1()).intValue();
                int intersectionIncrease = ((Number)iterator.component2()).intValue();
                windowWordCounts += windowIncrease;
                var13_23 += intersectionIncrease;
                if (!StringsKt.isBlank((CharSequence)((CharSequence)lines.get(i2))) || i2 == lines.size() - windowSize) {
                    void var13_23;
                    double score = JaccardSimilarityRetrieverKt.jaccardSimilarity(targetWordCounts, windowWordCounts, (int)var13_23);
                    int startLine = i2;
                    int endLine = i2 + windowSize - 1;
                    list.add(new JaccardMatch(score, CollectionsKt.joinToString$default((Iterable)lines.subList(startLine, endLine + 1), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), startLine, endLine));
                }
                if (i2 == wordCount) break;
                ++i2;
            }
        }
        List $this$sortByDescending$iv = list;
        boolean $i$f$sortByDescending = false;
        if ($this$sortByDescending$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    JaccardMatch it = (JaccardMatch)b;
                    boolean bl = false;
                    Comparable comparable = Double.valueOf(it.getScore());
                    it = (JaccardMatch)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(it.getScore()));
                }
            });
        }
        List retainedWindows = new ArrayList();
        Set includedLines = new LinkedHashSet();
        for (JaccardMatch window : list) {
            int n4;
            boolean hasOverlap = false;
            int i3 = window.getStartLine();
            if (i3 <= (n4 = window.getEndLine())) {
                while (true) {
                    if (includedLines.contains(i3)) {
                        hasOverlap = true;
                        break;
                    }
                    if (i3 == n4) break;
                    ++i3;
                }
            }
            if (hasOverlap) continue;
            int i4 = window.getStartLine();
            if (i4 <= (n4 = window.getEndLine())) {
                while (true) {
                    includedLines.add(i4);
                    if (i4 == n4) break;
                    ++i4;
                }
            }
            retainedWindows.add(window);
        }
        return CollectionsKt.take((Iterable)retainedWindows, (int)maxMatches);
    }

    public static final double jaccardSimilarity(int left, int right, int intersection) {
        int union = left + right - intersection;
        if (!(union >= 0)) {
            boolean bl = false;
            String string = "intersection can't be greater than the sum of left and right";
            throw new IllegalArgumentException(string.toString());
        }
        return union == 0 ? 0.0 : (double)intersection / (double)union;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, Integer> getWordOccurrences(@NotNull String s) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Map frequencyCounter = new LinkedHashMap();
        List<String> words = JaccardSimilarityRetrieverKt.tokenizeAndSplit(s);
        Iterable $this$filter$iv = words;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)it).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List filteredWords = (List)destination$iv$iv;
        for (String word : filteredWords) {
            String stem = JaccardSimilarityRetrieverKt.stemWithCache(word);
            Map map = frequencyCounter;
            Integer n = (Integer)frequencyCounter.get(stem);
            Integer n2 = (n != null ? n : 0) + 1;
            map.put(stem, n2);
        }
        return frequencyCounter;
    }

    public static final int sumWordCounts(@NotNull Map<String, Integer> words) {
        Intrinsics.checkNotNullParameter(words, (String)"words");
        return CollectionsKt.sumOfInt((Iterable)words.values());
    }

    public static final int subtract(@NotNull Map<String, Integer> minuend, @NotNull Map<String, Integer> subtrahend) {
        Intrinsics.checkNotNullParameter(minuend, (String)"minuend");
        Intrinsics.checkNotNullParameter(subtrahend, (String)"subtrahend");
        int decrease = 0;
        for (Map.Entry<String, Integer> entry : subtrahend.entrySet()) {
            String word = entry.getKey();
            int count = ((Number)entry.getValue()).intValue();
            Integer n = minuend.get(word);
            int currentCount = n != null ? n : 0;
            int newCount = Math.max(0, currentCount - count);
            Integer n2 = newCount;
            minuend.put(word, n2);
            decrease += newCount - currentCount;
        }
        return decrease;
    }

    @NotNull
    public static final Pair<Integer, Integer> add(@NotNull Map<String, Integer> target, @NotNull Map<String, Integer> window, @NotNull Map<String, Integer> intersection, @NotNull Map<String, Integer> newLine) {
        Intrinsics.checkNotNullParameter(target, (String)"target");
        Intrinsics.checkNotNullParameter(window, (String)"window");
        Intrinsics.checkNotNullParameter(intersection, (String)"intersection");
        Intrinsics.checkNotNullParameter(newLine, (String)"newLine");
        int windowIncrease = 0;
        int intersectionIncrease = 0;
        for (Map.Entry<String, Integer> entry : newLine.entrySet()) {
            String word = entry.getKey();
            int count = ((Number)entry.getValue()).intValue();
            windowIncrease += count;
            Map<String, Integer> map = window;
            Integer n = window.get(word);
            Integer n2 = (n != null ? n : 0) + count;
            map.put(word, n2);
            Integer n3 = target.get(word);
            int targetCount = n3 != null ? n3 : 0;
            if (targetCount <= 0) continue;
            Integer n4 = intersection.get(word);
            int intersectionCount = n4 != null ? n4 : 0;
            int newIntersectionCount = Math.min(count + intersectionCount, targetCount);
            Integer n5 = newIntersectionCount;
            intersection.put(word, n5);
            intersectionIncrease += newIntersectionCount - intersectionCount;
        }
        return new Pair((Object)windowIncrease, (Object)intersectionIncrease);
    }

    @NotNull
    public static final String stemWithCache(@NotNull String word) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        Map $this$getOrPut$iv = stemmerCache;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(word);
        if (value$iv == null) {
            boolean bl = false;
            String answer$iv = JaccardSimilarityRetrieverKt.stem(word);
            $this$getOrPut$iv.put(word, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (String)object;
    }

    @NotNull
    public static final String stem(@NotNull String word) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        String string = word.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)string, (CharSequence)"s"), (CharSequence)"ing"), (CharSequence)"ed");
    }

    @NotNull
    public static final List<String> breakCamelAndSnakeCase(@NotNull String word) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        Regex camelCaseRegex = new Regex("(?<=[a-z])(?=[A-Z])");
        Regex snakeKebabRegex = new Regex("_");
        CharSequence charSequence = word;
        String[] stringArray = " ";
        String brokenWord = camelCaseRegex.replace(charSequence, (String)stringArray);
        charSequence = brokenWord;
        stringArray = " ";
        brokenWord = snakeKebabRegex.replace(charSequence, (String)stringArray);
        if (Intrinsics.areEqual((Object)word, (Object)brokenWord)) {
            return CollectionsKt.listOf((Object)word);
        }
        stringArray = new String[]{" "};
        List array = StringsKt.split$default((CharSequence)brokenWord, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        return CollectionsKt.plus((Collection)array, (Object)word);
    }

    @NotNull
    public static final List<String> breakCamelAndSnakeCaseWithCache(@NotNull String word) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        Map $this$getOrPut$iv = breakCamelAndSnakeCaseCache;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(word);
        if (value$iv == null) {
            boolean bl = false;
            List<String> answer$iv = JaccardSimilarityRetrieverKt.breakCamelAndSnakeCase(word);
            $this$getOrPut$iv.put(word, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (List)object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> tokenizeAndSplit(@NotNull String text) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        CharSequence charSequence = text;
        Regex regex = new Regex("\\W+");
        int n = 0;
        Iterable $this$flatMap$iv = regex.split(charSequence, n);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = JaccardSimilarityRetrieverKt.breakCamelAndSnakeCaseWithCache(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final String getFilePathFromDocument(@NotNull Document document) {
        VirtualFile virtualFile;
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        VirtualFile virtualFile2 = virtualFile = FileDocumentManager.getInstance().getFile(document);
        return virtualFile2 != null ? virtualFile2.getPath() : null;
    }

    @Nullable
    public static final String getFileNameFromDocument(@NotNull Document document) {
        VirtualFile virtualFile;
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        VirtualFile virtualFile2 = virtualFile = FileDocumentManager.getInstance().getFile(document);
        return virtualFile2 != null ? virtualFile2.getUrl() : null;
    }

    @NotNull
    public static final String getText(@NotNull Document document, int startOffset, int endOffset) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        int safeStartOffset = RangesKt.coerceAtLeast((int)startOffset, (int)0);
        int safeEndOffset = RangesKt.coerceAtMost((int)endOffset, (int)document.getTextLength());
        TextRange textRange = new TextRange(safeStartOffset, safeEndOffset);
        String string = document.getText(textRange);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    @NotNull
    public static final String lastNLines(@NotNull String text, int n) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        List lines = StringsKt.lines((CharSequence)text);
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.takeLast((List)lines, (int)n), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public static final Range getContextRange(@NotNull Document document, @NotNull DocumentContext context) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new Range(0, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean startOrEndOverlapsLineRange(@NotNull String uriA, @NotNull Pair<Integer, Integer> lineRangeA, @NotNull String uriB, @NotNull Pair<Integer, Integer> lineRangeB) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)uriA, (String)"uriA");
        Intrinsics.checkNotNullParameter(lineRangeA, (String)"lineRangeA");
        Intrinsics.checkNotNullParameter((Object)uriB, (String)"uriB");
        Intrinsics.checkNotNullParameter(lineRangeB, (String)"lineRangeB");
        if (!Intrinsics.areEqual((Object)uriA, (Object)uriB)) {
            return false;
        }
        int n = ((Number)lineRangeB.getFirst()).intValue();
        int n2 = ((Number)lineRangeB.getSecond()).intValue();
        int n3 = ((Number)lineRangeA.getFirst()).intValue();
        if (n <= n3) {
            if (n3 <= n2) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        n = ((Number)lineRangeB.getFirst()).intValue();
        n2 = ((Number)lineRangeB.getSecond()).intValue();
        n3 = ((Number)lineRangeA.getSecond()).intValue();
        if (n > n3) return false;
        if (n3 > n2) return false;
        return true;
    }
}

