/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.services.context;

import cn.gitlab.kilo.jetbrains.services.context.DocumentContext;
import cn.gitlab.kilo.jetbrains.services.context.LanguageUtilsKt;
import cn.gitlab.kilo.jetbrains.services.context.Position;
import cn.gitlab.kilo.jetbrains.services.context.Selection;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J\t\u0010%\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010&\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010*\u001a\u00020\u0005H\u00d6\u0001J\t\u0010+\u001a\u00020\u001dH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\u0018\u001a\u0004\u0018\u00010\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020!8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u0006,"}, d2={"Lcn/gitlab/kilo/jetbrains/services/context/ContextRetrieverOptions;", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "maxChars", "", "<init>", "(Lcom/intellij/openapi/editor/Editor;I)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "getMaxChars", "()I", "document", "Lcom/intellij/openapi/editor/Document;", "getDocument", "()Lcom/intellij/openapi/editor/Document;", "psiFile", "Lcom/intellij/psi/PsiFile;", "getPsiFile", "()Lcom/intellij/psi/PsiFile;", "position", "Lcn/gitlab/kilo/jetbrains/services/context/Position;", "getPosition", "()Lcn/gitlab/kilo/jetbrains/services/context/Position;", "selection", "Lcn/gitlab/kilo/jetbrains/services/context/Selection;", "getSelection", "()Lcn/gitlab/kilo/jetbrains/services/context/Selection;", "language", "", "getLanguage", "()Ljava/lang/String;", "docContext", "Lcn/gitlab/kilo/jetbrains/services/context/DocumentContext;", "getDocContext", "()Lcn/gitlab/kilo/jetbrains/services/context/DocumentContext;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "coderider-kilo-jetbrains"})
public final class ContextRetrieverOptions {
    @NotNull
    private final Editor editor;
    private final int maxChars;

    public ContextRetrieverOptions(@NotNull Editor editor, int maxChars) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.editor = editor;
        this.maxChars = maxChars;
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    public final int getMaxChars() {
        return this.maxChars;
    }

    @NotNull
    public final Document getDocument() {
        Document document = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        return document;
    }

    @NotNull
    public final PsiFile getPsiFile() {
        return (PsiFile)ActionsKt.runReadAction(() -> ContextRetrieverOptions._get_psiFile_$lambda$0(this));
    }

    @NotNull
    public final Position getPosition() {
        return (Position)ActionsKt.runReadAction(() -> ContextRetrieverOptions._get_position_$lambda$1(this));
    }

    @Nullable
    public final Selection getSelection() {
        return (Selection)ActionsKt.runReadAction(() -> ContextRetrieverOptions._get_selection_$lambda$2(this));
    }

    @NotNull
    public final String getLanguage() {
        return (String)ActionsKt.runReadAction(() -> ContextRetrieverOptions._get_language_$lambda$3(this));
    }

    @NotNull
    public final DocumentContext getDocContext() {
        return (DocumentContext)ActionsKt.runReadAction(() -> ContextRetrieverOptions._get_docContext_$lambda$4(this));
    }

    @NotNull
    public final Editor component1() {
        return this.editor;
    }

    public final int component2() {
        return this.maxChars;
    }

    @NotNull
    public final ContextRetrieverOptions copy(@NotNull Editor editor, int maxChars) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return new ContextRetrieverOptions(editor, maxChars);
    }

    public static /* synthetic */ ContextRetrieverOptions copy$default(ContextRetrieverOptions contextRetrieverOptions, Editor editor, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            editor = contextRetrieverOptions.editor;
        }
        if ((n2 & 2) != 0) {
            n = contextRetrieverOptions.maxChars;
        }
        return contextRetrieverOptions.copy(editor, n);
    }

    @NotNull
    public String toString() {
        return "ContextRetrieverOptions(editor=" + this.editor + ", maxChars=" + this.maxChars + ")";
    }

    public int hashCode() {
        int result2 = this.editor.hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.maxChars);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ContextRetrieverOptions)) {
            return false;
        }
        ContextRetrieverOptions contextRetrieverOptions = (ContextRetrieverOptions)other;
        if (!Intrinsics.areEqual((Object)this.editor, (Object)contextRetrieverOptions.editor)) {
            return false;
        }
        return this.maxChars == contextRetrieverOptions.maxChars;
    }

    private static final PsiFile _get_psiFile_$lambda$0(ContextRetrieverOptions this$0) {
        Project project = this$0.editor.getProject();
        Intrinsics.checkNotNull((Object)project);
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(this$0.getDocument());
        Intrinsics.checkNotNull((Object)psiFile);
        return psiFile;
    }

    private static final Position _get_position_$lambda$1(ContextRetrieverOptions this$0) {
        return new Position(this$0.editor.getCaretModel().getLogicalPosition().line, this$0.editor.getCaretModel().getOffset());
    }

    private static final Selection _get_selection_$lambda$2(ContextRetrieverOptions this$0) {
        SelectionModel selectionModel = this$0.editor.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue((Object)selectionModel, (String)"getSelectionModel(...)");
        SelectionModel model = selectionModel;
        return model.hasSelection() ? new Selection(new Position(this$0.getDocument().getLineNumber(model.getSelectionStart()), model.getSelectionStart()), new Position(this$0.getDocument().getLineNumber(model.getSelectionEnd()), model.getSelectionEnd())) : null;
    }

    private static final String _get_language_$lambda$3(ContextRetrieverOptions this$0) {
        String string = LanguageUtilsKt.getLanguageFromDocument(this$0.getDocument());
        if (string == null) {
            string = "unknown";
        }
        return string;
    }

    private static final DocumentContext _get_docContext_$lambda$4(ContextRetrieverOptions this$0) {
        int caretOffset = this$0.editor.getCaretModel().getOffset();
        String string = this$0.getDocument().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String string2 = string;
        int n = 0;
        String string3 = string2.substring(n, caretOffset);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        String prefix = string3;
        String string4 = this$0.getDocument().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getText(...)");
        String string5 = string4.substring(caretOffset);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
        String suffix = string5;
        return new DocumentContext(prefix, suffix);
    }
}

