/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.services;

import cn.gitlab.kilo.jetbrains.services.StorageItem;
import cn.gitlab.kilo.jetbrains.services.StorageServiceKt;
import cn.gitlab.kilo.jetbrains.services.StorageServiceMessage;
import cn.gitlab.kilo.jetbrains.services.UserStorage;
import cn.gitlab.kilo.jetbrains.utils.ThemeUtilKt;
import com.google.gson.Gson;
import com.intellij.openapi.project.Project;
import com.intellij.ui.jcef.JBCefBrowser;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0018B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\n\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0006J*\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0006J\"\u0010\u0013\u001a\u00020\u00112\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0006J \u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u000b\u001a\u0004\u0018\u00010\fR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0019"}, d2={"Lcn/gitlab/kilo/jetbrains/services/StorageService;", "", "<init>", "()V", "userId2UserStorage", "", "", "Lcn/gitlab/kilo/jetbrains/services/UserStorage;", "getUserId2UserStorage", "()Ljava/util/Map;", "getItem", "project", "Lcom/intellij/openapi/project/Project;", "storageType", "Lcn/gitlab/kilo/jetbrains/services/StorageService$StorageType;", "key", "setItem", "", "value", "removeItem", "handleWebviewMessage", "msg", "webView", "Lcom/intellij/ui/jcef/JBCefBrowser;", "StorageType", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nStorageService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StorageService.kt\ncn/gitlab/kilo/jetbrains/services/StorageService\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,152:1\n382#2,7:153\n382#2,7:161\n382#2,7:168\n382#2,7:175\n1#3:160\n*S KotlinDebug\n*F\n+ 1 StorageService.kt\ncn/gitlab/kilo/jetbrains/services/StorageService\n*L\n38#1:153,7\n48#1:161,7\n57#1:168,7\n67#1:175,7\n*E\n"})
public final class StorageService {
    @NotNull
    public static final StorageService INSTANCE = new StorageService();
    @NotNull
    private static final Map<String, UserStorage> userId2UserStorage = new LinkedHashMap();

    private StorageService() {
    }

    @NotNull
    public final Map<String, UserStorage> getUserId2UserStorage() {
        return userId2UserStorage;
    }

    @Nullable
    public final String getItem(@Nullable Project project, @NotNull StorageType storageType, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)((Object)storageType), (String)"storageType");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String userId = StorageServiceKt.getUserId();
        UserStorage userStorage = userId2UserStorage.get(userId);
        if (userStorage == null) {
            return null;
        }
        UserStorage userStorage2 = userStorage;
        switch (WhenMappings.$EnumSwitchMapping$0[storageType.ordinal()]) {
            case 1: {
                StorageItem storageItem = userStorage2.getGlobalStorage().get(key);
                return storageItem != null ? storageItem.getValue() : null;
            }
            case 2: {
                Project project2 = project;
                Intrinsics.checkNotNull((Object)project2);
                String projectKey = StorageServiceKt.getProjectKey(project2);
                Map<String, StorageItem> workspaceStorage = userStorage2.getProjectKey2WorkspaceStorageMap().get(projectKey);
                Map<String, StorageItem> map = workspaceStorage;
                return map != null && (map = map.get(key)) != null ? ((StorageItem)((Object)map)).getValue() : null;
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    public static /* synthetic */ String getItem$default(StorageService storageService, Project project, StorageType storageType, String string, int n, Object object) {
        if ((n & 1) != 0) {
            project = null;
        }
        return storageService.getItem(project, storageType, string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void setItem(@Nullable Project project, @NotNull StorageType storageType, @NotNull String key, @NotNull String value) {
        UserStorage userStorage;
        Intrinsics.checkNotNullParameter((Object)((Object)storageType), (String)"storageType");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string = StorageServiceKt.getUserId();
        if (string == null) {
            return;
        }
        String userId = string;
        Map<String, UserStorage> $this$getOrPut$iv = userId2UserStorage;
        boolean $i$f$getOrPut = false;
        UserStorage userStorage2 = $this$getOrPut$iv.get(userId);
        if (userStorage2 == null) {
            boolean bl = false;
            UserStorage answer$iv = new UserStorage(userId, new LinkedHashMap(), new LinkedHashMap());
            $this$getOrPut$iv.put(userId, answer$iv);
            userStorage = answer$iv;
        } else {
            userStorage = userStorage2;
        }
        UserStorage userStorage3 = userStorage;
        switch (WhenMappings.$EnumSwitchMapping$0[storageType.ordinal()]) {
            case 1: {
                userStorage3.getGlobalStorage().put(key, new StorageItem(key, value, storageType));
                return;
            }
            case 2: {
                Map map;
                Object object = project;
                if (object == null) return;
                Project it = object;
                boolean bl = false;
                String string2 = StorageServiceKt.getProjectKey(it);
                object = string2;
                if (string2 == null) {
                    return;
                }
                Object object2 = object;
                Map<String, Map<String, StorageItem>> $this$getOrPut$iv2 = userStorage3.getProjectKey2WorkspaceStorageMap();
                boolean $i$f$getOrPut2 = false;
                Map value$iv = $this$getOrPut$iv2.get(object2);
                if (value$iv == null) {
                    boolean bl2 = false;
                    Map answer$iv = new LinkedHashMap();
                    $this$getOrPut$iv2.put((String)object2, answer$iv);
                    map = answer$iv;
                } else {
                    map = value$iv;
                }
                Map workspaceStorage = map;
                workspaceStorage.put((String)key, (StorageItem)new StorageItem(key, value, storageType));
                return;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public static /* synthetic */ void setItem$default(StorageService storageService, Project project, StorageType storageType, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            project = null;
        }
        storageService.setItem(project, storageType, string, string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void removeItem(@Nullable Project project, @NotNull StorageType storageType, @NotNull String key) {
        UserStorage userStorage;
        Intrinsics.checkNotNullParameter((Object)((Object)storageType), (String)"storageType");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String string = StorageServiceKt.getUserId();
        if (string == null) {
            return;
        }
        String userId = string;
        Map<String, UserStorage> $this$getOrPut$iv = userId2UserStorage;
        boolean $i$f$getOrPut = false;
        UserStorage userStorage2 = $this$getOrPut$iv.get(userId);
        if (userStorage2 == null) {
            boolean bl = false;
            UserStorage answer$iv = new UserStorage(userId, new LinkedHashMap(), new LinkedHashMap());
            $this$getOrPut$iv.put(userId, answer$iv);
            userStorage = answer$iv;
        } else {
            userStorage = userStorage2;
        }
        UserStorage userStorage3 = userStorage;
        switch (WhenMappings.$EnumSwitchMapping$0[storageType.ordinal()]) {
            case 1: {
                StorageItem storageItem = userStorage3.getGlobalStorage().remove(key);
                return;
            }
            case 2: {
                Map map;
                Object object = project;
                if (object == null) return;
                Project it = object;
                boolean bl = false;
                String string2 = StorageServiceKt.getProjectKey(it);
                object = string2;
                if (string2 == null) {
                    return;
                }
                Object object2 = object;
                Map<String, Map<String, StorageItem>> $this$getOrPut$iv2 = userStorage3.getProjectKey2WorkspaceStorageMap();
                boolean $i$f$getOrPut2 = false;
                Map value$iv = $this$getOrPut$iv2.get(object2);
                if (value$iv == null) {
                    boolean bl2 = false;
                    Map answer$iv = new LinkedHashMap();
                    $this$getOrPut$iv2.put((String)object2, answer$iv);
                    map = answer$iv;
                } else {
                    map = value$iv;
                }
                Map workspaceStorage = map;
                StorageItem storageItem = workspaceStorage.remove(key);
                return;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public static /* synthetic */ void removeItem$default(StorageService storageService, Project project, StorageType storageType, String string, int n, Object object) {
        if ((n & 1) != 0) {
            project = null;
        }
        storageService.removeItem(project, storageType, string);
    }

    public final void handleWebviewMessage(@NotNull String msg, @NotNull JBCefBrowser webView, @Nullable Project project) {
        Pair[] it;
        Object object;
        StorageServiceMessage message;
        block19: {
            block18: {
                Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
                Intrinsics.checkNotNullParameter((Object)webView, (String)"webView");
                Gson gson = new Gson();
                message = (StorageServiceMessage)gson.fromJson(msg, StorageServiceMessage.class);
                object = message.getStorageType();
                if (object == null) break block18;
                it = object;
                boolean bl = false;
                String string = it.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
                StorageType storageType = StorageType.valueOf(string);
                object = storageType;
                if (storageType != null) break block19;
            }
            object = StorageType.GLOBAL;
        }
        Pair[] storageType = object;
        switch (message.getCommand()) {
            case "getItem": {
                String retrievedValue = this.getItem(project, (StorageType)storageType, message.getKey());
                it = new Pair[5];
                it[0] = TuplesKt.to((Object)"type", (Object)"getItemResponse");
                String string = storageType.name().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                it[1] = TuplesKt.to((Object)"storageType", (Object)string);
                it[2] = TuplesKt.to((Object)"requestId", (Object)message.getRequestId());
                it[3] = TuplesKt.to((Object)"key", (Object)message.getKey());
                it[4] = TuplesKt.to((Object)"value", (Object)retrievedValue);
                Map response = MapsKt.mapOf((Pair[])it);
                ThemeUtilKt.sendToWebview((Map<String, ? extends Object>)response, webView);
                break;
            }
            case "setItem": {
                String string = message.getValue();
                if (string != null) {
                    String value = string;
                    boolean bl = false;
                    INSTANCE.setItem(project, (StorageType)storageType, message.getKey(), value);
                    Pair[] pairArray = new Pair[5];
                    pairArray[0] = TuplesKt.to((Object)"type", (Object)"setItemResponse");
                    String string2 = storageType.name().toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                    pairArray[1] = TuplesKt.to((Object)"storageType", (Object)string2);
                    pairArray[2] = TuplesKt.to((Object)"requestId", (Object)message.getRequestId());
                    pairArray[3] = TuplesKt.to((Object)"key", (Object)message.getKey());
                    pairArray[4] = TuplesKt.to((Object)"value", (Object)value);
                    Map response = MapsKt.mapOf((Pair[])pairArray);
                    ThemeUtilKt.sendToWebview((Map<String, ? extends Object>)response, webView);
                }
                break;
            }
            case "removeItem": {
                this.removeItem(project, (StorageType)storageType, message.getKey());
                Pair[] pairArray = new Pair[5];
                pairArray[0] = TuplesKt.to((Object)"type", (Object)"removeItemResponse");
                String string = storageType.name().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                pairArray[1] = TuplesKt.to((Object)"storageType", (Object)string);
                pairArray[2] = TuplesKt.to((Object)"requestId", (Object)message.getRequestId());
                pairArray[3] = TuplesKt.to((Object)"key", (Object)message.getKey());
                pairArray[4] = TuplesKt.to((Object)"value", (Object)"");
                Map response = MapsKt.mapOf((Pair[])pairArray);
                ThemeUtilKt.sendToWebview((Map<String, ? extends Object>)response, webView);
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcn/gitlab/kilo/jetbrains/services/StorageService$StorageType;", "", "<init>", "(Ljava/lang/String;I)V", "GLOBAL", "WORKSPACE", "coderider-kilo-jetbrains"})
    public static final class StorageType
    extends Enum<StorageType> {
        public static final /* enum */ StorageType GLOBAL = new StorageType();
        public static final /* enum */ StorageType WORKSPACE = new StorageType();
        private static final /* synthetic */ StorageType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static StorageType[] values() {
            return (StorageType[])$VALUES.clone();
        }

        public static StorageType valueOf(String value) {
            return Enum.valueOf(StorageType.class, value);
        }

        @NotNull
        public static EnumEntries<StorageType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = storageTypeArray = new StorageType[]{StorageType.GLOBAL, StorageType.WORKSPACE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[StorageType.values().length];
            try {
                nArray[StorageType.GLOBAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StorageType.WORKSPACE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

