/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.services;

import cn.gitlab.kilo.jetbrains.chat.ChatHandler;
import cn.gitlab.kilo.jetbrains.common.Conversation;
import cn.gitlab.kilo.jetbrains.config.ConversationStorage;
import cn.gitlab.kilo.jetbrains.services.ConversationDisplayItem;
import cn.gitlab.kilo.jetbrains.services.ConversationListPayload;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\u0007J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\b\u001a\u00020\tJ\u001e\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0011"}, d2={"Lcn/gitlab/kilo/jetbrains/services/ConversationService;", "", "<init>", "()V", "getConversationListPayload", "Lcn/gitlab/kilo/jetbrains/services/ConversationListPayload;", "deleteConversation", "", "conversationId", "", "cleanAllConversations", "getConversation", "Lcn/gitlab/kilo/jetbrains/common/Conversation;", "updateConversationTitle", "title", "project", "Lcom/intellij/openapi/project/Project;", "coderider-kilo-jetbrains"})
public final class ConversationService {
    @NotNull
    public static final ConversationService INSTANCE = new ConversationService();

    private ConversationService() {
    }

    @NotNull
    public final ConversationListPayload getConversationListPayload() {
        Stream<ConversationDisplayItem> stream;
        Stream<Object> stream2;
        Stream<Conversation> stream3;
        Collection<Conversation> collection;
        Map<String, Conversation> map = ConversationStorage.Companion.getInstance().getConversations();
        List conversations = map != null && (collection = map.values()) != null && (stream3 = collection.stream()) != null && (stream2 = stream3.sorted(Comparator.comparing(arg_0 -> ConversationService.getConversationListPayload$lambda$1(ConversationService::getConversationListPayload$lambda$0, arg_0)).reversed())) != null && (stream = stream2.map(arg_0 -> ConversationService.getConversationListPayload$lambda$3(ConversationService::getConversationListPayload$lambda$2, arg_0))) != null ? stream.collect(Collectors.toList()) : null;
        return new ConversationListPayload(conversations);
    }

    public final void deleteConversation(@NotNull String conversationId) {
        Intrinsics.checkNotNullParameter((Object)conversationId, (String)"conversationId");
        ConversationStorage.Companion.getInstance().removeConversation(conversationId);
    }

    public final void cleanAllConversations() {
        ConversationStorage.Companion.getInstance().removeAll();
    }

    @Nullable
    public final Conversation getConversation(@NotNull String conversationId) {
        Intrinsics.checkNotNullParameter((Object)conversationId, (String)"conversationId");
        return ConversationStorage.Companion.getInstance().getConversations().get(conversationId);
    }

    public final void updateConversationTitle(@NotNull String conversationId, @NotNull String title, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)conversationId, (String)"conversationId");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Conversation conv = ConversationStorage.Companion.getInstance().getConversations().get(conversationId);
        if (conv != null) {
            conv.setTitle(title);
            ChatHandler.INSTANCE.putConversation(conv);
        }
    }

    private static final Long getConversationListPayload$lambda$0(Conversation it) {
        return it.getCreatedAt();
    }

    private static final Long getConversationListPayload$lambda$1(Function1 $tmp0, Object p0) {
        return (Long)$tmp0.invoke(p0);
    }

    private static final ConversationDisplayItem getConversationListPayload$lambda$2(Conversation it) {
        return new ConversationDisplayItem(it.getConversationId(), it.getTitle());
    }

    private static final ConversationDisplayItem getConversationListPayload$lambda$3(Function1 $tmp0, Object p0) {
        return (ConversationDisplayItem)$tmp0.invoke(p0);
    }
}

