/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.services;

import cn.gitlab.kilo.jetbrains.common.ExtensionMessage;
import cn.gitlab.kilo.jetbrains.common.Logger;
import cn.gitlab.kilo.jetbrains.services.CockpitChatWindow;
import com.google.gson.Gson;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.DumbAware;
import com.intellij.ui.jcef.JBCefBrowser;
import com.intellij.util.io.Ksuid;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0017\u001a\u00020\u0018H\u0016J*\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00112\b\u0010\u001c\u001a\u0004\u0018\u00010\u001a2\b\b\u0002\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u001fJ\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010#\u001a\u00020\u00112\u0006\u0010$\u001a\u00020\u0011H\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0016\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006%"}, d2={"Lcn/gitlab/kilo/jetbrains/services/CockpitChatPluginService;", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "logger", "Lcn/gitlab/kilo/jetbrains/common/Logger;", "getLogger", "()Lcn/gitlab/kilo/jetbrains/common/Logger;", "gson", "Lcom/google/gson/Gson;", "getGson", "()Lcom/google/gson/Gson;", "mainCoroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "workspacePaths", "", "", "getWorkspacePaths", "()[Ljava/lang/String;", "setWorkspacePaths", "([Ljava/lang/String;)V", "[Ljava/lang/String;", "dispose", "", "sendToWebview", "", "messageType", "data", "messageId", "cockpitChatWindow", "Lcn/gitlab/kilo/jetbrains/services/CockpitChatWindow;", "extensionMessage", "Lcn/gitlab/kilo/jetbrains/common/ExtensionMessage;", "msg", "buildJavaScript", "jsonData", "coderider-kilo-jetbrains"})
public final class CockpitChatPluginService
implements Disposable,
DumbAware {
    @NotNull
    private final Logger logger = Logger.Companion.getInstance("CockpitChatPluginService");
    @NotNull
    private final Gson gson = new Gson();
    @NotNull
    private final CoroutineScope mainCoroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getDefault()));
    @Nullable
    private String[] workspacePaths;

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public final Gson getGson() {
        return this.gson;
    }

    @Nullable
    public final String[] getWorkspacePaths() {
        return this.workspacePaths;
    }

    public final void setWorkspacePaths(@Nullable String[] stringArray) {
        this.workspacePaths = stringArray;
    }

    public void dispose() {
        CoroutineScopeKt.cancel$default((CoroutineScope)this.mainCoroutineScope, null, (int)1, null);
    }

    @NotNull
    public final Object sendToWebview(@NotNull String messageType, @Nullable Object data, @NotNull String messageId, @NotNull CockpitChatWindow cockpitChatWindow) {
        Intrinsics.checkNotNullParameter((Object)messageType, (String)"messageType");
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Intrinsics.checkNotNullParameter((Object)cockpitChatWindow, (String)"cockpitChatWindow");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"messageId", (Object)messageId), TuplesKt.to((Object)"messageType", (Object)messageType), TuplesKt.to((Object)"data", (Object)data)};
        String string = this.gson.toJson((Object)MapsKt.mapOf((Pair[])pairArray));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
        return this.sendToWebview(this.buildJavaScript(string), cockpitChatWindow);
    }

    public static /* synthetic */ Object sendToWebview$default(CockpitChatPluginService cockpitChatPluginService, String string, Object object, String string2, CockpitChatWindow cockpitChatWindow, int n, Object object2) {
        if ((n & 4) != 0) {
            string2 = Ksuid.generate();
        }
        return cockpitChatPluginService.sendToWebview(string, object, string2, cockpitChatWindow);
    }

    @NotNull
    public final Object sendToWebview(@NotNull ExtensionMessage extensionMessage, @NotNull CockpitChatWindow cockpitChatWindow) {
        Intrinsics.checkNotNullParameter((Object)extensionMessage, (String)"extensionMessage");
        Intrinsics.checkNotNullParameter((Object)cockpitChatWindow, (String)"cockpitChatWindow");
        String string = this.gson.toJson((Object)extensionMessage);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
        return this.sendToWebview(this.buildJavaScript(string), cockpitChatWindow);
    }

    @NotNull
    public final Object sendToWebview(@NotNull String msg, @NotNull CockpitChatWindow cockpitChatWindow) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)cockpitChatWindow, (String)"cockpitChatWindow");
        try {
            unit = BuildersKt.launch$default((CoroutineScope)this.mainCoroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(cockpitChatWindow, msg, null){
                int label;
                final /* synthetic */ CockpitChatWindow $cockpitChatWindow;
                final /* synthetic */ String $msg;
                {
                    this.$cockpitChatWindow = $cockpitChatWindow;
                    this.$msg = $msg;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            JBCefBrowser jBCefBrowser = this.$cockpitChatWindow.getWebView();
                            if (jBCefBrowser != null && (jBCefBrowser = jBCefBrowser.getCefBrowser()) != null) {
                                jBCefBrowser.executeJavaScript(this.$msg, "", 0);
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
        catch (IllegalStateException error2) {
            error2.printStackTrace();
            Logger.error$default(this.logger, "Webview not initialized yet " + error2, null, 2, null);
            unit = Unit.INSTANCE;
        }
        return unit;
    }

    private final String buildJavaScript(String jsonData) {
        return "window.postMessage(" + jsonData + ", \"*\");";
    }
}

