/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.quickfix;

import ai.grazie.utils.mpp.UUID;
import cn.gitlab.kilo.jetbrains.common.Logger;
import cn.gitlab.kilo.jetbrains.common.Range;
import cn.gitlab.kilo.jetbrains.edit.EditStreamHandler;
import cn.gitlab.kilo.jetbrains.edit.LensesService;
import cn.gitlab.kilo.jetbrains.services.ErrorQuickFix;
import cn.gitlab.kilo.jetbrains.utils.EditUtilKt;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u001eH\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u0006\""}, d2={"Lcn/gitlab/kilo/jetbrains/quickfix/CodeRiderFixHighlightPass;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPass;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/editor/Editor;)V", "getFile", "()Lcom/intellij/psi/PsiFile;", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "diffStreamHandler", "Lcn/gitlab/kilo/jetbrains/edit/EditStreamHandler;", "getDiffStreamHandler", "()Lcn/gitlab/kilo/jetbrains/edit/EditStreamHandler;", "setDiffStreamHandler", "(Lcn/gitlab/kilo/jetbrains/edit/EditStreamHandler;)V", "logger", "Lcn/gitlab/kilo/jetbrains/common/Logger;", "myHighlights", "", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo;", "taskId", "", "getTaskId", "()Ljava/lang/String;", "setTaskId", "(Ljava/lang/String;)V", "doCollectInformation", "", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "doApplyInformationToEditor", "coderider-kilo-jetbrains"})
public final class CodeRiderFixHighlightPass
extends TextEditorHighlightingPass {
    @NotNull
    private final PsiFile file;
    @NotNull
    private final Editor editor;
    @Nullable
    private EditStreamHandler diffStreamHandler;
    @NotNull
    private final Logger logger;
    @NotNull
    private List<? extends HighlightInfo> myHighlights;
    @NotNull
    private String taskId;

    public CodeRiderFixHighlightPass(@NotNull PsiFile file, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        super(file.getProject(), editor.getDocument(), false);
        this.file = file;
        this.editor = editor;
        this.logger = Logger.Companion.getInstance(CodeRiderFixHighlightPass.class);
        this.myHighlights = CollectionsKt.emptyList();
        this.taskId = UUID.Companion.random().toString();
    }

    @NotNull
    public final PsiFile getFile() {
        return this.file;
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    @Nullable
    public final EditStreamHandler getDiffStreamHandler() {
        return this.diffStreamHandler;
    }

    public final void setDiffStreamHandler(@Nullable EditStreamHandler editStreamHandler) {
        this.diffStreamHandler = editStreamHandler;
    }

    @NotNull
    public final String getTaskId() {
        return this.taskId;
    }

    public final void setTaskId(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.taskId = string;
    }

    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
        Project project = this.file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        if (DaemonCodeAnalyzer.getInstance((Project)project2).isHighlightingAvailable(this.file) || progress.isCanceled()) {
            VirtualFile virtualFile = this.file.getVirtualFile();
            if (virtualFile != null) {
                this.myHighlights = EditUtilKt.getCursorErrorsAtCurrentPosition(this.editor);
                if (this.myHighlights.isEmpty()) {
                    return;
                }
                Document document = this.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
                Range range = EditUtilKt.getHighlightsRange(this.myHighlights, document);
                int startOffset = range.getStart();
                int endOffset = range.getEnd();
                int startLineNumber = this.editor.getDocument().getLineNumber(startOffset);
                int endLineNumber = this.editor.getDocument().getLineNumber(endOffset);
                VirtualFile virtualFile2 = FileDocumentManager.getInstance().getFile(this.editor.getDocument());
                String path = virtualFile2 != null ? virtualFile2.getPath() : null;
                String string = this.editor.getDocument().getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                String originFile = string;
                Ref.ObjectRef lensesService = new Ref.ObjectRef();
                lensesService.element = LensesService.Companion.getInstance(project2);
                this.diffStreamHandler = new EditStreamHandler(() -> CodeRiderFixHighlightPass.doCollectInformation$lambda$0(lensesService, this), () -> CodeRiderFixHighlightPass.doCollectInformation$lambda$1(lensesService, this, virtualFile, range), project2, this.editor, startLineNumber, endLineNumber, CodeRiderFixHighlightPass::doCollectInformation$lambda$2, () -> CodeRiderFixHighlightPass.doCollectInformation$lambda$3(lensesService, this, virtualFile, range), path, originFile, startOffset, endOffset, this.editor, null, null, null, 57344, null);
            }
            return;
        }
    }

    @RequiresEdt
    public void doApplyInformationToEditor() {
        for (HighlightInfo highlightInfo : this.myHighlights) {
            EditStreamHandler handler;
            if (highlightInfo.startOffset > this.getDocument().getTextLength() || highlightInfo.endOffset > this.getDocument().getTextLength() || highlightInfo.startOffset > highlightInfo.endOffset) continue;
            if (this.diffStreamHandler == null) continue;
            boolean bl = false;
            ErrorQuickFix quickFix = new ErrorQuickFix("CodeRider-Kilo", handler, this.myHighlights);
            highlightInfo.registerFix((IntentionAction)quickFix, null, "CodeRider-Kilo", null, null);
        }
    }

    private static final Unit doCollectInformation$lambda$0(Ref.ObjectRef $lensesService, CodeRiderFixHighlightPass this$0) {
        ((LensesService)$lensesService.element).clearLenses(this$0.editor);
        return Unit.INSTANCE;
    }

    private static final Unit doCollectInformation$lambda$1(Ref.ObjectRef $lensesService, CodeRiderFixHighlightPass this$0, VirtualFile $virtualFile, Range $range) {
        LensesService lensesService = (LensesService)$lensesService.element;
        Editor editor = this$0.editor;
        String string = $virtualFile.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
        lensesService.updateLenses(editor, string, $virtualFile, ((LensesService)$lensesService.element).generateInlineEditStartLense($range, this$0.taskId));
        return Unit.INSTANCE;
    }

    private static final Unit doCollectInformation$lambda$2() {
        return Unit.INSTANCE;
    }

    private static final Unit doCollectInformation$lambda$3(Ref.ObjectRef $lensesService, CodeRiderFixHighlightPass this$0, VirtualFile $virtualFile, Range $range) {
        LensesService lensesService = (LensesService)$lensesService.element;
        Editor editor = this$0.editor;
        String string = $virtualFile.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
        lensesService.updateLenses(editor, string, $virtualFile, ((LensesService)$lensesService.element).generateInlineEditEndLense($range, this$0.taskId));
        return Unit.INSTANCE;
    }
}

