/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.kilo.jetbrains.llmClient;

import cn.gitlab.kilo.jetbrains.llmClient.InternalErrorException;
import cn.gitlab.kilo.jetbrains.llmClient.OpenAiErrorDetails;
import cn.gitlab.kilo.jetbrains.llmClient.OpenAiException;
import cn.gitlab.kilo.jetbrains.utils.ChatParameters;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import okhttp3.Request;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0014\u0010\u0005\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\t"}, d2={"checkIsOpenAIContextWindowError", "", "error", "Lcn/gitlab/kilo/jetbrains/llmClient/OpenAiErrorDetails;", "checkIsInternalContextWindowError", "addServerTraceHeader", "Lokhttp3/Request$Builder;", "param", "Lcn/gitlab/kilo/jetbrains/utils/ChatParameters;", "coderider-kilo-jetbrains"})
@SourceDebugExtension(value={"SMAP\nOpenAiClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenAiClient.kt\ncn/gitlab/kilo/jetbrains/llmClient/OpenAiClientKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,382:1\n1761#2,3:383\n1761#2,3:386\n1#3:389\n*S KotlinDebug\n*F\n+ 1 OpenAiClient.kt\ncn/gitlab/kilo/jetbrains/llmClient/OpenAiClientKt\n*L\n365#1:383,3\n369#1:386,3\n*E\n"})
public final class OpenAiClientKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean checkIsOpenAIContextWindowError(@NotNull OpenAiErrorDetails error2) {
        String it;
        Intrinsics.checkNotNullParameter((Object)error2, (String)"error");
        if (Intrinsics.areEqual((Object)error2.getName(), (Object)"LengthFinishReasonError")) {
            return true;
        }
        if (!Intrinsics.areEqual((Object)error2.getCode(), (Object)"400")) return false;
        if (error2.getMessage() == null) return false;
        Iterable $this$any$iv = OpenAiException.Companion.getKNOWN_CONTEXT_ERROR_SUBSTRINGS();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (String)element$iv;
            boolean bl = false;
        } while (!StringsKt.contains$default((CharSequence)error2.getMessage(), (CharSequence)it, (boolean)false, (int)2, null));
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean checkIsInternalContextWindowError(@NotNull OpenAiErrorDetails error2) {
        Regex it;
        Intrinsics.checkNotNullParameter((Object)error2, (String)"error");
        if (error2.getMessage() == null) return false;
        if (StringsKt.contains$default((CharSequence)error2.getMessage(), (CharSequence)"Please reduce the length of the messages or completion", (boolean)false, (int)2, null)) return true;
        Iterable $this$any$iv = InternalErrorException.Companion.getCONTEXT_ERROR_REGEX();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (Regex)element$iv;
            boolean bl = false;
        } while (!it.containsMatchIn((CharSequence)error2.getMessage()));
        return true;
    }

    private static final Request.Builder addServerTraceHeader(Request.Builder $this$addServerTraceHeader, ChatParameters param) {
        String string = param.getSessionId();
        if (string != null) {
            String it = string;
            boolean bl = false;
            $this$addServerTraceHeader.header("x-session-id", it);
        }
        $this$addServerTraceHeader.header("x-trace-id", param.getTraceId());
        return $this$addServerTraceHeader;
    }

    public static final /* synthetic */ Request.Builder access$addServerTraceHeader(Request.Builder $receiver, ChatParameters param) {
        return OpenAiClientKt.addServerTraceHeader($receiver, param);
    }
}

